/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class COPropertiesComparator
extends PropertiesComparator {
    private static String INTEGER = "INTEGER";
    private static String SMALLINT = "SMALLINT";
    private static String INT = "INT";
    private static String NUMERIC = "NUMERIC";
    private static String DECIMAL = "DECIMAL";
    private static String DEC = "DEC";
    private static String NUMBER = "NUMBER";
    private static String FLOAT = "FLOAT";
    private static String REAL = "REAL";
    private static String DOUBLE = "DOUBLE PRECISION";
    private ContainedObjectWithDomain left_co;
    private ContainedObjectWithDomain right_co;

    public COPropertiesComparator(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        super(left_co, right_co);
        this.left_co = left_co;
        this.right_co = right_co;
    }

    public static String decodeDataTypeKindToString(short use) {
        if (use == 0) {
            return Messages.getString("COPropertiesComparator.Domain");
        }
        if (use == 1) {
            return Messages.getString("COPropertiesComparator.LogicalType");
        }
        if (use == 2) {
            return Messages.getString("COPropertiesComparator.DistinctType");
        }
        if (use == 3) {
            return Messages.getString("COPropertiesComparator.StructuredType");
        }
        if (use == 4) {
            return Messages.getString("COPropertiesComparator.CollectionType");
        }
        return "";
    }

    public static String getType(ContainedObjectWithDomain co) {
        Object type = "";
        RDBMSType dbtype = co.getDesignPart().getSelectedRDBMSType();
        String dbtypeName = dbtype != null ? dbtype.getName() : StorageDesignOraclev12c.RDBMS_TYPE.getName();
        try {
            type = co.getDesign().getDomainSet().getDefaultDomain().getDataType().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        short use = co.getUse();
        if (use == 0 && co.getDomain() != null) {
            type = co.getDataType().toString();
        } else if (use == 1) {
            type = co.getDataType().toString();
        } else if (use == 2) {
            if (co.getDistinctType() != null) {
                type = co.getDatatypeString(dbtypeName);
            }
        } else if (use == 3) {
            if (co.getStructuredType() != null) {
                type = co.isReference() ? "REF " + co.getStructuredType().getName() : co.getStructuredType().getName();
            }
        } else if (use == 4 && co.getCollectionType() != null) {
            type = co.getCollectionType().getName();
        }
        if ("unknown".equalsIgnoreCase((String)type)) {
            type = co.getNativeDataType();
        }
        return type;
    }

    @Override
    protected void initPropertiesList() {
        String rform;
        String lform;
        EngPropertyHolder cnPH;
        this.initNameProperty();
        COPropertiesComparator.processDataTypeAndUse(this.propertiesList, this.left_co, this.right_co);
        PropertyHolder ph = new PropertyHolder(MANDATORY);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.left_co != null ? String.valueOf(!this.left_co.getNullsAllowed()) : "");
        ph.setRightValue(this.right_co != null ? String.valueOf(!this.right_co.getNullsAllowed()) : "");
        if (this.isExcludedFromComparison(MANDATORY)) {
            ph.setExcluded(true);
        } else if (this.left_co != null && this.right_co != null && this.left_co.getNullsAllowed() != this.right_co.getNullsAllowed()) {
            if (this.left_co.isFKElement() && this.right_co.isFKElement()) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setRightValue(ph.getRightValue() + "(FK)");
            } else {
                ph.setModified(true);
                ph.setSelected(true);
            }
        }
        this.propertiesList.add(ph);
        if (this.left_co != null && this.left_co instanceof Column && this.right_co != null && this.right_co instanceof Column) {
            String rname;
            Column lcol = (Column)this.left_co;
            Column rcol = (Column)this.right_co;
            ph = new PropertyHolder(NNC_NAME);
            ph.setDDLHolder(true);
            String lname = lcol.getNotNullConstraintName();
            if (lname == null) {
                lname = "";
            }
            if ((rname = rcol.getNotNullConstraintName()) == null) {
                rname = "";
            }
            ph.setLeftValue(lname);
            ph.setRightValue(rname);
            if (this.isExcludedFromComparison(NNC_NAME)) {
                ph.setExcluded(true);
            } else if (!(lname.equalsIgnoreCase(rname) || "".equals(lname) && rname.startsWith("SYS_") || "".equals(rname) && lname.startsWith("SYS_") || lname.startsWith("SYS_") && rname.startsWith("SYS_") || (this.includeSystemNames || lname.startsWith("SYS_")) && !this.includeSystemNames)) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(DEFAULT_VALUE);
        ph.setDDLHolder(true);
        String leftValue = this.left_co != null ? this.left_co.getDefaultValue().replaceAll("'", "") : "";
        String rightValue = this.right_co != null ? this.right_co.getDefaultValue().replaceAll("'", "") : "";
        ph.setLeftValue(leftValue);
        ph.setRightValue(rightValue);
        if (this.left_co != null && this.right_co != null && !leftValue.trim().equals(rightValue.trim())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        boolean usename = true;
        if (this.left_co != null && this.right_co != null && this.left_co.getUseDomainConstraints() && PropertiesComparator.DDL_ONLY) {
            usename = false;
        }
        if (this.isExcludedFromComparison((cnPH = COPropertiesComparator.createCheckConstrNamePH(this.left_co, this.right_co)).getName())) {
            cnPH.setExcluded(true);
        }
        this.propertiesList.add(cnPH);
        if (!PropertiesComparator.DDL_ONLY) {
            ph = new PropertyHolder(EngPropertiesComparator.USE_DOMAIN_CONSTRAINT);
            ph.setLeftValue(this.left_co != null ? String.valueOf(this.left_co.getUseDomainConstraints()) : "");
            ph.setRightValue(this.right_co != null ? String.valueOf(this.right_co.getUseDomainConstraints()) : "");
            if (this.isExcludedFromComparison(USE_DOMAIN_CONSTRAINT)) {
                ph.setExcluded(true);
            } else if (this.left_co != null && this.right_co != null && this.left_co.getUseDomainConstraints() != this.right_co.getUseDomainConstraints()) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        if (this.left_co != null && !this.left_co.getUseDomainConstraints() || this.right_co != null && !this.right_co.getUseDomainConstraints()) {
            EngPropertyHolder ccPH = COPropertiesComparator.createCheckConstrPH(this.left_co, this.right_co);
            EngPropertyHolder rcPH = COPropertiesComparator.createRangeConstrPH(this.left_co, this.right_co);
            EngPropertyHolder vcPH = COPropertiesComparator.createLOVConstraintPH(this.left_co, this.right_co);
            if ((ccPH.isModified() || rcPH.isModified() || vcPH.isModified()) && COPropertiesComparator.isConstrCondConsistent(this.left_co, this.right_co)) {
                ccPH.setSelected(false);
                rcPH.setSelected(false);
                vcPH.setSelected(false);
            }
            if (this.isExcludedFromComparison(ccPH.getName())) {
                ccPH.setExcluded(true);
            }
            if (this.isExcludedFromComparison(rcPH.getName())) {
                rcPH.setExcluded(true);
            }
            if (this.isExcludedFromComparison(vcPH.getName())) {
                vcPH.setExcluded(true);
            }
            this.propertiesList.add(ccPH);
            this.propertiesList.add(rcPH);
            this.propertiesList.add(vcPH);
        }
        if (!PropertiesComparator.DDL_ONLY && this.left_co != null && this.left_co instanceof Column && this.right_co != null && this.right_co instanceof Column) {
            ph = new PropertyHolder(GEN_CHECK_CONSTRAINT_IN_DDL);
            ph.setDDLHolder(true);
            ph.setLeftValue(((Column)this.left_co).getGenerateConstraintInDDL());
            ph.setRightValue(((Column)this.right_co).getGenerateConstraintInDDL());
            if (this.isExcludedFromComparison(GEN_CHECK_CONSTRAINT_IN_DDL)) {
                ph.setExcluded(true);
            } else {
                ph.setModified(false);
                ph.setSelected(false);
            }
            this.propertiesList.add(ph);
        }
        this.initCommentsAndNotes();
        if (!PropertiesComparator.DDL_ONLY) {
            ph = new PropertyHolder(SOURCE_TYPE);
            ph.setLeftValue(this.left_co != null ? this.left_co.getSourceType() : "");
            ph.setRightValue(this.right_co != null ? this.right_co.getSourceType() : "");
            if (this.isExcludedFromComparison(SOURCE_TYPE)) {
                ph.setExcluded(true);
            } else if (this.left_co != null && this.right_co != null && !this.left_co.getSourceType().equals(this.right_co.getSourceType())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        if (this.left_co instanceof Column || this.right_co instanceof Column) {
            ph = new PropertyHolder(COMPUTED);
            ph.setLeftValue(this.left_co != null ? String.valueOf(((Column)this.left_co).isComputed()) : "");
            ph.setRightValue(this.right_co != null ? String.valueOf(((Column)this.right_co).isComputed()) : "");
            if (this.isExcludedFromComparison(COMPUTED)) {
                ph.setExcluded(true);
            } else if (this.left_co != null && this.right_co != null && !((Column)this.left_co).isComputed().equals(((Column)this.right_co).isComputed())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(FORMULA_DESC);
        ph.setLeftValue(this.left_co != null ? this.left_co.getFormulaDesc() : "");
        ph.setRightValue(this.right_co != null ? this.right_co.getFormulaDesc() : "");
        if (this.isExcludedFromComparison(FORMULA_DESC)) {
            ph.setExcluded(true);
        } else if (this.left_co != null && this.right_co != null && !(lform = this.left_co.getFormulaDesc()).equals(rform = this.right_co.getFormulaDesc()) && !(lform = StringUtilities.removeQuotes(lform)).equalsIgnoreCase(rform = StringUtilities.removeQuotes(rform))) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(TYPE_SUBSTITUTION);
        ph.setLeftValue(this.left_co != null ? String.valueOf(this.left_co.isAllowSubtypeSubstitution()) : "");
        ph.setRightValue(this.right_co != null ? String.valueOf(this.right_co.isAllowSubtypeSubstitution()) : "");
        if (this.isExcludedFromComparison(TYPE_SUBSTITUTION)) {
            ph.setExcluded(true);
        } else if (this.left_co != null && this.right_co != null && this.left_co.isAllowSubtypeSubstitution() != this.right_co.isAllowSubtypeSubstitution()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_co != null && this.right_co != null) {
            this.right_co.setTemporaryWriteable(true);
            super.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(DATA_TYPE) || ph.getName().equals(DATA_TYPE_KIND) || ph.getName().equals(NATIVE_DATA_TYPE)) {
                    MergingModels.copyDataTypeFromCOWD_To_COWD(this.left_co, this.right_co, true);
                    continue;
                }
                if (ph.getName().equals(TYPE_SUBSTITUTION)) {
                    this.right_co.setAllowSubtypeSubstitution(this.left_co.isAllowSubtypeSubstitution());
                    this.right_co.setRestrictedTypeSubstitution(this.left_co.isRestrictedTypeSubstitution());
                    continue;
                }
                if (ph.getName().equals(MANDATORY)) {
                    this.right_co.setNullsAllowed(this.left_co.getNullsAllowed());
                    continue;
                }
                if (ph.getName().equals(NNC_NAME) && this.right_co instanceof Column && this.left_co instanceof Column) {
                    ((Column)this.right_co).setNotNullConstraintName(((Column)this.left_co).getNotNullConstraintName());
                    continue;
                }
                if (ph.getName().equals(GEN_CHECK_CONSTRAINT_IN_DDL) && this.right_co instanceof Column && this.left_co instanceof Column) {
                    ((Column)this.right_co).setGenerateConstraintInDDL(((Column)this.left_co).getGenerateConstraintInDDL());
                    continue;
                }
                if (ph.getName().equals(DEFAULT_VALUE)) {
                    this.right_co.setDefaultValue(this.left_co.getDefaultValue());
                    continue;
                }
                if (ph.getName().equals(USES_DEFUALT_VALUE)) {
                    this.right_co.setUsesDefaultValue(this.left_co.getUsesDefaultValue());
                    continue;
                }
                if (ph.getName().equals(SOURCE_TYPE)) {
                    this.right_co.setSourceType(this.left_co.getSourceType());
                    continue;
                }
                if (ph.getName().equals(COMPUTED)) {
                    ((Column)this.right_co).setComputed(((Column)this.left_co).isComputed());
                    continue;
                }
                if (ph.getName().equals(FORMULA_DESC)) {
                    this.right_co.setFormulaDesc(this.left_co.getFormulaDesc());
                    continue;
                }
                if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                    this.right_co.setConstraintName(this.left_co.getConstraintName());
                    continue;
                }
                if (ph.getName().equals(EngPropertiesComparator.USE_DOMAIN_CONSTRAINT)) {
                    this.right_co.setUseDomainConstraints(this.left_co.getUseDomainConstraints());
                    continue;
                }
                if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT)) {
                    COPropertiesComparator.copyCheckConstraint(this.left_co, this.right_co);
                    continue;
                }
                if (ph.getName().equals(EngPropertiesComparator.RANGE_CONSTRAINT)) {
                    COPropertiesComparator.copyRangeConstraint(this.left_co, this.right_co);
                    continue;
                }
                if (!ph.getName().equals(EngPropertiesComparator.LOV_CONSTRAINT)) continue;
                COPropertiesComparator.copyLOVConstraint(this.left_co, this.right_co);
            }
            this.copySelectedDynamicProperties();
            this.right_co.setTemporaryWriteable(false);
        }
    }

    public static EngPropertyHolder createCheckConstrNamePH(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        EngPropertyHolder ph = new EngPropertyHolder(CHECK_CONSTRAINT_NAME);
        ph.setDDLHolder(true);
        String leftName = "";
        String leftName2 = "";
        if (left_co != null) {
            leftName = left_co.getConstraintName();
            if (PropertiesComparator.DDL_ONLY && !leftName.toUpperCase().startsWith("SYS_")) {
                leftName2 = leftName;
            }
        }
        String rightName = "";
        String rightName2 = "";
        if (right_co != null) {
            rightName = right_co.getConstraintName();
            if (PropertiesComparator.DDL_ONLY && !rightName.toUpperCase().startsWith("SYS_")) {
                rightName2 = rightName;
            }
        }
        ph.setLeftValue(leftName);
        ph.setRightValue(rightName);
        if (left_co != null && right_co != null && !leftName.equalsIgnoreCase(rightName)) {
            ph.setModified(true);
            ph.setSelected(true);
            if (PropertiesComparator.DDL_ONLY && rightName2.equalsIgnoreCase(leftName2)) {
                ph.setEditable(true);
                ph.setSelected(false);
                ph.setFiltered(true);
            }
        }
        return ph;
    }

    public static EngPropertyHolder createCheckConstrPH(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        EngPropertyHolder ph = new EngPropertyHolder(CHECK_CONSTRAINT);
        ph.setDDLHolder(true);
        if (left_co != null && left_co.getCheck() != null) {
            CheckConstraint left_check = left_co.getCheck();
            RDBMSType left_type = left_co.getDesignPart().getSelectedRDBMSSite().getType();
            String left_text = left_check.getImplementation(left_type);
            left_text = left_text.replaceAll("%COLUMN%", left_co.getName());
            left_text = left_text.replaceAll("%column%", left_co.getName());
            ph.setLeftValue(left_text.trim());
        } else {
            ph.setLeftValue("");
        }
        if (right_co != null && right_co.getCheck() != null) {
            CheckConstraint right_check = right_co.getCheck();
            RDBMSType right_type = right_co.getDesignPart().getSelectedRDBMSSite().getType();
            String right_text = right_check.getImplementation(right_type);
            right_text = right_text.replaceAll("%COLUMN%", right_co.getName());
            right_text = right_text.replaceAll("%column%", right_co.getName());
            ph.setRightValue(right_text.trim());
        } else {
            ph.setRightValue("");
        }
        if (left_co != null && right_co != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        return ph;
    }

    public static EngPropertyHolder createLOVConstraintPH(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        EngPropertyHolder ph = new EngPropertyHolder(LOV_CONSTRAINT);
        ph.setDDLHolder(true);
        String leftValue = "";
        if (left_co != null && left_co.getValueList() != null) {
            ConstraintEnumeration left_check = left_co.getValueList();
            leftValue = left_check.getValuesAsString().replaceAll("'", "");
        }
        ph.setLeftValue(leftValue);
        String rightValue = "";
        if (right_co != null && right_co.getValueList() != null) {
            ConstraintEnumeration right_check = right_co.getValueList();
            rightValue = right_check.getValuesAsString().replaceAll("'", "");
        }
        ph.setRightValue(rightValue);
        if (left_co != null && right_co != null && !leftValue.equals(rightValue)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        return ph;
    }

    public static EngPropertyHolder createRangeConstrPH(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        EngPropertyHolder ph = new EngPropertyHolder(RANGE_CONSTRAINT);
        ph.setDDLHolder(true);
        if (left_co != null) {
            ph.setLeftValue(COPropertiesComparator.getAVTsToString(left_co));
        } else {
            ph.setLeftValue("");
        }
        if (right_co != null) {
            ph.setRightValue(COPropertiesComparator.getAVTsToString(right_co));
        } else {
            ph.setRightValue("");
        }
        if (left_co != null && right_co != null && !COPropertiesComparator.haveEqualAVTs(left_co, right_co)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        return ph;
    }

    public static boolean isConstrCondConsistent(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        String left_text = "";
        String right_text = "";
        if (left_co != null) {
            left_text = left_co.getConstraintsText(left_co.getName().toUpperCase());
        }
        if (right_co != null) {
            right_text = right_co.getConstraintsText(right_co.getName().toUpperCase());
        }
        return left_text.equals(right_text);
    }

    private static String getAVTsToString(ContainedObject co) {
        StringBuffer sb = new StringBuffer();
        for (AVT avt : co.getAVTs()) {
            sb.append(avt.getValuesAsString()).append(",").append("\n ");
        }
        int i = sb.lastIndexOf(",");
        if (i > 0) {
            return sb.substring(0, i).trim();
        }
        return sb.toString().trim();
    }

    private static boolean haveEqualAVTs(ContainedObject left_co, ContainedObject right_co) {
        Object[] right_ar;
        Object[] left_ar = left_co.getAVTs().toArray();
        if (left_ar.length != (right_ar = right_co.getAVTs().toArray()).length) {
            return false;
        }
        for (int i = 0; i < left_ar.length; ++i) {
            if (!(left_ar[i] instanceof AVT) || !(right_ar[i] instanceof AVT)) {
                return false;
            }
            AVT left_avt = (AVT)left_ar[i];
            AVT right_avt = (AVT)right_ar[i];
            if (left_avt.getBeginValue().equals(right_avt.getBeginValue()) && left_avt.getEndValue().equals(right_avt.getEndValue())) continue;
            return false;
        }
        return true;
    }

    public static void copyCheckConstraint(ContainedObject left_co, ContainedObject right_co) {
        if (PropertiesComparator.DDL_ONLY) {
            right_co.setUseDomainConstraints(false);
        }
        if (right_co.getUseDomainConstraints()) {
            return;
        }
        CheckConstraint left_c = left_co.getCheck();
        if (left_c == null) {
            right_co.setCheck(null);
            return;
        }
        CheckConstraint right_c = right_co.getCheck();
        if (right_c == null) {
            right_c = new CheckConstraint();
            right_c.setDesign(left_co.getDesign());
        }
        right_co.setCheck(right_c);
        if (right_c != left_c) {
            left_c.copyTo(right_c);
        }
    }

    public static void copyLOVConstraint(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        if (PropertiesComparator.DDL_ONLY) {
            right_co.setUseDomainConstraints(false);
        }
        if (right_co.getUseDomainConstraints()) {
            return;
        }
        ConstraintEnumeration left_c = left_co.getOwnValueList();
        if (left_c == null) {
            right_co.setOwnValueList(null);
            return;
        }
        ConstraintEnumeration right_c = right_co.getOwnValueList();
        if (right_c == null) {
            right_c = new ConstraintEnumeration();
            right_c.setDesign(right_co.getDesign());
        }
        right_co.setValueList(right_c);
        if (right_c != left_c) {
            ((AbstractConstraint)left_c).copyTo(right_c);
        }
    }

    public static void copyRangeConstraint(ContainedObject left_co, ContainedObject right_co) {
        if (PropertiesComparator.DDL_ONLY) {
            right_co.setUseDomainConstraints(false);
        }
        if (right_co.getUseDomainConstraints()) {
            return;
        }
        Iterator it = left_co.getAVTs().iterator();
        right_co.clearAVTs();
        while (it.hasNext()) {
            AVT avt = (AVT)it.next();
            AVT newAVT = new AVT(avt.getBeginValue(), avt.getEndValue(), avt.getDescription());
            right_co.addAVT(newAVT);
        }
    }

    public static boolean isTypesDifferent(String leftType, String rightType) {
        String[] parts = leftType.split(" ");
        Object left = "";
        for (String p : parts) {
            String s = p.trim();
            if (s.isEmpty()) continue;
            left = (String)left + s;
        }
        Object right = "";
        for (String p : parts = rightType.split(" ")) {
            String s = p.trim();
            if (s.isEmpty()) continue;
            right = (String)right + s;
        }
        return !((String)left).equalsIgnoreCase((String)right);
    }

    public static void processDataTypeAndUse(List propertiesList, ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        String left_type = left_co != null ? COPropertiesComparator.getType(left_co) : "";
        String right_type = right_co != null ? COPropertiesComparator.getType(right_co) : "";
        StorageDesign sd = null;
        if (left_co != null && left_co.getDesignPart() instanceof RelationalDesign) {
            sd = ((RelationalDesign)left_co.getDesignPart()).getStorageDesign();
        } else if (right_co != null && right_co.getDesignPart() instanceof RelationalDesign) {
            sd = ((RelationalDesign)right_co.getDesignPart()).getStorageDesign();
        }
        if (PropertiesComparator.HIVE_DATA_TYPES) {
            if (left_co != null && left_co instanceof Column) {
                left_type = left_co.getDataTypePresentationForHive();
            }
            if (right_co != null && right_co instanceof Column) {
                right_type = right_co.getDataTypePresentationForHive();
            }
        }
        String left_datatype_kind = left_co != null ? COPropertiesComparator.decodeDataTypeKindToString(left_co) : "";
        String right_datatype_kind = right_co != null ? COPropertiesComparator.decodeDataTypeKindToString(right_co) : "";
        EngPropertyHolder ph = new EngPropertyHolder(DATA_TYPE);
        ph.setDDLHolder(true);
        ph.setLeftValue(left_type);
        ph.setRightValue(right_type);
        if (left_co != null && right_co != null && COPropertiesComparator.isTypesDifferent(left_type, right_type)) {
            boolean synonyms = COPropertiesComparator.isEqualToNumberDataType(sd, left_co, right_co);
            if (!synonyms) {
                synonyms = COPropertiesComparator.isEqualToFloatDataType(sd, left_co, right_co);
            }
            if (!synonyms) {
                ph.setModified(true);
                ph.setSelected(true);
                if (COPropertiesComparator.isDatatypeCompatible(left_co, right_co)) {
                    ph.setSelected(false);
                }
            }
        }
        propertiesList.add(ph);
        boolean useDataTypeKind = false;
        if (left_co != null) {
            useDataTypeKind = left_co.getDesignPart().getDesign().getSettings().isUseDataTypeKindInCompare();
        } else if (right_co != null) {
            useDataTypeKind = right_co.getDesignPart().getDesign().getSettings().isUseDataTypeKindInCompare();
        }
        ph = new EngPropertyHolder(DATA_TYPE_KIND);
        ph.setLeftValue(left_datatype_kind);
        ph.setRightValue(right_datatype_kind);
        if (left_co != null && right_co != null && !left_datatype_kind.equals(right_datatype_kind)) {
            ph.setModified(true);
            if (useDataTypeKind && !PropertiesComparator.DDL_ONLY) {
                ph.setSelected(true);
            } else {
                ph.setEditable(false);
                ph.setFiltered(true);
            }
        }
        propertiesList.add(ph);
    }

    public static String decodeDataTypeKindToString(ContainedObjectWithDomain co) {
        short use = co.getUse();
        if (use == 0) {
            return "Domain(" + co.getDomain().getName() + ")";
        }
        if (use == 1) {
            return "Logical Type(" + co.getLogicalDatatype().getName() + ")";
        }
        if (use == 2) {
            if (co.getDistinctType() != null) {
                return "Distinct Type(" + co.getDistinctType().getName() + ")";
            }
            return "Missing Distinct Type";
        }
        if (use == 3) {
            return "Structured Type";
        }
        if (use == 4) {
            return "Collection Type";
        }
        return "";
    }

    private static boolean isEqualToFloatDataType(StorageDesign sd, ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        if (sd != null && sd instanceof StorageDesignOracle) {
            String rdbmsName = sd.getRDBMSType().getName();
            ContainedObjectWithDomain co = right_co;
            Datatype leftDataType = left_co.getDataType();
            Datatype rightDataType = right_co.getDataType();
            String rightName = rightDataType.getName();
            String leftName = leftDataType.getName();
            if (FLOAT.equalsIgnoreCase(leftName) && (FLOAT.equalsIgnoreCase(rightName) || REAL.equalsIgnoreCase(rightName) || DOUBLE.equalsIgnoreCase(rightName)) || FLOAT.equalsIgnoreCase(rightName) && (FLOAT.equalsIgnoreCase(leftName) || REAL.equalsIgnoreCase(leftName) || DOUBLE.equalsIgnoreCase(leftName))) {
                Map map;
                String pdf;
                String rpr = right_co.getPrecision();
                if (right_co.getUse() == 0 && right_co.getDomain() != null) {
                    rpr = right_co.getDomain().getPrecision();
                }
                String lpr = left_co.getPrecision();
                if (left_co.getUse() == 0 && left_co.getDomain() != null) {
                    lpr = left_co.getDomain().getPrecision();
                }
                if ("".equals(lpr) && (pdf = (String)(map = (Map)left_co.getLogicalDatatype().getDefaultValues().get(rdbmsName)).get("precision_default_value")) != null && !"".equals(pdf)) {
                    lpr = pdf;
                }
                if ("".equals(rpr) && (pdf = (String)(map = (Map)right_co.getLogicalDatatype().getDefaultValues().get(rdbmsName)).get("precision_default_value")) != null && !"".equals(pdf)) {
                    rpr = pdf;
                }
                if (rpr.equalsIgnoreCase(lpr)) {
                    return true;
                }
                if ("".equals(lpr) && "126".equals(rpr) || "".equals(rpr) && "126".equals(lpr)) {
                    return true;
                }
                if ("".equals(lpr) && "63".equals(rpr) || "".equals(rpr) && "63".equals(lpr)) {
                    return true;
                }
            }
            if (rightName.equalsIgnoreCase(INTEGER) || rightName.equalsIgnoreCase(INT) || rightName.equalsIgnoreCase(SMALLINT)) {
                leftDataType = right_co.getDataType();
                rightDataType = left_co.getDataType();
                co = left_co;
            } else if (!(leftName.equalsIgnoreCase(INTEGER) || leftName.equalsIgnoreCase(INT) || leftName.equalsIgnoreCase(SMALLINT))) {
                return false;
            }
            rightName = rightDataType.getName();
            if ((rightName.equalsIgnoreCase(NUMBER) || rightName.equalsIgnoreCase(NUMERIC)) && "38".equals(co.getPrecision())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isDatatypeCompatible(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        String rightSize;
        String leftSize;
        Datatype leftDataType = left_co.getDataType();
        Datatype rightDataType = right_co.getDataType();
        if (leftDataType.getName().equalsIgnoreCase(rightDataType.getName()) && leftDataType.getName().equalsIgnoreCase("VARCHAR2") && (leftSize = left_co.getSizeOnly()).equalsIgnoreCase(rightSize = right_co.getSizeOnly())) {
            String rightUnit;
            String leftUnit = left_co.getUnits();
            return leftUnit.equalsIgnoreCase(rightUnit = right_co.getUnits()) || !"CHAR".equals(leftUnit) && !"CHAR".equals(rightUnit);
        }
        return false;
    }

    private static boolean isEqualToNumberDataType(StorageDesign sd, ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        if (sd != null && sd instanceof StorageDesignOracle) {
            String rdbmsName = sd.getRDBMSType().getName();
            ContainedObjectWithDomain co = right_co;
            Datatype leftDataType = left_co.getDataType();
            Datatype rightDataType = right_co.getDataType();
            String rightName = rightDataType.getName();
            String leftName = leftDataType.getName();
            if (NUMBER.equalsIgnoreCase(leftName) && (NUMERIC.equalsIgnoreCase(rightName) || DECIMAL.equalsIgnoreCase(rightName) || DEC.equalsIgnoreCase(rightName) || NUMBER.equalsIgnoreCase(rightName)) || NUMBER.equalsIgnoreCase(rightName) && (NUMERIC.equalsIgnoreCase(leftName) || DECIMAL.equalsIgnoreCase(leftName) || DEC.equalsIgnoreCase(leftName) || NUMBER.equalsIgnoreCase(leftName))) {
                String pdf;
                String rpr = right_co.getPrecision();
                String rsc = right_co.getScale();
                if (right_co.getUse() == 0 && right_co.getDomain() != null) {
                    rpr = right_co.getDomain().getPrecision();
                    rsc = right_co.getDomain().getScale();
                }
                String lpr = left_co.getPrecision();
                String lsc = left_co.getScale();
                if (left_co.getUse() == 0 && left_co.getDomain() != null) {
                    lpr = left_co.getDomain().getPrecision();
                }
                Map map = (Map)left_co.getLogicalDatatype().getDefaultValues().get(rdbmsName);
                if ("".equals(lpr) && (pdf = (String)map.get("precision_default_value")) != null && !"".equals(pdf)) {
                    lpr = pdf;
                }
                if ("".equals(lsc) && (pdf = (String)map.get("scale_default_value")) != null && !"".equals(pdf)) {
                    lsc = pdf;
                }
                map = (Map)right_co.getLogicalDatatype().getDefaultValues().get(rdbmsName);
                if ("".equals(rpr) && (pdf = (String)map.get("precision_default_value")) != null && !"".equals(pdf)) {
                    rpr = pdf;
                }
                if ("".equals(rsc) && (pdf = (String)map.get("scale_default_value")) != null && !"".equals(pdf)) {
                    rpr = pdf;
                }
                if (rpr.equalsIgnoreCase(lpr) && rsc.equalsIgnoreCase(lsc)) {
                    return true;
                }
                if ("".equals(lpr) && "38".equals(rpr) || "".equals(rpr) && "38".equals(lpr)) {
                    return true;
                }
            }
            if (rightName.equalsIgnoreCase(INTEGER) || rightName.equalsIgnoreCase(INT) || rightName.equalsIgnoreCase(SMALLINT)) {
                leftDataType = right_co.getDataType();
                rightDataType = left_co.getDataType();
                co = left_co;
            } else if (!(leftName.equalsIgnoreCase(INTEGER) || leftName.equalsIgnoreCase(INT) || leftName.equalsIgnoreCase(SMALLINT))) {
                return false;
            }
            rightName = rightDataType.getName();
            if ((rightName.equalsIgnoreCase(NUMBER) || rightName.equalsIgnoreCase(NUMERIC)) && "38".equals(co.getPrecision())) {
                return true;
            }
        }
        return false;
    }
}

