/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;

public class Note
extends MultiShapedDesignObject
implements EditableFonts {
    private static final String DEFAULT_TEXT = Messages.getString("Note.DoubleClickToedit");
    private List editableFonts = new ArrayList();
    public static final String TYPE_NAME = "Note";

    public Note(DesignPart designPart) {
        super(designPart);
        this.setComment(DEFAULT_TEXT);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public String getText() {
        return this.getComment();
    }

    public void setText(String text) {
        this.setComment(text);
    }

    @Override
    public String getFCObjectType() {
        return TYPE_NAME;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    @Override
    public void remove() {
        this.remove(true);
    }

    public void remove(boolean ask) {
        super.remove();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "note" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

