/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.search.Searchable;
import oracle.dbtools.crest.util.GUID;

public abstract class DesignPart
extends ModelIDObject
implements SetListener,
Searchable {
    public static final String SUB_VIEW_TYPE = "SUB_VIEW_TYPE";
    private Set listeners = new HashSet();
    private boolean shouldBeOpen;
    private boolean loaded;
    private boolean objectListChanged;
    protected boolean listOfObjectsChanged = false;
    private String mainViewID;
    private List errorDescriptionList;
    private List tasks = Collections.synchronizedList(new ArrayList());
    protected Map f2tMap = null;
    protected Map dfMap = null;
    protected DesignPartView mainView;
    private IDGenerator globalGenerator;
    protected SubViewObjectSet subViews;
    protected DesignPartViewPlaceHolder dpvPlaceHolder;
    private TreeMap filesMap = new TreeMap();

    public DesignPart() {
        this.subViews = new SubViewObjectSet(this, Messages.getString("DesignPart.Subviews"));
        this.subViews.setParent(this);
        this.subViews.setElementDescriptor(SUB_VIEW_TYPE);
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public List getErrorDescriptionList() {
        if (this.errorDescriptionList == null) {
            this.errorDescriptionList = new ArrayList();
        }
        return this.errorDescriptionList;
    }

    public boolean isShouldBeOpen() {
        return this.shouldBeOpen;
    }

    public void setShouldBeOpen(boolean shouldBeOpen) {
        this.shouldBeOpen = shouldBeOpen;
    }

    public String getMainViewID() {
        return this.mainViewID;
    }

    public void setMainViewID(String mainViewID) {
        this.mainViewID = mainViewID;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setObjectListChanged(boolean objectListChanged) {
        this.objectListChanged = objectListChanged;
    }

    public boolean isObjectListChanged() {
        return this.objectListChanged;
    }

    public abstract List getStorableSets();

    public void sortCollections() {
    }

    public void addDesignPartListener(DesignPartListener listener) {
        this.listeners.add(listener);
    }

    public void removeDesignPartListener(DesignPartListener listener) {
        this.listeners.remove(listener);
    }

    public List<StorableObject> getNotMarkedGenerateObjects() {
        return Collections.EMPTY_LIST;
    }

    public void doAfterSave() {
    }

    public abstract DesignPartView getMainView();

    public abstract Note createNote();

    public Collection getStorableDesignObjects() {
        ArrayList collection = new ArrayList();
        for (DesignObjectSet set : this.getStorableSets()) {
            set.addAllElementsTo(collection);
        }
        return collection;
    }

    public boolean hasDirtyStorableObjects() {
        for (DesignObject dobj : this.getStorableDesignObjects()) {
            if (!dobj.isDirty()) continue;
            return true;
        }
        return this.hasDeletedObjects();
    }

    public boolean hasDeletedObjects() {
        Collection col = this.getStorableDesignObjects();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (DesignObject designObject : col) {
            map.put(designObject.getObjectID(), designObject.getObjectID());
        }
        for (Map.Entry entry : this.filesMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null) continue;
            return true;
        }
        return false;
    }

    public void synchronizeFilesMap(boolean removeFromVCS) {
        this.removeDeletedObjects(removeFromVCS);
        this.createFilesMap();
    }

    public void createFilesMap() {
        this.filesMap.clear();
        Collection col = this.getStorableDesignObjects();
        for (DesignObject dobj : col) {
            if (dobj.getStorageName() == null) continue;
            this.filesMap.put(dobj.getObjectID(), dobj.getSegmentedStorageName());
        }
    }

    private void removeDeletedObjects(boolean removeFromVCS) {
        Collection col = this.getStorableDesignObjects();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (DesignObject dobj : col) {
            map.put(dobj.getObjectID(), dobj.getObjectID());
        }
        ArrayList deleted = new ArrayList();
        for (Map.Entry entry : this.filesMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null) continue;
            deleted.add(entry.getValue());
        }
        if (deleted.size() > 0) {
            // empty if block
        }
    }

    public void executeTasks() {
        Iterator it = this.tasks.iterator();
        while (it.hasNext()) {
            boolean succeeded = false;
            Task task = (Task)it.next();
            try {
                succeeded = task.execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!succeeded) continue;
            it.remove();
        }
    }

    public void doAfterLoad() {
        int pers = this.getDesign().getLoadedModelPersistence();
        if (pers != Design.PERS_MODEL_IN_ONE_FILE) {
            this.createFilesMap();
        }
        this.setLoaded(true);
        this.setDirty(false);
        this.setObjectListChanged(false);
    }

    public void doBeforeLoad() {
    }

    public boolean isListOfObjectsChanged() {
        return this.listOfObjectsChanged;
    }

    public abstract StorableObject createObject(String var1, String var2, String var3);

    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
        }
        return this.f2tMap;
    }

    public Map getDiagramFolderMap() {
        if (this.dfMap == null) {
            this.dfMap = new LinkedHashMap();
            this.dfMap.put("subviews", "");
        }
        return this.dfMap;
    }

    public Label createLabel() {
        Label label = new Label(this);
        label.setObjectID(new GUID().toString());
        return label;
    }

    public abstract Collection getAllTopLevelObjects();

    public IDGenerator getIDGenerator() {
        if (this.globalGenerator == null) {
            this.globalGenerator = new IDGenerator();
            this.globalGenerator.initializeWith(10000L, 3000000L);
        }
        return this.globalGenerator;
    }

    public String getSubViewTypeName() {
        return "SubView";
    }

    protected abstract DesignPartView createDesignPartSubView(String var1);

    public DesignPartView createDesignPartSubView() {
        DesignPartView dpv = this.createDesignPartSubView(this.getName() + " - " + this.getSubViewTypeName());
        dpv.setDPVId(this.getIDGenerator().createNewID());
        return dpv;
    }

    private boolean componentsCollectionContainsName(SubViewObjectSet col, String name) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            if (!name.equalsIgnoreCase(((DesignObject)it.next()).getName())) continue;
            return true;
        }
        return false;
    }

    public String getNameVersion(SubViewObjectSet col, String name) {
        boolean ok = false;
        String oldName = name;
        int i = 0;
        while (!ok) {
            name = new StringBuffer(oldName).append('_').append(String.valueOf(++i)).toString();
            if (this.componentsCollectionContainsName(col, name)) continue;
            ok = true;
        }
        return name;
    }

    public DesignPartView getSubViewGeneratedByDPV(String designPVId) {
        return this.subViews.getSubViewGeneratedByDPV(designPVId);
    }

    public DesignPartView getSubViewByID(String designPVId) {
        return this.subViews.getSubViewByID(designPVId);
    }

    public DesignPartView getSubViewByName(String name) {
        return this.subViews.getSubViewByName(name);
    }

    public DesignPartView[] getMainViewAndSubViews() {
        return this.subViews.getMainViewAndSubViews();
    }

    public SubViewObjectSet getDesignSubviews() {
        return this.subViews;
    }

    public List<DesignPartView> getAllDiagrams() {
        ArrayList<DesignPartView> allDiagrams = new ArrayList<DesignPartView>();
        DesignPartView mainView = this.getMainView();
        if (mainView != null) {
            allDiagrams.add(mainView);
        }
        Iterator iterator = this.subViews.iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceholder = (DesignPartViewPlaceHolder)iterator.next();
            allDiagrams.add(designPartViewPlaceholder.getDesignPartView());
        }
        return allDiagrams;
    }

    public List getAllDPVPlaceHoldersForObjects(List objects, boolean includeMainDiagram) {
        HashMap<DesignPartView, PlaceHolder> map = new HashMap<DesignPartView, PlaceHolder>();
        DesignPartView mdpv = this.getMainView();
        for (Object object : objects) {
            if (!(object instanceof DesignObject)) continue;
            DesignObject dobj = (DesignObject)object;
            for (DesignPartView dpv : dobj.getAffectedDPVs()) {
                if (dpv == mdpv) continue;
                map.put(dpv, dpv.getPlaceHolder());
            }
        }
        ArrayList<DesignPartViewPlaceHolder> list = new ArrayList<DesignPartViewPlaceHolder>();
        if (includeMainDiagram && mdpv != null && this.getMainDPVPlaceHolder() != null) {
            list.add(this.getMainDPVPlaceHolder());
        }
        list.addAll(map.values());
        return list;
    }

    public DesignPartViewPlaceHolder getMainDPVPlaceHolder() {
        if (this.dpvPlaceHolder == null) {
            this.dpvPlaceHolder = new DesignPartViewPlaceHolder(this, this.getMainView());
            this.dpvPlaceHolder.setParent(this);
        }
        return this.dpvPlaceHolder;
    }
}

