/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.options.format.DefaultFCAgent;
import oracle.dbtools.crest.util.options.format.DefaultFCCube;
import oracle.dbtools.crest.util.options.format.DefaultFCDimension;
import oracle.dbtools.crest.util.options.format.DefaultFCEntity;
import oracle.dbtools.crest.util.options.format.DefaultFCInOutParams;
import oracle.dbtools.crest.util.options.format.DefaultFCInfoStore;
import oracle.dbtools.crest.util.options.format.DefaultFCLabel;
import oracle.dbtools.crest.util.options.format.DefaultFCLegend;
import oracle.dbtools.crest.util.options.format.DefaultFCLevel;
import oracle.dbtools.crest.util.options.format.DefaultFCLogicalView;
import oracle.dbtools.crest.util.options.format.DefaultFCNote;
import oracle.dbtools.crest.util.options.format.DefaultFCProcess;
import oracle.dbtools.crest.util.options.format.DefaultFCRelationalView;
import oracle.dbtools.crest.util.options.format.DefaultFCStructuredType;
import oracle.dbtools.crest.util.options.format.DefaultFCTable;
import oracle.dbtools.crest.util.options.format.DefaultFCTransformation;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.format.DefaultLWCDTInheritance;
import oracle.dbtools.crest.util.options.format.DefaultLWCDTReference;
import oracle.dbtools.crest.util.options.format.DefaultLWCFlow;
import oracle.dbtools.crest.util.options.format.DefaultLWCForeignKey;
import oracle.dbtools.crest.util.options.format.DefaultLWCInheritanceRelation;
import oracle.dbtools.crest.util.options.format.DefaultLWCLink;
import oracle.dbtools.crest.util.options.format.DefaultLWCRelation;
import oracle.dbtools.crest.util.options.format.DefaultLWCTypeSubstitution;
import oracle.dbtools.crest.util.options.format.DefaultLineWidthAndColor;
import oracle.dbtools.crest.util.options.format.DefaultRALabel;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DesignLevelSettings {
    public static String fileVersion = "";
    public static final String DESIGN_LEVEL_SETTINGS_FILE_NAME = "dl_settings.xml";
    public static final String SETTINGS_ELEMENT = "settings";
    public static final String SUBSTITUTION_PATTERNS = "substitution_patterns";
    public static final String OLD_STRING = "oldstring";
    public static final String NEW_STRING = "newstring";
    public static final String SELECTED = "selected";
    public static final String COMMENTS = "comments";
    public static final String CASE_SENSITIVE = "casesensitive";
    public static final String COLOR = "color";
    public static final String FOREGROUND_COLOR = "fgcolor";
    public static final String PREFIX = "prefix";
    public static final String WIDTH = "width";
    public static final String CLASSNAME = "classname";
    public static final String ATTRIBUTE = "attribute";
    public static final String VALUE = "value";
    public static final String CLASSIFICATION_TYPES = "classification_types";
    public static final String NAMING_STANDARD_RULE = "naming_standard_rules";
    public static final String LOGICAL = "logical";
    public static final String SEPARATOR = "separator";
    public static final String LOGICALCHAR = "char";
    public static final String ENTITY = "entity";
    public static final String RELATIONAL = "relational";
    public static final String MANDATORY = "mandatory";
    public static final String TYPE = "type";
    public static final String COLUMN = "column";
    public static final String DOMAIN = "domain";
    public static final String DOMAINS = "domains";
    public static final String TABLE = "table";
    public static final String TAG_VALUE = "value";
    public static final String TAG_NAME = "name";
    public static final String LOGICALTYPE_FOR_DOMAIN_PRESENTATION = "logical_type_for_domain_presentation";
    public static final String AUTOMATIC_PK_GENERATION = "automatic_pk_generation";
    public static final String AUTOMATIC_UK_GENERATION = "automatic_uk_generation";
    public static final String AUTOMATIC_FK_GENERATION = "automatic_fk_generation";
    public static final String PRESERVE_DDL_GENERATION_OPTIONS = "preserve_ddl_generation_options";
    public static final String COMPARE_MAPPING_ELEMENTS = "comparemapping";
    public static final String COMPARE_MAPPING_ELEMENT = "mapping";
    public static final String COMPARE_MAPPING_SOURCE_PARENT = "sourceparent";
    public static final String COMPARE_MAPPING_TARGET_PARENT = "targetparent";
    public static final String COMPARE_MAPPING_SOURCE_OBJECT = "sourceobject";
    public static final String COMPARE_MAPPING_TARGET_OBJECT = "targetobject";
    public static final String COMPARE_MAPPING_SELECTED = "selected";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String DEFAULT_FONTS_AND_COLORS = "default_fonts_and_colors";
    public static final String DEFAULT_LINE_WIDTHS_AND_COLORS = "default_line_widths_and_colors";
    public static final String FC_OBJECT = "fc_object";
    public static final String LWC_OBJECT = "lwc_object";
    public static final String ABBREVIATED_ONLY = "abbreviated_only";
    public static final String CONSTRAINTS = "constraints";
    public static final String PK_VALUE = "pk";
    public static final String FK_VALUE = "fk";
    public static final String CK_VALUE = "ck";
    public static final String UN_VALUE = "un";
    public static final String IDX_VALUE = "idx";
    public static final String AUTOMATIC_IDX_VALUE = "automatic_idx";
    public static final String COLCK_VALUE = "colck";
    public static final String COLNNC_VALUE = "colnnc";
    public static final String COLUMN_FK_VALUE = "column_foreign_key";
    public static final String UI_VALUE = "ui";
    public static final String RELATION_ATTRIBUTE_VALUE = "relation_attribute";
    public static final String SURROGATE_KEY = "surrogate_key";
    public static final String SURROGATE_KEY_COL = "surrogate_key_col";
    public static final String DISCRIMINATOR_COL = "discriminator_col";
    public static final String GLOSSARY = "glossaries";
    public static final String GLOSSARIES = "glossary_file";
    public static final char NEW_LINE = '\n';
    public static final char TAB = '\t';
    public static final String USE_GLOBAL_DESIGN_LEVEL_SETTINGS = "use_global_design_level_settings";
    private boolean logicalTypeForDomainPresentation = false;
    private List substitutionList = new ArrayList();
    private List classificationTypeList;
    private NamingStandardRule namingRule;
    private boolean automaticUKGeneration;
    private boolean automaticPKGeneration;
    private boolean automaticFKGeneration;
    public List defaultFCObjects = new ArrayList();
    public List defaultLWCObjects = new ArrayList();
    public static Map<String, String> compClassToNameMap = new TreeMap<String, String>();
    public static Map<String, String> compNameToClassMap = new TreeMap<String, String>();
    public static final String USE_PREFERRED_CLASSIFICATION_TYPES = "use_preferred_classification_types";
    public static final String DESIGN_ESTIMATES = "design_estimates";
    public static final String LOGICAL_MODEL_ESTIMATES = "logical_model_estimates";
    public static final String ENTITIES = "entities";
    public static final String RELATIONS = "relations";
    public static final String VIEWS = "views";
    public static final String ARCS = "arcs";
    public static final String DATA_TYPES_MODEL_ESTIMATES = "data_types_model_estimates";
    public static final String STRUCTURED_TYPES = "structured_types";
    public static final String COLLECTION_TYPES = "collection_types";
    public static final String DISTINCT_TYPES = "distinct_types";
    public static final String RELATIONAL_MODEL_ESTIMATES = "relational_model_estimates";
    public static final String RELATIONAL_MODEL_ = "relational_model_";
    public static final String _ESTIMATES = "_estimates";
    public static final String RELATIONAL_MODEL_NAME = "relational_model_name";
    public static final String TABLES = "tables";
    public static final String FOREIGN_KEYS = "foreign_keys";
    public static final String SCHEMAS = "schemas";
    public static final String SUBVIEWS = "subviews";
    public static final String PHYSICAL_MODELS_ESTIMATES = "physical_models_estimates";
    public static final String PHYSICAL_MODEL_ = "physical_model_";
    public static final String PHYSICAL_MODEL_NAME = "physical_model_name";
    public static final String CLUSTERS = "clusters";
    public static final String CONTEXTS = "contexts";
    public static final String DBS = "dBs";
    public static final String DIMENSIONS = "dimensions";
    public static final String DIRECTORIES = "directories";
    public static final String DISKGROUPS = "diskGroups";
    public static final String EXTERNALTABLES = "externalTables";
    public static final String SNAPSHOTS = "snapshots";
    public static final String ROLES = "roles";
    public static final String ROLLBACKSEGMENTS = "rollbackSegments";
    public static final String SEGMENTS = "segments";
    public static final String SEQUENCES = "sequences";
    public static final String STOREDPROCEDURES = "storedProcedures";
    public static final String FUNCTIONS = "functions";
    public static final String PACKAGES = "packages";
    public static final String COLLECTIONTYPES = "collectionTypes";
    public static final String STRUCTUREDTYPES = "structuredTypes";
    public static final String SYNONYMS = "synonyms";
    public static final String TABLESPACES = "tableSpaces";
    public static final String TEMPORARYTABLESPACES = "temporaryTableSpaces";
    public static final String UNDOTABLESPACES = "undoTableSpaces";
    public static final String USERS = "users";
    public static final String TRIGGERS = "triggers";
    public static final String DATA_BASES = "data_bases";
    public static final String LOGINS = "logins";
    public static final String USER_DEFINED_TYPES = "user_defined_types";
    public static final String ALIASES = "aliases";
    public static final String AUX_TABLES = "aux_tables";
    public static final String BUFFER_POOLS = "buffer_pools";
    public static final String OWNERS = "owners";
    public static final String STORAGE_TEMPLATES = "storage_templates";
    public static final String STORED_PROCEDURES = "stored_procedures";
    public static final String VCATS = "vcats";
    public static final String VOLUMES = "volumes";
    public static final String DB_PARTITIONS = "db_partitions";
    public static final String USER_GROUPS = "user_groups";
    public static final String TABLE_SPACES = "table_spaces";

    public DesignLevelSettings(Design design) {
        this.loadDefaultValues();
    }

    private void loadDefaultValues() {
        this.initDefaultFCObjects();
        this.initDefaultLWCObjects();
        this.initDefaultClassificationTypes();
    }

    public NamingStandardRule getNamingStandardRule() {
        if (this.namingRule == null) {
            this.namingRule = new NamingStandardRule();
        }
        return this.namingRule;
    }

    public void initDefaultClassificationTypes() {
        this.getClassificationTypeList().add(new ClassificationType("Fact", new Color(255, 226, 198), Color.BLUE, "1", true, "", false));
        this.getClassificationTypeList().add(new ClassificationType("Dimension", new Color(228, 208, 253), Color.BLUE, "2", true, "", false));
        this.getClassificationTypeList().add(new ClassificationType("Logging", new Color(228, 228, 228), Color.BLUE, "3", true, "", false));
        this.getClassificationTypeList().add(new ClassificationType("Summary", new Color(207, 244, 202), Color.BLUE, "4", true, "", false));
        this.getClassificationTypeList().add(new ClassificationType("Temporary", new Color(255, 255, 255), Color.BLUE, "5", true, "", false));
        this.getClassificationTypeList().add(new ClassificationType("External", new Color(244, 255, 244), Color.BLUE, "6", true, "", false));
    }

    private void initDefaultFCObjects() {
        this.defaultFCObjects.clear();
        DefaultFCEntity dfcEntity = new DefaultFCEntity("Entity", new Color(164, 225, 255), Color.BLUE);
        DefaultFCLogicalView dfcLogicalView = new DefaultFCLogicalView("Logical View", new Color(255, 155, 106), Color.BLUE);
        DefaultFCTable dfcTable = new DefaultFCTable("Table", new Color(255, 255, 180), Color.BLUE);
        DefaultFCRelationalView dfcRelView = new DefaultFCRelationalView("Relational View", new Color(150, 255, 150), Color.BLUE);
        DefaultFCStructuredType dfcStructuredType = new DefaultFCStructuredType("Structured Type", new Color(140, 250, 220), Color.BLACK);
        DefaultFCCube dfcCube = new DefaultFCCube("Cube", new Color(255, 226, 198), Color.BLACK);
        DefaultFCDimension dfcDimension = new DefaultFCDimension("Dimension", new Color(0, 250, 20), Color.BLACK);
        DefaultFCLevel dfcLevel = new DefaultFCLevel("Level", new Color(228, 208, 253), Color.BLACK);
        DefaultFCProcess dfcProcess = new DefaultFCProcess("Process", new Color(255, 255, 150), Color.BLACK);
        DefaultFCAgent dfcAgent = new DefaultFCAgent("External Agent", new Color(170, 255, 170), Color.BLACK);
        DefaultFCInfoStore dfcInfoStore = new DefaultFCInfoStore("Information Store", new Color(100, 205, 255), Color.BLACK);
        DefaultFCInOutParams dfcInOutParams = new DefaultFCInOutParams("In-Out Parameters", new Color(250, 250, 250), Color.BLACK);
        DefaultFCTransformation dfcTransformation = new DefaultFCTransformation("Transformation", new Color(255, 255, 213), Color.BLACK);
        DefaultFCNote dfcNote = new DefaultFCNote("Note", Color.LIGHT_GRAY, Color.BLACK);
        DefaultFCLabel dfcLabel = new DefaultFCLabel("Label", Color.WHITE, Color.BLACK);
        DefaultRALabel dfcRA = new DefaultRALabel("Relationship Attributes", new Color(255, 153, 102), Color.BLACK);
        DefaultFCLegend dfcLegend = new DefaultFCLegend("Legend", Color.WHITE, Color.BLACK);
        this.defaultFCObjects.add(dfcEntity);
        this.defaultFCObjects.add(dfcLogicalView);
        this.defaultFCObjects.add(dfcTable);
        this.defaultFCObjects.add(dfcRelView);
        this.defaultFCObjects.add(dfcStructuredType);
        this.defaultFCObjects.add(dfcCube);
        this.defaultFCObjects.add(dfcDimension);
        this.defaultFCObjects.add(dfcLevel);
        this.defaultFCObjects.add(dfcProcess);
        this.defaultFCObjects.add(dfcAgent);
        this.defaultFCObjects.add(dfcInfoStore);
        this.defaultFCObjects.add(dfcInOutParams);
        this.defaultFCObjects.add(dfcTransformation);
        this.defaultFCObjects.add(dfcNote);
        this.defaultFCObjects.add(dfcLabel);
        this.defaultFCObjects.add(dfcRA);
        this.defaultFCObjects.add(dfcLegend);
    }

    private void initDefaultLWCObjects() {
        this.defaultLWCObjects.clear();
        DefaultLWCRelation dlwcRelation = new DefaultLWCRelation("Logical Relation", Color.BLACK, 1);
        DefaultLWCInheritanceRelation dlwcInheritance = new DefaultLWCInheritanceRelation("Logical Inheritance", Color.RED, 1);
        DefaultLWCForeignKey dlwcForeignKey = new DefaultLWCForeignKey("Relational Foreign Key", Color.BLACK, 1);
        DefaultLWCTypeSubstitution dlwcTypeSubstitution = new DefaultLWCTypeSubstitution("Type Substitution", new Color(0, 200, 20), 1);
        DefaultLWCDTReference dlwcDTReference = new DefaultLWCDTReference("Datatype Reference", Color.BLUE, 1);
        DefaultLWCDTInheritance dlwcDTInheritance = new DefaultLWCDTInheritance("Datatype Inheritance", Color.RED, 1);
        DefaultLWCLink dlwcLink = new DefaultLWCLink("Multidimentional Link", Color.BLUE, 1);
        DefaultLWCLink dlwcHierarchy = new DefaultLWCLink("Multidimensional Hierarchy", new Color(0, 200, 20), 1);
        DefaultLWCFlow dlwcFlow = new DefaultLWCFlow("Process Flow", Color.RED, 1);
        this.defaultLWCObjects.add(dlwcRelation);
        this.defaultLWCObjects.add(dlwcInheritance);
        this.defaultLWCObjects.add(dlwcForeignKey);
        this.defaultLWCObjects.add(dlwcTypeSubstitution);
        this.defaultLWCObjects.add(dlwcDTReference);
        this.defaultLWCObjects.add(dlwcDTInheritance);
        this.defaultLWCObjects.add(dlwcLink);
        this.defaultLWCObjects.add(dlwcHierarchy);
        this.defaultLWCObjects.add(dlwcFlow);
    }

    public List getClassificationTypeList() {
        if (this.classificationTypeList == null) {
            this.classificationTypeList = new ArrayList();
        }
        return this.classificationTypeList;
    }

    public ClassificationType getClassificationTypeByID(String typeID) {
        for (ClassificationType typeExists : this.classificationTypeList) {
            if (!typeExists.equalID(typeID)) continue;
            return typeExists;
        }
        return null;
    }

    public String getClassificationTypeNameByID(String typeID) {
        if (this.getClassificationTypeByID(typeID) != null) {
            return this.getClassificationTypeByID(typeID).getTypeName();
        }
        return "";
    }

    public ClassificationType getClassificationTypeByName(String name) {
        for (ClassificationType nameExists : this.classificationTypeList) {
            if (!nameExists.getTypeName().equalsIgnoreCase(name)) continue;
            return nameExists;
        }
        return null;
    }

    public Object[] getClassificationTypeNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(null);
        for (ClassificationType ct : this.classificationTypeList) {
            list.add(ct.getTypeName());
        }
        return list.toArray();
    }

    public DefaultFontAndColor getDefaultFCObject(String className) {
        for (DefaultFontAndColor dfc : this.defaultFCObjects) {
            if (!dfc.getClassName().equalsIgnoreCase(className)) continue;
            return dfc;
        }
        return null;
    }

    public DefaultLineWidthAndColor getDefaultLWCObject(String className) {
        for (DefaultLineWidthAndColor dlwc : this.defaultLWCObjects) {
            if (!dlwc.getClassName().equalsIgnoreCase(className)) continue;
            return dlwc;
        }
        return null;
    }

    public List getDefaultFCObjects() {
        return this.defaultFCObjects;
    }

    public List getDefaultLWCObjects() {
        return this.defaultLWCObjects;
    }

    public boolean isLogicalTypeForDomainPresentation() {
        return this.logicalTypeForDomainPresentation;
    }

    public void setLogicalTypeForDomainPresentation(boolean logicalTypeForDomainPresentation) {
        this.logicalTypeForDomainPresentation = logicalTypeForDomainPresentation;
    }

    public List getSubstitutionList() {
        return this.substitutionList;
    }

    public void setAutomaticUKGeneration(boolean automaticUKGeneration) {
        this.automaticUKGeneration = automaticUKGeneration;
    }

    public boolean isAutomaticUKGeneration() {
        return this.automaticUKGeneration;
    }

    public boolean isAutomaticPKGeneration() {
        return this.automaticPKGeneration;
    }

    public void setAutomaticPKGeneration(boolean automaticPKGeneration) {
        this.automaticPKGeneration = automaticPKGeneration;
    }

    public void setAutomaticFKGeneration(boolean automaticFKGeneration) {
        this.automaticFKGeneration = automaticFKGeneration;
    }

    public boolean isAutomaticFKGeneration() {
        return this.automaticFKGeneration;
    }
}

