/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.PreparedStatement;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPackageBodyOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPlSqlStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPackageOracle
extends MOHPlSqlStorageObjectOracle<PackageOracle> {
    public static final String OBJECT_TYPE = "PACKAGE";
    private static final Logger LOGGER = new Logger(MOHPackageOracle.class);
    private MOHPackageBodyOracle mohPackageBodyOracle;

    public MOHPackageOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.mohPackageBodyOracle = new MOHPackageBodyOracle(dbmeHandler);
    }

    public MOHPackageOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler, dbaUser);
        this.mohPackageBodyOracle = new MOHPackageBodyOracle(dbmeHandler, dbaUser);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public PackageOracle generateObject(StorageDesignOracle storageDesignOracle, DBObject dbObject, String source) {
        PackageOracle packageOracle = (PackageOracle)storageDesignOracle.getPackageSet().createElement(null);
        UserOracle user = (UserOracle)storageDesignOracle.getUserSet().getByName(dbObject.getSchema());
        packageOracle.setOwner(user);
        packageOracle.setName(dbObject.getName());
        packageOracle.setSource("CREATE OR REPLACE " + source);
        return packageOracle;
    }

    @Override
    protected PackageOracle generate(PreparedStatement statement, DBObject dbObject, ImportLogger importLog) throws Exception {
        PackageOracle packageOracle = (PackageOracle)super.generate(statement, dbObject, importLog);
        if (packageOracle != null) {
            packageOracle.setBody(this.mohPackageBodyOracle.generate(packageOracle, statement.getConnection(), dbObject, importLog));
            this.stampModelObject(packageOracle, dbObject);
        }
        return packageOracle;
    }
}

