/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.scheduling.SQLStatementBuilderScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerProgram;

public class SSBSchedulerProgram
extends SQLStatementBuilderScheduler {
    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new TreeMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("PROGRAM_ACTION", "PROGRAM_ACTION");
        this.excludeMap.put("PROGRAM_NAME", "PROGRAM_NAME");
        this.excludeMap.put("PROGRAM_OWNER", "PROGRAM_OWNER");
        this.excludeMap.put("PROGRAM_TYPE", "PROGRAM_TYPE");
        this.excludeMap.put("HAS_CONSTRAINTS", "HAS_CONSTRAINTS");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object instanceof SchedulerProgram) {
            SchedulerProgram prog = (SchedulerProgram)object;
            if (prog.isMinimumDefined()) {
                Map<String, String> excludeMap = this.getExcludeMap();
                StringBuffer buffer = new StringBuffer();
                SSBSchedulerProgram.appendStringWithSpace(buffer, "BEGIN");
                SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerProgram.appendStringWithSpace(buffer, "DBMS_SCHEDULER.CREATE_PROGRAM (");
                SSBSchedulerProgram.appendObjectName(buffer, prog, prettyPrint);
                SSBSchedulerProgram.appendActionJobType(buffer, prog, prettyPrint);
                SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerProgram.appendStringWithSpace(buffer, ");");
                SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 0);
                this.appendAtrtributes(buffer, prog, prettyPrint, excludeMap);
                SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 0);
                this.appendArguments(buffer, prog, prettyPrint, excludeMap);
                SSBSchedulerProgram.appendEnable(buffer, prog, prettyPrint);
                SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerProgram.appendString(buffer, "END");
                SSBSchedulerProgram.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, "");
            } else {
                SSBSchedulerProgram.appendStringWithSpace(oldbuffer, "invalid program definitiion for " + String.valueOf(prog.getName() + "\n program type and program action should be defined"));
            }
        }
    }

    public static void appendObjectName(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 2);
        SSBSchedulerProgram.appendString(buffer, "program_name => '" + obj.getNameFormatted() + "'");
    }

    public static boolean appendActionJobType(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        String type;
        String action = obj.getProperty("PROGRAM_ACTION");
        if (action != null && !action.isEmpty() && (type = obj.getProperty("PROGRAM_TYPE")) != null && !type.isEmpty()) {
            SSBSchedulerProgram.appendString(buffer, ',');
            SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerProgram.appendString(buffer, "program_type => '" + type + "',");
            SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerProgram.appendString(buffer, "program_action => '" + SSBSchedulerProgram.replaceSingle_Quote(action) + "'");
            return true;
        }
        return false;
    }

    public static void appendEnable(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getProperty("ENABLED");
        if (res != null && !res.isEmpty() && "TRUE".equalsIgnoreCase(res)) {
            String name = job.getNameFormatted();
            SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerProgram.appendStringWithSpace(buffer, "DBMS_SCHEDULER.enable(name => '" + name + "');");
        }
    }

    public void appendArguments(StringBuffer buffer, SchedulerProgram prog, boolean prettyPrint, Map<String, String> excludeMap) {
        for (SchedulerArgument arg : prog.getSortedArguments()) {
            if (arg.isMetadataArgument()) {
                SSBSchedulerProgram.appendMetadataArgument(buffer, prog, arg, prettyPrint);
                continue;
            }
            SSBSchedulerProgram.appendProgramArgument(buffer, prog, arg, prettyPrint);
        }
    }

    public static void appendMetadataArgument(StringBuffer buffer, SchedulerObject prog, SchedulerArgument arg, boolean prettyPrint) {
        SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 1);
        SSBSchedulerProgram.appendStringWithSpace(buffer, "DBMS_SCHEDULER.DEFINE_METADATA_ARGUMENT(");
        SSBSchedulerProgram.appendStringAttribute(buffer, "program_name".toLowerCase(), prog.getNameFormatted(), prettyPrint);
        if (!arg.isNullOrEmpty("ARGUMENT_NAME")) {
            SSBSchedulerProgram.appendString(buffer, ',');
            SSBSchedulerProgram.appendStringAttribute(buffer, "ARGUMENT_NAME".toLowerCase(), arg.getProperty("ARGUMENT_NAME"), prettyPrint);
        }
        if (!arg.isNullOrEmpty("ARGUMENT_POSITION")) {
            SSBSchedulerProgram.appendString(buffer, ',');
            SSBSchedulerProgram.appendNonStringAttribute(buffer, "ARGUMENT_POSITION".toLowerCase(), arg.getProperty("ARGUMENT_POSITION"), prettyPrint);
        }
        if (!arg.isNullOrEmpty("METADATA_ATTRIBUTE")) {
            SSBSchedulerProgram.appendString(buffer, ',');
            SSBSchedulerProgram.appendStringAttribute(buffer, "METADATA_ATTRIBUTE".toLowerCase(), arg.getProperty("METADATA_ATTRIBUTE"), prettyPrint);
        }
        SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 1);
        SSBSchedulerProgram.appendStringWithSpace(buffer, ");");
    }

    public static void appendProgramArgument(StringBuffer buffer, SchedulerObject prog, SchedulerArgument arg, boolean prettyPrint) {
        SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 1);
        SSBSchedulerProgram.appendStringWithSpace(buffer, "DBMS_SCHEDULER.DEFINE_PROGRAM_ARGUMENT(");
        SSBSchedulerProgram.appendStringAttribute(buffer, "program_name".toLowerCase(), prog.getNameFormatted(), prettyPrint);
        if (!arg.isNullOrEmpty("ARGUMENT_NAME")) {
            SSBSchedulerProgram.appendString(buffer, ',');
            SSBSchedulerProgram.appendStringAttribute(buffer, "ARGUMENT_NAME".toLowerCase(), arg.getProperty("ARGUMENT_NAME"), prettyPrint);
        }
        if (!arg.isNullOrEmpty("ARGUMENT_POSITION")) {
            SSBSchedulerProgram.appendString(buffer, ',');
            SSBSchedulerProgram.appendNonStringAttribute(buffer, "ARGUMENT_POSITION".toLowerCase(), arg.getProperty("ARGUMENT_POSITION"), prettyPrint);
        }
        String type = null;
        if (!arg.isNullOrEmpty("ARGUMENT_TYPE")) {
            type = arg.getProperty("ARGUMENT_TYPE");
            SSBSchedulerProgram.appendString(buffer, ',');
            SSBSchedulerProgram.appendStringAttribute(buffer, "ARGUMENT_TYPE".toLowerCase(), type, prettyPrint);
        }
        if (!arg.isNullOrEmpty("DEFAULT_VALUE")) {
            String value = arg.getProperty("DEFAULT_VALUE");
            String sqlValue = SSBSchedulerProgram.getValue(value, null);
            SSBSchedulerProgram.appendString(buffer, ',');
            SSBSchedulerProgram.appendNonStringAttribute(buffer, "DEFAULT_VALUE".toLowerCase(), sqlValue, prettyPrint);
        }
        SSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 1);
        SSBSchedulerProgram.appendStringWithSpace(buffer, ");");
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerProgram;
    }
}

