/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.scheduling.SQLStatementBuilderScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerJobClass;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SSBSchedulerJobClass
extends SQLStatementBuilderScheduler {
    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new TreeMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("JOB_CLASS_NAME", "WINDOW_NAME");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object instanceof SchedulerJobClass) {
            SchedulerJobClass sched = (SchedulerJobClass)object;
            if (sched.isMinimumDefined()) {
                Map<String, String> excludeMap = this.getExcludeMap();
                StringBuffer buffer = new StringBuffer();
                SSBSchedulerJobClass.appendStringWithSpace(buffer, "BEGIN");
                SSBSchedulerJobClass.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerJobClass.appendStringWithSpace(buffer, "DBMS_SCHEDULER.CREATE_JOB_CLASS(");
                SSBSchedulerJobClass.appendObjectName(buffer, sched, prettyPrint);
                SSBSchedulerJobClass.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerJobClass.appendStringWithSpace(buffer, ");");
                this.appendAtrtributes(buffer, sched, prettyPrint, excludeMap);
                SSBSchedulerJobClass.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerJobClass.appendEnable(buffer, sched, prettyPrint);
                SSBSchedulerJobClass.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerJobClass.appendString(buffer, "END");
                SSBSchedulerJobClass.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, "");
            } else {
                SSBSchedulerJobClass.appendStringWithSpace(oldbuffer, "invalid Job Class definitiion for " + String.valueOf(sched.getName() + "\n job class name should be defined"));
            }
        }
    }

    public static void appendObjectName(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        SSBSchedulerJobClass.appendNewLine(buffer, prettyPrint, 2);
        SSBSchedulerJobClass.appendString(buffer, "JOB_CLASS_NAME".toLowerCase() + " => '" + obj.getNameFormatted() + "'");
    }

    public static void appendEnable(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getProperty("ENABLED");
        if (res != null && !res.isEmpty() && "TRUE".equalsIgnoreCase(res)) {
            String name = job.getNameFormatted();
            SSBSchedulerJobClass.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerJobClass.appendStringWithSpace(buffer, "DBMS_SCHEDULER.enable(name => '" + name + "');");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerJobClass;
    }
}

