/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.builder.UnicodeMap;

public class UnicodeMapInt
extends UnicodeMap {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static int flag_mask = -65536;
    private static int index_mask = 65535;
    private int[] dataArray = null;
    private int[][] surrogateTable = null;
    private int[][] expandingTable = null;
    private int expanding_flag = -131072;
    private int surrogate_flag = -65536;

    public UnicodeMapInt(Vector vector) {
        if (vector == null) {
            return;
        }
        Vector vector2 = new Vector();
        int n = vector.size();
        int[] nArray = new int[65536];
        Vector vector3 = new Vector();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])vector.elementAt(i);
            int[] nArray2 = (int[])objectArray[0];
            if (nArray2.length == 1) {
                nArray2 = this.toUTF16(nArray2[0]);
            }
            int[] nArray3 = (int[])objectArray[1];
            this.putMap(nArray2, nArray3, nArray, vector2, vector3);
        }
        this.setSurrogateTable(vector2);
        this.setExpandingTable(vector3);
        this.setData(nArray);
    }

    public UnicodeMapInt(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray();
        Vector vector = new Vector();
        int n = objectArray.length;
        int[] nArray = new int[65536];
        Vector vector2 = new Vector();
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)objectArray[i];
            int n3 = n2;
            int[] nArray2 = this.toUTF16(n3);
            int[] nArray3 = (int[])hashMap.get(n2);
            this.putMap(nArray2, nArray3, nArray, vector, vector2);
        }
        this.setSurrogateTable(vector);
        this.setExpandingTable(vector2);
        this.setData(nArray);
    }

    public UnicodeMapInt(int n, int n2, Vector vector) {
        this.expanding_flag = n;
        this.surrogate_flag = n2;
        if (vector == null) {
            return;
        }
        Vector vector2 = new Vector();
        int n3 = vector.size();
        int[] nArray = new int[65536];
        Vector vector3 = new Vector();
        for (int i = 0; i < n3; ++i) {
            Object[] objectArray = (Object[])vector.elementAt(i);
            int[] nArray2 = (int[])objectArray[0];
            if (nArray2.length == 1) {
                nArray2 = this.toUTF16(nArray2[0]);
            }
            int[] nArray3 = (int[])objectArray[1];
            this.putMap(nArray2, nArray3, nArray, vector2, vector3);
        }
        this.setSurrogateTable(vector2);
        this.setExpandingTable(vector3);
        this.setData(nArray);
    }

    public UnicodeMapInt(int n, int n2, HashMap hashMap) {
        this.expanding_flag = n;
        this.surrogate_flag = n2;
        if (hashMap == null) {
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray();
        Vector vector = new Vector();
        int n3 = objectArray.length;
        int[] nArray = new int[65536];
        Vector vector2 = new Vector();
        for (int i = 0; i < n3; ++i) {
            Integer n4 = (Integer)objectArray[i];
            int n5 = n4;
            int[] nArray2 = this.toUTF16(n5);
            int[] nArray3 = (int[])hashMap.get(n4);
            this.putMap(nArray2, nArray3, nArray, vector, vector2);
        }
        this.setSurrogateTable(vector);
        this.setExpandingTable(vector2);
        this.setData(nArray);
    }

    public int[] getMapping(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        int[] nArray = new int[n * 4];
        int n3 = 0;
        while (n2 < n) {
            char c;
            int[] nArray2;
            if ((nArray2 = this.getMapping(c = string.charAt(n2++))) == null) {
                if (n2 == n) {
                    nArray2 = new int[]{c};
                } else {
                    char c2 = string.charAt(n2);
                    int n4 = c2 - 56320;
                    if (n4 <= 0 || n4 >= 1023) {
                        nArray2 = new int[]{c};
                    } else {
                        ++n2;
                        nArray2 = this.getSurrogate(c, c2);
                    }
                }
            }
            if (nArray2 == null) continue;
            if (n3 + nArray2.length > nArray.length) {
                // empty if block
            }
            System.arraycopy(nArray2, 0, nArray, n3, nArray2.length);
            n3 += nArray2.length;
        }
        int[] nArray3 = new int[n3];
        System.arraycopy(nArray, 0, nArray3, 0, n3);
        return nArray3;
    }

    public int[] getMapping(char c) {
        int n = this.getData(c);
        int n2 = n & flag_mask;
        int[] nArray = null;
        if (n2 == this.expanding_flag) {
            int n3 = n & index_mask;
            int n4 = this.expandingTable[n3].length;
            nArray = new int[n4];
            System.arraycopy(this.expandingTable[n3], 0, nArray, 0, n4);
        } else if (n2 != this.surrogate_flag) {
            nArray = new int[]{n};
        }
        return nArray;
    }

    public int[] getSurrogate(char c, char c2) {
        int n = c & 0xFFFF;
        int n2 = c2 & 0xFFFF;
        if (n < 55296 || n > 56319 || n2 < 56320 || n2 < 57343) {
            return null;
        }
        int n3 = this.getData(c);
        int n4 = this.surrogateTable[n3 & index_mask][c2 - 56320];
        if ((n4 & this.expanding_flag) != 0) {
            return this.expandingTable[n4 & index_mask];
        }
        int[] nArray = new int[]{n4};
        return nArray;
    }

    private int getData(char c) {
        return this.dataArray[this.indexArray[c >>> 8] + (c & 0xFF)];
    }

    private void putMap(int[] nArray, int[] nArray2, int[] nArray3, Vector vector, Vector vector2) {
        if (nArray.length == 1) {
            if (nArray2.length == 1) {
                nArray3[nArray[0]] = nArray2[0];
                return;
            }
            int n = vector2.size();
            nArray3[nArray[0]] = this.expanding_flag + n;
            vector2.addElement(nArray2);
            return;
        }
        if (nArray[0] < 55296 || nArray[0] > 56319 || nArray[1] < 56320 || nArray[1] < 57343) {
            System.out.println("NLT error -- invalid surrogate code points");
        } else {
            int n;
            int n2 = nArray[0] - 55296;
            int n3 = nArray[1] - 56320;
            int[] nArray4 = null;
            if (nArray3[nArray[0]] == 0) {
                int n4;
                nArray4 = new int[1024];
                n = vector.size();
                nArray3[nArray[0]] = n4 = this.surrogate_flag + n;
                vector.addElement(nArray4);
            } else {
                n = nArray3[nArray[0]] & index_mask;
                nArray4 = (int[])vector.elementAt(n);
            }
            if (nArray2.length == 1) {
                nArray4[n3] = nArray2[0];
            } else {
                n = vector2.size();
                nArray4[n3] = this.expanding_flag + n;
                vector2.addElement(nArray2);
            }
        }
    }

    private void setExpandingTable(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        this.expandingTable = new int[n][];
        for (int i = 0; i < n; ++i) {
            if (i == 240) {
                System.out.println(i);
            }
            int[] nArray = (int[])vector.elementAt(i);
            this.expandingTable[i] = new int[nArray.length];
            for (int j = 0; j < nArray.length; ++j) {
                this.expandingTable[i][j] = nArray[j];
            }
        }
    }

    private void setData(int[] nArray) {
        this.indexArray = new int[256];
        int n = UnicodeMapInt.compressIntArray(nArray, this.indexArray);
        this.dataArray = new int[n];
        System.arraycopy(nArray, 0, this.dataArray, 0, n);
    }

    private static int compressIntArray(int[] nArray, int[] nArray2) {
        nArray2[0] = 0;
        int n = 256;
        for (int i = 1; i < 256; ++i) {
            int n2;
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                int n4;
                int n5;
                int n6;
                for (n2 = 0; n2 < (256 < n - n3 ? 256 : n - n3) && (n6 = nArray[n3 + n2]) == (n5 = nArray[(n4 = i << 8) | n2]); ++n2) {
                }
                if (n2 == (256 < n - n3 ? 256 : n - n3)) break;
            }
            nArray2[i] = (short)n3;
            for (n2 = (i << 8) + (n - n3); n2 < i + 1 << 8; ++n2) {
                nArray[n++] = nArray[n2];
            }
        }
        return n;
    }

    private int[] toUTF16(int n) {
        int[] nArray = new int[1];
        if ((n & 0xFFFF0000) != 0) {
            nArray = new int[]{(n & 0xFFFF0000) >>> 16, n & 0xFFFF};
        } else {
            nArray[0] = n;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        HashMap<int[], int[]> hashMap = new HashMap<int[], int[]>();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        nArray[0] = 65;
        nArray2[0] = 1;
        hashMap.put(nArray, nArray2);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        nArray3[0] = 66;
        nArray4[0] = 2;
        hashMap.put(nArray3, nArray4);
        Set set = hashMap.keySet();
        Set set2 = hashMap.entrySet();
        Object[] objectArray = set.toArray();
        UnicodeMapInt unicodeMapInt = new UnicodeMapInt(hashMap);
        System.out.println("data of A is " + unicodeMapInt.getMapping('A')[0]);
        System.out.println("data of B is " + unicodeMapInt.getMapping('B')[0]);
    }
}

