/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.util.GDKOracleMetaData;

public class UnicodeCatTable
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private Hashtable unicodeData;
    private Vector sortedVector;
    private Hashtable htable1 = new Hashtable();
    private Hashtable htable2 = new Hashtable();
    private Hashtable htable3 = new Hashtable();
    private int[] level2 = null;
    private int[] level3 = null;
    private int[] level4 = null;
    private int[] level1 = new int[4096];
    private int[][] level2Indexer;
    private int[][] level3Indexer;
    private int[][] level4Indexer;
    private int level2IndexerPt = 0;
    private int level3IndexerPt = 0;
    private int level4IndexerPt = 0;

    public UnicodeCatTable() {
        this.unicodeData = new Hashtable();
        this.sortedVector = new Vector();
    }

    public void setData(int n, int n2) {
        int[] nArray = new int[1];
        Integer n3 = new Integer(n);
        nArray[0] = n2;
        this.unicodeData.put(n3, nArray);
        this.sortedVector.addElement(n3);
        this.storeMappingRange(n, this.htable1, this.htable2, this.htable3);
    }

    public int getData(int n) {
        Integer n2 = new Integer(n);
        int[] nArray = (int[])this.unicodeData.get(n2);
        if (nArray != null) {
            return nArray[0];
        }
        return 0;
    }

    public void finishSet() {
        int n;
        int n2;
        int n3;
        char[] cArray;
        Object k;
        int n4 = 0;
        Enumeration enumeration = this.htable1.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            cArray = (char[])this.htable1.get(k);
            if (cArray == null) continue;
            ++n4;
        }
        int n5 = 0;
        enumeration = this.htable2.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            cArray = (char[])this.htable2.get(k);
            if (cArray == null) continue;
            ++n5;
        }
        int n6 = 0;
        enumeration = this.htable3.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            byte[] byArray = (byte[])this.htable3.get(k);
            if (byArray == null) continue;
            ++n6;
        }
        this.level2Indexer = new int[n4][];
        this.level3Indexer = new int[n5][];
        this.level4Indexer = new int[n6][];
        for (int i = 0; i < 4096; ++i) {
            this.level1[i] = -1;
        }
        this.sortedVector.trimToSize();
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        boolean bl = false;
        for (n3 = 0; n3 < this.sortedVector.size(); ++n3) {
            int n11;
            int n12;
            Integer n13 = (Integer)this.sortedVector.elementAt(n3);
            int n14 = n13;
            int[] nArray = (int[])this.unicodeData.get(n13);
            if (n14 >>> 26 != 54) {
                n12 = n14 >> 4 & 0xFFF;
                n11 = n14 & 0xF;
                if (n12 != n7 && n7 != -1) {
                    n2 = this.level4IndexerPt - 1;
                    for (n = this.level4IndexerPt - 2; n >= 0; --n) {
                        if (!this.compareArray(this.level4Indexer[n2], this.level4Indexer[n])) continue;
                        if (this.level1[n7] == n2) {
                            this.level1[n7] = n;
                            this.level4Indexer[n2] = null;
                            --this.level4IndexerPt;
                            break;
                        }
                        System.err.println("internal error, please investigate");
                    }
                }
                if (this.level1[n12] == -1) {
                    ++this.level4IndexerPt;
                }
                if (this.level4Indexer[this.level1[n12]] == null) {
                    this.level4Indexer[this.level1[n12]] = new int[16];
                }
                this.level4Indexer[this.level1[n12]][n11] = nArray[0];
                bl = false;
                n7 = n12;
                n10 = n11;
                continue;
            }
            n12 = n14 >> 20 & 0xFFF;
            int n15 = n14 >> 12 & 0xFF;
            int n16 = n14 >> 4 & 0xFF;
            n11 = n14 & 0xF;
            if (!bl) {
                if (n12 != n7 && n7 != -1) {
                    n2 = this.level4IndexerPt - 1;
                    for (n = this.level4IndexerPt - 2; n >= 0; --n) {
                        if (!this.compareArray(this.level4Indexer[n2], this.level4Indexer[n])) continue;
                        if (this.level1[n7] == n2) {
                            this.level1[n7] = n;
                            this.level4Indexer[n2] = null;
                            --this.level4IndexerPt;
                            break;
                        }
                        System.err.println("internal error, please investigate");
                    }
                }
            } else if (n7 != -1 && n8 != -1 && n9 != -1 && n10 != -1) {
                if (n16 != n9 || n15 != n8 || n12 != n7) {
                    n2 = this.level4IndexerPt - 1;
                    for (n = this.level4IndexerPt - 2; n >= 0; --n) {
                        if (!this.compareArray(this.level4Indexer[n2], this.level4Indexer[n])) continue;
                        if (this.level3Indexer[this.level3IndexerPt - 1][n9] == n2) {
                            this.level3Indexer[this.level3IndexerPt - 1][n9] = n;
                            this.level4Indexer[n2] = null;
                            --this.level4IndexerPt;
                            break;
                        }
                        System.err.println("internal error, please investigate");
                    }
                }
                if (n15 != n8 || n12 != n7) {
                    n2 = this.level3IndexerPt - 1;
                    for (n = this.level3IndexerPt - 2; n >= 0; --n) {
                        if (!this.compareArray(this.level3Indexer[n2], this.level3Indexer[n])) continue;
                        if (this.level2Indexer[this.level2IndexerPt - 1][n8] == n2) {
                            this.level2Indexer[this.level2IndexerPt - 1][n8] = n;
                            this.level3Indexer[n2] = null;
                            --this.level3IndexerPt;
                            break;
                        }
                        System.err.println("internal error, please investigate");
                    }
                }
                if (n12 != n7) {
                    n2 = this.level2IndexerPt - 1;
                    for (n = this.level2IndexerPt - 2; n >= 0; --n) {
                        if (!this.compareArray(this.level2Indexer[n2], this.level2Indexer[n])) continue;
                        if (this.level1[n7] == n2) {
                            this.level1[n7] = n;
                            this.level2Indexer[n2] = null;
                            --this.level2IndexerPt;
                            break;
                        }
                        System.err.println("internal error, please investigate");
                    }
                }
            }
            if (this.level1[n12] == -1) {
                ++this.level2IndexerPt;
            }
            if (this.level2Indexer[this.level1[n12]] == null) {
                this.level2Indexer[this.level1[n12]] = new int[256];
                for (n2 = 0; n2 < 256; ++n2) {
                    this.level2Indexer[this.level1[n12]][n2] = -1;
                }
            }
            if (this.level2Indexer[this.level1[n12]][n15] == -1) {
                this.level2Indexer[this.level1[n12]][n15] = this.level3IndexerPt++;
            }
            if (this.level3Indexer[this.level2Indexer[this.level1[n12]][n15]] == null) {
                this.level3Indexer[this.level2Indexer[this.level1[n12]][n15]] = new int[256];
                for (n2 = 0; n2 < 256; ++n2) {
                    this.level3Indexer[this.level2Indexer[this.level1[n12]][n15]][n2] = -1;
                }
            }
            if (this.level3Indexer[this.level2Indexer[this.level1[n12]][n15]][n16] == -1) {
                this.level3Indexer[this.level2Indexer[this.level1[n12]][n15]][n16] = this.level4IndexerPt++;
            }
            if (this.level4Indexer[this.level3Indexer[this.level2Indexer[this.level1[n12]][n15]][n16]] == null) {
                this.level4Indexer[this.level3Indexer[this.level2Indexer[this.level1[n12]][n15]][n16]] = new int[16];
                for (n2 = 0; n2 < 16; ++n2) {
                    this.level4Indexer[this.level3Indexer[this.level2Indexer[this.level1[n12]][n15]][n16]][n2] = 0;
                }
            }
            this.level4Indexer[this.level3Indexer[this.level2Indexer[this.level1[n12]][n15]][n16]][n11] = nArray[0];
            bl = true;
            n7 = n12;
            n8 = n15;
            n9 = n16;
            n10 = n11;
        }
        this.unicodeData = null;
        this.sortedVector = null;
        this.htable1 = null;
        this.htable2 = null;
        this.htable3 = null;
        this.level2 = new int[this.level2IndexerPt * 256];
        this.level3 = new int[this.level3IndexerPt * 256];
        this.level4 = new int[this.level4IndexerPt * 16];
        n3 = 0;
        for (n2 = 0; n2 < this.level4IndexerPt; ++n2) {
            for (n = 0; n < 16; ++n) {
                this.level4[n3++] = this.level4Indexer[n2][n];
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < this.level3IndexerPt; ++n2) {
            for (n = 0; n < 256; ++n) {
                this.level3[n3++] = this.level3Indexer[n2][n] == -1 ? this.level3Indexer[n2][n] : this.level3Indexer[n2][n] * 16;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < this.level2IndexerPt; ++n2) {
            for (n = 0; n < 256; ++n) {
                this.level2[n3++] = this.level2Indexer[n2][n] == -1 ? this.level2Indexer[n2][n] : this.level2Indexer[n2][n] * 256;
            }
        }
        for (n2 = 0; n2 < 4096; ++n2) {
            if (this.level1[n2] == -1) continue;
            this.level1[n2] = n2 >= 3456 && n2 <= 3583 ? this.level1[n2] * 256 : this.level1[n2] * 16;
        }
        this.level2Indexer = null;
        this.level3Indexer = null;
        this.level4Indexer = null;
    }

    public int getProperties(int n) {
        int n2 = n < 65536 ? n : (55296 + (n - 65536 >> 10) << 16) + (56320 + (n & 0x3FF));
        if (n2 >>> 26 == 54) {
            int n3 = n2 >> 20 & 0xFFF;
            int n4 = n2 >> 12 & 0xFF;
            int n5 = n2 >> 4 & 0xFF;
            int n6 = n2 & 0xF;
            if (this.level1[n3] != -1 && this.level2[this.level1[n3] + n4] != -1 && this.level3[this.level2[this.level1[n3] + n4] + n5] != -1) {
                return this.level4[this.level3[this.level2[this.level1[n3] + n4] + n5] + n6];
            }
        } else {
            if (n2 >= 55296 && n2 <= 57343) {
                return 0;
            }
            int n7 = n2 >> 4 & 0xFFF;
            int n8 = n2 & 0xF;
            if (this.level1[n7] != -1) {
                return this.level4[this.level1[n7] + n8];
            }
        }
        return 0;
    }

    public boolean isCompatibility(int n) {
        if (n >= 63744 && n <= 64045) {
            return true;
        }
        return (this.getProperties(n) >>> 15 & 1) == 1;
    }

    private void storeMappingRange(int n, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        int n2 = 20;
        int n3 = 12;
        int n4 = 4;
        int n5 = 4095;
        int n6 = 255;
        int n7 = 255;
        int n8 = 15;
        if (n >>> 26 == 54) {
            int n9 = n >> n2 & n5;
            int n10 = n >> n3 & n6;
            int n11 = n >> n4 & n7;
            int n12 = n & n8;
            Integer n13 = new Integer(n9);
            Integer n14 = new Integer(n >> n3 & 0xFFFFF);
            Integer n15 = new Integer(n >> n4 & 0xFFFFFFF);
            char[] cArray = (char[])hashtable.get(n13);
            if (cArray == null) {
                cArray = new char[]{'\uffff', '\u0000'};
            }
            if (cArray[0] == '\uffff' && cArray[1] == '\u0000') {
                cArray[0] = (char)n10;
                cArray[1] = (char)n10;
            } else {
                if (n10 < (cArray[0] & 0xFFFF)) {
                    cArray[0] = (char)n10;
                }
                if (n10 > (cArray[0] & 0xFFFF)) {
                    cArray[1] = (char)n10;
                }
            }
            hashtable.put(n13, cArray);
            cArray = (char[])hashtable2.get(n14);
            if (cArray == null) {
                cArray = new char[]{'\uffff', '\u0000'};
            }
            if (cArray[0] == '\uffff' && cArray[1] == '\u0000') {
                cArray[0] = (char)n11;
                cArray[1] = (char)n11;
            } else {
                if (n11 < (cArray[0] & 0xFFFF)) {
                    cArray[0] = (char)n11;
                }
                if (n11 > (cArray[0] & 0xFFFF)) {
                    cArray[1] = (char)n11;
                }
            }
            hashtable2.put(n14, cArray);
            byte[] byArray = (byte[])hashtable3.get(n15);
            if (byArray == null) {
                byArray = new byte[]{-1, 0};
            }
            if (byArray[0] == 255 && byArray[1] == 0) {
                byArray[0] = (byte)n12;
                byArray[1] = (byte)n12;
            } else {
                if (n12 < (byArray[0] & 0xFF)) {
                    byArray[0] = (byte)n12;
                }
                if (n12 > (byArray[0] & 0xFF)) {
                    byArray[1] = (byte)n12;
                }
            }
            hashtable3.put(n15, byArray);
        } else {
            Integer n16 = new Integer(n >> 4 & n5);
            int n17 = n & 0xF;
            byte[] byArray = (byte[])hashtable3.get(n16);
            if (byArray == null) {
                byArray = new byte[]{-1, 0};
            }
            if (byArray[0] == 255 && byArray[1] == 0) {
                byArray[0] = (byte)n17;
                byArray[1] = (byte)n17;
            } else {
                if (n17 < (byArray[0] & 0xFF)) {
                    byArray[0] = (byte)n17;
                }
                if (n17 > (byArray[0] & 0xFF)) {
                    byArray[1] = (byte)n17;
                }
            }
            hashtable3.put(n16, byArray);
        }
    }

    private boolean compareArray(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }
}

