/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util;

import java.io.Serializable;
import java.util.Locale;
import oracle.gss.util.UnicodeProperty;
import oracle.i18n.util.GDKOracleMetaData;

public class XmlValidate
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    public static final short PARTIAL_ESCAPE = 0;
    public static final short FULL_ESCAPE = 1;
    private static final UnicodeProperty UnicodeProp = UnicodeProperty.getInstance();
    private static final XmlValidate m_xmlval = new XmlValidate();

    public static XmlValidate getInstance() {
        return m_xmlval;
    }

    public boolean isChar(int n) {
        return n >= 32 && n <= 55295 || n >= 57344 && n <= 65533 || n == 9 || n == 10 || n == 13 || n >= 65536 && n <= 0x10FFFF;
    }

    public boolean isSpace(int n) {
        return n == 32 || n == 9 || n == 13 || n == 10;
    }

    public boolean isLetter(int n) {
        return this.isBaseChar(n) || this.isIdeographic(n);
    }

    public boolean isDigit(int n) {
        if (XmlValidate.isCompatibleArea(n)) {
            return false;
        }
        short s = UnicodeProp.getProperties(n, (short)0);
        return s == 7;
    }

    public boolean isCombiningChar(int n) {
        short s = UnicodeProp.getProperties(n, (short)0);
        return !XmlValidate.isCompatibleArea(n) && (s == 4 || s == 6 || s == 5);
    }

    public boolean isBaseChar(int n) {
        if (n >= 97 && n <= 122 || n >= 65 && n <= 90) {
            return true;
        }
        short s = UnicodeProp.getProperties(n, (short)0);
        return !(n >= 160 && this.isCompatibility(n) || XmlValidate.isCompatibleArea(n) || s != 2 && s != 1 && s != 19 && s != 3 && s != 8);
    }

    public boolean isIdeographic(int n) {
        return n >= 19968 && n <= 40869 || n == 12295 || n >= 12321 && n <= 12329;
    }

    public boolean isAlphaNum(int n) {
        short s = UnicodeProp.getProperties(n, (short)0);
        return this.isLetter(n) || this.isDigit(n);
    }

    public boolean isPunctuation(int n) {
        short s = UnicodeProp.getProperties(n, (short)0);
        return s == 20 || s == 21 || s == 22 || s == 23 || s == 26;
    }

    public boolean isNameChar(int n) {
        return this.isLetter(n) || this.isDigit(n) || this.isCombiningChar(n) || this.isExtender(n) || n == 95 || n == 46 || n == 58 || n == 45;
    }

    public boolean isFirstNameChar(int n) {
        return this.isLetter(n) || n == 95 || n == 58;
    }

    public boolean isExtender(int n) {
        return n == 183 || n == 720 || n == 721 || n == 903 || n == 1600 || n == 3654 || n == 3782 || n == 12293 || n >= 12337 && n <= 12341 || n >= 12445 && n <= 12446 || n >= 12540 && n <= 12542 || n == 6211 || n == 750;
    }

    private static boolean isCompatibleArea(int n) {
        return n >= 63744 && n <= 65534;
    }

    public String SqlToXmlName(String string, short s) {
        String string2 = new String();
        int n = string.length();
        int n2 = 1;
        if (n == 0) {
            return string;
        }
        char c = string.charAt(0);
        if (c == ':') {
            string2 = string2 + "_x003A_";
        } else if (n >= 2 && string.substring(0, 2).equals("_x")) {
            string2 = string2 + "_x005F_";
        } else if (s == 1 && n >= 3 && string.substring(0, 3).toUpperCase(Locale.US).equals("XML")) {
            string2 = string2 + "_xFFFF_" + string.substring(0, 3);
            n2 = 3;
        } else if (c >= '\ud800' && c < '\udc00') {
            if (n > 1) {
                string2 = string2 + this.hexEscape(c << 16 | string.charAt(1) & 0xFFFF);
                n2 = 2;
            } else {
                string2 = string2 + this.hexEscape(c);
            }
        } else {
            string2 = this.isFirstNameChar(c) ? string2 + c : string2 + this.hexEscape(c);
        }
        for (int i = n2; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 >= '\ud800' && c2 < '\udc00') {
                if (i + 1 < n) {
                    string2 = string2 + this.hexEscape(c2 << 16 | string.charAt(i + 1) & 0xFFFF);
                    ++i;
                    continue;
                }
                string2 = string2 + this.hexEscape(c2);
                continue;
            }
            string2 = !this.isNameChar(c2) ? string2 + this.hexEscape(c2) : (c2 == ':' && s == 1 ? string2 + "_x003A_" : string2 + c2);
        }
        return string2;
    }

    public String XmlToSqlName(String string) {
        String string2 = new String();
        int n = string.length();
        boolean bl = false;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c >= 'A' && c <= 'F' || c >= '0' && c <= '9') {
                    string3 = string3 + c;
                    continue;
                }
                if (c == '_') {
                    bl = false;
                    int n2 = string3.length();
                    if (n2 > 4) {
                        char c2 = (char)Integer.parseInt(string3.substring(0, n2 - 4), 16);
                        char c3 = (char)Integer.parseInt(string3.substring(n2 - 4), 16);
                        string2 = string2 + c2;
                        string2 = string2 + c3;
                        continue;
                    }
                    int n3 = Integer.parseInt(string3, 16);
                    if (n3 == 65535) continue;
                    string2 = string2 + (char)n3;
                    continue;
                }
                string2 = string2 + "_x" + string3 + c;
                bl = false;
                continue;
            }
            if (c == '_' && i + 1 < n && string.charAt(i + 1) == 'x') {
                bl = true;
                string3 = new String();
                ++i;
                continue;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    public boolean isCompatibility(int n) {
        return UnicodeProp.isCompatibility(n);
    }

    private String hexEscape(char c) {
        String string = Integer.toHexString(c);
        switch (string.length()) {
            case 1: {
                string = "_x000" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 2: {
                string = "_x00" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 3: {
                string = "_x0" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 4: {
                string = "_x" + string.toUpperCase(Locale.US) + "_";
            }
        }
        return string;
    }

    private String hexEscape(int n) {
        String string = Integer.toHexString(n);
        switch (string.length()) {
            case 1: 
            case 5: {
                string = "_x000" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 2: 
            case 6: {
                string = "_x00" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 3: 
            case 7: {
                string = "_x0" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 4: 
            case 8: {
                string = "_x" + string.toUpperCase(Locale.US) + "_";
            }
        }
        return string;
    }
}

