/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.navigator;

import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.raptor.ssh.navigator.SshBaseElement;
import oracle.dbtools.raptor.ssh.navigator.SshHostElement;
import oracle.dbtools.raptor.ssh.navigator.SshTunnelElement;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;

public final class SshOverlayTracker
extends IconOverlayTracker {
    private static final IconOverlay CONNECTED_OVERLAY_INFORMATION = new IconOverlay(SshSupportResources.getIcon("HOST_OPEN_OVERLAY_ICON"), null, null);
    private static final IconOverlay DISCONNECTED_OVERLAY_INFORMATION = new IconOverlay(SshSupportResources.getIcon("HOST_CLOSED_OVERLAY_ICON"), null, null);

    protected boolean isControlled(Element element) {
        return element instanceof SshBaseElement;
    }

    protected IconOverlay[] getOverlays(Element[] elementArray) {
        Client client = Client.getInstance();
        IconOverlay[] iconOverlayArray = new IconOverlay[elementArray.length];
        for (int i = 0; i < elementArray.length; ++i) {
            HostDescriptor hostDescriptor;
            Element element = elementArray[i];
            if (element instanceof SshHostElement) {
                hostDescriptor = ((SshHostElement)element).getHost();
                iconOverlayArray[i] = client.isConnectionOpen(hostDescriptor) ? CONNECTED_OVERLAY_INFORMATION : DISCONNECTED_OVERLAY_INFORMATION;
                continue;
            }
            if (!(element instanceof SshTunnelElement)) continue;
            hostDescriptor = ((SshTunnelElement)element).getTunnel();
            iconOverlayArray[i] = client.isTunnelOpen((TunnelDescriptor)hostDescriptor) ? CONNECTED_OVERLAY_INFORMATION : DISCONNECTED_OVERLAY_INFORMATION;
        }
        return iconOverlayArray;
    }
}

