/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.navigator;

import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.ClientEvent;
import oracle.dbtools.raptor.ssh.core.ClientListener;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.StoreEvent;
import oracle.dbtools.raptor.ssh.core.StoreListener;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public abstract class SshBaseElement
extends DefaultElement
implements Subject {
    private IdeSubject m_delegate;
    private Icon mIcon;

    protected SshBaseElement() {
    }

    public final Icon getIcon() {
        if (this.mIcon == null) {
            this.mIcon = this.loadIcon();
        }
        return this.mIcon;
    }

    protected abstract Icon loadIcon();

    protected final void clearIcon() {
        this.mIcon = null;
    }

    protected void processEvent(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public final synchronized void attach(Observer observer) {
        if (this.m_delegate == null) {
            this.m_delegate = new IdeSubject();
        }
        this.m_delegate.attach(observer);
    }

    public final synchronized void detach(Observer observer) {
        if (this.m_delegate != null) {
            this.m_delegate.detach(observer);
        }
    }

    public final void notifyObservers(Object object, UpdateMessage updateMessage) {
        if (this.m_delegate != null) {
            this.m_delegate.notifyObservers(object, updateMessage);
        }
    }

    protected void initListeners() {
        Client client = Client.getInstance();
        Store store = client.getStore();
        store.addStoreListener(new StoreListener(){

            public void hostAdded(final StoreEvent storeEvent) {
                SshBaseElement.this.processEvent(new Runnable(){

                    @Override
                    public void run() {
                        SshBaseElement.this.handleHostAdded(storeEvent);
                    }
                });
            }

            public void hostRemoved(final StoreEvent storeEvent) {
                SshBaseElement.this.processEvent(new Runnable(){

                    @Override
                    public void run() {
                        SshBaseElement.this.handleHostRemoved(storeEvent);
                    }
                });
            }

            public void hostChanged(final StoreEvent storeEvent) {
                SshBaseElement.this.processEvent(new Runnable(){

                    @Override
                    public void run() {
                        SshBaseElement.this.handleHostChanged(storeEvent);
                    }
                });
            }

            public void tunnelAdded(final StoreEvent storeEvent) {
                SshBaseElement.this.processEvent(new Runnable(){

                    @Override
                    public void run() {
                        SshBaseElement.this.handleTunnelAdded(storeEvent);
                    }
                });
            }

            public void tunnelRemoved(final StoreEvent storeEvent) {
                SshBaseElement.this.processEvent(new Runnable(){

                    @Override
                    public void run() {
                        SshBaseElement.this.handleTunnelRemoved(storeEvent);
                    }
                });
            }

            public void tunnelChanged(final StoreEvent storeEvent) {
                SshBaseElement.this.processEvent(new Runnable(){

                    @Override
                    public void run() {
                        SshBaseElement.this.handleTunnelChanged(storeEvent);
                    }
                });
            }
        });
        client.addListener(new ClientListener(){

            public void connectionOpened(ClientEvent clientEvent) {
                SshBaseElement.this.processClientEvent(clientEvent);
            }

            public void connectionClosed(ClientEvent clientEvent) {
                SshBaseElement.this.processClientEvent(clientEvent);
            }

            public void tunnelOpened(ClientEvent clientEvent) {
                SshBaseElement.this.processClientEvent(clientEvent);
            }

            public void tunnelClosed(ClientEvent clientEvent) {
                SshBaseElement.this.processClientEvent(clientEvent);
            }
        });
    }

    protected void handleHostAdded(StoreEvent storeEvent) {
    }

    protected void handleHostRemoved(StoreEvent storeEvent) {
    }

    protected void handleHostChanged(StoreEvent storeEvent) {
    }

    protected void handleTunnelAdded(StoreEvent storeEvent) {
    }

    protected void handleTunnelRemoved(StoreEvent storeEvent) {
    }

    protected void handleTunnelChanged(StoreEvent storeEvent) {
    }

    protected void processClientEvent(ClientEvent clientEvent) {
    }
}

