/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh;

import java.awt.Component;
import java.io.IOException;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;

public class TunnelOpenRunnable
implements Runnable {
    private final Client client;
    private final TunnelDescriptor desc;
    private volatile Tunnel t;
    private volatile IOException ex;

    public static Tunnel openTunnel(Client client, TunnelDescriptor tunnelDescriptor) throws IOException {
        IOException iOException;
        TunnelOpenRunnable tunnelOpenRunnable = new TunnelOpenRunnable(client, tunnelDescriptor);
        if (SwingUtilities.isEventDispatchThread()) {
            iOException = new ProgressBar((Component)Ide.getMainWindow(), "Opening SSH Tunnel", null, true);
            iOException.setRunnable(() -> TunnelOpenRunnable.lambda$openTunnel$0(tunnelOpenRunnable, (ProgressBar)iOException));
            iOException.setCancelable(false);
            iOException.start("", "");
        } else {
            tunnelOpenRunnable.run();
        }
        iOException = tunnelOpenRunnable.ex;
        if (iOException != null) {
            throw iOException;
        }
        return tunnelOpenRunnable.t;
    }

    private TunnelOpenRunnable(Client client, TunnelDescriptor tunnelDescriptor) {
        this.client = client;
        this.desc = tunnelDescriptor;
    }

    @Override
    public void run() {
        try {
            this.t = this.client.openTunnel(this.desc);
        }
        catch (IOException iOException) {
            this.ex = iOException;
        }
    }

    private static /* synthetic */ void lambda$openTunnel$0(TunnelOpenRunnable tunnelOpenRunnable, ProgressBar progressBar) {
        tunnelOpenRunnable.run();
        progressBar.setDoneStatus();
    }
}

