/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.util.Logger;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;

public final class RaptorStore
extends Store {
    private static final String TUNNELS_KEY = "tunnels";
    private static final String HOSTS_KEY = "hosts";
    private static final String PORT_KEY = "port";
    private static final String HOSTPORT_KEY = "hostport";
    private static final String HOSTNAME_KEY = "hostname";
    private static final String TYPE_KEY = "type";
    private static final String NAME_KEY = "name";
    private static final String USERNAME_KEY = "user";
    private static final String PROPS_KEY = "properties";
    private static final String KEYFILE_KEY = "keyfile";
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"sqldeveloper-ssh");
    private static final String ROOT_NAME = "ssh-hosts";
    private final URL mStoreURL;
    private HashStructure mHash;

    private static HashStructure toHashStructure(TunnelDescriptor tunnelDescriptor) {
        HashStructure hashStructure = HashStructure.newInstance();
        hashStructure.putString(NAME_KEY, tunnelDescriptor.getName());
        TunnelDescriptor.Type type = tunnelDescriptor.getType();
        hashStructure.putString(TYPE_KEY, type.name());
        hashStructure.putString(HOSTNAME_KEY, tunnelDescriptor.getHostname());
        hashStructure.putInt(HOSTPORT_KEY, tunnelDescriptor.getHostport());
        int n = tunnelDescriptor.getPort();
        if (n > 0) {
            hashStructure.putInt(PORT_KEY, n);
        }
        return hashStructure;
    }

    private static TunnelDescriptor createTunnelDescriptor(HashStructure hashStructure) {
        TunnelDescriptor tunnelDescriptor = null;
        String string = hashStructure.getString(NAME_KEY);
        if (ModelUtil.hasLength((String)string)) {
            try {
                TunnelDescriptor.Type type = TunnelDescriptor.Type.valueOf((String)hashStructure.getString(TYPE_KEY));
                TunnelDescriptor.Builder builder = new TunnelDescriptor.Builder(string, type);
                builder.host(hashStructure.getString(HOSTNAME_KEY));
                builder.hostPort(hashStructure.getInt(HOSTPORT_KEY));
                int n = hashStructure.getInt(PORT_KEY, 0);
                if (n > 0) {
                    builder.port(n);
                }
                tunnelDescriptor = builder.getDescriptor();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.severe(RaptorStore.class, (Throwable)illegalArgumentException);
            }
        }
        return tunnelDescriptor;
    }

    private static HashStructure toHashStructure(HostDescriptor hostDescriptor) {
        Set set;
        URL uRL;
        HashStructure hashStructure = HashStructure.newInstance();
        hashStructure.putString(NAME_KEY, hostDescriptor.getName());
        hashStructure.putString(HOSTNAME_KEY, hostDescriptor.getHostname());
        hashStructure.putString(USERNAME_KEY, hostDescriptor.getUsername());
        int n = hostDescriptor.getPort();
        if (n != 22) {
            hashStructure.putInt(PORT_KEY, n);
        }
        if ((uRL = hostDescriptor.getKeyfile()) != null) {
            hashStructure.putURL(KEYFILE_KEY, uRL);
        }
        if ((set = hostDescriptor.getPropertyNames()).size() > 0) {
            HashStructure hashStructure2 = HashStructure.newInstance();
            hashStructure.putHashStructure(PROPS_KEY, hashStructure2);
            for (String string : set) {
                hashStructure2.putString(string, hostDescriptor.getProperty(string));
            }
        }
        return hashStructure;
    }

    private static HostDescriptor createHostDescriptor(HashStructure hashStructure) {
        HashStructure hashStructure2;
        URL uRL;
        Object object;
        String string = hashStructure.getString(NAME_KEY);
        String string2 = hashStructure.getString(HOSTNAME_KEY);
        String string3 = hashStructure.getString(USERNAME_KEY);
        int n = hashStructure.getInt(PORT_KEY, -1);
        if (!ModelUtil.hasLength((String)string)) {
            if (!ModelUtil.hasLength((String)string2) || !ModelUtil.hasLength((String)string3)) {
                return null;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(string3).append('@');
            ((StringBuilder)object).append(string2);
            if (n > 0 && n != 22) {
                ((StringBuilder)object).append(':');
                ((StringBuilder)object).append(n);
            }
            string = ((StringBuilder)object).toString();
        }
        object = new HostDescriptor.Builder(string);
        if (string2 != null) {
            object.hostname(string2);
        }
        if (string3 != null) {
            object.username(string3);
        }
        if (n > 0) {
            object.port(n);
        }
        if ((uRL = hashStructure.getURL(KEYFILE_KEY)) != null) {
            object.keyfile(uRL);
        }
        if ((hashStructure2 = hashStructure.getHashStructure(PROPS_KEY)) != null) {
            for (String string4 : hashStructure2.keySet()) {
                object.setProperty(string4, hashStructure2.getString(string4));
            }
        }
        return object.getDescriptor();
    }

    static Store createStore(URL uRL) {
        HashStructure hashStructure = HashStructure.newInstance();
        RaptorStore raptorStore = new RaptorStore(hashStructure, uRL);
        try {
            raptorStore.load();
        }
        catch (IOException iOException) {
            Logger.severe(Store.class, (Throwable)iOException);
        }
        return raptorStore;
    }

    protected static HashStructureIO getIO() {
        return new HashStructureIO(NAMESPACE_URI, ROOT_NAME);
    }

    private RaptorStore(HashStructure hashStructure, URL uRL) {
        this.mHash = hashStructure;
        this.mStoreURL = uRL;
    }

    void load() throws IOException {
        if (URLFileSystem.exists((URL)this.mStoreURL)) {
            HashStructureIO hashStructureIO = RaptorStore.getIO();
            hashStructureIO.open(this.mStoreURL, (Object)this.mHash);
        }
    }

    void save() throws IOException {
        if (this.mHash.isDirty()) {
            HashStructureIO hashStructureIO = RaptorStore.getIO();
            hashStructureIO.save(this.mStoreURL, (Object)this.mHash);
            this.mHash.markDirty(false);
        }
    }

    private void doSave() {
        try {
            this.save();
        }
        catch (IOException iOException) {
            Logger.severe(Store.class, (Throwable)iOException);
        }
    }

    private HashStructure getHosts(boolean bl) {
        HashStructure hashStructure = this.mHash.getHashStructure(HOSTS_KEY);
        if (bl && hashStructure == null) {
            hashStructure = HashStructure.newInstance();
            this.mHash.putHashStructure(HOSTS_KEY, hashStructure);
        }
        return hashStructure;
    }

    private HashStructure getTunnels(String string, boolean bl) {
        HashStructure hashStructure;
        HashStructure hashStructure2 = null;
        HashStructure hashStructure3 = this.getHosts(false);
        if (hashStructure3 != null && (hashStructure = hashStructure3.getHashStructure(string)) != null && (hashStructure2 = hashStructure.getHashStructure(TUNNELS_KEY)) == null && bl) {
            hashStructure2 = HashStructure.newInstance();
            hashStructure.putHashStructure(TUNNELS_KEY, hashStructure2);
        }
        return hashStructure2;
    }

    public Collection<String> listHosts() {
        HashStructure hashStructure = this.getHosts(false);
        Set set = hashStructure != null ? hashStructure.keySet() : Collections.emptySet();
        return set;
    }

    public HostDescriptor getHostDescriptor(String string) {
        HashStructure hashStructure;
        HostDescriptor hostDescriptor = null;
        HashStructure hashStructure2 = this.getHosts(false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string)) != null) {
            hostDescriptor = RaptorStore.createHostDescriptor(hashStructure);
        }
        return hostDescriptor;
    }

    public Collection<String> listTunnels(String string) {
        HashStructure hashStructure = this.getTunnels(string, false);
        Set set = hashStructure != null ? hashStructure.keySet() : Collections.emptySet();
        return set;
    }

    public TunnelDescriptor getTunnelDescriptor(String string, String string2) {
        HashStructure hashStructure;
        TunnelDescriptor tunnelDescriptor = null;
        HashStructure hashStructure2 = this.getTunnels(string, false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string2)) != null) {
            tunnelDescriptor = RaptorStore.createTunnelDescriptor(hashStructure);
            HostDescriptor hostDescriptor = this.getHostDescriptor(string);
            tunnelDescriptor.setHost(hostDescriptor);
        }
        return tunnelDescriptor;
    }

    public void addHost(HostDescriptor hostDescriptor) {
        HashStructure hashStructure = this.getHosts(true);
        hashStructure.putHashStructure(hostDescriptor.getName(), RaptorStore.toHashStructure(hostDescriptor));
        this.doSave();
        this.fireHostAddedEvent(hostDescriptor);
    }

    public void removeHost(String string) {
        HashStructure hashStructure;
        HashStructure hashStructure2 = this.getHosts(false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string)) != null) {
            HostDescriptor hostDescriptor = RaptorStore.createHostDescriptor(hashStructure);
            hashStructure2.remove(string);
            this.doSave();
            this.fireHostRemovedEvent(hostDescriptor);
        }
    }

    public void updateHost(HostDescriptor hostDescriptor, HostDescriptor hostDescriptor2) {
        HashStructure hashStructure = this.getHosts(false);
        if (hashStructure != null && ModelUtil.areDifferent((Object)hostDescriptor, (Object)hostDescriptor2)) {
            String string = hostDescriptor.getName();
            String string2 = hostDescriptor2.getName();
            HashStructure hashStructure2 = null;
            HashStructure hashStructure3 = hashStructure.getHashStructure(string);
            if (hashStructure3 != null) {
                hashStructure2 = hashStructure3.getHashStructure(TUNNELS_KEY);
                hashStructure.remove(string);
            }
            HashStructure hashStructure4 = RaptorStore.toHashStructure(hostDescriptor2);
            if (hashStructure2 != null) {
                hashStructure4.putHashStructure(TUNNELS_KEY, hashStructure2);
            }
            hashStructure.putHashStructure(string2, hashStructure4);
            this.doSave();
            this.fireHostChangedEvent(hostDescriptor2, hostDescriptor);
        }
    }

    public void addTunnel(HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor) {
        tunnelDescriptor.setHost(hostDescriptor);
        HashStructure hashStructure = this.getTunnels(hostDescriptor.getName(), true);
        if (hashStructure != null) {
            hashStructure.putHashStructure(tunnelDescriptor.getName(), RaptorStore.toHashStructure(tunnelDescriptor));
            this.doSave();
            this.fireTunnelAddedEvent(hostDescriptor, tunnelDescriptor);
        }
    }

    public void removeTunnel(HostDescriptor hostDescriptor, String string) {
        HashStructure hashStructure;
        HashStructure hashStructure2 = this.getTunnels(hostDescriptor.getName(), false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string)) != null) {
            TunnelDescriptor tunnelDescriptor = RaptorStore.createTunnelDescriptor(hashStructure);
            tunnelDescriptor.setHost(hostDescriptor);
            hashStructure2.remove(string);
            this.doSave();
            this.fireTunnelRemovedEvent(hostDescriptor, tunnelDescriptor);
        }
    }

    public void updateTunnel(HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor, TunnelDescriptor tunnelDescriptor2) {
        HashStructure hashStructure = this.getTunnels(hostDescriptor.getName(), false);
        if (hashStructure != null) {
            String string = tunnelDescriptor2.getName();
            String string2 = tunnelDescriptor.getName();
            if (ModelUtil.areDifferent((Object)string2, (Object)string)) {
                hashStructure.remove(string2);
            }
            hashStructure.putHashStructure(string, RaptorStore.toHashStructure(tunnelDescriptor2));
            tunnelDescriptor2.setHost(hostDescriptor);
            this.doSave();
            this.fireTunnelChangedEvent(hostDescriptor, tunnelDescriptor2, tunnelDescriptor);
        }
    }
}

