/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.vhv.VHVResource;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVVersionableResource;
import oracle.ide.vhv.model.Branch;
import oracle.ide.vhv.model.BranchElement;
import oracle.ide.vhv.model.BranchList;
import oracle.ide.vhv.model.CheckOutElement;
import oracle.ide.vhv.model.ContextElement;
import oracle.ide.vhv.model.ElementKind;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.MergeElement;
import oracle.ide.vhv.model.RootBranchResource;
import oracle.ide.vhv.model.SuccessorElement;
import oracle.ide.vhv.model.VersionElement;
import oracle.ide.vhv.model.VersionTreeLayoutManager;

public abstract class VersionTree {
    public static final VHVResource ROOT_BRANCH = new RootBranchResource();
    private int m_nodeCount;
    private BranchElement m_rootElement;
    private HashMap m_elements;
    private HashMap m_branches;
    private VersionTreeLayoutManager m_layoutManager;
    private Point m_bottomRight = new Point(0, 0);
    private boolean m_requiresLayout = true;
    private boolean m_showingAllNodes = true;
    private boolean m_displayMainBranch = true;
    private ContextElement m_inContextVersion;

    protected VersionTree(boolean displayMainBranch) {
        this.m_displayMainBranch = displayMainBranch;
    }

    protected void createVersionTree(VersionElement[] elements) {
        this.m_nodeCount = elements.length;
        this.m_elements = new HashMap(this.m_nodeCount);
        this.m_branches = new HashMap();
        try {
            this.createElements(elements);
        }
        catch (VHVResourceException re) {
            re.printStackTrace();
        }
        this.validateVersionTree();
        this.buildBranches();
        this.m_elements = null;
    }

    private void createElements(VersionElement[] objects) throws VHVResourceException {
        for (int i = 0; i < objects.length; ++i) {
            VersionElement element = objects[i];
            ElementKind kind = element.getKind();
            GraphElement created = null;
            if (kind == ElementKind.BRANCH) {
                created = new BranchElement(element);
                if (element.getFromResource() instanceof RootBranchResource) {
                    this.m_rootElement = created;
                    this.m_elements.put(ROOT_BRANCH, created);
                }
            } else if (kind == ElementKind.NODE || kind == ElementKind.TIP) {
                created = new SuccessorElement(element);
            } else if (kind == ElementKind.MERGE) {
                created = new MergeElement(element);
            } else if (kind == ElementKind.UNRESERVED_CHECKOUT || kind == ElementKind.RESERVED_CHECKOUT) {
                created = new CheckOutElement(element);
            }
            this.storeElement(created);
        }
    }

    private void storeElement(GraphElement g) {
        if (g != null) {
            if (g instanceof MergeElement) {
                this.m_elements.put(g.getParentElement().getResource().toString() + g.getChildElement().getResource().toString(), g);
            } else {
                this.m_elements.put(g.getResource(), g);
            }
        }
    }

    private void validateVersionTree() {
        for (GraphElement g : this.m_elements.values()) {
            g.validateElement(this);
        }
        this.m_elements.remove(ROOT_BRANCH);
    }

    private void buildBranches() {
        Branch b;
        for (GraphElement g : this.m_elements.values()) {
            VHVResource resource = null;
            b = null;
            if (g instanceof SuccessorElement || g instanceof CheckOutElement) {
                resource = g.getOwnerElement().getResource();
                b = (Branch)this.m_branches.get(resource);
            } else if (g instanceof BranchElement) {
                resource = g.getResource();
                b = (Branch)this.m_branches.get(resource);
                if (b == null) {
                    b = new Branch();
                }
                b.setBranchElement((BranchElement)g);
            } else if (g instanceof MergeElement) {
                resource = g.getOwnerElement().getOwnerElement().getResource();
                b = (Branch)this.m_branches.get(resource);
            }
            if (b == null) {
                b = new Branch();
            }
            b.add(g);
            this.m_branches.put(resource, b);
        }
        Iterator itr = this.getBranches();
        while (itr.hasNext()) {
            b = (Branch)itr.next();
            BranchElement be = b.getBranchElement();
            if (be.isRoot()) continue;
            ((SuccessorElement)be.getParentElement()).addBranch(b);
        }
    }

    public int getNodeCount() {
        return this.m_nodeCount;
    }

    public Branch getBranch(VHVResource branchResource) {
        return (Branch)this.m_branches.get(branchResource);
    }

    public Iterator getBranches() {
        return this.m_branches.values().iterator();
    }

    public BranchElement getRootElement() {
        return this.m_rootElement;
    }

    GraphElement getGraphElement(VHVResource key) {
        if (this.m_elements != null) {
            return (GraphElement)this.m_elements.get(key);
        }
        throw new UnsupportedOperationException("oracle.repos.services.version.VersionTree.getGraphElement - method is unsupported outside of VersionTree initialisation");
    }

    public ContextElement getInContextVersion() {
        return this.m_inContextVersion;
    }

    public boolean setInContextVersion(ContextElement ce) {
        boolean layoutRequired = false;
        if (this.m_inContextVersion != null) {
            this.m_inContextVersion.setInContext(false);
            if (this.m_inContextVersion instanceof SuccessorElement && !((SuccessorElement)this.m_inContextVersion).isMajor()) {
                layoutRequired = true;
            }
        }
        this.m_inContextVersion = ce;
        if (this.m_inContextVersion instanceof SuccessorElement && !((SuccessorElement)this.m_inContextVersion).isMajor()) {
            layoutRequired = true;
        }
        this.m_inContextVersion.setInContext(true);
        if (layoutRequired) {
            if (!this.isShowingAllNodes()) {
                this.showMajorNodes(true);
            } else {
                layoutRequired = false;
            }
        }
        return layoutRequired;
    }

    public boolean setInContextVersion(VHVResource resource) {
        Iterator itr = this.getBranches();
        while (itr.hasNext()) {
            Branch b = (Branch)itr.next();
            for (Object next : b) {
                if (!(next instanceof ContextElement) || !((ContextElement)next).getVersionableResource().equals(resource)) continue;
                return this.setInContextVersion((ContextElement)next);
            }
        }
        return false;
    }

    public VersionTreeLayoutManager getLayoutManager() {
        if (this.m_layoutManager == null) {
            // empty if block
        }
        this.m_layoutManager = new VersionTreeLayoutManager(this);
        return this.m_layoutManager;
    }

    public void layoutElements() {
        if (this.m_requiresLayout) {
            this.m_bottomRight = this.getLayoutManager().layout(this.m_displayMainBranch);
            this.m_requiresLayout = false;
        }
    }

    public boolean showMajorNodes() {
        return this.showMajorNodes(false);
    }

    public boolean showMajorNodes(boolean force) {
        if (this.m_showingAllNodes || force) {
            this.getLayoutManager().showMajorNodes();
            this.m_requiresLayout = true;
            this.layoutElements();
            this.m_showingAllNodes = false;
            return true;
        }
        return false;
    }

    public boolean showAllNodes() {
        return this.showAllNodes(false);
    }

    public boolean showAllNodes(boolean force) {
        if (!this.m_showingAllNodes || force) {
            this.getLayoutManager().showAllNodes();
            this.m_requiresLayout = true;
            this.layoutElements();
            this.m_showingAllNodes = true;
            return true;
        }
        return false;
    }

    public void toggleAllNodesMajorNodes() {
        if (this.m_showingAllNodes) {
            this.showMajorNodes();
        } else {
            this.showAllNodes();
        }
    }

    public boolean isShowingAllNodes() {
        return this.m_showingAllNodes;
    }

    public void showAllBranches() {
        Iterator itr = this.getBranches();
        while (itr.hasNext()) {
            Branch b = (Branch)itr.next();
            b.getBranchElement().setDisplayed(true);
        }
    }

    public void hideAllBranches() {
        Iterator itr = this.getBranches();
        while (itr.hasNext()) {
            Branch b = (Branch)itr.next();
            b.getBranchElement().setDisplayed(false);
        }
    }

    public void showBranches(List branchResources) {
        for (VHVResource resource : branchResources) {
            Branch b = this.getBranch(resource);
            if (b == null) continue;
            b.getBranchElement().setDisplayed(true);
        }
    }

    public void showContextBranch() {
        ContextElement ce = this.getInContextVersion();
        if (ce != null) {
            ce.getOwnerElement().setDisplayed(true);
        }
    }

    public BranchList getDisplayedRootElements() {
        return this.getDisplayedRootElements(this.getRootElement());
    }

    BranchList getDisplayedRootElements(GraphElement ge) {
        if (ge instanceof SuccessorElement) {
            return this.getDisplayedRootElements((SuccessorElement)ge);
        }
        return null;
    }

    BranchList getDisplayedRootElements(SuccessorElement se) {
        BranchList result = new BranchList();
        if (se.hasBranches()) {
            for (Branch b : se.getBranches()) {
                if (!b.getBranchElement().isDisplayed()) continue;
                result.add(b);
            }
            if (result.size() > 0) {
                return result;
            }
        }
        if (se.getChildElement() != null && (result = this.getDisplayedRootElements(se.getChildElement())) != null) {
            return result;
        }
        if (se.hasBranches()) {
            for (Branch b : se.getBranches()) {
                result = this.getDisplayedRootElements(b.getBranchElement());
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    BranchList getDisplayedRootElements(BranchElement be) {
        return this.getDisplayedRootElements(be.getChildElement());
    }

    public int getMaxX() {
        return this.m_bottomRight.x + 32;
    }

    public int getMaxY() {
        return this.m_bottomRight.y + 32;
    }

    public final VersionTree requeryInBackground() throws VHVResourceException {
        return this.getContextResource().getVersionTree();
    }

    public final void requeryAfterEDT(VersionTree versionTree) {
        if (this.isShowingAllNodes()) {
            versionTree.showAllNodes(true);
        } else {
            versionTree.showMajorNodes(true);
        }
    }

    public VHVVersionableResource getContextResource() {
        GraphElement tmpGE;
        for (tmpGE = this.m_rootElement; tmpGE != null && !(tmpGE instanceof ContextElement); tmpGE = tmpGE.getChildElement()) {
        }
        return ((ContextElement)tmpGE).getVersionableResource();
    }
}

