/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import java.awt.Point;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.model.Branch;
import oracle.ide.vhv.model.BranchList;
import oracle.ide.vhv.model.CheckOutElement;
import oracle.ide.vhv.model.CheckOutList;
import oracle.ide.vhv.model.ContextElement;
import oracle.ide.vhv.model.ElementKind;
import oracle.ide.vhv.model.GraphElementVisitor;
import oracle.ide.vhv.model.HolderElement;
import oracle.ide.vhv.model.INameHelper;
import oracle.ide.vhv.model.MergeElement;
import oracle.ide.vhv.model.MergeList;
import oracle.ide.vhv.model.MergeSource;
import oracle.ide.vhv.model.MergeTarget;
import oracle.ide.vhv.model.VersionElement;
import oracle.ide.vhv.model.VersionTreeElement;
import oracle.ide.vhv.resource.VHVArb;

public class SuccessorElement
extends ContextElement
implements MergeTarget,
MergeSource {
    private String m_shortLabel = null;
    private boolean m_tip = false;
    private BranchList m_branchList = null;
    private CheckOutList m_unreservedCOList = null;
    private CheckOutElement m_reservedCO = null;
    private MergeList m_sourceMerges = null;
    private MergeList m_targetMerges = null;

    SuccessorElement() {
    }

    SuccessorElement(VersionElement element) throws VHVResourceException {
        super(element);
        this.setOwnerElement(new HolderElement(this.getVersionableResource().getBranch()));
        this.setParentElement(new HolderElement(element.getFromResource()));
        if (element.getKind() == ElementKind.TIP) {
            this.m_tip = true;
        }
        if (!this.m_tip) {
            this.setChildElement(new HolderElement(element.getToResource()));
        }
    }

    public String getShortLabel() {
        return this.m_shortLabel;
    }

    public boolean isRoot() throws VHVResourceException {
        return this.getVersionableResource().isFirstVersionOnBranch();
    }

    public boolean isRootOfMain() throws VHVResourceException {
        if (this.isRoot()) {
            return this.getParentElement().getParentElement() instanceof VersionTreeElement;
        }
        return false;
    }

    public boolean isTip() {
        return this.m_tip;
    }

    public void setTip(boolean tip) {
        this.m_tip = tip;
    }

    @Override
    public boolean isMergeSource() {
        return this.m_sourceMerges != null;
    }

    @Override
    public void addSourceMerge(MergeElement me) {
        if (this.m_sourceMerges == null) {
            this.m_sourceMerges = new MergeList();
        }
        this.m_sourceMerges.add(me);
    }

    @Override
    public MergeList getSourceMerges() {
        return this.m_sourceMerges;
    }

    @Override
    public boolean isMergeTarget() {
        return this.m_targetMerges != null;
    }

    @Override
    public void addTargetMerge(MergeElement me) {
        if (this.m_targetMerges == null) {
            this.m_targetMerges = new MergeList();
        }
        this.m_targetMerges.add(me);
    }

    @Override
    public MergeList getTargetMerges() {
        return this.m_targetMerges;
    }

    public boolean isMajor() {
        return this.isMergeTarget() || this.isMergeSource() || this.hasBranches() || this.isTip() || this.hasCheckOuts() || this.isInContext();
    }

    public void addBranch(Branch b) {
        if (this.m_branchList == null) {
            this.m_branchList = new BranchList();
        }
        this.m_branchList.add(b);
    }

    public boolean hasBranches() {
        return this.m_branchList != null;
    }

    public BranchList getBranches() {
        return this.m_branchList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckOut(CheckOutElement ce) {
        if (ce.isUnreservedCheckOut()) {
            if (this.m_unreservedCOList == null) {
                SuccessorElement successorElement = this;
                synchronized (successorElement) {
                    if (this.m_unreservedCOList == null) {
                        this.m_unreservedCOList = new CheckOutList();
                    }
                }
            }
            this.m_unreservedCOList.add(ce);
        } else {
            this.m_reservedCO = ce;
        }
    }

    public CheckOutList getUnreservedCheckOuts() {
        return this.m_unreservedCOList;
    }

    public CheckOutElement getReservedCheckOut() {
        return this.m_reservedCO;
    }

    public boolean hasCheckOuts() {
        return this.getReservedCheckOut() != null || this.getUnreservedCheckOuts() != null;
    }

    @Override
    Point getTopConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x, location.y - this.getHeight() / 2);
    }

    @Override
    Point getRightConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x + this.getWidth() / 2, location.y);
    }

    @Override
    Point getBottomConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x, location.y + this.getHeight() / 2);
    }

    @Override
    Point getLeftConnectionPoint() {
        Point location = this.getLocation();
        return new Point(location.x - this.getWidth() / 2, location.y);
    }

    @Override
    public void accept(GraphElementVisitor geVisitor) throws Exception {
        geVisitor.visitSucessorElement(this);
    }

    @Override
    public String getDisplayName(INameHelper nameHelper) {
        StringBuffer s = new StringBuffer();
        String name = nameHelper.getObjectName(this);
        if (name != null) {
            s.append(nameHelper.getObjectName(this));
        }
        s.append("{");
        s.append(nameHelper.getBranchName(this));
        s.append(";");
        try {
            s.append(this.getVersionableResource().getVersionLabel());
        }
        catch (VHVResourceException re) {
            re.printStackTrace();
        }
        s.append("} ");
        return s.toString();
    }

    @Override
    public String getDisplayVersion(INameHelper nameHelper) {
        Object[] branchAndVersion;
        try {
            branchAndVersion = new String[]{nameHelper.getBranchName(this), this.getVersionableResource().getVersionLabel()};
        }
        catch (VHVResourceException re) {
            re.printStackTrace();
            branchAndVersion = new String[]{nameHelper.getBranchName(this), ""};
        }
        return VHVArb.format(60, branchAndVersion);
    }

    public String toString() {
        return "N: " + (this.getResource() == null ? null : this.getResource().toString());
    }
}

