/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import oracle.ide.vhv.model.FrontierComponent;

public class Frontier {
    private FrontierComponent m_start = new FrontierComponent();
    static final int HORZ_SIMPLIFICATION_LEVEL = 32;
    static final int VERT_SIMPLIFICATION_LEVEL = 10;

    public void addFrontierComponent(FrontierComponent fc) {
        FrontierComponent add = fc;
        FrontierComponent current = this.getStart();
        FrontierComponent next = null;
        FrontierComponent previous = null;
        FrontierComponent remainder = null;
        while (add.getStartX() > current.getEndX() && current.getEndX() != -1) {
            current = current.getNext();
        }
        next = current.getNext();
        previous = current;
        if (add.getY() < current.getY()) {
            add.setPrevious(current);
        } else {
            current.setNext(add);
        }
        remainder = new FrontierComponent(add.getStartX() + 1, current.getEndX(), current.getY());
        remainder.setNext(next);
        current = remainder;
        while (current.getEndX() < add.getEndX() && current.getEndX() != -1) {
            if (current.getY() > add.getY()) {
                int oldEndX = add.getEndX();
                add.setNext(current);
                add = new FrontierComponent(current.getEndX() + 1, oldEndX, add.getY());
            }
            previous = current;
            current = current.getNext();
        }
        if (previous.getY() < add.getY()) {
            previous.setNext(add);
        } else {
            add.setPrevious(previous);
        }
        if (add.getY() < current.getY()) {
            add.setNext(current);
        } else {
            current.setPrevious(add);
        }
        this.simplify();
    }

    public void simplify() {
        FrontierComponent previous = this.getStart();
        FrontierComponent current = this.getStart().getNext();
        if (current == null) {
            return;
        }
        FrontierComponent next = current.getNext();
        if (Math.abs(previous.getY() - current.getY()) <= 10) {
            if (previous.getY() > current.getY()) {
                previous.setEndX(-1);
            } else {
                current.setStartX(-2);
                this.setStart(current);
            }
            previous.setNext(null);
        } else if (previous.getEndX() - previous.getStartX() <= 0) {
            this.setStart(current);
        }
        if (next == null) {
            return;
        }
        while (next != null && current != null && previous != null) {
            if (Math.abs(current.getY() - previous.getY()) <= 10) {
                if (current.getY() > previous.getY()) {
                    previous.setY(current.getY());
                }
                previous.setNext(next);
                current = next;
            } else if (Math.abs(next.getY() - current.getY()) <= 10) {
                if (next.getY() > current.getY()) {
                    next.setPrevious(previous);
                    current = next;
                    next = next.getNext();
                } else {
                    current.setNext(next.getNext());
                    previous = current;
                    current = next;
                }
            } else if (current.getEndX() - current.getStartX() <= 32 && (current.getY() < previous.getY() || current.getY() < next.getY())) {
                if (next.getY() > previous.getY()) {
                    next.setPrevious(previous);
                } else {
                    previous.setNext(next);
                }
                current = next;
            } else {
                previous = previous.getNext();
                current = current.getNext();
            }
            next = next.getNext();
        }
    }

    public int getMaxY(int x) {
        return this.getMaxY(-2, x);
    }

    public int getMaxY(int x1, int x2) {
        FrontierComponent current;
        int maxY = -1;
        for (current = this.getStart(); current != null && current.getEndX() < x1 && x1 != -2; current = current.getNext()) {
        }
        while (current != null && (x2 == -1 || current.getStartX() < x2)) {
            maxY = Math.max(current.getY(), maxY);
            current = current.getNext();
        }
        return maxY;
    }

    FrontierComponent getStart() {
        return this.m_start;
    }

    private void setStart(FrontierComponent start) {
        this.m_start = start;
    }

    public String toString() {
        StringBuffer frontier = new StringBuffer();
        for (FrontierComponent current = this.getStart(); current != null; current = current.getNext()) {
            frontier.append(current.toString());
            frontier.append('\n');
        }
        return frontier.toString();
    }
}

