/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.HashMap;
import oracle.dbtools.migration.parser.helper.CodeBlockManager;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.Function;

public class FunctionHelper {
    private HashMap<Block, Function> m_functionMap;
    private CodeBlockManager m_CodeBlockMgr;

    public FunctionHelper(CodeBlockManager codeBlockManager) {
        this.m_CodeBlockMgr = codeBlockManager;
        this.m_functionMap = new HashMap();
    }

    public void addFunction(AST aST) {
        Block block = this.getObjectBlock(aST);
        if (block == null) {
            return;
        }
        if (this.m_functionMap.containsKey(block)) {
            return;
        }
        this.m_functionMap.put(block, new Function(aST));
    }

    public boolean isTableValuedFunction(AST aST) {
        if (aST == null) {
            return false;
        }
        Block block = this.getObjectBlock(aST);
        if (block == null) {
            return false;
        }
        Function function = this.m_functionMap.get(block);
        if (function == null) {
            return false;
        }
        return function.isTableValuedFunction();
    }

    public void setTableValuedFunction(AST aST, boolean bl) {
        Block block = this.getObjectBlock(aST);
        if (block == null) {
            return;
        }
        Function function = this.m_functionMap.get(block);
        if (function == null) {
            return;
        }
        function.setTableValuedFunction(bl);
    }

    private Block getObjectBlock(AST aST) {
        return this.m_CodeBlockMgr.findEnclosingBlock(aST, "CREATEOBJBLOCK");
    }
}

