/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.color;

import com.ibm.icu.text.NumberFormat;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.swing.IlvJSpinner;
import ilog.views.util.swing.color.ColorChangedEvent;
import ilog.views.util.swing.color.ColorChangedListener;
import ilog.views.util.swing.color.IlvAlphaColorChooserPanel;
import ilog.views.util.text.internal.IlvICUNumberFormatFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IlvHSBAColorChooserPanel
extends IlvAlphaColorChooserPanel
implements ChangeListener,
ColorChangedListener {
    private ResourceBundle a;
    private NumberFormat b;
    private JSlider c;
    private JSlider d;
    private JSlider e;
    private JSlider f;
    private JSpinner g;
    private JSpinner h;
    private JSpinner i;
    private JSpinner j;
    private JLabel k;
    private JLabel l;
    private JLabel m;
    private JLabel n;
    private JLabel o;
    private boolean p;
    private static final String q = "IlvHSBAColorChooserPanel.";
    private static final String r = "resources.messages";
    private static final String s = "IlvHSBAColorChooserPanel.HueLabel";
    private static final String t = "IlvHSBAColorChooserPanel.HueMnemonic";
    private static final String u = "IlvHSBAColorChooserPanel.SaturationLabel";
    private static final String v = "IlvHSBAColorChooserPanel.SaturationMnemonic";
    private static final String w = "IlvHSBAColorChooserPanel.BrightnessLabel";
    private static final String x = "IlvHSBAColorChooserPanel.BrightnessMnemonic";
    private static final String y = "IlvHSBAColorChooserPanel.AlphaLabel";
    private static final String z = "IlvHSBAColorChooserPanel.AlphaMnemonic";

    @Override
    protected void buildChooser() {
        this.removeAll();
        this.a = IlvResourceUtil.getBundle(r, IlvHSBAColorChooserPanel.class, IlvLocaleUtil.getCurrentLocale());
        this.b = IlvICUNumberFormatFactory.createInstance(IlvLocaleUtil.getCurrentULocale());
        this.b.setMinimumFractionDigits(1);
        this.b.setMaximumFractionDigits(2);
        this.setLayout(new GridBagLayout());
        this.c = this.a();
        this.e = this.a();
        this.d = this.a();
        this.f = this.a();
        this.g = this.b();
        this.i = this.b();
        this.h = this.b();
        this.j = this.b();
        this.k = new JLabel(this.a.getString(s), 0);
        this.k.setDisplayedMnemonic(this.a.getString(t).charAt(0));
        this.k.setLabelFor(this.c);
        this.l = new JLabel(this.a.getString(u), 0);
        this.l.setDisplayedMnemonic(this.a.getString(v).charAt(0));
        this.l.setLabelFor(this.d);
        this.m = new JLabel(this.a.getString(w), 0);
        this.m.setDisplayedMnemonic(this.a.getString(x).charAt(0));
        this.m.setLabelFor(this.e);
        this.n = new JLabel(this.a.getString(y), 0);
        this.n.setDisplayedMnemonic(this.a.getString(z).charAt(0));
        this.n.setLabelFor(this.f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 10;
        this.o = this.c();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.o, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.k, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.c, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.g, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.l, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.d, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.h, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.m, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.e, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.i, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.n, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.f, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.j, gridBagConstraints);
    }

    @Override
    public void colorChange(ColorChangedEvent colorChangedEvent) {
        if (colorChangedEvent != null) {
            Color color = colorChangedEvent.getNewColor();
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        if (this.p) {
            return;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (changeEvent != null) {
            if (changeEvent.getSource() instanceof JSpinner) {
                f = (float)((Double)this.g.getValue()).doubleValue();
                f2 = (float)((Double)this.i.getValue()).doubleValue();
                f3 = (float)((Double)this.h.getValue()).doubleValue();
                f4 = (float)((Double)this.j.getValue()).doubleValue();
            } else if (changeEvent.getSource() instanceof JSlider) {
                f = (float)this.c.getValue() / 1000.0f;
                if (f >= 1.0f) {
                    f = 0.98f;
                }
                f2 = (float)this.e.getValue() / 1000.0f;
                f3 = (float)this.d.getValue() / 1000.0f;
                f4 = (float)this.f.getValue() / 1000.0f;
            }
        }
        if ((n = (int)(f4 * 255.0f + 0.5f)) > 255) {
            n = 255;
        }
        int n2 = Color.HSBtoRGB(f, f3, f2) & 0xFFFFFF | n << 24;
        this.getColorSelectionModel().setSelectedColor(new Color(n2, true));
    }

    @Override
    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        if (this.c != null) {
            this.c.removeChangeListener(this);
        }
        if (this.d != null) {
            this.d.removeChangeListener(this);
        }
        if (this.e != null) {
            this.e.removeChangeListener(this);
        }
        if (this.f != null) {
            this.f.removeChangeListener(this);
        }
        if (this.g != null) {
            this.g.removeChangeListener(this);
        }
        if (this.h != null) {
            this.h.removeChangeListener(this);
        }
        if (this.i != null) {
            this.i.removeChangeListener(this);
        }
        if (this.j != null) {
            this.j.removeChangeListener(this);
        }
        this.c = null;
        this.d = null;
        this.e = null;
        this.f = null;
        this.g = null;
        this.h = null;
        this.i = null;
        this.j = null;
        this.k = null;
        this.l = null;
        this.m = null;
        this.n = null;
        super.uninstallChooserPanel(jColorChooser);
    }

    @Override
    public void updateChooser() {
        Color color = this.getColorSelectionModel().getSelectedColor();
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
        float f = (float)n4 / 255.0f;
        this.p = true;
        this.b(fArray[0], fArray[1], fArray[2], f);
        this.a(fArray[0], fArray[1], fArray[2], f);
        this.p = false;
    }

    private JSlider a() {
        JSlider jSlider = new JSlider(0, 0, 1000, 500);
        jSlider.setMajorTickSpacing(250);
        jSlider.setMinorTickSpacing(50);
        jSlider.addChangeListener(this);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(new Integer(0), new JLabel(this.b.format(0.0)));
        ((Dictionary)hashtable).put(new Integer(250), new JLabel(this.b.format(0.25)));
        ((Dictionary)hashtable).put(new Integer(500), new JLabel(this.b.format(0.5)));
        ((Dictionary)hashtable).put(new Integer(750), new JLabel(this.b.format(0.75)));
        ((Dictionary)hashtable).put(new Integer(1000), new JLabel(this.b.format(1.0)));
        jSlider.setLabelTable(hashtable);
        return jSlider;
    }

    private JSpinner b() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0.5, 0.0, 1.0, 0.05);
        IlvJSpinner ilvJSpinner = new IlvJSpinner(spinnerNumberModel);
        JFormattedTextField jFormattedTextField = this.a(ilvJSpinner);
        if (jFormattedTextField != null) {
            jFormattedTextField.setColumns(5);
            jFormattedTextField.setHorizontalAlignment(4);
        }
        ilvJSpinner.addChangeListener(this);
        return ilvJSpinner;
    }

    private JFormattedTextField a(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        return null;
    }

    private JLabel c() {
        JLabel jLabel = new JLabel(this.d());
        return jLabel;
    }

    private ImageIcon d() {
        int n = this.c.getPreferredSize().width - 16;
        if (n <= 0) {
            n = 2;
        }
        BufferedImage bufferedImage = new BufferedImage(n, 10, 1);
        if (this.getComponentOrientation().isLeftToRight()) {
            for (int i = 0; i < n; ++i) {
                float f = (float)i / (float)n;
                int n2 = Color.HSBtoRGB(f, 1.0f, 1.0f);
                for (int j = 0; j < 10; ++j) {
                    bufferedImage.setRGB(i, j, n2);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                float f = (float)i / (float)n;
                int n3 = Color.HSBtoRGB(f, 1.0f, 1.0f);
                for (int j = 0; j < 10; ++j) {
                    bufferedImage.setRGB(n - 1 - i, j, n3);
                }
            }
        }
        return new ImageIcon(bufferedImage);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        super.setComponentOrientation(componentOrientation);
        if (bl != componentOrientation.isLeftToRight() && this.o != null) {
            this.o.setIcon(this.d());
        }
    }

    private void a(float f, float f2, float f3, float f4) {
        this.g.setValue(new Double(f));
        this.h.setValue(new Double(f2));
        this.i.setValue(new Double(f3));
        this.j.setValue(new Double(f4));
    }

    private void b(float f, float f2, float f3, float f4) {
        this.c.setValue((int)(f * 1000.0f + 0.5f));
        this.d.setValue((int)(f2 * 1000.0f + 0.5f));
        this.e.setValue((int)(f3 * 1000.0f + 0.5f));
        this.f.setValue((int)(f4 * 1000.0f + 0.5f));
    }

    @Override
    String a(String string) {
        return super.a(q + string);
    }
}

