/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.calendar.plaf;

import ilog.views.util.swing.calendar.IlvCalendarModel;
import ilog.views.util.swing.calendar.IlvJTimeChooser;
import ilog.views.util.swing.calendar.event.CalendarModelEvent;
import ilog.views.util.swing.calendar.event.CalendarModelListener;
import ilog.views.util.swing.calendar.plaf.TimeChooserUI;
import ilog.views.util.text.internal.IlvFormatUtil;
import ilog.views.util.time.IlvCalendarFactory;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;

public class BasicTimeChooserUI
extends TimeChooserUI {
    protected IlvJTimeChooser timeChooser;
    protected JTextField timeText;
    protected PropertyChangeListener propertyChangeListener;
    protected CalendarModelListener modelListener;
    private transient boolean a;
    private Timer b = new Timer(0, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicTimeChooserUI.this.b();
        }
    });

    public BasicTimeChooserUI() {
        this.b.setInitialDelay(500);
        this.b.setRepeats(false);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTimeChooserUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.timeChooser = (IlvJTimeChooser)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.timeChooser = null;
    }

    protected void installComponents() {
        this.timeChooser.setLayout(new FlowLayout());
        Color color = this.timeChooser.getBackground();
        this.timeText = new TimeTextField(this.timeChooser);
        this.timeText.setBackground(color);
        this.timeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicTimeChooserUI.this.b();
            }
        });
        this.timeText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                BasicTimeChooserUI.this.a();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                BasicTimeChooserUI.this.a();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                BasicTimeChooserUI.this.a();
            }
        });
        this.timeChooser.add(this.timeText);
        this.timeText.addActionListener(this.timeChooser);
    }

    private void a() {
        try {
            this.a = true;
            this.b();
        }
        finally {
            this.a = false;
        }
    }

    private void b() {
        Date date;
        if (!this.a) {
            this.b.stop();
        }
        if ((date = this.c()) != null) {
            Calendar calendar = this.timeChooser.getCalendar();
            Calendar calendar2 = IlvCalendarFactory.createInstance(this.timeChooser.getULocale());
            calendar2.setTime(date);
            calendar.set(11, calendar2.get(11));
            calendar.set(12, calendar2.get(12));
            calendar.set(13, calendar2.get(13));
            calendar.set(14, calendar2.get(14));
            this.timeChooser.setCalendar(calendar);
        }
        this.timeChooser.validationPerformed(date != null);
        if (this.a) {
            this.b.restart();
        }
    }

    private Date c() {
        String string = this.timeText.getText();
        Date date = null;
        try {
            date = IlvFormatUtil.parseFully(this.timeChooser.getTimeFormat(), string);
        }
        catch (ParseException parseException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return date;
    }

    @Override
    public boolean isValid() {
        return this.c() != null;
    }

    protected void uninstallComponents() {
        this.timeText.removeActionListener(this.timeChooser);
        this.timeChooser.remove(this.timeText);
    }

    protected void installDefaults() {
        this.timeChooser.setOpaque(true);
        LookAndFeel.installColorsAndFont(this.timeChooser, "TimeChooser.background", "TimeChooser.foreground", "TimeChooser.font");
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.modelListener = this.createCalendarModelListener();
        this.timeChooser.addPropertyChangeListener(this.propertyChangeListener);
        IlvCalendarModel ilvCalendarModel = this.timeChooser.getModel();
        if (ilvCalendarModel != null) {
            ilvCalendarModel.addCalendarModelListener(this.modelListener);
        }
    }

    protected void uninstallListeners() {
        this.timeChooser.removePropertyChangeListener(this.propertyChangeListener);
        IlvCalendarModel ilvCalendarModel = this.timeChooser.getModel();
        if (ilvCalendarModel != null) {
            ilvCalendarModel.removeCalendarModelListener(this.modelListener);
        }
        this.propertyChangeListener = null;
        this.modelListener = null;
    }

    protected CalendarModelListener createCalendarModelListener() {
        return new CalendarModelHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void repaintTime() {
        if (!this.a) {
            Date date = this.timeChooser.getCalendar().getTime();
            String string = this.timeChooser.getTimeFormat().format(date);
            this.timeText.setText(string);
        }
    }

    static class TimeTextField
    extends JTextField {
        private IlvJTimeChooser a;

        TimeTextField(IlvJTimeChooser ilvJTimeChooser) {
            this.a = ilvJTimeChooser;
            this.updateUI();
            this.setColumns(15);
            this.setHorizontalAlignment(0);
        }

        @Override
        public void updateUI() {
            if (this.a == null) {
                return;
            }
            super.updateUI();
            this.setFont(this.a.getFont());
            this.setForeground(this.a.getForeground());
            this.setBackground(this.a.getBackground());
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                IlvCalendarModel ilvCalendarModel = (IlvCalendarModel)propertyChangeEvent.getOldValue();
                IlvCalendarModel ilvCalendarModel2 = (IlvCalendarModel)propertyChangeEvent.getNewValue();
                if (ilvCalendarModel != null) {
                    ilvCalendarModel.removeCalendarModelListener(BasicTimeChooserUI.this.modelListener);
                }
                if (ilvCalendarModel2 != null) {
                    ilvCalendarModel2.addCalendarModelListener(BasicTimeChooserUI.this.modelListener);
                }
                BasicTimeChooserUI.this.timeChooser.repaint();
            } else if (string.equals("timeFormat")) {
                BasicTimeChooserUI.this.repaintTime();
            } else if (string.equals("font")) {
                BasicTimeChooserUI.this.timeText.setFont(BasicTimeChooserUI.this.timeChooser.getFont());
            } else if (string.equals("foreground")) {
                BasicTimeChooserUI.this.timeText.setForeground(BasicTimeChooserUI.this.timeChooser.getForeground());
            } else if (string.equals("background")) {
                BasicTimeChooserUI.this.timeText.setBackground(BasicTimeChooserUI.this.timeChooser.getBackground());
            }
        }
    }

    public class CalendarModelHandler
    implements CalendarModelListener {
        @Override
        public void calendarChanged(CalendarModelEvent calendarModelEvent) {
            if (!calendarModelEvent.getOldCalendar().equals(calendarModelEvent.getNewCalendar())) {
                BasicTimeChooserUI.this.repaintTime();
            }
        }
    }
}

