/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.servlet.tiling;

import ilog.views.util.IlvResourceUtil;
import ilog.views.util.servlet.tiling.IlvTileUtil;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class IlvDefaultFileTileCache {
    private long a;
    private long b;
    private TreeSet c;
    private long d;

    public IlvDefaultFileTileCache() {
        this(0x500000L, 0x100000L);
    }

    public IlvDefaultFileTileCache(long l, long l2) {
        this.a = l;
        this.b = 0L;
        this.d = l2;
        FileComparator fileComparator = new FileComparator();
        this.c = new TreeSet(fileComparator);
    }

    public synchronized void objectAdded(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            this.c.add(object);
            this.b += file.length();
            String string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "addToCache");
            IlvTileUtil.trace(MessageFormat.format(string, IlvTileUtil.print(file), this.b));
            if (this.b > this.a) {
                Iterator iterator = this.c.iterator();
                while (iterator.hasNext()) {
                    file = (File)iterator.next();
                    string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "removeCache");
                    IlvTileUtil.trace(string + " " + IlvTileUtil.print(file));
                    iterator.remove();
                    string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "attemptDeleteFile");
                    IlvTileUtil.trace(string + " " + file, true);
                    long l = file.length();
                    if (file.delete()) {
                        this.b -= l;
                        string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "deletedOK");
                        IlvTileUtil.trace(string + " " + this.b);
                    } else {
                        string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "deletedFailed");
                        IlvTileUtil.trace(string);
                    }
                    if (this.b > this.a - this.d) continue;
                    string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "sizeDecreased");
                    IlvTileUtil.trace("Cleaning done. Size decreased to " + this.b);
                    break;
                }
            }
        }
    }

    public synchronized void objectAccessed(Object object) {
        if (object instanceof File) {
            boolean bl = this.c.remove(object);
            File file = (File)object;
            file.setLastModified(System.currentTimeMillis());
            String string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "objectAccess");
            IlvTileUtil.trace(string + " " + IlvTileUtil.print(file));
            if (bl) {
                this.c.add(object);
            } else {
                string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "objectNotInCache");
                IlvTileUtil.trace(string + " " + IlvTileUtil.print(file));
                this.objectAdded(object);
            }
        }
    }

    public synchronized void stats() {
        String string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "numberOfFiles");
        IlvTileUtil.trace(string + " " + this.c.size());
        string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "sizeOfFiles");
        IlvTileUtil.trace(MessageFormat.format(string, this.b, this.a));
        string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "cacheClean");
        IlvTileUtil.trace(MessageFormat.format(string, this.d, this.a));
    }

    public synchronized void clear() {
        String string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "clearingCache");
        IlvTileUtil.trace(string);
        Iterator iterator = this.c.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            iterator.remove();
            string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "attemptDeleteFile");
            IlvTileUtil.trace(string + " " + IlvTileUtil.print(file), true);
            long l = file.length();
            if (file.delete()) {
                this.b -= l;
                string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "deletedOK");
                IlvTileUtil.trace(string + " " + this.b);
                continue;
            }
            string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "deletedFailed");
            IlvTileUtil.trace(string);
        }
    }

    public long getCurrentSize() {
        return this.b;
    }

    static class FileComparator
    implements Comparator,
    Serializable {
        FileComparator() {
        }

        public int compare(Object object, Object object2) {
            long l;
            File file = (File)object;
            File file2 = (File)object2;
            long l2 = file.lastModified();
            if (l2 == (l = file2.lastModified())) {
                String string = IlvResourceUtil.getServerLocaleString(IlvDefaultFileTileCache.class, "sameLastModified");
                IlvTileUtil.trace(MessageFormat.format(string, IlvTileUtil.print(file), IlvTileUtil.print(file2)), true);
                int n = file.compareTo(file2);
                IlvTileUtil.trace(" -> " + n);
                return n;
            }
            if (l2 < l) {
                return -1;
            }
            return 1;
        }
    }
}

