/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.data;

import ilog.views.util.convert.IlvConvert;
import ilog.views.util.convert.IlvConvertException;
import ilog.views.util.data.IlvBasicTableModelPropertyDescriptor;
import ilog.views.util.data.IlvEnumerationTableModelPropertyDescriptor;
import ilog.views.util.data.IlvMultiColumnTableModelPropertyDescriptor;
import ilog.views.util.data.IlvTableModelMappingException;
import ilog.views.util.data.IlvTableModelPropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IlvTableModelMapper
implements Cloneable {
    private HashMap<String, Structure> a = new HashMap(4);
    private TableModel b;

    public IlvTableModelMapper(TableModel tableModel) {
        this.b = tableModel;
    }

    public Object clone() {
        IlvTableModelMapper ilvTableModelMapper = null;
        try {
            ilvTableModelMapper = (IlvTableModelMapper)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        ilvTableModelMapper.b = this.b;
        HashMap<String, Structure> hashMap = new HashMap<String, Structure>(this.a.size());
        for (Map.Entry<String, Structure> entry : this.a.entrySet()) {
            Structure structure = new Structure();
            structure.descriptor = entry.getValue().descriptor;
            structure.requiredType = entry.getValue().requiredType;
            hashMap.put(entry.getKey(), structure);
        }
        ilvTableModelMapper.a = hashMap;
        return ilvTableModelMapper;
    }

    public final TableModel getTableModel() {
        return this.b;
    }

    public final void setTableModel(TableModel tableModel) {
        this.b = tableModel;
    }

    public final void addPropertyDescriptor(String string, IlvTableModelPropertyDescriptor ilvTableModelPropertyDescriptor, Class clazz) {
        Structure structure = this.a.get(string);
        if (structure == null) {
            structure = new Structure();
            this.a.put(string, structure);
        }
        if (ilvTableModelPropertyDescriptor != null) {
            structure.descriptor = ilvTableModelPropertyDescriptor;
        }
        if (clazz != null) {
            structure.requiredType = clazz;
        }
    }

    public final void removePropertyDescriptor(String string) {
        this.removePropertyDescriptor(string, false);
    }

    public final void removePropertyDescriptor(String string, boolean bl) {
        Structure structure = this.a.get(string);
        if (structure != null) {
            if (bl || structure.requiredType == null) {
                this.a.remove(string);
            } else {
                structure.descriptor = null;
            }
        }
    }

    public final IlvTableModelPropertyDescriptor getPropertyDescriptor(String string) {
        Structure structure = this.a.get(string);
        return structure != null ? structure.descriptor : null;
    }

    public final Class getRequiredType(String string) {
        Structure structure = this.a.get(string);
        return structure != null ? structure.requiredType : null;
    }

    public final void clear() {
        this.a.clear();
    }

    public final Object getProperty(String string, int n) throws IlvConvertException, IlvTableModelMappingException {
        Object object;
        Structure structure = this.a.get(string);
        if (structure != null && structure.descriptor != null) {
            object = structure.descriptor.getProperty(this.b, n);
        } else {
            int n2 = this.findColumn(string);
            if (n2 == -1) {
                throw new IlvTableModelMappingException("Can't find a cell for the property: " + string, string);
            }
            object = this.b.getValueAt(n, n2);
        }
        if (structure != null && structure.requiredType != null && object != null) {
            object = structure.requiredType.equals(String.class) ? (IlvConvert.isConvertible(object.getClass(), String.class) ? IlvConvert.convert(object, structure.requiredType) : object.toString()) : IlvConvert.convert(object, structure.requiredType);
        }
        return object;
    }

    public final void setProperty(String string, int n, Object object) throws IlvConvertException, IlvTableModelMappingException {
        Structure structure = this.a.get(string);
        if (structure != null && structure.descriptor != null) {
            structure.descriptor.setProperty(this.b, n, object);
        } else {
            int n2 = this.findColumn(string);
            if (n2 == -1) {
                throw new IlvTableModelMappingException("Can't find a cell for the property: " + string);
            }
            if (object != null) {
                object = IlvConvert.convert(object, this.b.getColumnClass(n2));
            }
            this.b.setValueAt(object, n, n2);
        }
    }

    public final boolean isPropertyEditable(String string, int n) {
        int[] nArray;
        Structure structure = this.a.get(string);
        if (structure != null && structure.descriptor != null) {
            nArray = structure.descriptor.getColumns(this.b);
        } else {
            int n2 = this.findColumn(string);
            if (n2 == -1) {
                return false;
            }
            nArray = new int[]{n2};
        }
        for (int n3 : nArray) {
            if (this.b.isCellEditable(n, n3)) continue;
            return false;
        }
        return true;
    }

    public final List<String> getPropertyName(int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (n != -1) {
            this.a(n, linkedList);
        } else {
            for (int i = 0; i < this.b.getColumnCount(); ++i) {
                this.a(i, linkedList);
            }
        }
        return linkedList;
    }

    private void a(int n, List<String> list) {
        Iterator<Map.Entry<String, Structure>> iterator = this.a.entrySet().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Map.Entry<String, Structure> entry = iterator.next();
            Structure structure = entry.getValue();
            if (structure == null || structure.descriptor == null || Arrays.binarySearch(structure.descriptor.getColumns(this.b), n) < 0) continue;
            bl = true;
            list.add(entry.getKey());
        }
        if (!bl) {
            list.add(this.b.getColumnName(n));
        }
    }

    public final Collection<String> getPropertyNames() {
        return new ArrayList<String>(this.a.keySet());
    }

    public final Collection<String> getSupportedPropertyNames() {
        Set<String> set = this.a.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        for (String string : set) {
            if (!this.isPropertySupported(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public final boolean isPropertySupported(String string) {
        if (this.getPropertyDescriptor(string) != null) {
            return true;
        }
        return this.findColumn(string) != -1;
    }

    public final boolean check() {
        try {
            for (Map.Entry<String, Structure> entry : this.a.entrySet()) {
                Class<?> clazz;
                IlvTableModelPropertyDescriptor ilvTableModelPropertyDescriptor = entry.getValue().descriptor;
                Class clazz2 = entry.getValue().requiredType;
                if (clazz2 == null) continue;
                int n = -1;
                if (ilvTableModelPropertyDescriptor != null) {
                    if (ilvTableModelPropertyDescriptor.getColumns(this.b).length == 1) {
                        n = ilvTableModelPropertyDescriptor.getColumns(this.b)[0];
                    }
                } else {
                    n = this.findColumn(entry.getKey());
                }
                if (n == -1 || IlvConvert.isConvertible(clazz = ilvTableModelPropertyDescriptor instanceof IlvEnumerationTableModelPropertyDescriptor ? ((IlvEnumerationTableModelPropertyDescriptor)ilvTableModelPropertyDescriptor).getModelValues()[0].getClass() : this.b.getColumnClass(n), clazz2)) continue;
                if (clazz2.equals(String.class)) continue;
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return true;
    }

    protected int findColumn(String string) {
        int n = this.b.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!this.b.getColumnName(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void serialize(Element element) {
        for (String string : this.getPropertyNames()) {
            IlvTableModelPropertyDescriptor ilvTableModelPropertyDescriptor = this.getPropertyDescriptor(string);
            Element element2 = element.getOwnerDocument().createElement("map");
            element2.setAttribute("property", string);
            Class clazz = this.getRequiredType(string);
            if (clazz != null) {
                element2.setAttribute("requiredType", clazz.getName());
            }
            int[] nArray = ilvTableModelPropertyDescriptor.getColumns(this.getTableModel());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nArray[0]);
            for (int i = 1; i < nArray.length; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(nArray[i]);
            }
            element2.setAttribute("columns", stringBuffer.toString());
            if (ilvTableModelPropertyDescriptor instanceof IlvEnumerationTableModelPropertyDescriptor) {
                IlvEnumerationTableModelPropertyDescriptor ilvEnumerationTableModelPropertyDescriptor = (IlvEnumerationTableModelPropertyDescriptor)ilvTableModelPropertyDescriptor;
                Object[] objectArray = ilvEnumerationTableModelPropertyDescriptor.getModelValues();
                Object[] objectArray2 = ilvEnumerationTableModelPropertyDescriptor.getTableValues();
                element2.setAttribute("tableType", objectArray2[0].getClass().getName());
                for (int i = 0; i < objectArray.length; ++i) {
                    Element element3 = element.getOwnerDocument().createElement("value");
                    if (objectArray[i] instanceof String) {
                        element3.setAttribute("model", (String)objectArray[i]);
                    } else {
                        Class<?> clazz2 = objectArray[i].getClass();
                        Field[] fieldArray = clazz2.getDeclaredFields();
                        int n = -1;
                        for (int j = 0; j < fieldArray.length; ++j) {
                            try {
                                if (!objectArray[i].equals(fieldArray[j].get(null))) continue;
                                n = j;
                                break;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (n != -1) {
                            element3.setAttribute("model", clazz2.getName() + "." + fieldArray[n].getName());
                        }
                    }
                    element3.setAttribute("table", objectArray2[i].toString());
                    element2.appendChild(element3);
                }
            }
            element.appendChild(element2);
        }
    }

    public static IlvTableModelMapper deserialize(Element element) throws Exception {
        IlvTableModelMapper ilvTableModelMapper = new IlvTableModelMapper(null);
        NodeList nodeList = element.getElementsByTagName("map");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            IlvBasicTableModelPropertyDescriptor ilvBasicTableModelPropertyDescriptor;
            Object[] objectArray;
            IlvBasicTableModelPropertyDescriptor[] ilvBasicTableModelPropertyDescriptorArray;
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getElementsByTagName("value");
            String string = element2.getAttribute("columns");
            String string2 = element2.getAttribute("requiredType");
            String string3 = element2.getAttribute("property");
            Class<?> clazz = null;
            if (string2.length() != 0) {
                clazz = Class.forName(string2);
            }
            if (nodeList2 != null && nodeList2.getLength() != 0) {
                int n = -1;
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                }
                Class<?> clazz2 = Class.forName(element2.getAttribute("tableType"));
                Class[] classArray = new Class[1];
                classArray[0] = String.class;
                ilvBasicTableModelPropertyDescriptorArray = clazz2.getConstructor(classArray);
                Object[] objectArray2 = new Object[nodeList2.getLength()];
                objectArray = new Object[nodeList2.getLength()];
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    String string4 = ((Element)nodeList2.item(j)).getAttribute("model");
                    String string5 = ((Element)nodeList2.item(j)).getAttribute("table");
                    try {
                        objectArray2[j] = Integer.valueOf(string4);
                    }
                    catch (Exception exception) {
                        try {
                            int n2 = string4.lastIndexOf(46);
                            String string6 = string4.substring(0, n2);
                            String string7 = string4.substring(n2 + 1);
                            Class<?> clazz3 = Class.forName(string6);
                            Field field = clazz3.getDeclaredField(string7);
                            objectArray2[j] = field.get(null);
                        }
                        catch (Exception exception2) {
                            objectArray2[j] = string4;
                        }
                    }
                    try {
                        objectArray[j] = ilvBasicTableModelPropertyDescriptorArray.newInstance(string5);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ilvBasicTableModelPropertyDescriptor = n != -1 ? new IlvEnumerationTableModelPropertyDescriptor(n, objectArray2, objectArray) : new IlvEnumerationTableModelPropertyDescriptor(string, objectArray2, objectArray);
                ilvTableModelMapper.addPropertyDescriptor(string3, ilvBasicTableModelPropertyDescriptor, clazz);
                continue;
            }
            if (string.indexOf(44) != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n = stringTokenizer.countTokens();
                ilvBasicTableModelPropertyDescriptorArray = new IlvBasicTableModelPropertyDescriptor[n];
                int n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    objectArray = stringTokenizer.nextToken();
                    try {
                        int n4 = Integer.parseInt((String)objectArray);
                        ilvBasicTableModelPropertyDescriptorArray[n3] = new IlvBasicTableModelPropertyDescriptor(n4);
                    }
                    catch (Exception exception) {
                        ilvBasicTableModelPropertyDescriptorArray[n3] = new IlvBasicTableModelPropertyDescriptor((String)objectArray);
                    }
                    ++n3;
                }
                ilvTableModelMapper.addPropertyDescriptor(string3, new IlvMultiColumnTableModelPropertyDescriptor(ilvBasicTableModelPropertyDescriptorArray, "-"), clazz);
                continue;
            }
            try {
                int n = Integer.parseInt(string);
                ilvBasicTableModelPropertyDescriptor = new IlvBasicTableModelPropertyDescriptor(n);
            }
            catch (Exception exception) {
                ilvBasicTableModelPropertyDescriptor = new IlvBasicTableModelPropertyDescriptor(string);
            }
            ilvTableModelMapper.addPropertyDescriptor(string3, ilvBasicTableModelPropertyDescriptor, clazz);
        }
        return ilvTableModelMapper;
    }

    private static class Structure {
        public IlvTableModelPropertyDescriptor descriptor;
        public Class requiredType;

        private Structure() {
        }
    }
}

