/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.cssbeans;

import ilog.views.util.css.IlvCSSModel;
import ilog.views.util.cssbeans.IlvCSSBeans;
import ilog.views.util.cssbeans.IlvExpressionEvaluator;
import ilog.views.util.cssbeans.IlvExpressionWalker;
import ilog.views.util.internal.IlvInternalError;
import ilog.views.util.styling.runtime.IlvExpressionEvaluation;
import java.beans.PropertyDescriptor;

class IlvExpressionCompiler
extends IlvExpressionWalker {
    static final IlvExpressionEvaluator a = new IlvExpressionEvaluator(null, null, null, null, null);

    IlvExpressionCompiler() {
    }

    @Override
    protected Object handleConditional(Object object, Object object2, Object object3) {
        return new Conditional((AST)object, (AST)object2, (AST)object3);
    }

    @Override
    protected Object handleAnd(Object object, Object object2) {
        return new Binary(0, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleOr(Object object, Object object2) {
        return new Binary(1, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleEquals(Object object, Object object2, Object[] objectArray) {
        return new Binary(2, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleNotEquals(Object object, Object object2, Object[] objectArray) {
        return new Binary(3, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleLess(Object object, Object object2) {
        return new Binary(4, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleLessOrEquals(Object object, Object object2) {
        return new Binary(5, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleGreater(Object object, Object object2) {
        return new Binary(6, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleGreaterOrEquals(Object object, Object object2) {
        return new Binary(7, (AST)object, (AST)object2);
    }

    @Override
    protected Object handlePlus(Object object, Object object2, Object[] objectArray) {
        return new Binary(8, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleMinus(Object object, Object object2) {
        return new Binary(9, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleMultiply(Object object, Object object2) {
        return new Binary(10, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleDivide(Object object, Object object2) {
        return new Binary(11, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleRemainder(Object object, Object object2) {
        return new Binary(12, (AST)object, (AST)object2);
    }

    @Override
    protected Object handlePow(Object object, Object object2) {
        return new Binary(13, (AST)object, (AST)object2);
    }

    @Override
    protected Object handleUnaryMinus(Object object) {
        return new Unary(0, (AST)object);
    }

    @Override
    protected Object handleNot(Object object) {
        return new Unary(1, (AST)object);
    }

    @Override
    protected Object handleFunctionAbs(Object object) {
        return new Unary(2, (AST)object);
    }

    @Override
    protected Object handleFunctionAcos(Object object) {
        return new Unary(3, (AST)object);
    }

    @Override
    protected Object handleFunctionAsin(Object object) {
        return new Unary(4, (AST)object);
    }

    @Override
    protected Object handleFunctionAtan(Object object) {
        return new Unary(5, (AST)object);
    }

    @Override
    protected Object handleFunctionCeil(Object object) {
        return new Unary(6, (AST)object);
    }

    @Override
    protected Object handleFunctionCos(Object object) {
        return new Unary(7, (AST)object);
    }

    @Override
    protected Object handleFunctionExp(Object object) {
        return new Unary(8, (AST)object);
    }

    @Override
    protected Object handleFunctionFloor(Object object) {
        return new Unary(9, (AST)object);
    }

    @Override
    protected Object handleFunctionLog(Object object) {
        return new Unary(10, (AST)object);
    }

    @Override
    protected Object handleFunctionPi() {
        return new Zeroary(0);
    }

    @Override
    protected Object handleFunctionRint(Object object) {
        return new Unary(11, (AST)object);
    }

    @Override
    protected Object handleFunctionRound(Object object) {
        return new Unary(12, (AST)object);
    }

    @Override
    protected Object handleFunctionSin(Object object) {
        return new Unary(13, (AST)object);
    }

    @Override
    protected Object handleFunctionSqrt(Object object) {
        return new Unary(14, (AST)object);
    }

    @Override
    protected Object handleFunctionTan(Object object) {
        return new Unary(15, (AST)object);
    }

    @Override
    protected Object handleStringLiteral(String string) {
        return new Constant(string);
    }

    @Override
    protected Object handleNumberLiteral(Number number) {
        return new Constant(number);
    }

    @Override
    protected Object handleBooleanLiteral(Boolean bl) {
        return new Constant(bl);
    }

    @Override
    protected Object handleFunctionCall(String string, Object[] objectArray, boolean bl) {
        int n = objectArray.length;
        AST[] aSTArray = new AST[n];
        System.arraycopy(objectArray, 0, aSTArray, 0, n);
        return new FunctionCall(string, aSTArray, bl);
    }

    @Override
    protected Object handleSymbolResource(String string) {
        throw new UnsupportedOperationException("symbolResource is not supported in evaluated expressions");
    }

    @Override
    protected Object handlePrimary(String string, boolean bl) {
        return new Primary(string, bl);
    }

    AST b(String string) {
        try {
            return (AST)this.parse(string);
        }
        catch (RuntimeException runtimeException) {
            return new Error(runtimeException);
        }
    }

    static final class Error
    extends AST {
        private final RuntimeException a;

        Error(RuntimeException runtimeException) {
            this.a = runtimeException;
        }

        @Override
        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, IlvCSSBeans ilvCSSBeans) {
            throw this.a;
        }
    }

    static final class Primary
    extends AST {
        private final String a;
        private final boolean b;

        Primary(String string, boolean bl) {
            this.a = string;
            this.b = bl;
        }

        @Override
        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, PropertyDescriptor propertyDescriptor, boolean bl, IlvCSSBeans ilvCSSBeans) {
            if (!this.b) {
                propertyDescriptor = null;
            }
            return ilvCSSBeans.a(null, this.a, ilvCSSModel, object, propertyDescriptor, ilvCSSBeans.valueCode(this.a), object2, null, bl, null);
        }

        @Override
        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, IlvCSSBeans ilvCSSBeans) {
            return this.a(ilvCSSModel, object, object2, null, false, ilvCSSBeans);
        }

        String a() {
            return this.a;
        }
    }

    static final class FunctionCall
    extends AST {
        private final String a;
        private final AST[] b;
        private final boolean c;

        FunctionCall(String string, AST[] aSTArray, boolean bl) {
            this.a = string;
            this.b = aSTArray;
            this.c = bl;
        }

        @Override
        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, PropertyDescriptor propertyDescriptor, boolean bl, IlvCSSBeans ilvCSSBeans) {
            if (!this.c) {
                propertyDescriptor = null;
            }
            int n = this.b.length;
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.b[i].a(ilvCSSModel, object, object2, ilvCSSBeans);
            }
            return ilvCSSBeans.a(this.a, objectArray, ilvCSSModel, object, object2, propertyDescriptor, bl);
        }

        @Override
        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, IlvCSSBeans ilvCSSBeans) {
            return this.a(ilvCSSModel, object, object2, null, false, ilvCSSBeans);
        }

        @Override
        void a(Visitor visitor) {
            super.a(visitor);
            int n = this.b.length;
            for (int i = 0; i < n; ++i) {
                this.b[i].a(visitor);
            }
        }

        String a() {
            return this.a;
        }

        AST[] b() {
            return this.b;
        }
    }

    static final class Constant
    extends AST {
        private final Object a;

        Constant(Object object) {
            this.a = object;
        }

        @Override
        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, IlvCSSBeans ilvCSSBeans) {
            return this.a;
        }
    }

    static final class Zeroary
    extends AST {
        static final int a = 0;
        private final int b;

        Zeroary(int n) {
            this.b = n;
        }

        @Override
        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, IlvCSSBeans ilvCSSBeans) {
            switch (this.b) {
                case 0: {
                    return a.handleFunctionPi();
                }
            }
            throw new IlvInternalError("unhandled Zeroary op " + this.b);
        }
    }

    static final class Unary
    extends AST {
        static final int a = 0;
        static final int b = 1;
        static final int c = 2;
        static final int d = 3;
        static final int e = 4;
        static final int f = 5;
        static final int g = 6;
        static final int h = 7;
        static final int i = 8;
        static final int j = 9;
        static final int k = 10;
        static final int l = 11;
        static final int m = 12;
        static final int n = 13;
        static final int o = 14;
        static final int p = 15;
        private final int q;
        private final AST r;

        Unary(int n, AST aST) {
            this.q = n;
            this.r = aST;
        }

        @Override
        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, IlvCSSBeans ilvCSSBeans) {
            Object object3 = this.r.a(ilvCSSModel, object, object2, ilvCSSBeans);
            switch (this.q) {
                case 0: {
                    return a.handleUnaryMinus(object3);
                }
                case 1: {
                    return a.handleNot(object3);
                }
                case 2: {
                    return a.handleFunctionAbs(object3);
                }
                case 3: {
                    return a.handleFunctionAcos(object3);
                }
                case 4: {
                    return a.handleFunctionAsin(object3);
                }
                case 5: {
                    return a.handleFunctionAtan(object3);
                }
                case 6: {
                    return a.handleFunctionCeil(object3);
                }
                case 7: {
                    return a.handleFunctionCos(object3);
                }
                case 8: {
                    return a.handleFunctionExp(object3);
                }
                case 9: {
                    return a.handleFunctionFloor(object3);
                }
                case 10: {
                    return a.handleFunctionLog(object3);
                }
                case 11: {
                    return a.handleFunctionRint(object3);
                }
                case 12: {
                    return a.handleFunctionRound(object3);
                }
                case 13: {
                    return a.handleFunctionSin(object3);
                }
                case 14: {
                    return a.handleFunctionSqrt(object3);
                }
                case 15: {
                    return a.handleFunctionTan(object3);
                }
            }
            throw new IlvInternalError("unhandled Unary op " + this.q);
        }

        @Override
        void a(Visitor visitor) {
            super.a(visitor);
            this.r.a(visitor);
        }
    }

    static final class Binary
    extends AST {
        static final int a = 0;
        static final int b = 1;
        static final int c = 2;
        static final int d = 3;
        static final int e = 4;
        static final int f = 5;
        static final int g = 6;
        static final int h = 7;
        static final int i = 8;
        static final int j = 9;
        static final int k = 10;
        static final int l = 11;
        static final int m = 12;
        static final int n = 13;
        private final int o;
        private final AST p;
        private final AST q;

        Binary(int n, AST aST, AST aST2) {
            this.o = n;
            this.p = aST;
            this.q = aST2;
        }

        @Override
        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, IlvCSSBeans ilvCSSBeans) {
            Object object3 = this.p.a(ilvCSSModel, object, object2, ilvCSSBeans);
            switch (this.o) {
                case 0: {
                    Object object4;
                    if (IlvExpressionEvaluation.convertToBoolean(object3) && IlvExpressionEvaluation.convertToBoolean(object4 = this.q.a(ilvCSSModel, object, object2, ilvCSSBeans))) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                case 1: {
                    Object object5;
                    if (!IlvExpressionEvaluation.convertToBoolean(object3) && !IlvExpressionEvaluation.convertToBoolean(object5 = this.q.a(ilvCSSModel, object, object2, ilvCSSBeans))) {
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
            }
            Object object6 = this.q.a(ilvCSSModel, object, object2, ilvCSSBeans);
            switch (this.o) {
                case 2: {
                    return a.a(object3, object6);
                }
                case 3: {
                    return a.b(object3, object6);
                }
                case 4: {
                    return a.handleLess(object3, object6);
                }
                case 5: {
                    return a.handleLessOrEquals(object3, object6);
                }
                case 6: {
                    return a.handleGreater(object3, object6);
                }
                case 7: {
                    return a.handleGreaterOrEquals(object3, object6);
                }
                case 8: {
                    return a.c(object3, object6);
                }
                case 9: {
                    return a.handleMinus(object3, object6);
                }
                case 10: {
                    return a.handleMultiply(object3, object6);
                }
                case 11: {
                    return a.handleDivide(object3, object6);
                }
                case 12: {
                    return a.handleRemainder(object3, object6);
                }
                case 13: {
                    return a.handlePow(object3, object6);
                }
            }
            throw new IlvInternalError("unhandled Binary op " + this.o);
        }

        @Override
        void a(Visitor visitor) {
            super.a(visitor);
            this.p.a(visitor);
            this.q.a(visitor);
        }
    }

    static final class Conditional
    extends AST {
        private final AST a;
        private final AST b;
        private final AST c;

        Conditional(AST aST, AST aST2, AST aST3) {
            this.a = aST;
            this.b = aST2;
            this.c = aST3;
        }

        @Override
        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, IlvCSSBeans ilvCSSBeans) {
            Object object3 = this.a.a(ilvCSSModel, object, object2, ilvCSSBeans);
            AST aST = IlvExpressionEvaluation.convertToBoolean(object3) ? this.b : this.c;
            return aST.a(ilvCSSModel, object, object2, ilvCSSBeans);
        }

        @Override
        void a(Visitor visitor) {
            super.a(visitor);
            this.a.a(visitor);
            this.b.a(visitor);
            this.c.a(visitor);
        }
    }

    static interface Visitor {
        public void visit(AST var1);
    }

    static abstract class AST {
        AST() {
        }

        Object a(IlvCSSModel ilvCSSModel, Object object, Object object2, PropertyDescriptor propertyDescriptor, boolean bl, IlvCSSBeans ilvCSSBeans) {
            return this.a(ilvCSSModel, object, object2, ilvCSSBeans);
        }

        abstract Object a(IlvCSSModel var1, Object var2, Object var3, IlvCSSBeans var4);

        void a(Visitor visitor) {
            visitor.visit(this);
        }
    }
}

