/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections;

import java.io.Serializable;

public class IlvDoubleArrayList
implements Cloneable,
Serializable {
    private static double[] a = new double[0];
    private double[] b;
    private int c;

    public IlvDoubleArrayList() {
        this.b = new double[10];
        this.c = 0;
    }

    public IlvDoubleArrayList(int n) {
        this.b = new double[n];
        this.c = 0;
    }

    public IlvDoubleArrayList(double[] dArray) {
        int n = dArray.length;
        n += n / 4;
        this.b = new double[n];
        this.c = dArray.length;
        System.arraycopy(dArray, 0, this.b, 0, this.c);
    }

    public int size() {
        return this.c;
    }

    public boolean isEmpty() {
        return this.c == 0;
    }

    public double get(int n) {
        if (n < this.c) {
            return this.b[n];
        }
        throw new IndexOutOfBoundsException("index " + n + " too large for size " + this.c);
    }

    public double set(int n, double d) {
        if (n < this.c) {
            double d2 = this.b[n];
            this.b[n] = d;
            return d2;
        }
        throw new IndexOutOfBoundsException("index " + n + " too large for size " + this.c);
    }

    public void copyInto(double[] dArray) {
        if (this.c > 0) {
            System.arraycopy(this.b, 0, dArray, 0, this.c);
        }
    }

    public double[] toArray() {
        if (this.c > 0) {
            double[] dArray = new double[this.c];
            System.arraycopy(this.b, 0, dArray, 0, this.c);
            return dArray;
        }
        return a;
    }

    public void add(double d) {
        this.ensureCapacity(this.c + 1);
        this.b[this.c] = d;
        ++this.c;
    }

    public void add(int n, double d) {
        if (n < 0 && n > this.c) {
            throw new IndexOutOfBoundsException("index " + n + " inappropriate for size " + this.c);
        }
        this.ensureCapacity(this.c + 1);
        if (n < this.c) {
            System.arraycopy(this.b, n, this.b, n + 1, this.c - n);
        }
        this.b[n] = d;
        ++this.c;
    }

    public double remove(int n) {
        if (n < 0 && n >= this.c) {
            throw new IndexOutOfBoundsException("index " + n + " inappropriate for size " + this.c);
        }
        double d = this.b[n];
        if (n + 1 < this.c) {
            System.arraycopy(this.b, n + 1, this.b, n, this.c - n - 1);
        }
        --this.c;
        return d;
    }

    public void removeRange(int n, int n2) {
        if (n < 0 || n2 > this.c || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            if (n2 < this.c) {
                System.arraycopy(this.b, n2, this.b, n, this.c - n2);
            }
            this.c -= n3;
        }
    }

    public void clear() {
        this.c = 0;
    }

    public void trimToSize() {
        if (this.b.length > this.c) {
            if (this.c > 0) {
                double[] dArray = new double[this.c];
                System.arraycopy(this.b, 0, dArray, 0, this.c);
                this.b = dArray;
            } else {
                this.b = a;
            }
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.b.length) {
            int n2 = this.b.length;
            if ((n2 += n2 / 4) < n) {
                n2 = n;
            }
            double[] dArray = new double[n2];
            System.arraycopy(this.b, 0, dArray, 0, this.c);
            this.b = dArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.c; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.b[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof IlvDoubleArrayList) {
            IlvDoubleArrayList ilvDoubleArrayList = (IlvDoubleArrayList)object;
            if (this.c != ilvDoubleArrayList.c) {
                return false;
            }
            int n = this.c;
            for (int i = 0; i < n; ++i) {
                if (Double.doubleToRawLongBits(this.b[i]) == Double.doubleToRawLongBits(ilvDoubleArrayList.b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        long l = this.c + 1;
        for (int i = 0; i < this.c; ++i) {
            l = 31L * l + Double.doubleToRawLongBits(this.b[i]);
        }
        return (int)(l ^ l >>> 32);
    }

    public Object clone() {
        try {
            IlvDoubleArrayList ilvDoubleArrayList = (IlvDoubleArrayList)super.clone();
            ilvDoubleArrayList.b = this.toArray();
            return ilvDoubleArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

