/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.annotation.NoWarning;
import ilog.views.util.beans.editor.IlvInternationalizedPropertyEditor;
import ilog.views.util.text.internal.IlvFormatUtil;
import ilog.views.util.text.internal.IlvICUNumberFormatFactory;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;

public abstract class IlvMultiNumberObjectPropertyEditor
extends PropertyEditorSupport
implements IlvInternationalizedPropertyEditor {
    private String a;
    private boolean b;
    private char c;
    private final ULocale d;
    private boolean e = false;

    public IlvMultiNumberObjectPropertyEditor() {
        this("", false);
    }

    public IlvMultiNumberObjectPropertyEditor(ULocale uLocale) {
        this("", false, uLocale);
    }

    public IlvMultiNumberObjectPropertyEditor(String string, boolean bl) {
        this(string, bl, IlvLocaleUtil.getCurrentULocale());
    }

    public IlvMultiNumberObjectPropertyEditor(String string, boolean bl, ULocale uLocale) {
        this.d = uLocale;
        this.a = string;
        this.b = bl;
        this.c = this.isIntegerFormat() ? IlvMultiNumberObjectPropertyEditor.calculateLocalizedIntegerSeparator(uLocale) : IlvMultiNumberObjectPropertyEditor.calculateLocalizedDoubleSeparator(uLocale);
    }

    @NoWarning(value={"com.ibm.icu.text.NumberFormat.getInstance(com.ibm.icu.util.Locale)"})
    public static char calculateLocalizedDoubleSeparator(ULocale uLocale) {
        char[] cArray = new char[]{';', ',', ' ', '|', '.'};
        NumberFormat numberFormat = NumberFormat.getInstance((ULocale)uLocale);
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)numberFormat).getDecimalFormatSymbols();
            char c = decimalFormatSymbols.getZeroDigit();
            char c2 = decimalFormatSymbols.getGroupingSeparator();
            char c3 = decimalFormatSymbols.getDecimalSeparator();
            char c4 = decimalFormatSymbols.getMinusSign();
            String string = decimalFormatSymbols.getInfinity();
            String string2 = decimalFormatSymbols.getNaN();
            for (int i = 0; i < cArray.length; ++i) {
                if (c == cArray[i] || c2 == cArray[i] || c3 == cArray[i] || c4 == cArray[i]) continue;
                if (string.contains("" + cArray[i])) continue;
                if (string2.contains("" + cArray[i])) continue;
                return cArray[i];
            }
        } else {
            for (int i = 0; i < cArray.length; ++i) {
                String string = numberFormat.format(0.5);
                String string3 = numberFormat.format(1000000.5);
                if (string.contains("" + cArray[i])) continue;
                if (string3.contains("" + cArray[i])) continue;
                return cArray[i];
            }
        }
        return '#';
    }

    public static char calculateLocalizedIntegerSeparator(ULocale uLocale) {
        char[] cArray = new char[]{';', ',', ' ', '|', '.'};
        NumberFormat numberFormat = NumberFormat.getIntegerInstance((ULocale)uLocale);
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)numberFormat).getDecimalFormatSymbols();
            char c = decimalFormatSymbols.getZeroDigit();
            char c2 = decimalFormatSymbols.getGroupingSeparator();
            char c3 = decimalFormatSymbols.getDecimalSeparator();
            char c4 = decimalFormatSymbols.getMinusSign();
            String string = decimalFormatSymbols.getInfinity();
            String string2 = decimalFormatSymbols.getNaN();
            for (int i = 0; i < cArray.length; ++i) {
                if (c == cArray[i] || c2 == cArray[i] || c3 == cArray[i] || c4 == cArray[i]) continue;
                if (string.contains("" + cArray[i])) continue;
                if (string2.contains("" + cArray[i])) continue;
                return cArray[i];
            }
        } else {
            for (int i = 0; i < cArray.length; ++i) {
                String string = numberFormat.format(0L);
                String string3 = numberFormat.format(1000000L);
                if (string.contains("" + cArray[i])) continue;
                if (string3.contains("" + cArray[i])) continue;
                return cArray[i];
            }
        }
        return '#';
    }

    protected int getArity() {
        return 2;
    }

    protected boolean isIntegerFormat() {
        int n = this.getArity();
        double[] dArray = new double[n];
        return this.getMultiNumberObject(dArray) == null;
    }

    protected Object getMultiNumberObject(long[] lArray) {
        return null;
    }

    protected Object getMultiNumberObject(double[] dArray) {
        return null;
    }

    protected long[] getMultiNumberValuesAsInteger(Object object) {
        return null;
    }

    protected double[] getMultiNumberValuesAsDouble(Object object) {
        return null;
    }

    protected Object getMultiNumberObjectAsNullReplacement() {
        int n = this.getArity();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.0;
        }
        Object object = this.getMultiNumberObject(dArray);
        if (object == null) {
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = 0L;
            }
            object = this.getMultiNumberObject(lArray);
        }
        return object;
    }

    @Override
    public abstract String getJavaInitializationString();

    @Override
    public Object getValue() {
        Object object = super.getValue();
        if (object == null && !this.b) {
            object = this.getMultiNumberObjectAsNullReplacement();
        }
        return object;
    }

    @Override
    public void setValue(Object object) {
        if (object == null && !this.b) {
            object = this.getMultiNumberObjectAsNullReplacement();
        }
        super.setValue(object);
    }

    @Override
    public String getAsText() {
        return this.a(',', false);
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        this.a(string, ',', false);
    }

    public char getLocalizedSeparator() {
        return this.c;
    }

    @Override
    public String getAsLocalizedText() {
        return this.a(this.c, true);
    }

    @Override
    public void setAsLocalizedText(String string) throws IllegalArgumentException {
        this.a(string, this.c, true);
    }

    @Override
    public String[] getValuesAsLocalizedText() {
        return null;
    }

    private String a(char c, boolean bl) {
        Object object = this.getValue();
        if (object != null) {
            long[] lArray = this.getMultiNumberValuesAsInteger(object);
            double[] dArray = this.getMultiNumberValuesAsDouble(object);
            StringBuffer stringBuffer = null;
            if (lArray != null) {
                if (bl) {
                    NumberFormat numberFormat = IlvICUNumberFormatFactory.createIntegerInstance(this.d);
                    numberFormat.setGroupingUsed(this.e);
                    for (int i = 0; i < lArray.length; ++i) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        } else {
                            stringBuffer.append(c);
                        }
                        stringBuffer.append(numberFormat.format(lArray[i]));
                    }
                } else {
                    for (int i = 0; i < lArray.length; ++i) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        } else {
                            stringBuffer.append(c);
                        }
                        stringBuffer.append("" + lArray[i]);
                    }
                }
            } else if (dArray != null) {
                if (bl) {
                    NumberFormat numberFormat = IlvICUNumberFormatFactory.createInstance(this.d);
                    numberFormat.setGroupingUsed(this.e);
                    for (int i = 0; i < dArray.length; ++i) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        } else {
                            stringBuffer.append(c);
                        }
                        stringBuffer.append(numberFormat.format(dArray[i]));
                    }
                } else {
                    for (int i = 0; i < dArray.length; ++i) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        } else {
                            stringBuffer.append(c);
                        }
                        stringBuffer.append("" + dArray[i]);
                    }
                }
            } else {
                throw new RuntimeException("Internal error");
            }
            return stringBuffer.toString();
        }
        return this.a;
    }

    private void a(String string, char c, boolean bl) throws IllegalArgumentException {
        if (this.b && this.a.equals(string)) {
            this.setValue(null);
        } else if (this.isIntegerFormat()) {
            NumberFormat numberFormat = IlvICUNumberFormatFactory.getIntegerInstance(this.d);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "" + c);
            int n = stringTokenizer.countTokens();
            if (n != this.getArity()) {
                throw new IllegalArgumentException("invalid input:" + string);
            }
            long[] lArray = new long[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                try {
                    lArray[n2] = bl ? IlvFormatUtil.parseFully(numberFormat, string2).longValue() : Long.parseLong(string2);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("invalid input:" + string);
                }
                ++n2;
            }
            this.setValue(this.getMultiNumberObject(lArray));
        } else {
            NumberFormat numberFormat = IlvICUNumberFormatFactory.getInstance(this.d);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "" + c);
            int n = stringTokenizer.countTokens();
            if (n != this.getArity()) {
                throw new IllegalArgumentException("invalid input:" + string);
            }
            double[] dArray = new double[n];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                try {
                    dArray[n3] = bl ? IlvFormatUtil.parseFully(numberFormat, string3).doubleValue() : Double.parseDouble(string3);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("invalid input:" + string);
                }
                ++n3;
            }
            this.setValue(this.getMultiNumberObject(dArray));
        }
    }

    public void setGroupingUsed(boolean bl) {
        this.e = bl;
    }

    public boolean isGroupingUsed() {
        return this.e;
    }
}

