/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.beans.editor.IlvFormattedPropertyEditor;
import ilog.views.util.beans.editor.Messages;
import ilog.views.util.swing.calendar.IlvJCalendar;
import ilog.views.util.swing.calendar.event.CalendarModelEvent;
import ilog.views.util.swing.calendar.event.CalendarModelListener;
import ilog.views.util.text.IlvDateFormat;
import ilog.views.util.text.IlvDateFormatFactory;
import ilog.views.util.time.IlvCalendarFactory;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class IlvFormattedDatePropertyEditor
extends IlvFormattedPropertyEditor {
    private ULocale a;
    private Date b;
    private IlvJCalendar c;

    public IlvFormattedDatePropertyEditor() {
        this.a = IlvLocaleUtil.getCurrentULocale();
    }

    public IlvFormattedDatePropertyEditor(ULocale uLocale) {
        this.a = uLocale;
    }

    public Locale getLocale() {
        return this.a != null ? this.a.toLocale() : null;
    }

    public void setLocale(Locale locale) {
        this.a = ULocale.forLocale((Locale)locale);
    }

    public ULocale getULocale() {
        return this.a;
    }

    public void setULocale(ULocale uLocale) {
        this.a = uLocale;
    }

    @Override
    public String getJavaInitializationString() {
        Date date = (Date)this.getValue();
        return "new java.util.Date(" + date.getTime() + "L)";
    }

    @Override
    protected String getFormatAsText() {
        String string = "";
        Format format = this.getFormat();
        if (format != null) {
            if (format instanceof SimpleDateFormat) {
                string = ((SimpleDateFormat)format).toPattern();
            } else if (format instanceof IlvDateFormat) {
                string = ((IlvDateFormat)format).toPattern();
            }
        }
        return string;
    }

    @Override
    protected void setFormatFromText(String string) throws IllegalArgumentException {
        this.setFormat(IlvDateFormatFactory.getInstance(string, this.a, null));
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (string != null) {
            Date date = null;
            char c = string.charAt(0);
            if (!Character.isDigit(c)) {
                try {
                    super.setAsText(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Could not create a Date from " + string);
                }
            }
            try {
                date = new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (date == null) {
                throw new IllegalArgumentException("Could not create a Date from " + string);
            }
            this.setValue(date);
        }
    }

    @Override
    public String getAsText() {
        Date date = (Date)this.getValue();
        if (date == null) {
            return "";
        }
        if (this.getFormat() == null) {
            this.setFormat(IlvDateFormatFactory.getDateTimeInstance(3, 3, this.a));
        }
        return super.getAsText();
    }

    @Override
    public void setValue(Object object) {
        this.b = (Date)object;
        super.setValue(object);
        if (this.c != null && object != null && !object.equals(this.c.getCalendar().getTime())) {
            this.c.getCalendar().setTime(this.b);
        }
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string;
        if (this.b == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        if (this.getFormat() == null) {
            this.setFormat(IlvDateFormatFactory.getDateTimeInstance(3, 3, this.a));
        }
        if ((string = this.getFormattedValue()) == null) {
            string = String.valueOf(this.b.getTime());
        }
        graphics.drawString(string, 0, rectangle.height - n);
    }

    @Override
    public Object getValue() {
        return this.b;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.c == null) {
            this.c = new IlvJCalendar();
            this.c.putClientProperty("__PSheetDialogTitleKey", Messages.BUNDLE.getString("FormattedDatePropertyEditor.Title"));
            this.c.setTimeChooser(this.c.createDefaultTimeChooser());
            this.c.getModel().addCalendarModelListener(new CalendarModelListener(){

                @Override
                public void calendarChanged(CalendarModelEvent calendarModelEvent) {
                    IlvFormattedDatePropertyEditor.this.setValue(IlvFormattedDatePropertyEditor.this.c.getCalendar().getTime());
                }
            });
        } else if (this.b != null) {
            Calendar calendar = IlvCalendarFactory.createInstance(this.a);
            calendar.setTime(this.b);
            this.c.setCalendar(calendar);
        }
        return this.c;
    }
}

