/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.beans.editor.Messages;
import ilog.views.util.swing.font.IlvFontChooser;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IlvFontPropertyEditor
extends PropertyEditorSupport {
    private IlvFontChooser a = null;
    private Font b = Font.getFont("Dialog");
    private String c;
    static FontStyleDef[] d;

    @Override
    public String getJavaInitializationString() {
        Font font = (Font)this.getValue();
        if (font == null) {
            return "null";
        }
        return "new java.awt.Font(\"" + font.getFamily() + "\", java.awt.Font." + IlvFontPropertyEditor.a(font.getStyle()) + ", " + font.getSize() + ")";
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        int n = string.indexOf(45);
        int n2 = string.indexOf(45, n + 1);
        if (n < 0 || n2 < 0) {
            n = string.indexOf(44);
            n2 = string.indexOf(44, n + 1);
            if (n < 0 || n2 < 0) {
                throw new IllegalArgumentException(string);
            }
        }
        try {
            String string2 = string.substring(0, n);
            int n3 = IlvFontPropertyEditor.a(string.substring(n + 1, n2));
            int n4 = Integer.parseInt(string.substring(n2 + 1));
            this.setValue(new Font(string2, n3, n4));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public String getAsText() {
        Font font = (Font)this.getValue();
        if (font == null) {
            return "null";
        }
        return font.getFamily() + "-" + IlvFontPropertyEditor.a(font.getStyle()) + "-" + font.getSize();
    }

    @Override
    public void setValue(Object object) {
        this.b = (Font)object;
        super.setValue(object);
        if (this.a != null && (object != null ? this.a.getSelectedFont() == null || !object.equals(this.a.getSelectedFont()) : this.a.getSelectedFont() != null)) {
            this.a.setSelectedFont(this.b);
        }
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    private String a() {
        if (this.c == null) {
            this.c = IlvResourceUtil.getBundle("resources.messages", IlvFontChooser.class, IlvLocaleUtil.getCurrentLocale()).getString("IlvFontChooser.ExemplarCharacters.Short");
        }
        return this.c;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Font font = graphics.getFont();
        graphics.setFont(this.b);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(this.a(), 0, rectangle.height - n);
        graphics.setFont(font);
    }

    @Override
    public Object getValue() {
        return this.b;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.a == null) {
            this.a = new IlvFontChooser(this.b);
            this.a.putClientProperty("__PSheetDialogTitleKey", Messages.BUNDLE.getString("FontEditor.Title"));
            this.a.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    IlvFontPropertyEditor.this.setValue(IlvFontPropertyEditor.this.a.getSelectedFont());
                }
            });
        }
        if (this.b == null) {
            this.b = this.a.getSelectedFont();
        } else {
            this.a.setSelectedFont(this.b);
        }
        return this.a;
    }

    static int a(String string) {
        string = string.toUpperCase(Locale.ENGLISH);
        for (int i = 0; i < d.length; ++i) {
            if (!string.equals(IlvFontPropertyEditor.d[i].name)) continue;
            return IlvFontPropertyEditor.d[i].val;
        }
        throw new IllegalArgumentException(string);
    }

    static String a(int n) {
        for (int i = 0; i < d.length; ++i) {
            if (n != IlvFontPropertyEditor.d[i].val) continue;
            return IlvFontPropertyEditor.d[i].name;
        }
        throw new IllegalArgumentException("" + n);
    }

    static {
        FontStyleDef[] fontStyleDefArray = new FontStyleDef[4];
        fontStyleDefArray[0] = new FontStyleDef("BOLD", 1);
        fontStyleDefArray[1] = new FontStyleDef("ITALIC", 2);
        fontStyleDefArray[2] = new FontStyleDef("BOLDITALIC", 3);
        fontStyleDefArray[3] = new FontStyleDef("PLAIN", 0);
        d = fontStyleDefArray;
    }

    public static class FontStyleDef {
        public int val;
        public String name;

        public FontStyleDef(String string, int n) {
            this.name = string;
            this.val = n;
        }
    }
}

