/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans;

import ilog.views.util.beans.IlvPropertyEditorManager;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.HashSet;

public final class IlvBeanUtil {
    private IlvBeanUtil() {
    }

    public static PropertyEditor createPropertyEditor(Class clazz, String string) {
        PropertyDescriptor propertyDescriptor = IlvBeanUtil.findPropertyDescriptor(clazz, string);
        return propertyDescriptor != null ? IlvBeanUtil.createPropertyEditor(propertyDescriptor) : null;
    }

    public static PropertyDescriptor findPropertyDescriptor(Class clazz, String string) {
        BeanInfo beanInfo;
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("propertyName shouldn't be null or empty");
        }
        try {
            Class clazz2 = clazz;
            while (true) {
                try {
                    beanInfo = Introspector.getBeanInfo(clazz);
                }
                catch (ClassFormatError classFormatError) {
                    clazz2 = clazz2.getSuperclass();
                    if (clazz2 != null) continue;
                    return null;
                }
                break;
            }
        }
        catch (IntrospectionException introspectionException) {
            RuntimeException runtimeException = new RuntimeException(introspectionException.getMessage());
            runtimeException.initCause(introspectionException);
            throw runtimeException;
        }
        return IlvBeanUtil.findPropertyDescriptor(beanInfo, string);
    }

    public static PropertyDescriptor findPropertyDescriptor(BeanInfo beanInfo, String string) {
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray != null ? propertyDescriptorArray.length : 0;
        PropertyDescriptor propertyDescriptor = null;
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            propertyDescriptor = propertyDescriptorArray[i];
            string2 = propertyDescriptor.getName();
            if (!string2.equals(string)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public static PropertyEditor createPropertyEditor(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("propDescriptor cannot be null");
        }
        PropertyEditor propertyEditor = null;
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        if (clazz != null) {
            try {
                propertyEditor = (PropertyEditor)clazz.newInstance();
            }
            catch (Exception exception) {
                propertyEditor = null;
            }
        } else {
            Class<?> clazz2 = propertyDescriptor.getPropertyType();
            propertyEditor = IlvPropertyEditorManager.findEditor(clazz2);
        }
        return propertyEditor;
    }

    public static void addBeanInfoSearchPath(String ... stringArray) {
        int n;
        if (stringArray == null) {
            return;
        }
        if (stringArray.length == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = Introspector.getBeanInfoSearchPath();
        if (stringArray2 != null && stringArray2.length > 0) {
            for (n = 0; n < stringArray2.length; ++n) {
                if (hashSet.contains(stringArray2[n])) continue;
                hashSet.add(stringArray2[n]);
                arrayList.add(stringArray2[n]);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (hashSet.contains(stringArray[n])) continue;
            hashSet.add(stringArray[n]);
            arrayList.add(stringArray[n]);
        }
        stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        Introspector.setBeanInfoSearchPath(stringArray2);
        Introspector.flushCaches();
    }
}

