/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util;

import ilog.views.util.internal.IlvURLUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class IlvImageUtil {
    public static Image getImageFromFile(Class clazz, String string) throws IOException {
        int n;
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(clazz + ".getResourceAsStream(" + string + ") returns null");
        }
        byte[][] byArrayArray = new byte[1][];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byArrayArray[0] = new byte[1024];
        while ((n = bufferedInputStream.read(byArrayArray[0])) > 0) {
            byteArrayOutputStream.write(byArrayArray[0], 0, n);
        }
        bufferedInputStream.close();
        byteArrayOutputStream.flush();
        byArrayArray[0] = byteArrayOutputStream.toByteArray();
        if (byArrayArray[0] == null) {
            throw new IOException(clazz.getName() + "/" + string + " not found.");
        }
        if (byArrayArray[0].length == 0) {
            throw new IOException("warning: " + string + " is zero-length");
        }
        return Toolkit.getDefaultToolkit().createImage(byArrayArray[0]);
    }

    public static Image loadImageFromFile(Class clazz, String string) throws IOException {
        return IlvImageUtil.a(IlvImageUtil.getImageFromFile(clazz, string));
    }

    public static Image loadImage(URL uRL) {
        try {
            uRL = IlvURLUtil.prepare(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return IlvImageUtil.a(Toolkit.getDefaultToolkit().getImage(uRL));
    }

    public static Image loadImage(String string) {
        Image image = null;
        try {
            URL uRL = IlvURLUtil.convertFilenameToURL(string);
            image = IlvImageUtil.loadImage(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return image;
    }

    public static Image loadImage(byte[] byArray) {
        return IlvImageUtil.a(Toolkit.getDefaultToolkit().createImage(byArray));
    }

    private static Image a(Image image) {
        if (image != null) {
            MediaTracker mediaTracker = new MediaTracker(new Component(){});
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                mediaTracker.removeImage(image);
                image = null;
            }
            finally {
                if (image != null) {
                    mediaTracker.removeImage(image);
                }
                if (mediaTracker.isErrorAny()) {
                    image = null;
                }
                if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                    image = null;
                }
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(Image image) {
        if (image == null) {
            return null;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n < 0 || n2 < 0) {
            MediaTracker mediaTracker = new MediaTracker(new Component(){});
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            finally {
                mediaTracker.removeImage(image);
            }
            n = image.getWidth(null);
            n2 = image.getHeight(null);
        }
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        return new Dimension(n, n2);
    }

    public static BufferedImage createBufferedImage(Image image, int n) {
        Dimension dimension = IlvImageUtil.getImageSize(image);
        if (dimension == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, n);
        Graphics graphics = bufferedImage.getGraphics();
        if (graphics == null) {
            return null;
        }
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    public static BufferedImage loadImage(String string, int n) {
        BufferedImage bufferedImage = null;
        try {
            URL uRL = IlvURLUtil.convertFilenameToURL(string);
            bufferedImage = IlvImageUtil.loadImage(uRL, n);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return bufferedImage;
    }

    public static BufferedImage loadImage(URL uRL, int n) {
        if (uRL == null) {
            throw new IllegalArgumentException("URL of image is null");
        }
        Image image = IlvImageUtil.loadImage(uRL);
        return image == null ? null : IlvImageUtil.createBufferedImage(image, n);
    }

    private static BufferedImage a(URL uRL, int n) {
        BufferedImage bufferedImage = IlvImageUtil.a(uRL);
        if (bufferedImage != null && bufferedImage.getType() != n) {
            bufferedImage = IlvImageUtil.createBufferedImage(bufferedImage, n);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage a(URL uRL) {
        BufferedImage bufferedImage = null;
        if (uRL != null) {
            try {
                Object object = "file".equals(uRL.getProtocol()) ? IlvURLUtil.convertFileURLToFile(uRL) : IlvURLUtil.openStream(uRL);
                try {
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(object);
                    try {
                        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("jpeg");
                        if (!iterator.hasNext()) {
                            throw new IOException("no JPEG format reader found");
                        }
                        ImageReader imageReader = iterator.next();
                        try {
                            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                            imageReader.setInput(imageInputStream, !(object instanceof File), true);
                            bufferedImage = imageReader.read(0, imageReadParam);
                        }
                        finally {
                            imageReader.dispose();
                        }
                    }
                    finally {
                        imageInputStream.close();
                    }
                }
                finally {
                    if (object instanceof InputStream) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (IOException iOException) {
                bufferedImage = null;
            }
            if (bufferedImage != null && (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0)) {
                bufferedImage = null;
            }
        }
        return bufferedImage;
    }

    public static void writeJPEGImage(BufferedImage bufferedImage, File file) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, "JPEG", file);
    }

    public static void writeJPEGImage(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, "JPEG", outputStream);
    }

    public static void writeJPEGImage(BufferedImage bufferedImage, float f, File file) throws IOException {
        IlvImageUtil.a(bufferedImage, f, (Object)file);
    }

    public static void writeJPEGImage(BufferedImage bufferedImage, float f, OutputStream outputStream) throws IOException {
        IlvImageUtil.a(bufferedImage, f, (Object)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(BufferedImage bufferedImage, float f, Object object) throws IOException {
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(object);
        try {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpeg");
            if (!iterator.hasNext()) {
                throw new IOException("no JPEG format writer found");
            }
            ImageWriter imageWriter = iterator.next();
            try {
                imageWriter.setOutput(imageOutputStream);
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(f);
                imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
                imageOutputStream.flush();
            }
            finally {
                imageWriter.dispose();
            }
        }
        finally {
            imageOutputStream.close();
        }
    }

    public static void writePNGImage(BufferedImage bufferedImage, File file) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
    }

    public static void writePNGImage(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, "PNG", outputStream);
    }

    public static void writePNGImage(BufferedImage bufferedImage, Color color, File file) throws IOException {
        IlvImageUtil.a(bufferedImage, color, (Object)file);
    }

    public static void writePNGImage(BufferedImage bufferedImage, Color color, OutputStream outputStream) throws IOException {
        IlvImageUtil.a(bufferedImage, color, (Object)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(BufferedImage bufferedImage, Color color, Object object) throws IOException {
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(object);
        try {
            ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
            Iterator<ImageWriter> iterator = ImageIO.getImageWriters(imageTypeSpecifier, "png");
            if (!iterator.hasNext()) {
                throw new IOException("no PNG format writer found");
            }
            ImageWriter imageWriter = iterator.next();
            try {
                imageWriter.setOutput(imageOutputStream);
                if (color == null) {
                    imageWriter.write(bufferedImage);
                } else {
                    ImageWriteParam imageWriteParam = null;
                    IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
                    if (iIOMetadata != null) {
                        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(iIOMetadata.getNativeMetadataFormatName());
                        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("tRNS");
                        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("tRNS_RGB");
                        iIOMetadataNode3.setAttribute("red", Integer.toString(color.getRed()));
                        iIOMetadataNode3.setAttribute("green", Integer.toString(color.getGreen()));
                        iIOMetadataNode3.setAttribute("blue", Integer.toString(color.getBlue()));
                        iIOMetadataNode2.appendChild(iIOMetadataNode3);
                        iIOMetadataNode.appendChild(iIOMetadataNode2);
                        iIOMetadata.mergeTree(iIOMetadata.getNativeMetadataFormatName(), iIOMetadataNode);
                    }
                    imageWriter.write(iIOMetadata, new IIOImage(bufferedImage, null, iIOMetadata), imageWriteParam);
                }
                imageOutputStream.flush();
            }
            finally {
                imageWriter.dispose();
            }
        }
        finally {
            imageOutputStream.close();
        }
    }

    public static Image getScaledImage(Image image, int n, int n2, boolean bl, int n3) {
        try {
            return image.getScaledInstance(n, n2, n3);
        }
        catch (Exception exception) {
            int n4 = 0;
            int n5 = 0;
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!mediaTracker.isErrorID(0)) {
                n4 = image.getWidth(null);
                n5 = image.getHeight(null);
            }
            mediaTracker.removeImage(image);
            if (n4 <= 0 || n5 <= 0) {
                return null;
            }
            int n6 = bl ? 1 : 2;
            BufferedImage bufferedImage = new BufferedImage(n4, n5, n6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage.getScaledInstance(n, n2, n3);
        }
    }

    private IlvImageUtil() {
    }
}

