/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util;

import ilog.views.util.event.ClassLoaderLifetimeEvent;
import ilog.views.util.event.ClassLoaderLifetimeListener;
import ilog.views.util.internal.IlvLoggerUtil;
import ilog.views.util.internal.IlvReflection;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IlvClassLoaderUtil {
    private static Logger a = IlvLoggerUtil.getLogger("ilog.views.util.IlvClassLoaderUtil");
    private static Map<ClassLoader, Set<ClassLoaderLifetimeListener>> b = new HashMap<ClassLoader, Set<ClassLoaderLifetimeListener>>();
    private static List<ClassLoader> c = new ArrayList<ClassLoader>();
    private static final IlvClassLoaderUtil d;
    private static IlvClassLoaderUtil e;
    private static ClassLoader f;
    private static boolean g;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClassLoaderLifetimeListener(ClassLoader classLoader, ClassLoaderLifetimeListener classLoaderLifetimeListener) {
        Map<ClassLoader, Set<ClassLoaderLifetimeListener>> map = b;
        synchronized (map) {
            Set<ClassLoaderLifetimeListener> set = b.get(classLoader);
            if (set == null) {
                set = new HashSet<ClassLoaderLifetimeListener>();
                b.put(classLoader, set);
            }
            set.add(classLoaderLifetimeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClassLoaderLifetimeListener(ClassLoader classLoader, ClassLoaderLifetimeListener classLoaderLifetimeListener) {
        Map<ClassLoader, Set<ClassLoaderLifetimeListener>> map = b;
        synchronized (map) {
            Set<ClassLoaderLifetimeListener> set = b.get(classLoader);
            if (set != null) {
                set.remove(classLoaderLifetimeListener);
                if (set.isEmpty()) {
                    b.remove(classLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClassLoaderLifetimeListeners(ClassLoader classLoader) {
        Map<ClassLoader, Set<ClassLoaderLifetimeListener>> map = b;
        synchronized (map) {
            b.remove(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(ClassLoader classLoader) {
        ClassLoaderLifetimeListener[] classLoaderLifetimeListenerArray;
        Object object = b;
        synchronized (object) {
            Set<ClassLoaderLifetimeListener> set = b.get(classLoader);
            if (set == null) {
                return;
            }
            classLoaderLifetimeListenerArray = set.toArray(new ClassLoaderLifetimeListener[0]);
        }
        object = new ClassLoaderLifetimeEvent(IlvClassLoaderUtil.class, classLoader);
        for (int i = 0; i < classLoaderLifetimeListenerArray.length; ++i) {
            classLoaderLifetimeListenerArray[i].stopUse((ClassLoaderLifetimeEvent)object);
        }
    }

    public static void registerClassLoader(ClassLoader classLoader) {
        a.log(Level.FINER, "adding {0} to the list of registered ClassLoaders", classLoader);
        c.add(classLoader);
    }

    public static void unregisterClassLoader(ClassLoader classLoader) {
        a.log(Level.FINER, "removing {0} from the list of registered ClassLoaders", classLoader);
        c.remove(classLoader);
        IlvClassLoaderUtil.a(classLoader);
    }

    public static List<ClassLoader> getRegisteredClassLoaders() {
        return Collections.unmodifiableList(c);
    }

    public Class forNameImpl(Class clazz, String string) throws ClassNotFoundException {
        a.log(Level.FINER, ">> forNameImpl(\"{0}\")", string);
        try {
            Class clazz2 = this.a(clazz, string);
            a.log(Level.FINER, "<< forNameImpl(\"{0}\") -> found in class loader {1}", new Object[]{string, clazz2.getClassLoader()});
            return clazz2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            a.log(Level.FINER, "<< forNameImpl(\"" + string + "\") failed -> ", classNotFoundException);
            throw classNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            a.log(Level.FINER, "<< forNameImpl(\"" + string + "\") failed -> ", runtimeException);
            throw runtimeException;
        }
    }

    private Class a(Class clazz, String string) throws ClassNotFoundException {
        Object object;
        Class<?> clazz2;
        try {
            clazz2 = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            clazz2 = null;
        }
        a.log(Level.FINEST, ">> trying thread''s context class loader = {0}", clazz2);
        try {
            if (clazz2 != null && ((ClassLoader)((Object)clazz2)).loadClass(string) != null) {
                Class<?> clazz3 = Class.forName(string, true, (ClassLoader)((Object)clazz2));
                a.log(Level.FINEST, "<< trying thread''s context class loader: success -> {0}", clazz3);
                return clazz3;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ClassFormatError classFormatError) {
        }
        a.log(Level.FINEST, "<< trying thread's context class loader: failed");
        clazz2 = c.iterator();
        while (clazz2.hasNext()) {
            object = (ClassLoader)clazz2.next();
            a.log(Level.FINEST, ">> trying registered class loader {0}", object);
            try {
                if (((ClassLoader)object).loadClass(string) != null) {
                    Class<?> clazz4 = Class.forName(string, true, (ClassLoader)object);
                    a.log(Level.FINEST, "<< trying registered class loader: success -> {0}", clazz4);
                    return clazz4;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassFormatError classFormatError) {
            }
            a.log(Level.FINEST, "<< trying registered class loader: failed");
        }
        if (clazz != null && (clazz2 = clazz.getClassLoader()) != null) {
            a.log(Level.FINEST, ">> trying callingClass' class loader = {0}", clazz2);
            try {
                try {
                    if (((ClassLoader)((Object)clazz2)).loadClass(string) != null) {
                        object = Class.forName(string, true, clazz2);
                        a.log(Level.FINEST, "<< trying callingClass' class loader: success -> {0}", object);
                        return object;
                    }
                }
                catch (ClassFormatError classFormatError) {
                    throw new ClassNotFoundException(classFormatError.getMessage(), classFormatError);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                a.log(Level.FINEST, "<< trying callingClass' class loader: failed -> ", classNotFoundException);
                throw classNotFoundException;
            }
            a.log(Level.FINEST, "<< trying callingClass' class loader: failed");
        }
        a.log(Level.FINEST, ">> trying JViews Framework class loader = {0}", IlvClassLoaderUtil.class.getClassLoader());
        try {
            try {
                clazz2 = Class.forName(string);
                a.log(Level.FINEST, "<< trying JViews Framework class loader: success -> {0}", clazz2);
                return clazz2;
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassNotFoundException(classFormatError.getMessage(), classFormatError);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            a.log(Level.FINEST, "<< trying JViews Framework class loader: failed -> ", classNotFoundException);
            throw classNotFoundException;
        }
    }

    public URL getResourceImpl(Class clazz, String string) {
        a.log(Level.FINER, ">> getResourceImpl(\"{0}\")", string);
        try {
            URL uRL = this.b(clazz, string);
            a.log(Level.FINER, "<< getResourceImpl(\"{0}\") -> returns {1}", new Object[]{string, uRL});
            return uRL;
        }
        catch (RuntimeException runtimeException) {
            a.log(Level.FINER, "<< getResourceImpl(\"" + string + "\") failed -> ", runtimeException);
            throw runtimeException;
        }
    }

    private URL b(Class clazz, String string) {
        Object object;
        URL uRL = null;
        try {
            object = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            object = null;
        }
        a.log(Level.FINEST, ">> trying thread''s context class loader = {0}", object);
        try {
            if (object != null) {
                uRL = ((ClassLoader)object).getResource(string);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (uRL != null) {
            a.log(Level.FINEST, "<< trying thread''s context class loader: success -> {0}", uRL);
        } else {
            a.log(Level.FINEST, "<< trying thread's context class loader: failed");
        }
        if (uRL == null) {
            object = c.iterator();
            while (object.hasNext()) {
                ClassLoader classLoader = (ClassLoader)object.next();
                a.log(Level.FINEST, ">> trying registered class loader {0}", classLoader);
                try {
                    uRL = classLoader.getResource(string);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (uRL != null) {
                    a.log(Level.FINEST, "<< trying registered class loader: success -> {0}", uRL);
                    break;
                }
                a.log(Level.FINEST, "<< trying registered class loader: failed");
            }
        }
        if (uRL == null && clazz != null && (object = clazz.getClassLoader()) != null) {
            a.log(Level.FINEST, ">> trying callingClass' class loader = {0}", object);
            try {
                uRL = ((ClassLoader)object).getResource(string);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (uRL != null) {
                a.log(Level.FINEST, "<< trying callingClass' class loader: success -> {0}", uRL);
            } else {
                a.log(Level.FINEST, "<< trying callingClass' class loader: failed");
            }
        }
        if (uRL == null) {
            a.log(Level.FINEST, ">> trying JViews Framework class loader = {0}", IlvClassLoaderUtil.class.getClassLoader());
            uRL = IlvClassLoaderUtil.class.getResource("/" + string);
            if (uRL != null) {
                a.log(Level.FINEST, "<< trying JViews Framework class loader: success -> {0}", uRL);
            } else {
                a.log(Level.FINEST, "<< trying JViews Framework class loader: failed");
            }
        }
        return uRL;
    }

    public InputStream getResourceAsStreamImpl(Class clazz, String string) {
        a.log(Level.FINER, ">> getResourceAsStreamImpl(\"{0}\")", string);
        try {
            InputStream inputStream = this.c(clazz, string);
            a.log(Level.FINER, "<< getResourceAsStreamImpl(\"{0}\") -> success", string);
            return inputStream;
        }
        catch (RuntimeException runtimeException) {
            a.log(Level.FINER, "<< getResourceAsStreamImpl(\"" + string + "\") failed -> ", runtimeException);
            throw runtimeException;
        }
    }

    private InputStream c(Class clazz, String string) {
        Object object;
        InputStream inputStream = null;
        try {
            object = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            object = null;
        }
        a.log(Level.FINEST, ">> trying thread''s context class loader = {0}", object);
        try {
            if (object != null) {
                inputStream = ((ClassLoader)object).getResourceAsStream(string);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (inputStream != null) {
            a.log(Level.FINEST, "<< trying thread's context class loader: success");
        } else {
            a.log(Level.FINEST, "<< trying thread's context class loader: failed");
        }
        if (inputStream == null) {
            object = c.iterator();
            while (object.hasNext()) {
                ClassLoader classLoader = (ClassLoader)object.next();
                a.log(Level.FINEST, ">> trying registered class loader {0}", classLoader);
                try {
                    inputStream = classLoader.getResourceAsStream(string);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (inputStream != null) {
                    a.log(Level.FINEST, "<< trying registered class loader: success");
                    break;
                }
                a.log(Level.FINEST, "<< trying registered class loader: failed");
            }
        }
        if (inputStream == null && clazz != null && (object = clazz.getClassLoader()) != null) {
            a.log(Level.FINEST, ">> trying callingClass' class loader = {0}", object);
            try {
                inputStream = ((ClassLoader)object).getResourceAsStream(string);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (inputStream != null) {
                a.log(Level.FINEST, "<< trying callingClass' class loader: success");
            } else {
                a.log(Level.FINEST, "<< trying callingClass' class loader: failed");
            }
        }
        if (inputStream == null) {
            a.log(Level.FINEST, ">> trying JViews Framework class loader = {0}", IlvClassLoaderUtil.class.getClassLoader());
            inputStream = IlvClassLoaderUtil.class.getResourceAsStream("/" + string);
            if (inputStream != null) {
                a.log(Level.FINEST, "<< trying JViews Framework class loader: success");
            } else {
                a.log(Level.FINEST, "<< trying JViews Framework class loader: failed");
            }
        }
        return inputStream;
    }

    ResourceBundle a(String string, Locale locale) {
        a.log(Level.FINER, ">> getResourceBundleImpl(\"{0}\",{1})", new Object[]{string, locale});
        try {
            ResourceBundle resourceBundle = this.c(string, locale);
            a.log(Level.FINER, "<< getResourceBundleImpl(\"{0}\",{1}) -> returns {2}", new Object[]{string, locale, resourceBundle});
            return resourceBundle;
        }
        catch (RuntimeException runtimeException) {
            a.log(Level.FINER, "<< getResourceBundleImpl(\"" + string + "," + locale + "\") failed -> ", runtimeException);
            throw runtimeException;
        }
    }

    private ResourceBundle c(String string, Locale locale) {
        Object object;
        ResourceBundle resourceBundle = null;
        try {
            object = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            object = null;
        }
        a.log(Level.FINEST, ">> trying thread''s context class loader = {0}", object);
        try {
            if (object != null) {
                resourceBundle = ResourceBundle.getBundle(string, locale, (ClassLoader)object);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (resourceBundle != null) {
            a.log(Level.FINEST, "<< trying thread''s context class loader: success -> {0}", resourceBundle);
        } else {
            a.log(Level.FINEST, "<< trying thread's context class loader: failed");
        }
        if (resourceBundle == null) {
            for (ClassLoader classLoader : c) {
                a.log(Level.FINEST, ">> trying registered class loader {0}", classLoader);
                try {
                    resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
                }
                catch (SecurityException securityException) {
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (resourceBundle != null) {
                    a.log(Level.FINEST, "<< trying registered class loader: success -> {0}", resourceBundle);
                    break;
                }
                a.log(Level.FINEST, "<< trying registered class loader: failed");
            }
        }
        if (resourceBundle == null) {
            a.log(Level.FINEST, ">> trying JViews Framework class loader = {0}", IlvClassLoaderUtil.class.getClassLoader());
            resourceBundle = ResourceBundle.getBundle(string, locale);
            if (resourceBundle != null) {
                a.log(Level.FINEST, "<< trying JViews Framework class loader: success -> {0}", resourceBundle);
            } else {
                a.log(Level.FINEST, "<< trying JViews Framework class loader: failed");
            }
        }
        return resourceBundle;
    }

    public static IlvClassLoaderUtil getDefaultInstance() {
        return d;
    }

    public static IlvClassLoaderUtil getDelegate() {
        return e;
    }

    public static void setDelegate(IlvClassLoaderUtil ilvClassLoaderUtil) {
        e = ilvClassLoaderUtil;
    }

    public static Class forName(Class clazz, String string) throws ClassNotFoundException {
        if (string.startsWith("[") && string.length() >= 2) {
            switch (string.charAt(1)) {
                case 'Z': {
                    return IlvReflection.arrayType(Boolean.TYPE);
                }
                case 'C': {
                    return IlvReflection.arrayType(Character.TYPE);
                }
                case 'B': {
                    return IlvReflection.arrayType(Byte.TYPE);
                }
                case 'S': {
                    return IlvReflection.arrayType(Short.TYPE);
                }
                case 'I': {
                    return IlvReflection.arrayType(Integer.TYPE);
                }
                case 'J': {
                    return IlvReflection.arrayType(Long.TYPE);
                }
                case 'F': {
                    return IlvReflection.arrayType(Float.TYPE);
                }
                case 'D': {
                    return IlvReflection.arrayType(Double.TYPE);
                }
                case 'L': {
                    if (!string.endsWith(";")) break;
                    Class clazz2 = IlvClassLoaderUtil.forName(clazz, string.substring(2, string.length() - 1));
                    return Array.newInstance(clazz2, 0).getClass();
                }
            }
        }
        return e.forNameImpl(clazz, string);
    }

    public static URL getResource(Class clazz, String string) {
        return e.getResourceImpl(clazz, string);
    }

    public static InputStream getResourceAsStream(Class clazz, String string) {
        return e.getResourceAsStreamImpl(clazz, string);
    }

    static ResourceBundle b(String string, Locale locale) {
        return e.a(string, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassLoader getClassLoaderInstance() {
        if (g) return f;
        Class<IlvClassLoaderUtil> clazz = IlvClassLoaderUtil.class;
        synchronized (IlvClassLoaderUtil.class) {
            if (g) return f;
            try {
                f = new OurClassLoader();
            }
            catch (SecurityException securityException) {
                f = IlvClassLoaderUtil.class.getClassLoader();
            }
            g = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return f;
        }
    }

    static {
        e = d = new IlvClassLoaderUtil();
    }

    private static class OurClassLoader
    extends ClassLoader {
        private OurClassLoader() {
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            return e.forNameImpl(IlvClassLoaderUtil.class, string);
        }

        @Override
        protected URL findResource(String string) {
            return e.getResourceImpl(IlvClassLoaderUtil.class, string);
        }

        @Override
        public URL getResource(String string) {
            return e.getResourceImpl(IlvClassLoaderUtil.class, string);
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            return e.getResourceAsStreamImpl(IlvClassLoaderUtil.class, string);
        }
    }
}

