/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.builder.docview;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.event.ApplicationEvent;
import ilog.views.appframe.event.ApplicationListener;
import ilog.views.symbology.builder.docview.IlvSymbolDesignerDocument;
import ilog.views.symbology.editor.IlvSymbolEditorDocument;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;

public class IlvPseudoClassSelectorChooser
extends JMenuBar
implements ItemListener,
ApplicationListener {
    private IlvApplication a;
    private JMenu b;
    private JCheckBoxMenuItem[][] c;
    private boolean d = true;

    public IlvPseudoClassSelectorChooser(IlvApplication ilvApplication) {
        this.a = ilvApplication;
        this.a.addApplicationListener(this);
        this.a();
    }

    private void a() {
        ResourceBundle resourceBundle = IlvResourceUtil.getBundle("ilog.views.symbology.builder.symboldesigner", IlvLocaleUtil.getCurrentLocale());
        this.b = new JMenu(resourceBundle.getString("PseudoClassSelectorChooser.Conditions"));
        Dimension dimension = this.b.getPreferredSize();
        dimension.height = Math.max(dimension.height, 24);
        this.b.setPreferredSize(dimension);
        this.add(this.b);
        this.c = new JCheckBoxMenuItem[2][];
        this.c[0] = new JCheckBoxMenuItem[3];
        this.c[1] = new JCheckBoxMenuItem[2];
        resourceBundle = IlvResourceUtil.getBundle("ilog.views.builder.docview.selector.SelectorEditor", IlvLocaleUtil.getCurrentLocale());
        this.c[0][0] = new JCheckBoxMenuItem(resourceBundle.getString("low-detail-level"));
        this.c[0][0].setActionCommand("low-detail-level");
        this.c[0][1] = new JCheckBoxMenuItem(resourceBundle.getString("medium-detail-level"));
        this.c[0][1].setActionCommand("medium-detail-level");
        this.c[0][2] = new JCheckBoxMenuItem(resourceBundle.getString("high-detail-level"));
        this.c[0][2].setActionCommand("high-detail-level");
        this.c[1][0] = new JCheckBoxMenuItem(resourceBundle.getString("normal-contrast"));
        this.c[1][0].setActionCommand("normal-contrast");
        this.c[1][1] = new JCheckBoxMenuItem(resourceBundle.getString("high-contrast"));
        this.c[1][1].setActionCommand("high-contrast");
        for (int i = 0; i < this.c.length; ++i) {
            if (i > 0) {
                this.b.add(new JSeparator());
            }
            for (int j = 0; j < this.c[i].length; ++j) {
                this.c[i][j].addItemListener(this);
                this.b.add(this.c[i][j]);
            }
        }
        this.d = false;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.d) {
            return;
        }
        IlvSymbolEditorDocument ilvSymbolEditorDocument = this.getSymbolDocument();
        if (ilvSymbolEditorDocument == null) {
            this.updateState();
            return;
        }
        AbstractButton abstractButton = (AbstractButton)itemEvent.getSource();
        String string = abstractButton.getActionCommand();
        if (abstractButton.isSelected()) {
            if (string.contains("-detail")) {
                ilvSymbolEditorDocument.setLevelOfDetailMode(string);
            }
            if (string.contains("-contrast")) {
                ilvSymbolEditorDocument.setContrastMode(string);
            }
        } else {
            if (string.contains("-detail")) {
                ilvSymbolEditorDocument.setLevelOfDetailMode(null);
            }
            if (string.contains("-contrast")) {
                ilvSymbolEditorDocument.setContrastMode(null);
            }
        }
        this.updateState();
    }

    public void updateState() {
        if (this.c == null) {
            return;
        }
        this.d = true;
        try {
            for (int i = 0; i < this.c.length; ++i) {
                for (int j = 0; j < this.c[i].length; ++j) {
                    this.c[i][j].setSelected(false);
                }
            }
            IlvSymbolEditorDocument ilvSymbolEditorDocument = this.getSymbolDocument();
            if (ilvSymbolEditorDocument == null) {
                return;
            }
            if ("low-detail-level".equals(ilvSymbolEditorDocument.getLevelOfDetailMode())) {
                this.c[0][0].setSelected(true);
            }
            if ("medium-detail-level".equals(ilvSymbolEditorDocument.getLevelOfDetailMode())) {
                this.c[0][1].setSelected(true);
            }
            if ("high-detail-level".equals(ilvSymbolEditorDocument.getLevelOfDetailMode())) {
                this.c[0][2].setSelected(true);
            }
            if ("normal-contrast".equals(ilvSymbolEditorDocument.getContrastMode())) {
                this.c[1][0].setSelected(true);
            }
            if ("high-contrast".equals(ilvSymbolEditorDocument.getContrastMode())) {
                this.c[1][1].setSelected(true);
            }
        }
        finally {
            this.d = false;
        }
    }

    @Override
    public void applicationEventReceived(ApplicationEvent applicationEvent) {
        this.setEnabled(this.getSymbolDocument() != null);
        if (this.b != null) {
            this.b.setEnabled(this.getSymbolDocument() != null);
        }
        this.updateState();
    }

    public IlvSymbolEditorDocument getSymbolDocument() {
        IlvDocument ilvDocument = this.a.getActiveDocument(true);
        if (ilvDocument instanceof IlvSymbolDesignerDocument) {
            return ((IlvSymbolDesignerDocument)ilvDocument).getEditorDocument();
        }
        return null;
    }
}

