/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.svg;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.io.IlvReadFileException;
import ilog.views.svg.SVGHREFProperty;
import ilog.views.svg.SVGStreamFactory;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;

public class SVGHREFObjectInteractor
extends IlvObjectInteractor {
    private static ManagerFactory a = null;

    public static void SetManagerFactory(ManagerFactory managerFactory) {
        a = managerFactory;
    }

    public static ManagerFactory GetManagerFactory() {
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processEvent(IlvGraphic ilvGraphic, AWTEvent aWTEvent, IlvObjectInteractorContext ilvObjectInteractorContext) {
        if (aWTEvent.getID() == 502) {
            SVGHREFProperty sVGHREFProperty = (SVGHREFProperty)ilvGraphic.getNamedProperty("__SVGHREF");
            if (sVGHREFProperty == null) {
                if (ilvGraphic instanceof IlvGraphicSet) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
                    IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
                    IlvTransformer ilvTransformer = ilvObjectInteractorContext.getTransformer();
                    if (ilvTransformer != null) {
                        ilvTransformer.inverse(ilvPoint2);
                    }
                    if ((ilvGraphic = SVGHREFObjectInteractor.a((IlvGraphicSet)ilvGraphic, ilvPoint2, ilvPoint, ilvTransformer)) == null) {
                        return false;
                    }
                    return this.processEvent(ilvGraphic, aWTEvent, ilvObjectInteractorContext);
                }
                return false;
            }
            IlvManager ilvManager = null;
            if (sVGHREFProperty.getShowAttribute().equals("new")) {
                if (a == null) {
                    return false;
                }
                ilvManager = a.newManagerInstance();
            } else {
                IlvManagerView ilvManagerView = (IlvManagerView)ilvObjectInteractorContext;
                ilvManager = ilvManagerView.getManager();
                ilvManagerView.setTransformer(new IlvTransformer());
            }
            ilvManager.deleteAll(false);
            ilvManager.setStreamFactory(new SVGStreamFactory());
            try {
                ilvManager.read(sVGHREFProperty.getHREFAttribute());
            }
            catch (IlvReadFileException ilvReadFileException) {
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                ilvManager.reDraw();
            }
            return true;
        }
        return false;
    }

    private static IlvGraphic a(IlvGraphicSet ilvGraphicSet, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        int n = ilvGraphicSet.getCardinal();
        for (int i = n - 1; i >= 0; --i) {
            IlvGraphic ilvGraphic = ilvGraphicSet.getObject(i);
            if (!ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
            return ilvGraphic;
        }
        return null;
    }

    public static interface ManagerFactory {
        public IlvManager newManagerInstance();
    }
}

