/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.servlet.internal;

import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.servlet.internal.IlvServletUtil;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class IlvManagerServletUtil
extends IlvServletUtil {
    public static IlvRect getTileBBoxParameter(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView, IlvRect ilvRect) throws ServletException {
        IlvRect ilvRect2 = new IlvRect();
        String string = httpServletRequest.getParameter("tile");
        if (string == null) {
            String string2 = IlvResourceUtil.getCurrentLocaleString(IlvManagerServletUtil.class, "noBBox");
            throw new ServletException(string2);
        }
        String string3 = IlvResourceUtil.getCurrentLocaleString(IlvManagerServletUtil.class, "badTitle");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ServletException(string3 + " " + string);
        }
        String string4 = stringTokenizer.nextToken();
        float f = Float.parseFloat(string4);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ServletException(string3 + " " + string);
        }
        string4 = stringTokenizer.nextToken();
        int n = Integer.parseInt(string4);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ServletException(string3 + " " + string);
        }
        string4 = stringTokenizer.nextToken();
        int n2 = Integer.parseInt(string4);
        ilvRect2 = new IlvRect(ilvRect.x + (float)n * f, ilvRect.y + (float)n2 * f, f, f);
        return ilvRect2;
    }

    public static IlvRect getBBoxParameter(HttpServletRequest httpServletRequest) throws ServletException {
        return IlvManagerServletUtil.getBBoxParameter(httpServletRequest, "bbox");
    }

    public static IlvRect getBBoxParameter(HttpServletRequest httpServletRequest, String string) throws ServletException {
        IlvRect ilvRect = new IlvRect();
        String string2 = IlvServletUtil.getStringParameter(httpServletRequest, string);
        String string3 = IlvResourceUtil.getCurrentLocaleString(IlvManagerServletUtil.class, "badBbox");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
        try {
            if (!stringTokenizer.hasMoreTokens()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = " ";
                throw new ServletException(MessageFormat.format(string3, objectArray) + string2);
            }
            String string4 = stringTokenizer.nextToken();
            ilvRect.x = Float.parseFloat(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "y";
                throw new ServletException(MessageFormat.format(string3, objectArray));
            }
            string4 = stringTokenizer.nextToken();
            ilvRect.y = Float.parseFloat(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "w";
                throw new ServletException(MessageFormat.format(string3, objectArray));
            }
            string4 = stringTokenizer.nextToken();
            ilvRect.width = Float.parseFloat(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "h";
                throw new ServletException(MessageFormat.format(string3, objectArray));
            }
            string4 = stringTokenizer.nextToken();
            ilvRect.height = Float.parseFloat(string4);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[1];
            objectArray[0] = " ";
            throw new ServletException(MessageFormat.format(string3, objectArray) + string2, (Throwable)numberFormatException);
        }
        return ilvRect;
    }

    public static IlvTransformer getTransformer(IlvRect ilvRect, int n, int n2) {
        IlvTransformer ilvTransformer = new IlvTransformer();
        IlvTransformer.computeTransformer(ilvRect, new IlvRect(0.0f, 0.0f, n, n2), ilvTransformer);
        if (Double.isInfinite(ilvTransformer.zoomFactor())) {
            return new IlvTransformer();
        }
        return ilvTransformer;
    }

    private static Color a(String string) throws NumberFormatException {
        Color color = null;
        if (string != null) {
            string.trim();
            int n = Integer.decode(string);
            color = new Color(n);
        }
        if (color != null) {
            return color;
        }
        throw new NumberFormatException("bad color " + string);
    }

    public static Color getOptionalColorParameter(HttpServletRequest httpServletRequest, String string, Color color) throws ServletException {
        String string2 = httpServletRequest.getParameter(string);
        if (string2 == null || string2.length() == 0) {
            return color;
        }
        try {
            return IlvManagerServletUtil.a(string2);
        }
        catch (Exception exception) {
            String string3 = IlvResourceUtil.getCurrentLocaleString(IlvManagerServletUtil.class, "badColor");
            throw new ServletException(MessageFormat.format(string3, string) + ": " + string2, (Throwable)exception);
        }
    }

    public static String[] getLayerParameter(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("layer");
        if (string == null) {
            return new String[0];
        }
        string = IlvServletUtil.unescape(string);
        ArrayList<String> arrayList = new ArrayList<String>(2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void setVisibleLayers(IlvManagerView ilvManagerView, String[] stringArray, IlvManagerLayer[] ilvManagerLayerArray) {
        int n;
        Vector<IlvManagerLayer> vector = new Vector<IlvManagerLayer>(ilvManagerLayerArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = IlvServletUtil.unescape(stringArray[i]);
            IlvManagerLayer ilvManagerLayer = null;
            for (int j = 0; j < ilvManagerLayerArray.length; ++j) {
                if (ilvManagerLayerArray[j].getName() == null || !ilvManagerLayerArray[j].getName().equals(string)) continue;
                ilvManagerLayer = ilvManagerLayerArray[j];
                break;
            }
            String string2 = IlvResourceUtil.getCurrentLocaleString(IlvManagerServletUtil.class, "badLayer");
            if (ilvManagerLayer == null) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 >= 0 && n2 < ilvManagerLayerArray.length) {
                        ilvManagerLayer = ilvManagerLayerArray[n2];
                    }
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(string2 + " " + string);
                }
            }
            if (ilvManagerLayer == null) {
                throw new IllegalArgumentException(string2 + " " + string);
            }
            vector.addElement(ilvManagerLayer);
        }
        Object[] objectArray = new IlvManagerLayer[vector.size()];
        vector.copyInto(objectArray);
        for (n = 0; n < ilvManagerLayerArray.length; ++n) {
            ilvManagerView.getManager().setVisible(ilvManagerView, ilvManagerLayerArray[n].getIndex(), false, false);
        }
        for (n = 0; n < objectArray.length; ++n) {
            ilvManagerView.getManager().setVisible(ilvManagerView, ((IlvManagerLayer)objectArray[n]).getIndex(), true, false);
        }
    }
}

