/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.prototypes;

import ilog.views.prototypes.ColorToNumberFilter;
import ilog.views.prototypes.ColorToStringFilter;
import ilog.views.prototypes.FontToStringFilter;
import ilog.views.prototypes.IlvValueException;
import ilog.views.prototypes.IlvValueFilter;
import ilog.views.prototypes.NumberToColorFilter;
import ilog.views.prototypes.NumberToNumberFilter;
import ilog.views.prototypes.NumberToStringFilter;
import ilog.views.prototypes.StringToColorFilter;
import ilog.views.prototypes.StringToFontFilter;
import ilog.views.prototypes.StringToNumberFilter;
import java.io.Serializable;
import java.util.Hashtable;

public class IlvValueConverter
implements Serializable {
    static Hashtable a = new Hashtable();

    private IlvValueConverter() {
    }

    public static final void registerFilter(IlvValueFilter ilvValueFilter) {
        Class[] classArray = ilvValueFilter.fromTypes();
        Class[] classArray2 = ilvValueFilter.toTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            Hashtable<Class, IlvValueFilter> hashtable = (Hashtable<Class, IlvValueFilter>)a.get(clazz);
            if (hashtable == null) {
                hashtable = new Hashtable<Class, IlvValueFilter>();
                a.put(clazz, hashtable);
            }
            for (int j = 0; j < classArray2.length; ++j) {
                hashtable.put(classArray2[j], ilvValueFilter);
            }
        }
    }

    public static final Object convert(Object object, Class clazz) throws IlvValueException {
        if (object == null) {
            throw new IlvValueException("cannot convert null value");
        }
        if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        } else if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        } else if (clazz == Character.TYPE) {
            clazz = Character.class;
        } else if (clazz == Short.TYPE) {
            clazz = Short.class;
        } else if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        } else if (clazz == Long.TYPE) {
            clazz = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz = Float.class;
        } else if (clazz == Double.TYPE) {
            clazz = Double.class;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz2 == clazz) {
            return object;
        }
        Hashtable hashtable = (Hashtable)a.get(clazz2);
        IlvValueFilter ilvValueFilter = hashtable == null ? null : (IlvValueFilter)hashtable.get(clazz);
        if (ilvValueFilter != null) {
            return ilvValueFilter.convert(object, clazz);
        }
        throw new IlvValueException("No filter registered for " + clazz2.getName() + " to " + clazz.getName());
    }

    public static final String convertToString(Object object) throws IlvValueException {
        return (String)IlvValueConverter.convert(object, String.class);
    }

    public static final int convertToInt(Object object) throws IlvValueException {
        return (Integer)IlvValueConverter.convert(object, Integer.class);
    }

    public static final long convertToLong(Object object) throws IlvValueException {
        return (Long)IlvValueConverter.convert(object, Long.class);
    }

    public static final boolean convertToBoolean(Object object) throws IlvValueException {
        return (Boolean)IlvValueConverter.convert(object, Boolean.class);
    }

    public static final float convertToFloat(Object object) throws IlvValueException {
        return ((Float)IlvValueConverter.convert(object, Float.class)).floatValue();
    }

    public static final double convertToDouble(Object object) throws IlvValueException {
        return (Double)IlvValueConverter.convert(object, Double.class);
    }

    static {
        IlvValueConverter.registerFilter(new NumberToNumberFilter());
        IlvValueConverter.registerFilter(new NumberToStringFilter());
        IlvValueConverter.registerFilter(new StringToNumberFilter());
        IlvValueConverter.registerFilter(new StringToColorFilter());
        IlvValueConverter.registerFilter(new ColorToStringFilter());
        IlvValueConverter.registerFilter(new NumberToColorFilter());
        IlvValueConverter.registerFilter(new ColorToNumberFilter());
        IlvValueConverter.registerFilter(new StringToFontFilter());
        IlvValueConverter.registerFilter(new FontToStringFilter());
    }
}

