/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.prototypes;

import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.prototypes.IlvBehavior;
import ilog.views.prototypes.IlvGroup;
import ilog.views.prototypes.IlvGroupElement;
import ilog.views.prototypes.IlvGroupException;
import ilog.views.prototypes.IlvSingleBehavior;
import ilog.views.prototypes.IlvValueConverter;
import ilog.views.prototypes.IlvValueException;
import java.io.IOException;

public class IlvScaleBehavior
extends IlvSingleBehavior {
    String a;
    String b;
    double c = 1.0;
    boolean d = false;

    public IlvScaleBehavior(String string, String string2, String string3, boolean bl) {
        super(string);
        this.a = string2;
        this.b = string3;
        this.d = bl;
    }

    public IlvScaleBehavior(IlvScaleBehavior ilvScaleBehavior) {
        super(ilvScaleBehavior);
        this.a = ilvScaleBehavior.a;
        this.b = ilvScaleBehavior.b;
        this.c = ilvScaleBehavior.c;
        this.d = ilvScaleBehavior.d;
    }

    public IlvScaleBehavior(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readString("elementName");
        this.b = ilvInputStream.readString("center");
        this.d = ilvInputStream.readBoolean("vertical");
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("elementName", this.a);
        ilvOutputStream.write("center", this.b);
        ilvOutputStream.write("vertical", this.d);
    }

    @Override
    public IlvBehavior copy() {
        return new IlvScaleBehavior(this);
    }

    @Override
    public String toString() {
        return "scale " + this.a + (this.d ? " vertically" : " horizontally");
    }

    public void setVertical(boolean bl) {
        this.d = bl;
    }

    public boolean isVertical() {
        return this.d;
    }

    @Override
    protected void set(IlvGroup ilvGroup, String string, Object object) throws IlvValueException {
        IlvGroupElement ilvGroupElement;
        float f = ((Float)this.getParameter(ilvGroup, this.b, Float.class)).floatValue();
        double d = IlvValueConverter.convertToDouble(object);
        if (d == 0.0) {
            d = 1.0;
        }
        if (d == this.c) {
            return;
        }
        double d2 = d / this.c;
        this.c = d;
        IlvTransformer ilvTransformer = !this.d ? new IlvTransformer(d2, 1.0, new IlvPoint(f, 0.0f)) : new IlvTransformer(1.0, d2, new IlvPoint(0.0f, f));
        if (this.a.equals("[all]")) {
            ilvGroupElement = ilvGroup;
        } else {
            try {
                ilvGroupElement = ilvGroup.findElement(this.a);
            }
            catch (IlvGroupException ilvGroupException) {
                throw new IlvValueException(ilvGroupException.getMessage());
            }
        }
        ilvGroupElement.applyTransform(ilvTransformer);
    }

    @Override
    protected Object get(IlvGroup ilvGroup, String string) throws IlvValueException {
        return new Double(this.c);
    }

    public void setElementName(String string) {
        this.a = string;
    }

    public String getElementName() {
        return this.a;
    }

    public void setCenter(String string) {
        this.b = string;
    }

    public String getCenter() {
        return this.b;
    }
}

