/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.prototypes;

import ilog.views.IlvObjectInteractorContext;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.prototypes.Expression;
import ilog.views.prototypes.GraphicTraverser;
import ilog.views.prototypes.IlvBehavior;
import ilog.views.prototypes.IlvGraphicElement;
import ilog.views.prototypes.IlvGroup;
import ilog.views.prototypes.IlvGroupElement;
import ilog.views.prototypes.IlvGroupException;
import ilog.views.prototypes.IlvInteractiveBehavior;
import ilog.views.prototypes.IlvSingleBehavior;
import ilog.views.prototypes.IlvValueConverter;
import java.awt.AWTEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;

public class IlvEventBehavior
extends IlvSingleBehavior
implements IlvInteractiveBehavior {
    String a;
    int b;
    String c;
    String d;
    IlvGroup e;

    public IlvEventBehavior(String string, String string2, int n, String string3, String string4) {
        super(string);
        this.a = string2;
        this.b = n;
        this.c = string3;
        this.d = string4;
    }

    public IlvEventBehavior(IlvEventBehavior ilvEventBehavior) {
        super(ilvEventBehavior);
        this.a = ilvEventBehavior.a;
        this.b = ilvEventBehavior.b;
        this.c = ilvEventBehavior.c;
        this.d = ilvEventBehavior.d;
    }

    public IlvEventBehavior(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readString("elementName");
        this.b = ilvInputStream.readInt("eventID");
        this.c = ilvInputStream.readString("filterExpression");
        this.d = ilvInputStream.readString("dataExpression");
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("elementName", this.a);
        ilvOutputStream.write("eventID", this.b);
        ilvOutputStream.write("filterExpression", this.c);
        ilvOutputStream.write("dataExpression", this.d);
    }

    @Override
    public IlvBehavior copy() {
        return new IlvEventBehavior(this);
    }

    @Override
    public String toString() {
        String string = "events";
        switch (this.b) {
            case 401: {
                string = "KEY_PRESSED";
                break;
            }
            case 402: {
                string = "KEY_RELEASED";
                break;
            }
            case 501: {
                string = "MOUSE_PRESSED";
                break;
            }
            case 502: {
                string = "MOUSE_RELEASED";
                break;
            }
            case 506: {
                string = "MOUSE_DRAGGED";
                break;
            }
            case 503: {
                string = "MOUSE_MOVED";
                break;
            }
            case 500: {
                string = "MOUSE_CLICKED";
            }
        }
        return "on " + string + " in " + this.a;
    }

    @Override
    protected void attach(IlvGroup ilvGroup) {
        this.e = ilvGroup;
        this.c();
    }

    private void c() {
        if (this.e != null) {
            try {
                IlvGroupElement ilvGroupElement = this.e.findElement(this.a);
                ilvGroupElement.traverse(new GraphicTraverser(){

                    @Override
                    public boolean traverse(IlvGraphicElement ilvGraphicElement) {
                        ilvGraphicElement.setInteractor("ilog.views.prototypes.IlvGroupInteractor");
                        return true;
                    }
                });
            }
            catch (IlvGroupException ilvGroupException) {
                // empty catch block
            }
        }
    }

    public void setElementName(String string) {
        this.a = string;
        this.c();
    }

    public String getElementName() {
        return this.a;
    }

    public void setEventID(int n) {
        this.b = n;
    }

    public int getEventID() {
        return this.b;
    }

    public void setFilterExpression(String string) {
        this.c = string;
    }

    public String getFilterExpression() {
        return this.c;
    }

    public void setDataExpression(String string) {
        this.d = string;
    }

    public String getDataExpression() {
        return this.d;
    }

    @Override
    public boolean processEvent(IlvGroup ilvGroup, IlvGraphicElement ilvGraphicElement, AWTEvent aWTEvent, IlvObjectInteractorContext ilvObjectInteractorContext) {
        block11: {
            if (!(aWTEvent instanceof InputEvent)) {
                return false;
            }
            try {
                Object object;
                Serializable serializable;
                IlvGroupElement ilvGroupElement = ilvGroup.findElement(this.a);
                boolean bl = false;
                for (serializable = ilvGraphicElement; serializable != null; serializable = ((IlvGroupElement)serializable).getParent()) {
                    if (serializable != ilvGroupElement) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
                serializable = (InputEvent)aWTEvent;
                if (this.b != 0) {
                    if (((AWTEvent)serializable).getID() != this.b) break block11;
                }
                Expression.setGlobalVariable("eventID", new Integer(((AWTEvent)serializable).getID()));
                Expression.setGlobalVariable("button1Down", new Boolean((((InputEvent)serializable).getModifiers() & 0x10) != 0));
                Expression.setGlobalVariable("button2Down", new Boolean((((InputEvent)serializable).getModifiers() & 8) != 0));
                Expression.setGlobalVariable("button3Down", new Boolean((((InputEvent)serializable).getModifiers() & 4) != 0));
                Expression.setGlobalVariable("altDown", new Boolean(((InputEvent)serializable).isAltDown()));
                Expression.setGlobalVariable("controlDown", new Boolean(((InputEvent)serializable).isControlDown()));
                Expression.setGlobalVariable("metaDown", new Boolean(((InputEvent)serializable).isMetaDown()));
                Expression.setGlobalVariable("shiftDown", new Boolean(((InputEvent)serializable).isShiftDown()));
                if (serializable instanceof MouseEvent) {
                    Expression.setGlobalVariable("eventX", new Integer(((MouseEvent)serializable).getX()));
                    Expression.setGlobalVariable("eventY", new Integer(((MouseEvent)serializable).getY()));
                    Expression.setGlobalVariable("clickCount", new Integer(((MouseEvent)serializable).getClickCount()));
                } else if (serializable instanceof KeyEvent) {
                    Expression.setGlobalVariable("eventKey", KeyEvent.getKeyText(((KeyEvent)serializable).getKeyCode()));
                }
                Expression.setGlobalVariable("eventModifiers", new Integer(((InputEvent)serializable).getModifiers()));
                if (!(this.c.equals("") || (object = this.getParameter(ilvGroup, this.c, null)) != null && IlvValueConverter.convertToBoolean(object))) {
                    return false;
                }
                object = !this.d.equals("") ? this.getParameter(ilvGroup, this.d, null) : new Integer(0);
                ilvGroup.set(this.getName(), object);
                return true;
            }
            catch (Exception exception) {
                IlvGroup.a("Exception while processing event: " + exception.getMessage());
            }
        }
        return false;
    }

    static {
        Expression.setGlobalVariable("KEY_PRESSED", new Integer(401));
        Expression.setGlobalVariable("KEY_RELEASED", new Integer(402));
        Expression.setGlobalVariable("KEY_TYPED", new Integer(400));
        Expression.setGlobalVariable("MOUSE_CLICKED", new Integer(500));
        Expression.setGlobalVariable("MOUSE_DRAGGED", new Integer(506));
        Expression.setGlobalVariable("MOUSE_MOVED", new Integer(503));
        Expression.setGlobalVariable("MOUSE_PRESSED", new Integer(501));
        Expression.setGlobalVariable("MOUSE_RELEASED", new Integer(502));
        Expression.setGlobalVariable("eventID", new Integer(0));
        Expression.setGlobalVariable("button1Down", Boolean.FALSE);
        Expression.setGlobalVariable("button2Down", Boolean.FALSE);
        Expression.setGlobalVariable("button3Down", Boolean.FALSE);
        Expression.setGlobalVariable("altDown", Boolean.FALSE);
        Expression.setGlobalVariable("altGraphDown", Boolean.FALSE);
        Expression.setGlobalVariable("controlDown", Boolean.FALSE);
        Expression.setGlobalVariable("metaDown", Boolean.FALSE);
        Expression.setGlobalVariable("shiftDown", Boolean.FALSE);
        Expression.setGlobalVariable("eventX", new Integer(0));
        Expression.setGlobalVariable("eventY", new Integer(0));
        Expression.setGlobalVariable("clickCount", new Integer(0));
        Expression.setGlobalVariable("eventKey", "");
        Expression.setGlobalVariable("eventModifiers", new Integer(0));
    }
}

