/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.print;

import ilog.views.IlvRect;
import ilog.views.print.BoundedNumberField;
import ilog.views.print.FloatNumberField;
import ilog.views.print.IlvManagerPrintableDocument;
import ilog.views.print.IlvMessagesSupport;
import ilog.views.util.IlvImageUtil;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

class IlvManagerPageEditor
extends JPanel {
    private IlvManagerPrintableDocument a;
    private final IlvMessagesSupport b;
    private BoundedNumberField c;
    private BoundedNumberField d;
    private JRadioButton e;
    private JRadioButton f;
    private Icon g;
    private Icon h;
    private JLabel i;
    private JRadioButton j;
    private JRadioButton k;
    private FloatNumberField l;
    private JCheckBox m;
    private JPanel n;
    private JPanel o;
    private FloatNumberField p;
    private FloatNumberField q;
    private FloatNumberField r;
    private FloatNumberField s;

    public IlvManagerPageEditor(IlvManagerPrintableDocument ilvManagerPrintableDocument, IlvMessagesSupport ilvMessagesSupport) {
        this.a = ilvManagerPrintableDocument;
        this.b = ilvMessagesSupport;
        this.a();
    }

    private Icon a(String string) {
        try {
            Image image = IlvImageUtil.getImageFromFile(this.getClass(), "resources/" + string);
            return new ImageIcon(image);
        }
        catch (Exception exception) {
            Logger.getLogger("ilog.views.print").log(Level.INFO, "Cannot load " + string, exception);
            return null;
        }
    }

    private String b(String string) {
        return this.b.getMessage("IlvManagerPageEditor." + string);
    }

    private char c(String string) {
        return this.b.getMnemonic("IlvManagerPageEditor." + string);
    }

    private void a() {
        this.b();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
        jPanel.setBorder(new TitledBorder(this.b("Area")));
        this.p = new FloatNumberField(4);
        this.s = new FloatNumberField(4);
        this.q = new FloatNumberField(4);
        this.r = new FloatNumberField(4);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                IlvManagerPageEditor.this.k.setSelected(true);
            }
        };
        this.p.addFocusListener(focusAdapter);
        this.s.addFocusListener(focusAdapter);
        this.q.addFocusListener(focusAdapter);
        this.r.addFocusListener(focusAdapter);
        JLabel jLabel = new JLabel(this.b("Left"));
        jLabel.setDisplayedMnemonic(this.c("Left"));
        jLabel.setLabelFor(this.p);
        JLabel jLabel2 = new JLabel(this.b("Right"));
        jLabel2.setDisplayedMnemonic(this.c("Right"));
        jLabel2.setLabelFor(this.q);
        JLabel jLabel3 = new JLabel(this.b("Top"));
        jLabel3.setDisplayedMnemonic(this.c("Top"));
        jLabel3.setLabelFor(this.s);
        JLabel jLabel4 = new JLabel(this.b("Bottom"));
        jLabel4.setDisplayedMnemonic(this.c("Bottom"));
        jLabel4.setLabelFor(this.r);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.j = new JRadioButton(this.b("All"));
        this.j.setMnemonic(this.c("All"));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                IlvManagerPageEditor.this.setPrintAreaImpl(IlvManagerPageEditor.this.a.getTotalManagerPrintableArea());
            }
        };
        this.j.addItemListener(itemListener);
        this.k = new JRadioButton("");
        buttonGroup.add(this.j);
        buttonGroup.add(this.k);
        jPanel.add(this.j);
        jPanel.add(this.k);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.p, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.s, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = -1;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)this.q, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        jPanel3.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)this.r, gridBagConstraints);
        jPanel.add(jPanel3);
        this.o = new JPanel(new GridBagLayout());
        this.o.setBorder(new TitledBorder(this.b("Scaling")));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        JLabel jLabel5 = new JLabel(this.b("FitToRowsColumns"));
        JLabel jLabel6 = new JLabel(this.b("NumColumns"));
        jLabel6.setDisplayedMnemonic(this.c("NumColumns"));
        this.c = new BoundedNumberField(3, 1, 100);
        jLabel6.setLabelFor(this.c);
        JLabel jLabel7 = new JLabel(this.b("NumRows"));
        jLabel7.setDisplayedMnemonic(this.c("NumRows"));
        this.d = new BoundedNumberField(3, 1, 100);
        jLabel7.setLabelFor(this.d);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridwidth = 0;
        jPanel4.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        jPanel4.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel4.add((Component)this.c, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        jPanel4.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel4.add((Component)this.d, gridBagConstraints);
        this.n = new JPanel(new FlowLayout(3, 5, 5));
        JLabel jLabel8 = new JLabel(this.b("PrintAt"));
        jLabel8.setDisplayedMnemonic(this.c("PrintAt"));
        this.n.add(jLabel8);
        this.l = new FloatNumberField(4);
        this.n.add(this.l);
        this.n.add(new JLabel(this.b("PercentOfSize")));
        jLabel8.setLabelFor(this.l);
        this.l.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                IlvManagerPageEditor.this.checkZoomLevel();
            }
        });
        this.m = new JCheckBox(this.b("AutomaticZoomLevel"));
        this.m.setMnemonic(this.c("AutomaticZoomLevel"));
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvManagerPageEditor.this.d();
            }
        });
        gridBagConstraints.gridwidth = 0;
        this.o.add((Component)jPanel4, gridBagConstraints);
        if (this.a.isZoomLevelModificationEnabled()) {
            this.o.add((Component)this.n, gridBagConstraints);
            this.o.add((Component)this.m, gridBagConstraints);
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new TitledBorder(this.b("PageOrder")));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.f = new JRadioButton(this.b("OverThenDown"));
        this.f.setMnemonic(this.c("OverThenDown"));
        this.e = new JRadioButton(this.b("DownThenOver"));
        this.e.setMnemonic(this.c("DownThenOver"));
        buttonGroup2.add(this.f);
        buttonGroup2.add(this.e);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.add((Component)this.e, gridBagConstraints);
        jPanel6.add((Component)this.f, gridBagConstraints);
        this.i = new JLabel(this.a.getPageOrder() == 1 ? this.g : this.h);
        jPanel5.add(jPanel6);
        jPanel5.add(this.i);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = -1;
        ItemListener itemListener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                IlvManagerPageEditor.this.c();
            }
        };
        this.f.addItemListener(itemListener2);
        this.e.addItemListener(itemListener2);
        this.add((Component)jPanel, gridBagConstraints);
        this.add((Component)this.o, gridBagConstraints);
        this.add((Component)jPanel5, gridBagConstraints);
        this.setPrintArea(this.a.getPrintArea(), this.a.isPrintingAllManagerBBox());
        this.setPageOrder(this.a.getPageOrder());
        this.setColumnCount(this.a.d());
        this.setRowCount(this.a.e());
        this.setZoomLevel(this.a.getZoomLevel());
        this.setAutomaticZoomLevel(this.a.isAutomaticZoomLevel());
    }

    private void b() {
        String string = this.getComponentOrientation().isLeftToRight() ? "" : "_rtl";
        this.g = this.a("overdown" + string + ".gif");
        this.h = this.a("downover" + string + ".gif");
    }

    private void c() {
        this.i.setIcon(this.f.isSelected() ? this.g : this.h);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        this.b();
        this.c();
    }

    private static Window a(Component component) {
        if (component instanceof Window || component == null) {
            return (Window)component;
        }
        return IlvManagerPageEditor.a(component.getParent());
    }

    public void setZoomLevelModificationEnabled(boolean bl) {
        if (bl) {
            if (this.n.getParent() == null) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(2, 5, 2, 5);
                gridBagConstraints.gridwidth = 0;
                this.o.add((Component)this.n, gridBagConstraints);
                if (this.m.getParent() == null) {
                    this.o.add((Component)this.m, gridBagConstraints);
                }
                IlvManagerPageEditor.a(this.n).pack();
            }
        } else if (this.n.getParent() != null) {
            this.o.remove(this.n);
            if (this.m.getParent() != null) {
                this.o.remove(this.m);
            }
            IlvManagerPageEditor.a(this.o).pack();
        }
    }

    public void setPrintAreaImpl(IlvRect ilvRect) {
        this.p.setValue(ilvRect.x);
        this.s.setValue(ilvRect.y);
        this.q.setValue(ilvRect.x + ilvRect.width);
        this.r.setValue(ilvRect.y + ilvRect.height);
    }

    public void setPrintArea(IlvRect ilvRect, boolean bl) {
        if (bl) {
            this.j.setSelected(true);
        } else {
            this.k.setSelected(true);
        }
        this.setPrintAreaImpl(ilvRect);
    }

    public void checkZoomLevel() {
        double d;
        try {
            d = (double)this.l.getValue() / 100.0;
            if (d <= 0.0) {
                d = this.a.getZoomLevel();
            }
            if (d > this.a.getMaximumZoomLevel()) {
                d = this.a.getMaximumZoomLevel();
            }
            if (d < this.a.getMinimumZoomLevel()) {
                d = this.a.getMinimumZoomLevel();
            }
        }
        catch (ParseException parseException) {
            d = this.a.getZoomLevel();
        }
        this.setZoomLevel(d);
    }

    public double getZoomLevel() {
        if (this.a.isZoomLevelModificationEnabled()) {
            try {
                float f = this.l.getValue() / 100.0f;
                if (f <= 0.0f) {
                    return this.a.getZoomLevel();
                }
                return f;
            }
            catch (ParseException parseException) {
                return this.a.getZoomLevel();
            }
        }
        return this.a.getZoomLevel();
    }

    public void setZoomLevel(double d) {
        this.l.setValue((float)(d * 100.0));
        this.l.setCaretPosition(0);
    }

    public boolean isAutomaticZoomLevel() {
        if (this.a.isZoomLevelModificationEnabled()) {
            return this.m.isSelected();
        }
        return this.a.isAutomaticZoomLevel();
    }

    public void setAutomaticZoomLevel(boolean bl) {
        this.m.setSelected(bl);
        this.d();
    }

    private void d() {
        if (this.isAutomaticZoomLevel()) {
            this.n.setEnabled(false);
            for (int i = 0; i < this.n.getComponentCount(); ++i) {
                JComponent jComponent = (JComponent)this.n.getComponent(i);
                jComponent.setEnabled(false);
            }
        } else {
            this.n.setEnabled(true);
            for (int i = 0; i < this.n.getComponentCount(); ++i) {
                JComponent jComponent = (JComponent)this.n.getComponent(i);
                jComponent.setEnabled(true);
            }
        }
    }

    public void setPageOrder(int n) {
        this.f.setSelected(n == 1);
        this.e.setSelected(n == 0);
        this.c();
    }

    public boolean checkPrintArea() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = true;
        if (this.j.isSelected()) {
            return true;
        }
        try {
            f = this.p.getValue();
            f2 = this.s.getValue();
            f3 = this.q.getValue() - f;
            f4 = this.r.getValue() - f2;
        }
        catch (ParseException parseException) {
            bl = false;
        }
        if (bl && f3 < 0.0f || f4 < 0.0f) {
            bl = false;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this, this.b("PrintAreaBadlySpecified"), this.b("Error"), 2);
        }
        return bl;
    }

    public IlvRect getPrintArea() {
        if (this.j.isSelected()) {
            return null;
        }
        IlvRect ilvRect = new IlvRect();
        try {
            ilvRect.x = this.p.getValue();
            ilvRect.y = this.s.getValue();
            ilvRect.width = this.q.getValue() - ilvRect.x;
            ilvRect.height = this.r.getValue() - ilvRect.y;
        }
        catch (ParseException parseException) {
            return this.a.getPrintArea();
        }
        if (ilvRect.width < 0.0f || ilvRect.height < 0.0f) {
            return this.a.getPrintArea();
        }
        return ilvRect;
    }

    public int getPageOrder() {
        if (this.e.isSelected()) {
            return 0;
        }
        return 1;
    }

    public void setColumnCount(int n) {
        if (n != 0) {
            this.c.setText(Integer.toString(n));
        } else {
            this.c.setText("");
        }
    }

    public int getColumnCount() {
        int n;
        try {
            n = Integer.parseInt(this.c.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public void setRowCount(int n) {
        if (n != 0) {
            this.d.setText(Integer.toString(n));
        } else {
            this.d.setText("");
        }
    }

    public int getRowCount() {
        int n;
        try {
            n = Integer.parseInt(this.d.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public void setDocument(IlvManagerPrintableDocument ilvManagerPrintableDocument) {
        this.a = ilvManagerPrintableDocument;
        this.setPageOrder(this.a.getPageOrder());
        this.setColumnCount(this.a.d());
        this.setRowCount(this.a.e());
        this.setPrintArea(this.a.getPrintArea(), this.a.isPrintingAllManagerBBox());
        this.setZoomLevel(this.a.getZoomLevel());
        this.setZoomLevelModificationEnabled(this.a.isZoomLevelModificationEnabled());
    }

    public void writeBackToDocument(IlvManagerPrintableDocument ilvManagerPrintableDocument) {
        if (this.getColumnCount() != -1 || this.getRowCount() != -1) {
            ilvManagerPrintableDocument.setColumnCount(this.getColumnCount());
            ilvManagerPrintableDocument.setRowCount(this.getRowCount());
        }
        ilvManagerPrintableDocument.setPageOrder(this.getPageOrder());
        ilvManagerPrintableDocument.setPrintArea(this.getPrintArea());
        if (ilvManagerPrintableDocument.isZoomLevelModificationEnabled()) {
            ilvManagerPrintableDocument.setAutomaticZoomLevel(this.isAutomaticZoomLevel());
            ilvManagerPrintableDocument.setZoomLevel(this.getZoomLevel());
        }
    }
}

