/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.io;

import com.ibm.icu.util.ULocale;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.AsciiDataWriter;
import ilog.views.io.BinaryDataWriter;
import ilog.views.io.DataWriter;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.TypedArrayWriter;
import ilog.views.util.java2d.IlvPattern;
import ilog.views.util.java2d.IlvTexture;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Locale;

public class IlvOutputStream {
    static final float a = 1.0f;
    private boolean b = false;
    private DataOutputStream c;
    private DataWriter d;
    private TypedArrayWriter e;
    boolean f = false;
    private IlvManager g;

    public IlvOutputStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public IlvOutputStream(OutputStream outputStream, boolean bl) {
        this.c = new DataOutputStream(new BufferedOutputStream(outputStream, 1024));
        this.b = bl;
        this.d = this.b ? new BinaryDataWriter(this, this.c) : new AsciiDataWriter(this, this.c);
        this.e = new TypedArrayWriter(this.d);
    }

    public final void setBinary() {
        if (!this.b) {
            this.b = true;
            this.d = new BinaryDataWriter(this, this.c);
            this.e = new TypedArrayWriter(this.d);
        }
    }

    public final boolean getBinary() {
        return this.b;
    }

    public void write(IlvManager ilvManager, boolean bl) throws IOException {
        this.f = bl;
        this.g = ilvManager;
        this.d.b(this.f);
        this.d.a(ilvManager);
        this.d.b(ilvManager);
        this.writeExtensions(this.f);
    }

    public void write(IlvManager ilvManager) throws IOException {
        this.write(ilvManager, false);
    }

    public final IlvManager getManager() {
        return this.g;
    }

    public void write(IlvManagerLayer[] ilvManagerLayerArray, boolean bl) throws IOException {
        this.d.a(ilvManagerLayerArray, bl);
    }

    public final void write(String string, boolean bl) throws IOException {
        this.d.a(string);
        this.d.a(bl);
        this.d.d();
    }

    public final void write(String string, boolean[] blArray) throws IOException {
        this.d.a(string);
        this.d.a(blArray);
        this.d.d();
    }

    public final void write(String string, short s) throws IOException {
        this.d.a(string);
        this.d.a(s);
        this.d.d();
    }

    public final void write(String string, short[] sArray) throws IOException {
        this.d.a(string);
        this.d.a(sArray);
        this.d.d();
    }

    public final void write(String string, int n) throws IOException {
        this.d.a(string);
        this.d.a(n);
        this.d.d();
    }

    public final void write(String string, int[] nArray) throws IOException {
        this.d.a(string);
        this.d.a(nArray);
        this.d.d();
    }

    public final void write(String string, long l) throws IOException {
        this.d.a(string);
        this.d.a(l);
        this.d.d();
    }

    public final void write(String string, long[] lArray) throws IOException {
        this.d.a(string);
        this.d.a(lArray);
        this.d.d();
    }

    public final void write(String string, float f) throws IOException {
        this.d.a(string);
        this.d.a(f);
        this.d.d();
    }

    public final void write(String string, float[] fArray) throws IOException {
        this.d.a(string);
        this.d.a(fArray);
        this.d.d();
    }

    public final void write(String string, double d) throws IOException {
        this.d.a(string);
        this.d.a(d);
        this.d.d();
    }

    public final void write(String string, double[] dArray) throws IOException {
        this.d.a(string);
        this.d.a(dArray);
        this.d.d();
    }

    public final void write(String string, String string2) throws IOException {
        this.d.a(string);
        this.d.b(string2);
        this.d.d();
    }

    public final void write(String string, String[] stringArray) throws IOException {
        this.d.a(string);
        this.d.a(stringArray);
        this.d.d();
    }

    public final void write(String string, IlvRect ilvRect) throws IOException {
        this.d.a(string);
        this.d.a(ilvRect);
        this.d.d();
    }

    public final void write(String string, IlvRect[] ilvRectArray) throws IOException {
        this.d.a(string);
        this.d.a(ilvRectArray);
        this.d.d();
    }

    public final void write(String string, IlvPoint ilvPoint) throws IOException {
        this.d.a(string);
        this.d.a(ilvPoint);
        this.d.d();
    }

    public final void write(String string, IlvPoint[] ilvPointArray) throws IOException {
        this.d.a(string);
        this.d.a(ilvPointArray);
        this.d.d();
    }

    public final void write(String string, IlvTransformer ilvTransformer) throws IOException {
        this.d.a(string);
        this.d.a(ilvTransformer);
        this.d.d();
    }

    public final void write(String string, IlvTransformer[] ilvTransformerArray) throws IOException {
        this.d.a(string);
        this.d.a(ilvTransformerArray);
        this.d.d();
    }

    public final void write(String string, Font font) throws IOException {
        this.d.a(string);
        this.d.a(font);
        this.d.d();
    }

    public final void write(String string, Font[] fontArray) throws IOException {
        this.d.a(string);
        this.d.a(fontArray);
        this.d.d();
    }

    public final void write(String string, Color color) throws IOException {
        this.d.a(string);
        this.d.a(color);
        this.d.d();
    }

    public final void write(String string, Color[] colorArray) throws IOException {
        this.d.a(string);
        this.d.a(colorArray);
        this.d.d();
    }

    public final void write(String string, String string2, Shape shape) throws IOException {
        this.a(shape, string);
        this.b(shape, string2);
    }

    public final void write(String string, GradientPaint gradientPaint) throws IOException {
        this.d.a(string);
        this.d.a(gradientPaint);
        this.d.d();
    }

    public final void writeGradient(String string, GradientPaint gradientPaint) throws IOException {
        this.write(string, gradientPaint);
    }

    public final void write(String string, IlvPattern ilvPattern) throws IOException {
        this.d.a(string);
        this.d.a(ilvPattern);
        this.d.d();
    }

    public final void writePattern(String string, IlvPattern ilvPattern) throws IOException {
        this.write(string, ilvPattern);
    }

    public final void write(String string, IlvTexture ilvTexture) throws IOException {
        this.d.a(string);
        this.d.a(ilvTexture);
        this.d.d();
    }

    public final void writeTexture(String string, IlvTexture ilvTexture) throws IOException {
        this.write(string, ilvTexture);
    }

    public final void write(String string, Paint paint, Color color) throws IOException {
        IlvUtility2D.writePaint(this, paint, string, string, color);
    }

    public final void write(String string, BasicStroke basicStroke) throws IOException {
        this.d.a(string);
        this.d.a(basicStroke);
        this.d.d();
    }

    public final void writeStroke(String string, BasicStroke basicStroke) throws IOException {
        this.d.a(string);
        this.d.a(basicStroke);
        this.d.d();
    }

    public final void write(String string, ComponentOrientation componentOrientation) throws IOException {
        this.d.a(string);
        String string2 = componentOrientation == null ? "null" : (componentOrientation == ComponentOrientation.UNKNOWN ? "U" : (componentOrientation.isLeftToRight() ? "LTR" : "RTL"));
        this.d.b(string2);
        this.d.d();
    }

    public final void write(String string, Locale locale) throws IOException {
        this.d.a(string);
        String string2 = locale == null ? "null" : locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
        this.d.b(string2);
        this.d.d();
    }

    public final void write(String string, ULocale uLocale) throws IOException {
        this.d.a(string);
        String string2 = uLocale == null ? "null" : uLocale.getName();
        this.d.b(string2);
        this.d.d();
    }

    public final void write(String string, IlvPersistentObject ilvPersistentObject) throws IOException {
        this.d.a(string);
        this.d.a(ilvPersistentObject, false);
        this.d.d();
    }

    public final void write(String string, IlvPersistentObject[] ilvPersistentObjectArray) throws IOException {
        this.d.a(string);
        this.d.a(ilvPersistentObjectArray);
    }

    public final void write(String string, IlvPersistentObject[] ilvPersistentObjectArray, int n, int n2) throws IOException {
        this.d.a(string);
        this.d.a(ilvPersistentObjectArray, n, n2);
        this.d.d();
    }

    public final void write(String string, Enumeration enumeration) throws IOException {
        this.d.a(string);
        this.d.a(enumeration);
        this.d.d();
    }

    public final void write(String string, IlvGraphic ilvGraphic) throws IOException {
        this.d.a(string);
        this.write(ilvGraphic);
        this.d.d();
    }

    public final void write(String string, IlvGraphic[] ilvGraphicArray) throws IOException {
        this.d.a(string);
        this.d.a(ilvGraphicArray);
        this.d.d();
    }

    public final void write(String string, IlvGraphic[] ilvGraphicArray, int n, int n2) throws IOException {
        this.d.a(string);
        this.d.a(ilvGraphicArray, n, n2);
        this.d.d();
    }

    public final void write(String string, IlvGraphicEnumeration ilvGraphicEnumeration) throws IOException {
        this.write(string, ilvGraphicEnumeration, false);
    }

    public final void write(String string, IlvGraphicEnumeration ilvGraphicEnumeration, boolean bl) throws IOException {
        this.d.a(string);
        if (bl) {
            this.d.a(this.filterObjects(ilvGraphicEnumeration, this.f));
        } else {
            this.d.a(ilvGraphicEnumeration);
        }
        this.d.d();
    }

    public final void write(String string, Object[] objectArray, String string2) throws IOException {
        this.d.a(string);
        this.e.a(objectArray, string2);
        this.d.d();
    }

    public final void flush() throws IOException {
        this.c.flush();
    }

    protected void writeExtensions(boolean bl) throws IOException {
    }

    protected void write(IlvGraphic ilvGraphic) throws IOException {
        this.d.a(ilvGraphic);
    }

    protected IlvGraphicEnumeration filterObjects(IlvGraphicEnumeration ilvGraphicEnumeration, boolean bl) {
        return ilvGraphicEnumeration;
    }

    void a(Shape shape, String string) throws IOException {
        this.write(string, IlvOutputStream.a(shape));
    }

    void b(Shape shape, String string) throws IOException {
        int n = shape.getPathIterator(null).getWindingRule();
        if (n == 1) {
            this.write(string, "nonzero");
        } else {
            this.write(string, "evenodd");
        }
    }

    void a(GradientPaint gradientPaint) throws IOException {
        this.write("color1", gradientPaint.getColor1());
        this.write("color2", gradientPaint.getColor2());
        Point2D point2D = gradientPaint.getPoint1();
        this.write("point1", new IlvPoint((float)point2D.getX(), (float)point2D.getY()));
        point2D = gradientPaint.getPoint2();
        this.write("point2", new IlvPoint((float)point2D.getX(), (float)point2D.getY()));
        this.write("cyclic", gradientPaint.isCyclic());
    }

    void a(IlvPattern ilvPattern) throws IOException {
        this.write("fg", ilvPattern.getForeground());
        if (ilvPattern.getBackground() != null) {
            this.write("bg", ilvPattern.getBackground());
        }
        this.write("type", ilvPattern.getType());
    }

    void a(IlvTexture ilvTexture) throws IOException {
        block3: {
            Rectangle2D rectangle2D;
            block2: {
                this.write("url", ilvTexture.getImageURL().toString());
                rectangle2D = ilvTexture.getAnchorRect();
                BufferedImage bufferedImage = ilvTexture.getImage();
                if (rectangle2D.getX() != 0.0 || rectangle2D.getY() != 0.0 || rectangle2D.getWidth() != (double)bufferedImage.getWidth()) break block2;
                if (rectangle2D.getHeight() == (double)bufferedImage.getHeight()) break block3;
            }
            this.write("anchor", new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight()));
        }
    }

    void a(BasicStroke basicStroke) throws IOException {
        if (basicStroke.getLineWidth() != 1.0f) {
            this.write("lineWidth", basicStroke.getLineWidth());
        }
        if (basicStroke.getEndCap() != 2) {
            this.write("endCap", basicStroke.getEndCap() == 0 ? "Butt" : "Round");
        }
        if (basicStroke.getLineJoin() != 0) {
            this.write("lineJoin", basicStroke.getLineJoin() == 2 ? "Bevel" : "Round");
        }
        if (basicStroke.getDashArray() != null) {
            this.write("dashArray", basicStroke.getDashArray());
        }
        if (basicStroke.getDashPhase() != 0.0f) {
            this.write("dashPhase", basicStroke.getDashPhase());
        }
        if (basicStroke.getMiterLimit() != 10.0f) {
            this.write("miterLimit", basicStroke.getMiterLimit());
        }
    }

    private static String a(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        StringBuffer stringBuffer = new StringBuffer();
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 4: {
                    stringBuffer.append("z");
                    break;
                }
                case 3: {
                    stringBuffer.append("C");
                    stringBuffer.append(fArray[0]);
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[1]);
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[2]);
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[3]);
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[4]);
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[5]);
                    break;
                }
                case 1: {
                    stringBuffer.append("L");
                    stringBuffer.append(fArray[0]);
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[1]);
                    break;
                }
                case 0: {
                    stringBuffer.append("M");
                    stringBuffer.append(fArray[0]);
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[1]);
                    break;
                }
                case 2: {
                    stringBuffer.append("Q");
                    stringBuffer.append(fArray[0]);
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[1]);
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[2]);
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[3]);
                }
            }
            pathIterator.next();
        }
        return stringBuffer.toString();
    }

    void a(IlvGraphic ilvGraphic) throws IOException {
        IlvManager ilvManager;
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (ilvGraphicBag instanceof IlvManager) {
            ilvManager = (IlvManager)ilvGraphicBag;
            if (!ilvManager.objectIsSelectable(ilvGraphic)) {
                this.write("selectable", false);
            }
            if (!ilvManager.isMovable(ilvGraphic)) {
                this.write("moveable", false);
            }
            if (!ilvManager.isEditable(ilvGraphic)) {
                this.write("editable", false);
            }
            if (ilvGraphic.getObjectInteractor() != null) {
                this.write("interactor", ilvGraphic.getObjectInteractor().getClass().getName());
            }
        }
        if (ilvGraphicBag instanceof IlvGrapher) {
            ilvManager = (IlvGrapher)ilvGraphicBag;
            if (((IlvGrapher)ilvManager).isNode(ilvGraphic)) {
                this.write("gnode", true);
                IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
                if (ilvLinkConnector != null && ilvLinkConnector.isPersistent()) {
                    this.write("linkConnector", ilvLinkConnector);
                }
            }
            if (((IlvGrapher)ilvManager).isLink(ilvGraphic)) {
                this.write("glink", true);
            }
        }
    }
}

