/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.internal;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.awt.IlvScrollManagerView;
import ilog.views.graphic.composite.IlvCompositeLink;
import ilog.views.graphic.linkbundle.IlvLinkBundle;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.internal.impl.IlvEmptyGraphicEnumeration;
import ilog.views.swing.IlvJScrollManagerView;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.Adjustable;
import java.awt.Graphics;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.PrintStream;
import java.io.Serializable;

public final class IlvUtility {
    public static final float NEAR_ZERO_FLOAT = 1.0E-20f;
    public static final String ClipProperty = "__ClipProperty";
    public static IlvSwingUtil.Version JDK14 = new IlvSwingUtil.Version(1, 4, 0);

    private IlvUtility() {
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.err;
        String string = "Rogue Wave JViews Component Suite Version " + IlvUtil.GetVersion() + "." + IlvUtil.GetMinorVersion();
        if (IlvUtil.GetSubMinorVersion() != 0) {
            string = string + "." + IlvUtil.GetSubMinorVersion();
        }
        if (IlvUtil.GetPatchLevel() != 0) {
            string = string + " Patch Level " + IlvUtil.GetPatchLevel();
        }
        printStream.println(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Package[] packageArray;
                if (!"-packageinfo".equals(stringArray[i]) || (packageArray = Package.getPackages()) == null) continue;
                for (int j = 0; j < packageArray.length; ++j) {
                    IlvUtility.a(packageArray[j], "ilog.views", printStream);
                }
            }
        }
    }

    private static void a(Package package_, String string, PrintStream printStream) {
        if (package_ != null && (string == null || package_.getName().equals(string))) {
            printStream.println("Name: " + package_.getName());
            printStream.println("Specification-Title: " + package_.getSpecificationTitle());
            printStream.println("Specification-Version: " + package_.getSpecificationVersion());
            printStream.println("Specification-Vendor: " + package_.getSpecificationVendor());
            printStream.println("Implementation-Title: " + package_.getImplementationTitle());
            printStream.println("Implementation-Version: " + package_.getImplementationVersion());
            printStream.println("Implementation-Vendor: " + package_.getImplementationVendor());
        }
    }

    public static boolean IntersectHorizontal(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
        return IlvUtility.IntersectHorizontal(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, ilvPoint3.x, ilvPoint3.y);
    }

    public static boolean IntersectHorizontal(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d6 - d4) * (d3 - d) + (d2 - d4) * (d5 - d3);
        if (d6 > d4) {
            return d2 >= d4 && d2 < d6 && d7 >= 0.0;
        }
        return d2 >= d6 && d2 < d4 && d7 < 0.0;
    }

    public static void retractPointsForArrowHead(IlvLinkImage ilvLinkImage, IlvPoint[] ilvPointArray, float f, IlvTransformer ilvTransformer) {
        int n = ilvPointArray.length;
        if (n <= 1) {
            return;
        }
        if (f == -1.0f) {
            f = IlvStrokeInfo.zoomedLineWidth(ilvLinkImage.getLineWidth(), ilvLinkImage.getMaximumLineWidth(), ilvTransformer, false);
        }
        if (f <= 1.0f) {
            return;
        }
        if (!ilvLinkImage.isOriented()) {
            return;
        }
        float f2 = IlvGraphicUtil.GetArrowSize(ilvLinkImage, f, ilvTransformer);
        if (f2 <= 4.0f) {
            return;
        }
        int n2 = ilvLinkImage.getEndCap();
        double d = ilvPointArray[n - 1].x - ilvPointArray[n - 2].x;
        double d2 = ilvPointArray[n - 1].y - ilvPointArray[n - 2].y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if ((double)(2.0f * f2) > d3) {
            f2 = (float)d3 / 2.0f;
        }
        double d4 = n2 != 0 ? 2.0 * (double)f2 : 1.5 * (double)f2;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d3 > d4) {
            d5 = -d4 * d2 / d3;
            d6 = d4 * d / d3;
        }
        ilvPointArray[n - 1].x += (float)(-d6);
        ilvPointArray[n - 1].y += (float)d5;
    }

    public static IlvGraphic getRealVisibleObject(IlvGraphicBag ilvGraphicBag, IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag2 = ilvGraphic.getGraphicBag();
        IlvGraphic ilvGraphic2 = ilvGraphic;
        while (ilvGraphicBag2 != null && ilvGraphicBag2 != ilvGraphicBag) {
            IlvManager ilvManager = (IlvManager)ilvGraphicBag2;
            if (ilvManager.isCollapsed()) {
                ilvGraphic2 = ilvManager;
            }
            ilvGraphicBag2 = ilvManager.getGraphicBag();
        }
        return ilvGraphic2;
    }

    public static float arrowSize(float f, IlvTransformer ilvTransformer) {
        double d;
        double d2 = d = ilvTransformer == null ? 1.0 : ilvTransformer.zoomFactor();
        if (f == 0.0f) {
            if (d >= 1.0) {
                return 4.0f;
            }
            return (float)(4.0 * d);
        }
        if (f <= 1.0f) {
            if ((double)f * d >= 1.0) {
                return (float)(3.25 + (double)(0.75f * f) * d);
            }
            return (float)((double)(4.0f * f) * d);
        }
        if (d <= 1.0) {
            return (float)((double)(0.75f * f + 3.25f) * d);
        }
        return (float)(3.25 + (double)(0.75f * f) * d);
    }

    public static void ComputeArrow(float f, float f2, float f3, float f4, float f5, IlvPoint[] ilvPointArray, float f6) {
        double d = f3 - f;
        double d2 = f4 - f2;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = 0.0;
        double d5 = 0.0;
        if (d3 >= (double)1.0E-20f) {
            d4 = d / d3;
            d5 = d2 / d3;
        }
        double d6 = 2.0f * f6;
        d6 = Math.min(d6, (double)f5 * d3);
        double d7 = (double)f6 * d5;
        double d8 = (double)f6 * d4;
        double d9 = (double)f3 - d6 * d4;
        double d10 = (double)f4 - d6 * d5;
        ilvPointArray[0].move(f3, f4);
        ilvPointArray[1].move((float)(d9 + d7), (float)(d10 - d8));
        ilvPointArray[2].move((float)(d9 - d7), (float)(d10 + d8));
        if (f5 != 1.0f) {
            float f7 = (float)((double)(f5 - 1.0f) * d);
            float f8 = (float)((double)(f5 - 1.0f) * d2);
            ilvPointArray[0].translate(f7, f8);
            ilvPointArray[1].translate(f7, f8);
            ilvPointArray[2].translate(f7, f8);
        }
    }

    public static void drawArrow(Graphics graphics, float f, float f2, float f3, float f4, float f5, float f6) {
        IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint(), new IlvPoint()};
        IlvUtility.ComputeArrow(f, f2, f3, f4, f5, ilvPointArray, f6);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = (int)Math.floor(ilvPointArray[0].x);
        nArray[1] = Math.round(ilvPointArray[1].x);
        nArray[2] = Math.round(ilvPointArray[2].x);
        nArray2[0] = (int)Math.floor(ilvPointArray[0].y);
        nArray2[1] = Math.round(ilvPointArray[1].y);
        nArray2[2] = Math.round(ilvPointArray[2].y);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    public static AffineTransform IlvToJava2DTransformer(IlvTransformer ilvTransformer, AffineTransform affineTransform) {
        if (affineTransform == null) {
            affineTransform = new AffineTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
        } else {
            affineTransform.setTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
        }
        return affineTransform;
    }

    public static IlvRect Java2DToIlvRect(Rectangle2D rectangle2D, IlvRect ilvRect) {
        if (ilvRect == null) {
            ilvRect = new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        } else {
            ilvRect.setRect(rectangle2D);
        }
        return ilvRect;
    }

    public static void scrollByBlock(Adjustable adjustable, int n) {
        int n2 = adjustable.getValue();
        int n3 = adjustable.getBlockIncrement();
        int n4 = n3 * (n > 0 ? 1 : -1);
        adjustable.setValue(n2 + n4);
    }

    public static void scrollByUnits(Adjustable adjustable, int n, int n2) {
        int n3 = n2;
        n3 = n > 0 ? (n3 *= adjustable.getUnitIncrement()) : (n3 *= -adjustable.getUnitIncrement());
        int n4 = adjustable.getValue();
        int n5 = n4 + n3;
        if (n3 > 0 && n5 < n4) {
            n5 = adjustable.getMaximum();
        } else if (n3 < 0 && n5 > n4) {
            n5 = adjustable.getMinimum();
        }
        adjustable.setValue(n5);
    }

    public static boolean isOutside(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag;
        for (ilvGraphicBag = ilvGraphic.getGraphicBag(); ilvGraphicBag != ilvGrapher && ilvGraphicBag != null; ilvGraphicBag = ilvGraphicBag.getGraphicBag()) {
        }
        return ilvGraphicBag == null;
    }

    public static void correctMoveResizeNonzoomableGraphic(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl, boolean bl2) {
        IlvRect ilvRect2 = ilvGraphic.boundingBox(null);
        float f = 0.0f;
        if (bl) {
            f = Math.max(f, Math.abs(ilvRect2.x - ilvRect.x));
            f = Math.max(f, Math.abs(ilvRect2.x + ilvRect2.width - ilvRect.x - ilvRect.width));
            f = Math.max(f, Math.abs(ilvRect2.width - ilvRect.width));
            ilvRect2.x = ilvRect.x;
            ilvRect2.width = ilvRect.width;
        }
        if (bl2) {
            f = Math.max(f, Math.abs(ilvRect2.y - ilvRect.y));
            f = Math.max(f, Math.abs(ilvRect2.y + ilvRect2.height - ilvRect.y - ilvRect.height));
            f = Math.max(f, Math.abs(ilvRect2.height - ilvRect.height));
            ilvRect2.y = ilvRect.y;
            ilvRect2.height = ilvRect.height;
        }
        if (f > 0.5f) {
            IlvUtility.a(ilvGraphic, ilvRect2);
        }
    }

    private static void a(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        IlvRect ilvRect2 = new IlvRect(ilvRect);
        IlvUtility.adjustToAvoidZeroSize(ilvRect2);
        IlvRect ilvRect3 = ilvGraphic.boundingBox(null);
        if (ilvRect3.equals(ilvRect2)) {
            return;
        }
        IlvUtility.adjustToAvoidZeroSize(ilvRect3);
        Cloneable cloneable = new IlvTransformer();
        IlvTransformer.computeTransformer(ilvRect3, ilvRect2, (IlvTransformer)cloneable);
        if (((IlvTransformer)cloneable).isBad()) {
            return;
        }
        ilvGraphic.applyTransform((IlvTransformer)cloneable);
        Cloneable cloneable2 = ilvRect3;
        double d = Math.abs(((IlvTransformer)cloneable).getx11());
        double d2 = Math.abs(((IlvTransformer)cloneable).getx22());
        for (int i = 1; i < 4; ++i) {
            double d3;
            cloneable = ilvGraphic.boundingBox(null);
            if (((Rectangle2D)cloneable).equals(ilvRect2)) {
                return;
            }
            IlvUtility.adjustToAvoidZeroSize((IlvRect)cloneable);
            double d4 = ilvRect2.width - ((Rectangle2D.Float)cloneable).width;
            double d5 = ((Rectangle2D.Float)cloneable).width - cloneable2.width;
            if (d5 != 0.0) {
                d3 = d4 / d5 * ((d - 1.0) / d) + 1.0;
                if (d3 < 0.1) {
                    d3 = 0.1;
                } else if (d3 > 10.0) {
                    d3 = 10.0;
                }
            } else {
                d3 = 1.0;
            }
            d5 = ilvRect2.height - ((Rectangle2D.Float)cloneable).height;
            double d6 = ((Rectangle2D.Float)cloneable).height - cloneable2.height;
            if (d6 != 0.0) {
                d4 = d5 / d6 * ((d2 - 1.0) / d2) + 1.0;
                if (d4 < 0.1) {
                    d4 = 0.1;
                } else if (d4 > 10.0) {
                    d4 = 10.0;
                }
            } else {
                d4 = 1.0;
            }
            d5 = ilvRect2.getCenterX() - d3 * ((RectangularShape)cloneable).getCenterX();
            d6 = ilvRect2.getCenterY() - d4 * ((RectangularShape)cloneable).getCenterY();
            IlvTransformer ilvTransformer = new IlvTransformer(d3, 0.0, 0.0, d4, d5, d6);
            ilvGraphic.applyTransform(ilvTransformer);
            cloneable2 = cloneable;
            d = d3;
            d2 = d4;
        }
    }

    public static void adjustToAvoidZeroSize(IlvRect ilvRect) {
        if (ilvRect.width < 0.1f) {
            ilvRect.width = 0.1f;
        }
        if (ilvRect.height < 0.1f) {
            ilvRect.height = 0.1f;
        }
    }

    public static IlvTransformer getTransformerFromTo(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        while (ilvGraphic.getGraphicBag() instanceof IlvLinkBundle || ilvGraphic.getGraphicBag() instanceof IlvCompositeLink) {
            ilvGraphic = (IlvGraphic)((Object)ilvGraphic.getGraphicBag());
        }
        while (ilvGraphic2.getGraphicBag() instanceof IlvLinkBundle || ilvGraphic2.getGraphicBag() instanceof IlvCompositeLink) {
            ilvGraphic2 = (IlvGraphic)((Object)ilvGraphic2.getGraphicBag());
        }
        IlvManager ilvManager = (IlvManager)ilvGraphic.getGraphicBag();
        IlvManager ilvManager2 = (IlvManager)ilvGraphic2.getGraphicBag();
        return IlvUtility.getManagerTransformerFromTo(ilvManager, ilvManager2);
    }

    public static IlvTransformer getTransformerFromTo(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer, IlvGraphic ilvGraphic2) {
        IlvTransformer ilvTransformer2 = IlvUtility.getTransformerFromTo(ilvGraphic2, ilvGraphic);
        if (ilvTransformer2 == null) {
            ilvTransformer2 = ilvTransformer;
        } else if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        return ilvTransformer2;
    }

    public static IlvTransformer getManagerTransformerFromTo(IlvManager ilvManager, IlvTransformer ilvTransformer, IlvManager ilvManager2) {
        IlvTransformer ilvTransformer2 = IlvUtility.getManagerTransformerFromTo(ilvManager2, ilvManager);
        if (ilvTransformer2 == null) {
            ilvTransformer2 = ilvTransformer;
        } else if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        return ilvTransformer2;
    }

    public static IlvTransformer getManagerTransformerFromTo(IlvManager ilvManager, IlvManager ilvManager2) {
        if (ilvManager == null || ilvManager2 == null || ilvManager == ilvManager2) {
            return null;
        }
        IlvTransformer ilvTransformer = ilvManager.getTopLevelTransformer();
        IlvTransformer ilvTransformer2 = ilvManager2.getTopLevelTransformer();
        IlvTransformer ilvTransformer3 = new IlvTransformer();
        ilvTransformer2.computeInverse(ilvTransformer3);
        ilvTransformer.compose(ilvTransformer3);
        return ilvTransformer;
    }

    public static IlvGraphicEnumeration getObjectsImpl(IlvGraphicBag ilvGraphicBag, final IlvGraphic ilvGraphic) {
        if (ilvGraphic == null || ilvGraphic.getGraphicBag() != ilvGraphicBag) {
            return IlvEmptyGraphicEnumeration.instance;
        }
        return new IlvGraphicEnumeration(){
            IlvGraphic a;
            {
                this.a = ilvGraphic;
            }

            @Override
            public boolean hasMoreElements() {
                return this.a != null;
            }

            @Override
            public IlvGraphic nextElement() {
                IlvGraphic ilvGraphic2 = this.a;
                this.a = null;
                return ilvGraphic2;
            }
        };
    }

    public static IlvGraphicEnumeration getObjectsImpl(IlvGraphicBag ilvGraphicBag, IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        int n = 0;
        IlvGraphic ilvGraphic3 = null;
        IlvGraphic ilvGraphic4 = null;
        if (ilvGraphic != null && ilvGraphic.getGraphicBag() == ilvGraphicBag) {
            ++n;
            ilvGraphic3 = ilvGraphic;
        }
        if (ilvGraphic2 != null && ilvGraphic2.getGraphicBag() == ilvGraphicBag) {
            ++n;
            ilvGraphic4 = ilvGraphic2;
        }
        final int n2 = n;
        final IlvGraphic ilvGraphic5 = ilvGraphic3;
        final IlvGraphic ilvGraphic6 = ilvGraphic4;
        return new IlvGraphicEnumeration(){
            int a = 0;

            @Override
            public boolean hasMoreElements() {
                return this.a < n2;
            }

            @Override
            public IlvGraphic nextElement() {
                ++this.a;
                if (this.a == 1 && ilvGraphic5 != null) {
                    return ilvGraphic5;
                }
                return ilvGraphic6;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyToObjectImplForGraphic(IlvGraphic ilvGraphic, final IlvGraphic ilvGraphic2, final IlvApplyObject ilvApplyObject, Object object, boolean bl) {
        boolean bl2 = ilvGraphic2.setInApplyToObject(true);
        try {
            if (bl2 && ilvGraphic.getGraphicBag() != null) {
                ilvGraphic.getGraphicBag().applyToObject(ilvGraphic, new IlvApplyObject(){

                    @Override
                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        ilvApplyObject.apply(ilvGraphic2, object);
                    }
                }, object, bl);
            } else {
                ilvApplyObject.apply(ilvGraphic2, object);
                if (bl) {
                    ((IlvGraphicBag)((Object)ilvGraphic)).reDrawObj(ilvGraphic2);
                }
            }
        }
        finally {
            ilvGraphic2.setInApplyToObject(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyToObjectImplForBag(IlvGraphicBag ilvGraphicBag, IlvGraphic ilvGraphic, IlvApplyObject ilvApplyObject, Object object, boolean bl) {
        boolean bl2 = ilvGraphic.setInApplyToObject(true);
        try {
            ilvApplyObject.apply(ilvGraphic, object);
            if (bl) {
                ilvGraphicBag.reDrawObj(ilvGraphic);
            }
        }
        finally {
            ilvGraphic.setInApplyToObject(false);
        }
    }

    public static void reshapeObjectImplForGraphic(IlvGraphic ilvGraphic, final IlvGraphic ilvGraphic2, IlvRect ilvRect, boolean bl) {
        if (ilvGraphic.getGraphicBag() != null) {
            ilvGraphic.getGraphicBag().applyToObject(ilvGraphic, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ilvGraphic2.moveResize((IlvRect)object);
                }
            }, ilvRect, bl);
        } else {
            ilvGraphic2.moveResize(ilvRect);
            if (bl) {
                ((IlvGraphicBag)((Object)ilvGraphic)).reDrawObj(ilvGraphic2);
            }
        }
    }

    public static void moveObjectImplForGraphic(IlvGraphic ilvGraphic, final IlvGraphic ilvGraphic2, final float f, final float f2, boolean bl) {
        if (ilvGraphic.getGraphicBag() != null) {
            ilvGraphic.getGraphicBag().applyToObject(ilvGraphic, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ilvGraphic2.move(f, f2);
                }
            }, null, bl);
        } else {
            ilvGraphic2.move(f, f2);
            if (bl) {
                ((IlvGraphicBag)((Object)ilvGraphic)).reDrawObj(ilvGraphic2);
            }
        }
    }

    public static class MouseWheelAdapter
    implements MouseWheelListener,
    Serializable {
        private IlvJScrollManagerView a;
        private IlvScrollManagerView b;

        public MouseWheelAdapter(IlvJScrollManagerView ilvJScrollManagerView) {
            this.a = ilvJScrollManagerView;
        }

        public MouseWheelAdapter(IlvScrollManagerView ilvScrollManagerView) {
            this.b = ilvScrollManagerView;
        }

        public Adjustable getVerticalScrollBar() {
            if (this.a != null) {
                return this.a.getVerticalScrollBar();
            }
            return this.b.getVerticalAdjustable();
        }

        public boolean isVerticalScrollBarVisible() {
            if (this.a != null) {
                return this.a.isVerticalScrollBarVisible();
            }
            return this.b.isVerticalScrollbarVisible();
        }

        public Adjustable getHorizontalScrollBar() {
            if (this.a != null) {
                return this.a.getHorizontalScrollBar();
            }
            return this.b.getHorizontalAdjustable();
        }

        public boolean isHorizontalScrollBarVisible() {
            if (this.a != null) {
                return this.a.isHorizontalScrollBarVisible();
            }
            return this.b.isHorizontalScrollbarVisible();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.getScrollAmount() != 0) {
                int n;
                Adjustable adjustable = this.getVerticalScrollBar();
                if (!(adjustable != null && adjustable.getVisibleAmount() != adjustable.getMaximum() && this.isVerticalScrollBarVisible() || (adjustable = this.getHorizontalScrollBar()) != null && this.isHorizontalScrollBarVisible())) {
                    return;
                }
                int n2 = n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
                if (mouseWheelEvent.getScrollType() == 0) {
                    IlvUtility.scrollByUnits(adjustable, n, mouseWheelEvent.getScrollAmount());
                } else if (mouseWheelEvent.getScrollType() == 1) {
                    IlvUtility.scrollByBlock(adjustable, n);
                }
            }
        }
    }
}

