/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.linkpolicy;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvIndexedSet;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerViewsChangedEvent;
import ilog.views.event.ManagerViewsChangedListener;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.event.ObjectLayerChangedEvent;
import ilog.views.event.ObjectVisibilityChangedEvent;
import ilog.views.graphic.linkpolicy.IlvAbstractCrossingGraphic;
import ilog.views.graphic.linkpolicy.IlvAbstractLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvCrossingGraphic;
import ilog.views.graphic.linkpolicy.IlvCrossingLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvLinkPoints;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import ilog.views.internal.IlvLinkBoundingBoxCache;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class IlvCrossingAwareLinkImage
extends IlvPolicyAwareLinkImage {
    private Vector a;
    private Object b;
    private float c = 2.0f;
    private boolean d = true;
    private float e;
    private IlvGraphic f;
    private int g = -1;
    private int h = 0;
    private IlvManager i;
    private int j;
    private IlvLinkBoundingBoxCache k;
    private boolean l;
    private boolean m;
    private int n;
    private static final IlvPoint[] o = new IlvPoint[3];
    private CrossingApplyDrawObject p = new CrossingApplyDrawObject();
    private CrossingApplyBBoxObject q = new CrossingApplyBBoxObject();
    private CrossingApplyContObject r = new CrossingApplyContObject();
    private static final String s;

    public IlvCrossingAwareLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, IlvPoint[] ilvPointArray) {
        super(ilvGraphic, ilvGraphic2, bl, ilvPointArray);
        this.d();
    }

    private void d() {
        this.k = new IlvLinkBoundingBoxCache(3);
        this.l = false;
        this.m = true;
        this.c = 2.0f;
        this.d = true;
        this.f = null;
    }

    public IlvCrossingAwareLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, boolean bl2, IlvPoint[] ilvPointArray) {
        super(ilvGraphic, ilvGraphic2, bl2, ilvPointArray);
        this.d();
        this.setBackOriented(bl);
    }

    public IlvCrossingAwareLinkImage(IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage) {
        super(ilvCrossingAwareLinkImage);
        this.d();
        this.setBoundingBoxCacheSize(ilvCrossingAwareLinkImage.getBoundingBoxCacheSize());
        this.g = ilvCrossingAwareLinkImage.g;
        this.m = ilvCrossingAwareLinkImage.m;
        this.l = ilvCrossingAwareLinkImage.l;
        this.c = ilvCrossingAwareLinkImage.c;
        this.d = ilvCrossingAwareLinkImage.d;
        if (ilvCrossingAwareLinkImage.f != null) {
            this.f = ilvCrossingAwareLinkImage.f.copy();
            if (this.f instanceof IlvAbstractCrossingGraphic) {
                ((IlvAbstractCrossingGraphic)this.f).setRelatedLinkImage(this);
            }
        }
    }

    public IlvCrossingAwareLinkImage(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.d();
        try {
            this.setBoundingBoxCacheSize(ilvInputStream.readInt("bboxCacheSize"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.m = ilvInputStream.readBoolean("crossingEnabled");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.l = ilvInputStream.readBoolean("backoriented");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.c = ilvInputStream.readFloat("gap");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.d = ilvInputStream.readBoolean("gapZoomable");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.f = ilvInputStream.readObject("crossingGraphics");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.g = ilvInputStream.readInt("layerOfCrossingGraphic");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public IlvGraphic copy() {
        return new IlvCrossingAwareLinkImage(this);
    }

    public void setCrossingEnabled(boolean bl) {
        boolean bl2 = this.isCrossingEnabled();
        this.m = bl;
        this.c(bl2);
    }

    void a(boolean bl) {
        if (bl) {
            this.b(true);
        }
        boolean bl2 = this.isCrossingEnabled();
        this.n = bl ? ++this.n : --this.n;
        if (this.n < 0) {
            this.n = 0;
        }
        this.c(bl2);
        if (!bl) {
            this.b(false);
        }
    }

    private void c(boolean bl) {
        boolean bl2 = this.isCrossingEnabled();
        if (bl != bl2) {
            if (bl2) {
                this.a(this.getCrossingPolicy());
            } else {
                this.b();
            }
        }
    }

    public boolean isCrossingEnabled() {
        if (this.n > 0) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        return this.m;
    }

    public void setGap(float f) {
        this.c = f;
        this.invalidateBBoxCache();
    }

    public final float getGap() {
        return this.c;
    }

    public void setGapZoomable(boolean bl) {
        this.d = bl;
        this.invalidateBBoxCache();
    }

    public final boolean isGapZoomable() {
        return this.d;
    }

    @Override
    public boolean zoomable() {
        if (!super.zoomable()) {
            return false;
        }
        return this.isGapZoomable();
    }

    public void setCrossingGraphic(IlvGraphic ilvGraphic) {
        if (this.getGraphicBag() == null) {
            this.c(ilvGraphic);
        } else {
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvCrossingAwareLinkImage.this.c((IlvGraphic)object);
                }
            }, ilvGraphic, true);
        }
    }

    private void c(IlvGraphic ilvGraphic) {
        if (ilvGraphic != null && !(ilvGraphic instanceof IlvCrossingGraphic)) {
            throw new IllegalArgumentException("The crossing graphic must implement the IlvCrossingGraphic interface");
        }
        this.d(ilvGraphic);
        this.f = ilvGraphic;
        if (ilvGraphic != null && ilvGraphic.getGraphicBag() == null && this.getLinkShapePolicy() != null) {
            this.getLinkShapePolicy().onInstall(this);
        }
    }

    public void setCrossingGraphic(IlvGraphic ilvGraphic, int n) {
        this.setLayerOfCrossingGraphic(n);
        this.setCrossingGraphic(ilvGraphic);
    }

    public final IlvGraphic getCrossingGraphic() {
        return this.f;
    }

    private void d(IlvGraphic ilvGraphic) {
        IlvManager ilvManager;
        if (this.f != null && (ilvManager = (IlvManager)this.f.getGraphicBag()) != null) {
            int n = ilvManager.getLayer(this.f);
            this.e();
            if (ilvGraphic != null && ilvGraphic.getGraphicBag() == null) {
                this.f = ilvGraphic;
                this.a(ilvManager, n);
            }
        }
    }

    private void e() {
        if (this.f == null) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.f.getGraphicBag();
        if (ilvGraphicBag == null) {
            return;
        }
        boolean bl = this.a(ilvGraphicBag, true);
        try {
            ilvGraphicBag.removeObject(this.f, true);
        }
        finally {
            this.a(ilvGraphicBag, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvManager ilvManager, int n) {
        if (ilvManager == null) {
            return;
        }
        if (this.f == null) {
            return;
        }
        if (this.f.getGraphicBag() == ilvManager) {
            this.a(n);
            return;
        }
        boolean bl = this.a((IlvGraphicBag)ilvManager, true);
        try {
            if (n < 0) {
                n = 0;
            }
            ilvManager.addObject(this.f, n, true);
            ilvManager.setMovable(this.f, false);
            ilvManager.setEditable(this.f, false);
            ilvManager.setSelectable(this.f, true);
        }
        finally {
            this.a((IlvGraphicBag)ilvManager, bl);
        }
    }

    public void setLayerOfCrossingGraphic(int n) {
        int n2 = this.g;
        this.g = n;
        if (n2 != n && this.f != null && this.getLinkShapePolicy() != null) {
            this.getLinkShapePolicy().onInstall(this);
        }
    }

    public final int getLayerOfCrossingGraphic() {
        return this.g;
    }

    private void a(int n) {
        int n2;
        IlvManager ilvManager = (IlvManager)this.f.getGraphicBag();
        if (ilvManager == null) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if ((n2 = ilvManager.getLayer(this.f)) != n) {
            ilvManager.setLayer(this.f, n, false);
        }
    }

    @Override
    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        ContentChangedListener contentChangedListener;
        IlvGraphicBag ilvGraphicBag2 = this.getGraphicBag();
        if (ilvGraphicBag != ilvGraphicBag2) {
            if (ilvGraphicBag2 != null && (contentChangedListener = ContentChangedListener.a(ilvGraphicBag2, false)) != null) {
                contentChangedListener.b();
            }
            IlvCrossingAwareLinkImage.b((IlvGraphic)this);
            this.d((IlvGraphic)null);
        }
        super.setGraphicBag(ilvGraphicBag);
        if (ilvGraphicBag != ilvGraphicBag2 && ilvGraphicBag != null && (contentChangedListener = ContentChangedListener.a(ilvGraphicBag, true)) != null) {
            contentChangedListener.a();
        }
    }

    public IlvCrossingLinkShapePolicy getCrossingPolicy() {
        IlvLinkShapePolicy ilvLinkShapePolicy = this.getLinkShapePolicy();
        while (ilvLinkShapePolicy != null && ilvLinkShapePolicy instanceof IlvAbstractLinkShapePolicy) {
            if (ilvLinkShapePolicy instanceof IlvCrossingLinkShapePolicy) {
                return (IlvCrossingLinkShapePolicy)ilvLinkShapePolicy;
            }
            ilvLinkShapePolicy = ((IlvAbstractLinkShapePolicy)ilvLinkShapePolicy).getChildPolicy();
        }
        return null;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        if (this.getBoundingBoxCacheSize() != 3) {
            ilvOutputStream.write("bboxCacheSize", this.getBoundingBoxCacheSize());
        }
        ilvOutputStream.write("crossingEnabled", this.m);
        ilvOutputStream.write("backoriented", this.isBackOriented());
        ilvOutputStream.write("gap", this.c);
        ilvOutputStream.write("gapZoomable", this.d);
        if (this.f != null) {
            ilvOutputStream.write("crossingGraphics", this.f);
        }
        if (this.g != -1) {
            ilvOutputStream.write("layerOfCrossingGraphic", this.g);
        }
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (!this.isCrossingEnabled()) {
            this.a(graphics, ilvTransformer);
        } else {
            IlvLinkPoints ilvLinkPoints = this.a(ilvTransformer);
            if (!this.b(ilvLinkPoints)) {
                this.a(graphics, ilvTransformer);
            } else {
                this.a(graphics, ilvLinkPoints, ilvTransformer);
            }
        }
    }

    private void a(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        int n = ilvPointArray.length;
        int n2 = n - 1;
        IlvPoint ilvPoint = ilvPointArray[0];
        IlvPoint ilvPoint2 = ilvPointArray[n2];
        if (n > 1) {
            graphics.setColor(this.getForeground());
            float f = this.getLineWidth();
            float[] fArray = this.getLineStyle();
            if (f == 0.0f && fArray == null) {
                this.drawPolyline(graphics, ilvPointArray, n, 0.0f, this.getLineJoin(), this.getEndCap(), null, null, false);
            } else {
                float f2;
                float f3 = this.getMaximumLineWidth();
                fArray = IlvStrokeInfo.zoomedLineStyle(fArray, f, f3, ilvTransformer);
                f = IlvStrokeInfo.zoomedLineWidth(f, f3, ilvTransformer, false);
                if (this.isOriented()) {
                    f2 = this.getArrowSize(this.a(ilvTransformer, false), ilvTransformer);
                    if (f2 > 4.0f) {
                        ilvPoint2 = new IlvPoint(ilvPointArray[n2]);
                        this.a(ilvPoint2, ilvPointArray[n2 - 1], ilvPointArray[n2], f2);
                    }
                }
                if (this.isBackOriented()) {
                    f2 = this.getBackArrowSize(this.a(ilvTransformer, false), ilvTransformer);
                    if (f2 > 4.0f) {
                        ilvPoint = new IlvPoint(ilvPointArray[0]);
                        this.a(ilvPoint, ilvPointArray[1], ilvPointArray[0], f2);
                    }
                }
                this.a(ilvPointArray[0], ilvPoint);
                this.a(ilvPointArray[n2], ilvPoint2);
                this.drawPolyline(graphics, ilvPointArray, n, f, this.getLineJoin(), this.getEndCap(), fArray, ilvTransformer, true);
                this.a(ilvPointArray[0], ilvPoint);
                this.a(ilvPointArray[n2], ilvPoint2);
            }
            this.drawArrow(graphics, ilvPointArray[n2 - 1], ilvPointArray[n2], ilvTransformer);
            this.drawBackArrow(graphics, ilvPointArray[1], ilvPointArray[0], ilvTransformer);
        }
    }

    private void a(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        if (ilvPoint == ilvPoint2) {
            return;
        }
        float f = ilvPoint.x;
        ilvPoint.x = ilvPoint2.x;
        ilvPoint2.x = f;
        f = ilvPoint.y;
        ilvPoint.y = ilvPoint2.y;
        ilvPoint2.y = f;
    }

    protected IlvPoint[] getDrawingLinkPoints(IlvTransformer ilvTransformer) {
        float f;
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        IlvPoint ilvPoint = ilvPointArray[0];
        if (this.isBackOriented()) {
            f = this.getBackArrowSize(this.a(ilvTransformer, false), ilvTransformer);
            if (f > 4.0f) {
                ilvPoint = new IlvPoint(ilvPointArray[0]);
                this.a(ilvPoint, ilvPointArray[1], ilvPointArray[0], f);
            }
        }
        if (this.isOriented()) {
            f = this.getArrowSize(this.a(ilvTransformer, false), ilvTransformer);
            if (f > 4.0f) {
                int n = ilvPointArray.length - 1;
                this.a(ilvPointArray[n], ilvPointArray[n - 1], ilvPointArray[n], f);
            }
        }
        ilvPointArray[0] = ilvPoint;
        return ilvPointArray;
    }

    private void a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, float f) {
        float f2 = ilvPoint3.x;
        double d = f2 - ilvPoint2.x;
        float f3 = ilvPoint3.y;
        double d2 = f3 - ilvPoint2.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if ((double)(2.0f * f) > d3) {
            f = (float)d3 / 2.0f;
        }
        double d4 = this.getEndCap() != 0 ? 2.0 * (double)f : 1.5 * (double)f;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d3 != 0.0) {
            d5 = -d4 * d2 / d3;
            d6 = d4 * d / d3;
        }
        ilvPoint.x += (float)(-d6);
        ilvPoint.y += (float)d5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void b(boolean bl) {
        boolean bl2 = this.a();
        if (bl) {
            ++this.h;
        } else {
            --this.h;
            if (this.h < 0) {
                this.h = 0;
            }
        }
        boolean bl3 = this.a();
        if (bl2 != bl3) {
            if (this.f == null) {
                return;
            }
            IlvManager ilvManager = (IlvManager)this.f.getGraphicBag();
            boolean bl4 = this.a((IlvGraphicBag)ilvManager, true);
            try {
                if (bl3) {
                    this.i = ilvManager;
                    this.j = -1;
                    if (ilvManager != null) {
                        this.j = ilvManager.getLayer(this.f);
                    }
                } else if (this.i != ilvManager) {
                    this.e();
                    this.a(this.i, this.j);
                } else {
                    this.a(this.j);
                }
            }
            finally {
                this.a((IlvGraphicBag)ilvManager, bl4);
            }
        }
    }

    boolean a() {
        return this.h > 0;
    }

    public final boolean hasCrossings(IlvTransformer ilvTransformer) {
        IlvLinkPoints ilvLinkPoints = this.a(ilvTransformer);
        return this.b(ilvLinkPoints);
    }

    private void a(Graphics graphics, IlvLinkPoints ilvLinkPoints, IlvTransformer ilvTransformer) {
        IlvLinkPoints.Point point;
        IlvLinkPoints.Point point2;
        double d;
        graphics.setColor(this.getForeground());
        float f = this.getLineWidth();
        float f2 = this.getMaximumLineWidth();
        float[] fArray = this.getLineStyle();
        int n = this.getLineJoin();
        int n2 = this.getEndCap();
        if (f != 0.0f) {
            f = IlvStrokeInfo.zoomedLineWidth(f, f2, ilvTransformer, false);
            fArray = IlvStrokeInfo.zoomedLineStyle(fArray, f, f2, ilvTransformer);
        }
        IlvPoint[] ilvPointArray = new IlvPoint[ilvLinkPoints.i()];
        double d2 = d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        if (d == 0.0) {
            d = 1.0;
        }
        float f3 = this.c;
        if (this.d) {
            f3 = (float)((double)f3 * d);
        }
        if (n2 != 0) {
            f3 += (float)(0.5 * (double)f * d);
        }
        IlvPoint[] ilvPointArray2 = null;
        int n3 = 0;
        if (this.isOriented() || this.isBackOriented()) {
            ilvPointArray2 = this.getDrawingLinkPoints(ilvTransformer);
            n3 = ilvPointArray2.length;
        }
        IlvPoint ilvPoint = new IlvPoint(point2.a, point2.b);
        int n4 = 0;
        this.a(point2, f, ilvTransformer);
        boolean bl = false;
        for (point2 = point = ilvLinkPoints.l(); point2 != null; point2 = point2.c()) {
            if (ilvPointArray[n4] == null) {
                ilvPointArray[n4] = new IlvPoint(point2.a, point2.b);
            } else {
                ilvPointArray[n4].move(point2.a, point2.b);
            }
            if (point2.c() == null && this.isOriented()) {
                ilvPointArray[n4].setLocation(ilvPointArray2[n3 - 1]);
            }
            if (point2.d() == null && this.isBackOriented()) {
                ilvPointArray[n4].setLocation(ilvPointArray2[0]);
                ilvPoint.setLocation(ilvPointArray2[0]);
            }
            if (!(point2 instanceof IlvLinkPoints.CrossPoint) || ++n4 <= 1) continue;
            this.a(point, ilvPointArray, 0, ilvTransformer, f3);
            boolean bl2 = this.a(point2, ilvPointArray, n4 - 1, ilvTransformer, f3);
            if (bl2 || n4 > 2) {
                if (!bl) {
                    ilvPointArray[0].setLocation(ilvPoint);
                }
                this.drawPolyline(graphics, ilvPointArray, n4, f, n, n2, fArray, ilvTransformer, true);
                ilvPoint.setLocation(ilvPointArray[n4 - 1]);
                bl = false;
            }
            bl |= ((IlvLinkPoints.CrossPoint)point2).f();
            ilvPointArray[0].move(point2.a, point2.b);
            point = point2;
            n4 = 1;
        }
        if (n4 > 1) {
            this.a(point, ilvPointArray, 0, ilvTransformer, f3);
            if (!bl) {
                ilvPointArray[0].setLocation(ilvPoint);
            }
            this.drawPolyline(graphics, ilvPointArray, n4, f, this.getLineJoin(), n2, fArray, ilvTransformer, true);
        }
        if (this.isOriented() || this.isBackOriented()) {
            ilvPointArray2 = this.getLinkPoints(ilvTransformer);
            n3 = ilvPointArray2.length;
            this.drawArrow(graphics, ilvPointArray2[n3 - 2], ilvPointArray2[n3 - 1], ilvTransformer);
            this.drawBackArrow(graphics, ilvPointArray2[1], ilvPointArray2[0], ilvTransformer);
        }
    }

    protected Shape getStrokeShape(IlvPoint[] ilvPointArray, IlvTransformer ilvTransformer) {
        if (!this.isCrossingEnabled()) {
            return this.getSimpleShape(ilvPointArray, ilvTransformer);
        }
        IlvLinkPoints ilvLinkPoints = this.a(ilvTransformer);
        if (!this.b(ilvLinkPoints)) {
            return this.getSimpleShape(ilvPointArray, ilvTransformer);
        }
        return this.a(ilvPointArray, ilvLinkPoints, ilvTransformer);
    }

    protected Shape getSimpleShape(IlvPoint[] ilvPointArray, IlvTransformer ilvTransformer) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(ilvPointArray[0].x, ilvPointArray[0].y);
        for (int i = 1; i < ilvPointArray.length; ++i) {
            generalPath.lineTo(ilvPointArray[i].x, ilvPointArray[i].y);
        }
        return generalPath;
    }

    private Shape a(IlvPoint[] ilvPointArray, IlvLinkPoints ilvLinkPoints, IlvTransformer ilvTransformer) {
        int n;
        IlvLinkPoints.Point point;
        IlvLinkPoints.Point point2;
        double d;
        GeneralPath generalPath = new GeneralPath();
        float f = this.getLineWidth();
        float f2 = this.getMaximumLineWidth();
        int n2 = this.getEndCap();
        if (f != 0.0f) {
            f = IlvStrokeInfo.zoomedLineWidth(f, f2, ilvTransformer, false);
        }
        IlvPoint[] ilvPointArray2 = new IlvPoint[ilvLinkPoints.i()];
        double d2 = d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        if (d == 0.0) {
            d = 1.0;
        }
        float f3 = this.c;
        if (this.d) {
            f3 = (float)((double)f3 * d);
        }
        if (n2 != 0) {
            f3 += (float)(0.5 * (double)f * d);
        }
        int n3 = ilvPointArray.length;
        IlvPoint ilvPoint = new IlvPoint(point2.a, point2.b);
        int n4 = 0;
        this.a(point2, f, ilvTransformer);
        boolean bl = false;
        generalPath.moveTo(ilvPoint.x, ilvPoint.y);
        for (point2 = point = ilvLinkPoints.l(); point2 != null; point2 = point2.c()) {
            if (ilvPointArray2[n4] == null) {
                ilvPointArray2[n4] = new IlvPoint(point2.a, point2.b);
            } else {
                ilvPointArray2[n4].move(point2.a, point2.b);
            }
            if (point2.c() == null && this.isOriented()) {
                ilvPointArray2[n4].setLocation(ilvPointArray[n3 - 1]);
            }
            if (point2.d() == null && this.isBackOriented()) {
                ilvPointArray2[n4].setLocation(ilvPointArray[0]);
                ilvPoint.setLocation(ilvPointArray[0]);
                generalPath.moveTo(ilvPoint.x, ilvPoint.y);
            }
            if (!(point2 instanceof IlvLinkPoints.CrossPoint) || ++n4 <= 1) continue;
            this.a(point, ilvPointArray2, 0, ilvTransformer, f3);
            n = this.a(point2, ilvPointArray2, n4 - 1, ilvTransformer, f3) ? 1 : 0;
            if (n != 0 || n4 > 2) {
                if (!bl) {
                    ilvPointArray2[0].setLocation(ilvPoint);
                }
                if (!ilvPointArray2[0].equals(ilvPoint)) {
                    generalPath.moveTo(ilvPointArray2[0].x, ilvPointArray2[0].y);
                }
                for (int i = 1; i < n4; ++i) {
                    generalPath.lineTo(ilvPointArray2[i].x, ilvPointArray2[i].y);
                }
                ilvPoint.setLocation(ilvPointArray2[n4 - 1]);
                bl = false;
            }
            bl |= ((IlvLinkPoints.CrossPoint)point2).f();
            ilvPointArray2[0].move(point2.a, point2.b);
            point = point2;
            n4 = 1;
        }
        if (n4 > 1) {
            this.a(point, ilvPointArray2, 0, ilvTransformer, f3);
            if (!bl) {
                ilvPointArray2[0].setLocation(ilvPoint);
            }
            if (!ilvPointArray2[0].equals(ilvPoint)) {
                generalPath.moveTo(ilvPointArray2[0].x, ilvPointArray2[0].y);
            }
            for (n = 1; n < n4; ++n) {
                generalPath.lineTo(ilvPointArray2[n].x, ilvPointArray2[n].y);
            }
        }
        return generalPath;
    }

    protected void drawBackArrow(Graphics graphics, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.l) {
            IlvUtility.drawArrow(graphics, ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, 1.0f, this.getBackArrowSize(this.a(ilvTransformer, false), ilvTransformer));
        }
    }

    protected void drawPolyline(Graphics graphics, IlvPoint[] ilvPointArray, int n, float f, int n2, int n3, float[] fArray, IlvTransformer ilvTransformer, boolean bl) {
        IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, n, f, n2, n3, fArray, ilvTransformer, bl);
    }

    private boolean a(IlvLinkPoints.Point point, IlvPoint[] ilvPointArray, int n, IlvTransformer ilvTransformer, float f) {
        int n2;
        int n3;
        if (point == null || !(point instanceof IlvLinkPoints.CrossPoint)) {
            return false;
        }
        IlvLinkPoints.CrossPoint crossPoint = (IlvLinkPoints.CrossPoint)point;
        IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = crossPoint.h();
        IlvTransformer ilvTransformer2 = IlvCrossingAwareLinkImage.a((IlvGraphic)ilvCrossingAwareLinkImage, (IlvGraphic)this);
        if (ilvTransformer2 == null) {
            ilvTransformer2 = ilvTransformer;
        } else {
            ilvTransformer2.compose(ilvTransformer);
        }
        float f2 = ilvCrossingAwareLinkImage.getLineWidth(ilvTransformer2);
        float f3 = 0.5f * f2 + f;
        if (n == 0) {
            n3 = 0;
            n2 = 1;
        } else {
            n3 = n;
            n2 = n - 1;
        }
        double d = ilvPointArray[n2].x - ilvPointArray[n3].x;
        double d2 = ilvPointArray[n2].y - ilvPointArray[n3].y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (this.mergeCrossings((float)d3, f3, f2, ilvTransformer)) {
            ilvPointArray[n3].x = ilvPointArray[n2].x;
            ilvPointArray[n3].y = ilvPointArray[n2].y;
            this.e = (float)d3 - 0.5f * f2;
            return false;
        }
        ilvPointArray[n3].x = (float)((double)ilvPointArray[n3].x + (double)f3 * d / d3);
        ilvPointArray[n3].y = (float)((double)ilvPointArray[n3].y + (double)f3 * d2 / d3);
        this.e = f3 - 0.5f * f2;
        return true;
    }

    protected boolean mergeCrossings(float f, float f2, float f3, IlvTransformer ilvTransformer) {
        return f < f2;
    }

    static IlvTransformer a(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        IlvManager ilvManager = (IlvManager)ilvGraphic.getGraphicBag();
        IlvManager ilvManager2 = (IlvManager)ilvGraphic2.getGraphicBag();
        if (ilvManager == null || ilvManager2 == null || ilvManager == ilvManager2) {
            return null;
        }
        IlvTransformer ilvTransformer = ilvManager.getTopLevelTransformer();
        IlvTransformer ilvTransformer2 = ilvManager2.getTopLevelTransformer();
        IlvTransformer ilvTransformer3 = new IlvTransformer();
        ilvTransformer2.computeInverse(ilvTransformer3);
        ilvTransformer.compose(ilvTransformer3);
        return ilvTransformer;
    }

    public synchronized void drawCrossingGraphic(Graphics graphics, IlvTransformer ilvTransformer) {
        this.p.a = graphics;
        this.p.b = ilvTransformer;
        this.a(this.p, ilvTransformer);
    }

    public synchronized IlvRect boundingBoxCrossingGraphic(IlvTransformer ilvTransformer) {
        if (this.f == null) {
            return new IlvRect(0.0f, 0.0f, 1.0f, 1.0f);
        }
        return this.f.boundingBox(ilvTransformer);
    }

    public synchronized boolean containsAtCrossingGraphic(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        this.r.a = ilvPoint;
        this.r.b = ilvPoint2;
        this.r.c = ilvTransformer;
        return this.a(this.r, ilvTransformer);
    }

    private boolean a(CrossingApplyObject crossingApplyObject, IlvTransformer ilvTransformer) {
        IlvLinkPoints.Point point;
        double d;
        if (this.f == null) {
            return false;
        }
        if (!this.isCrossingEnabled()) {
            return false;
        }
        IlvLinkPoints ilvLinkPoints = this.a(ilvTransformer);
        if (ilvLinkPoints == null) {
            return false;
        }
        IlvCrossingGraphic ilvCrossingGraphic = (IlvCrossingGraphic)((Object)this.f);
        IlvPoint[] ilvPointArray = new IlvPoint[2];
        for (int i = 0; i < ilvPointArray.length; ++i) {
            ilvPointArray[i] = new IlvPoint();
        }
        IlvPoint ilvPoint = new IlvPoint();
        float f = this.getLineWidth();
        float f2 = this.getMaximumLineWidth();
        if (f != 0.0f) {
            f = IlvStrokeInfo.zoomedLineWidth(f, f2, ilvTransformer, false);
        }
        double d2 = d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        if (d == 0.0) {
            d = 1.0;
        }
        float f3 = 0.0f;
        float f4 = this.c;
        float f5 = this.c;
        if (this.d) {
            f5 = f4 = (float)((double)f5 * d);
        }
        if (this.getEndCap() != 0) {
            f3 = (float)(0.5 * (double)f * d);
        }
        f5 += f3;
        IlvPoint[] ilvPointArray2 = null;
        int n = 0;
        if (this.isOriented() || this.isBackOriented()) {
            ilvPointArray2 = this.getDrawingLinkPoints(ilvTransformer);
            n = ilvPointArray2.length;
        }
        IlvLinkPoints.Point point2 = null;
        IlvLinkPoints.Point point3 = null;
        float f6 = 0.0f;
        IlvPoint ilvPoint2 = new IlvPoint(point.a, point.b);
        IlvPoint ilvPoint3 = new IlvPoint(point.a, point.b);
        IlvPoint ilvPoint4 = new IlvPoint(point.a, point.b);
        IlvPoint ilvPoint5 = new IlvPoint(point.a, point.b);
        this.a(point, f, ilvTransformer);
        boolean bl = false;
        for (point = ilvLinkPoints.l(); point != null; point = point.c()) {
            ilvPointArray[1].move(point.a, point.b);
            if (point.c() == null && this.isOriented()) {
                ilvPointArray[1].setLocation(ilvPointArray2[n - 1]);
            }
            if (point.d() == null && this.isBackOriented()) {
                ilvPointArray[1].setLocation(ilvPointArray2[0]);
                ilvPoint5.setLocation(ilvPointArray2[0]);
            }
            if (point2 != null) {
                if (point2 instanceof IlvLinkPoints.CrossPoint) {
                    IlvPoint ilvPoint6;
                    float f7;
                    bl |= ((IlvLinkPoints.CrossPoint)point2).f();
                    if (point instanceof IlvLinkPoints.CrossPoint) {
                        this.a(point2, ilvPointArray, 0, ilvTransformer, f5);
                        f7 = this.e - f3;
                        ilvPoint.move(ilvPointArray[1].x, ilvPointArray[1].y);
                        if (this.a(point, ilvPointArray, 1, ilvTransformer, f5)) {
                            if (bl) {
                                ilvPoint4.move(ilvPointArray[1].x, ilvPointArray[1].y);
                                for (point3 = point.c(); ilvPoint4.equals(ilvPointArray[0]) && point3 != null; point3 = point3.c()) {
                                    ilvPoint4.move(point3.a, point3.b);
                                }
                                IlvPoint ilvPoint7 = ilvPoint6 = ilvPoint5.equals(ilvPoint3) ? ilvPoint2 : ilvPoint3;
                                if (crossingApplyObject.apply(ilvCrossingGraphic, this, ((IlvLinkPoints.CrossPoint)point2).h(), ilvPoint6, ilvPoint5, ilvPointArray[0], ilvPoint4, f6, f7, f4)) {
                                    return true;
                                }
                            }
                            ilvPoint5.setLocation(ilvPointArray[1]);
                            f6 = this.e - f3;
                            bl = false;
                        }
                        ilvPointArray[1].move(ilvPoint.x, ilvPoint.y);
                    } else {
                        if (bl) {
                            this.a(point2, ilvPointArray, 0, ilvTransformer, f5);
                            f7 = this.e - f3;
                            ilvPoint4.move(ilvPointArray[1].x, ilvPointArray[1].y);
                            for (point3 = point.c(); ilvPoint4.equals(ilvPointArray[0]) && point3 != null; point3 = point3.c()) {
                                ilvPoint4.move(point3.a, point3.b);
                            }
                            IlvPoint ilvPoint8 = ilvPoint6 = ilvPoint5.equals(ilvPoint3) ? ilvPoint2 : ilvPoint3;
                            if (crossingApplyObject.apply(ilvCrossingGraphic, this, ((IlvLinkPoints.CrossPoint)point2).h(), ilvPoint6, ilvPoint5, ilvPointArray[0], ilvPoint4, f6, f7, f4)) {
                                return true;
                            }
                        }
                        bl = false;
                    }
                } else {
                    if (point2.a != ilvPoint3.x || point2.b != ilvPoint3.y) {
                        ilvPoint2.setLocation(ilvPoint3);
                        ilvPoint3.move(point2.a, point2.b);
                    }
                    if (point instanceof IlvLinkPoints.CrossPoint) {
                        ilvPoint.move(ilvPointArray[1].x, ilvPointArray[1].y);
                        this.a(point, ilvPointArray, 1, ilvTransformer, f5);
                        ilvPoint5.setLocation(ilvPointArray[1]);
                        f6 = this.e - f3;
                        ilvPointArray[1].move(ilvPoint.x, ilvPoint.y);
                    }
                }
            }
            point2 = point;
            ilvPointArray[0].move(ilvPointArray[1].x, ilvPointArray[1].y);
        }
        return false;
    }

    private void a(IlvLinkPoints.Point point, float f, IlvTransformer ilvTransformer) {
        double d;
        double d2;
        double d3;
        double d4;
        IlvLinkPoints.CrossPoint crossPoint;
        IlvLinkPoints.Point point2;
        IlvLinkPoints.Point point3 = point2 = point;
        while (point2 != null) {
            if (point2 instanceof IlvLinkPoints.CrossPoint) {
                crossPoint = (IlvLinkPoints.CrossPoint)point2;
                crossPoint.a(true);
            }
            point3 = point2;
            point2 = point2.c();
        }
        if (this.isBackOriented()) {
            d4 = this.getBackArrowSize(f, ilvTransformer);
            for (point2 = point.c(); point2 != null && point2 instanceof IlvLinkPoints.CrossPoint; point2 = point2.c()) {
                crossPoint = (IlvLinkPoints.CrossPoint)point2;
                d3 = point.a - ((IlvLinkPoints.Point)crossPoint).a;
                d2 = point.b - ((IlvLinkPoints.Point)crossPoint).b;
                d = Math.sqrt(d3 * d3 + d2 * d2);
                if (!(d < 2.0 * d4)) continue;
                crossPoint.a(false);
            }
        }
        if (this.isOriented()) {
            d4 = this.getArrowSize(f, ilvTransformer);
            for (point2 = point3.d(); point2 != null && point2 instanceof IlvLinkPoints.CrossPoint; point2 = point2.d()) {
                crossPoint = (IlvLinkPoints.CrossPoint)point2;
                d3 = point3.a - ((IlvLinkPoints.Point)crossPoint).a;
                d2 = point3.b - ((IlvLinkPoints.Point)crossPoint).b;
                d = Math.sqrt(d3 * d3 + d2 * d2);
                if (!(d < 2.0 * d4)) continue;
                crossPoint.a(false);
            }
        }
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = new IlvPoint();
        IlvPoint ilvPoint2 = new IlvPoint();
        this.getConnectionPoints(ilvPoint, ilvPoint2, ilvTransformer);
        IlvRect ilvRect = this.k.get(ilvTransformer, ilvPoint, ilvPoint2);
        if (ilvRect == null) {
            ilvRect = this.calcBoundingBox(ilvTransformer);
            this.k.put(ilvTransformer, ilvPoint, ilvPoint2, ilvRect);
        }
        return ilvRect;
    }

    public void setBoundingBoxCacheSize(int n) {
        this.k.setSize(n);
    }

    public int getBoundingBoxCacheSize() {
        return this.k.getSize();
    }

    protected IlvRect calcBoundingBox(IlvTransformer ilvTransformer) {
        Object object;
        IlvRect ilvRect = super.boundingBox(ilvTransformer);
        if (this.l) {
            object = this.getLinkPoints(ilvTransformer);
            ilvRect.add(this.backArrowBBox(object[1], (IlvPoint)object[0], ilvTransformer));
        }
        if ((object = (IlvCrossingGraphic)((Object)this.f)) != null) {
            ilvRect = object.expandLinkBoundingBox(ilvRect, ilvTransformer);
        }
        return ilvRect;
    }

    protected boolean boundingBoxCacheContains(IlvTransformer ilvTransformer) {
        if (this.k != null) {
            return this.k.contains(ilvTransformer);
        }
        return false;
    }

    @Override
    protected void invalidateBBoxCache() {
        if (this.k != null) {
            this.k.setInvalid();
        }
    }

    protected void invalidateBoundingBoxCache() {
        this.invalidateBBoxCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IlvRect arrowBBox(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect();
        IlvPoint[] ilvPointArray = o;
        synchronized (o) {
            IlvUtility.ComputeArrow(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, 1.0f, o, this.getArrowSize(this.a(ilvTransformer, true), ilvTransformer));
            IlvUtil.BoundingBox(ilvRect, o, 3);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return ilvRect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IlvRect backArrowBBox(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect();
        IlvPoint[] ilvPointArray = o;
        synchronized (o) {
            IlvUtility.ComputeArrow(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, 1.0f, o, this.getBackArrowSize(this.a(ilvTransformer, true), ilvTransformer));
            IlvUtil.BoundingBox(ilvRect, o, 3);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return ilvRect;
        }
    }

    protected float getBackArrowSize(float f, IlvTransformer ilvTransformer) {
        return IlvUtility.arrowSize(f, ilvTransformer);
    }

    private float a(IlvTransformer ilvTransformer, boolean bl) {
        float f = this.getLineWidth();
        if (f == 0.0f) {
            return 0.0f;
        }
        return IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, bl);
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.boundingBoxCacheContains(ilvTransformer)) {
            IlvRect ilvRect = this.boundingBox(ilvTransformer);
            if (ilvPoint2.x < ilvRect.x) {
                return false;
            }
            if (ilvPoint2.x > ilvRect.x + ilvRect.width) {
                return false;
            }
            if (ilvPoint2.y < ilvRect.y) {
                return false;
            }
            if (ilvPoint2.y > ilvRect.y + ilvRect.height) {
                return false;
            }
        }
        return super.contains(ilvPoint, ilvPoint2, ilvTransformer);
    }

    @Override
    public void insertPoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (this.getGraphicBag() instanceof IlvGrapher && ((IlvGrapher)this.getGraphicBag()).isCrossingAwareLinksFrozen()) {
            return;
        }
        this.invalidateBBoxCache();
        super.insertPoint(n, f, f2, ilvTransformer);
    }

    @Override
    public void removePoint(int n, IlvTransformer ilvTransformer) {
        if (this.getGraphicBag() instanceof IlvGrapher && ((IlvGrapher)this.getGraphicBag()).isCrossingAwareLinksFrozen()) {
            return;
        }
        this.invalidateBBoxCache();
        super.removePoint(n, ilvTransformer);
    }

    @Override
    public void movePoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (this.getGraphicBag() instanceof IlvGrapher && ((IlvGrapher)this.getGraphicBag()).isCrossingAwareLinksFrozen()) {
            return;
        }
        this.invalidateBBoxCache();
        super.movePoint(n, f, f2, ilvTransformer);
    }

    @Override
    public void setIntermediateLinkPoints(IlvPoint[] ilvPointArray, int n, int n2) {
        if (this.getGraphicBag() instanceof IlvGrapher && ((IlvGrapher)this.getGraphicBag()).isCrossingAwareLinksFrozen()) {
            return;
        }
        this.invalidateBBoxCache();
        super.setIntermediateLinkPoints(ilvPointArray, n, n2);
    }

    @Override
    public void setOriented(boolean bl) {
        this.invalidateBBoxCache();
        super.setOriented(bl);
    }

    public void setBackOriented(boolean bl) {
        this.invalidateBBoxCache();
        this.l = bl;
    }

    public boolean isBackOriented() {
        return this.l;
    }

    @Override
    public void setLineWidth(float f) {
        this.invalidateBBoxCache();
        super.setLineWidth(f);
    }

    @Override
    public void setMaximumLineWidth(float f) {
        this.invalidateBBoxCache();
        super.setMaximumLineWidth(f);
    }

    @Override
    public void setEndCap(int n) {
        this.invalidateBBoxCache();
        super.setEndCap(n);
    }

    @Override
    public void setLineJoin(int n) {
        this.invalidateBBoxCache();
        super.setLineJoin(n);
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        this.invalidateBBoxCache();
        super.applyTransform(ilvTransformer);
    }

    IlvLinkPoints a(IlvTransformer ilvTransformer) {
        IlvLinkPoints ilvLinkPoints = this.c(ilvTransformer);
        if (ilvLinkPoints == null) {
            return this.b(ilvTransformer);
        }
        IlvCrossingAwareLinkImage.a((IlvManager)this.getTopLevelGraphicBag(), true);
        if (!ilvLinkPoints.b()) {
            return this.a(ilvLinkPoints, this.getCrossingPolicy());
        }
        return ilvLinkPoints;
    }

    IlvLinkPoints a(IlvManagerView ilvManagerView) {
        IlvLinkPoints ilvLinkPoints = this.d(ilvManagerView);
        if (ilvLinkPoints == null) {
            ilvLinkPoints = this.b(ilvManagerView);
        }
        return ilvLinkPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IlvLinkPoints b(IlvTransformer ilvTransformer) {
        if (this.g() == null) {
            return null;
        }
        IlvLinkPoints ilvLinkPoints = new IlvLinkPoints(this, ilvTransformer);
        this.f(true);
        this.b(true);
        try {
            ilvLinkPoints.a();
            this.f();
            IlvCrossingLinkShapePolicy ilvCrossingLinkShapePolicy = this.getCrossingPolicy();
            if (ilvCrossingLinkShapePolicy != null && this.isCrossingEnabled()) {
                CalcCrossingsUncachedApplyObject calcCrossingsUncachedApplyObject = new CalcCrossingsUncachedApplyObject();
                calcCrossingsUncachedApplyObject.b = ilvCrossingLinkShapePolicy;
                if (ilvCrossingLinkShapePolicy.isNestingTraversal()) {
                    this.b(ilvLinkPoints, calcCrossingsUncachedApplyObject);
                } else {
                    this.a(ilvLinkPoints, calcCrossingsUncachedApplyObject);
                }
            }
        }
        finally {
            this.b(false);
            this.f(false);
        }
        return ilvLinkPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(IlvCrossingLinkShapePolicy ilvCrossingLinkShapePolicy) {
        if (!this.isCrossingEnabled()) {
            return;
        }
        if (this.a == null) {
            return;
        }
        this.f(true);
        this.b(true);
        try {
            for (int i = 0; i < this.a.size(); ++i) {
                IlvLinkPoints ilvLinkPoints = (IlvLinkPoints)this.a.elementAt(i);
                this.a(ilvLinkPoints, ilvCrossingLinkShapePolicy);
            }
        }
        finally {
            this.b(false);
            this.f(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IlvLinkPoints a(IlvLinkPoints ilvLinkPoints, IlvCrossingLinkShapePolicy ilvCrossingLinkShapePolicy) {
        if (this.g() == null) {
            return ilvLinkPoints;
        }
        this.f(true);
        this.b(true);
        try {
            ilvLinkPoints.a();
            this.f();
            if (ilvCrossingLinkShapePolicy != null && this.isCrossingEnabled()) {
                CalcCrossingsCachedApplyObject calcCrossingsCachedApplyObject = new CalcCrossingsCachedApplyObject();
                calcCrossingsCachedApplyObject.b = ilvCrossingLinkShapePolicy;
                if (ilvCrossingLinkShapePolicy.isNestingTraversal()) {
                    this.b(ilvLinkPoints, calcCrossingsCachedApplyObject);
                } else {
                    this.a(ilvLinkPoints, calcCrossingsCachedApplyObject);
                }
            }
        }
        finally {
            this.b(false);
            this.f(false);
        }
        return ilvLinkPoints;
    }

    private void a(IlvLinkPoints ilvLinkPoints, CalcCrossingsApplyObject calcCrossingsApplyObject) {
        IlvManager ilvManager = this.g();
        if (ilvManager == null) {
            return;
        }
        IlvTransformer ilvTransformer = ilvLinkPoints.f();
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        IlvRect ilvRect2 = new IlvRect(ilvRect);
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvRect2);
        }
        IlvCrossingAwareLinkImage.a(ilvManager, ilvLinkPoints, ilvRect2, ilvRect, ilvTransformer, calcCrossingsApplyObject, false);
    }

    private void b(IlvLinkPoints ilvLinkPoints, CalcCrossingsApplyObject calcCrossingsApplyObject) {
        IlvManager ilvManager = (IlvManager)this.getTopLevelGraphicBag();
        if (ilvManager == null) {
            return;
        }
        IlvManager ilvManager2 = this.g();
        if (ilvManager2 == null) {
            return;
        }
        IlvTransformer ilvTransformer = ilvLinkPoints.f();
        IlvTransformer ilvTransformer2 = ilvManager2.getTopLevelTransformer();
        IlvTransformer ilvTransformer3 = new IlvTransformer();
        ilvTransformer2.computeInverse(ilvTransformer3);
        ilvTransformer3.compose(ilvTransformer);
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        IlvRect ilvRect2 = new IlvRect(ilvRect);
        ilvTransformer3.inverse(ilvRect2);
        IlvCrossingAwareLinkImage.a(ilvManager, ilvLinkPoints, ilvRect2, ilvRect, ilvTransformer3, calcCrossingsApplyObject, true);
    }

    private static void a(IlvManager ilvManager, IlvLinkPoints ilvLinkPoints, IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer, CalcCrossingsApplyObject calcCrossingsApplyObject, boolean bl) {
        IlvPersistentObject ilvPersistentObject;
        int n = ilvManager.getLayersCount();
        CalcCrossingsApplyObject calcCrossingsApplyObject2 = calcCrossingsApplyObject.a(ilvTransformer);
        for (int i = 0; i < n; ++i) {
            ilvPersistentObject = ilvManager.getManagerLayer(i);
            if (IlvCrossingAwareLinkImage.a((IlvManagerLayer)ilvPersistentObject) <= 0) continue;
            ((IlvIndexedSet)((Object)ilvPersistentObject)).mapIntersects(ilvRect, ilvRect2, calcCrossingsApplyObject2, ilvLinkPoints, ilvTransformer);
        }
        if (bl) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvPersistentObject = (IlvManager)ilvGraphicEnumeration.nextElement();
                if (!((IlvGraphic)ilvPersistentObject).intersects(ilvRect, ilvRect2, ilvTransformer)) continue;
                IlvTransformer ilvTransformer2 = ((IlvManager)ilvPersistentObject).getTransformer();
                ilvTransformer2.compose(ilvTransformer);
                IlvRect ilvRect3 = new IlvRect(ilvRect2);
                ilvTransformer2.inverse(ilvRect3);
                IlvCrossingAwareLinkImage.a((IlvManager)ilvPersistentObject, ilvLinkPoints, ilvRect3, ilvRect2, ilvTransformer2, calcCrossingsApplyObject, true);
            }
        }
    }

    private static boolean b(IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage, IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage2) {
        IlvManager ilvManager;
        IlvGrapher ilvGrapher;
        if (!(ilvCrossingAwareLinkImage.getGraphicBag() instanceof IlvGrapher)) {
            return false;
        }
        if (!(ilvCrossingAwareLinkImage2.getGraphicBag() instanceof IlvGrapher)) {
            return false;
        }
        IlvGrapher ilvGrapher2 = (IlvGrapher)ilvCrossingAwareLinkImage.getGraphicBag();
        if (ilvGrapher2 == (ilvGrapher = (IlvGrapher)ilvCrossingAwareLinkImage2.getGraphicBag())) {
            return true;
        }
        if (ilvGrapher2 == null || ilvGrapher == null) {
            return false;
        }
        IlvGrapher ilvGrapher3 = IlvGrapher.getLowestCommonGrapher(ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage2);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = ilvGrapher2.getLayer(ilvCrossingAwareLinkImage);
        int n2 = ilvGrapher.getLayer(ilvCrossingAwareLinkImage2);
        if (ilvGrapher2 != ilvGrapher3) {
            for (ilvManager = ilvGrapher2; ilvManager != null; ilvManager = ilvManager.getParent()) {
                if (ilvManager.isCollapsed()) {
                    bl3 = true;
                }
                if (ilvManager.getFrame() != null && ilvManager.getFrame().isOpaque(ilvManager)) {
                    bl = true;
                }
                if (ilvManager.getGraphicBag() != ilvGrapher3) continue;
                n = ilvGrapher3.getLayer(ilvManager);
                break;
            }
        }
        if (ilvGrapher != ilvGrapher3) {
            for (ilvManager = ilvGrapher; ilvManager != null; ilvManager = ilvManager.getParent()) {
                if (ilvManager.isCollapsed()) {
                    bl4 = true;
                }
                if (ilvManager.getFrame() != null && ilvManager.getFrame().isOpaque(ilvManager)) {
                    bl2 = true;
                }
                if (ilvManager.getGraphicBag() != ilvGrapher3) continue;
                n2 = ilvGrapher3.getLayer(ilvManager);
                break;
            }
        }
        if (bl3 || bl4) {
            return false;
        }
        if (bl) {
            if (bl2) {
                return false;
            }
            return n2 >= n;
        }
        if (bl2) {
            return n >= n2;
        }
        return true;
    }

    private static void b(IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage, IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage2, IlvLinkPoints ilvLinkPoints, IlvLinkPoints ilvLinkPoints2, IlvCrossingLinkShapePolicy ilvCrossingLinkShapePolicy) {
        IlvPoint[] ilvPointArray;
        IlvTransformer ilvTransformer = ilvLinkPoints.f();
        IlvTransformer ilvTransformer2 = ilvLinkPoints2.f();
        IlvGrapher ilvGrapher = (IlvGrapher)ilvCrossingAwareLinkImage2.getGraphicBag();
        if (ilvGrapher != null) {
            ilvTransformer2 = ilvGrapher.getDrawingTransformer(ilvLinkPoints2.h());
        }
        IlvPoint[] ilvPointArray2 = ilvPointArray = ilvCrossingAwareLinkImage.getLinkPoints(ilvTransformer);
        if (ilvCrossingAwareLinkImage != ilvCrossingAwareLinkImage2) {
            ilvPointArray2 = ilvCrossingAwareLinkImage2.getLinkPoints(ilvTransformer2);
        }
        int n = ilvPointArray.length;
        int n2 = ilvPointArray2.length;
        double d = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            double d2 = ilvPointArray[i + 1].x - ilvPointArray[i].x;
            double d3 = ilvPointArray[i + 1].y - ilvPointArray[i].y;
            if (d2 == 0.0 && d3 == 0.0) continue;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            d += d4;
            double d5 = 0.0;
            for (int j = 0; j < n2 - 1; ++j) {
                double d6;
                double d7;
                double d8;
                double d9 = ilvPointArray2[j + 1].x - ilvPointArray2[j].x;
                double d10 = ilvPointArray2[j + 1].y - ilvPointArray2[j].y;
                if (d9 == 0.0 && d10 == 0.0) continue;
                double d11 = Math.sqrt(d9 * d9 + d10 * d10);
                d5 += d11;
                if (ilvCrossingAwareLinkImage == ilvCrossingAwareLinkImage2 && j <= i + 1 || (d8 = d2 * d10) == (d7 = d9 * d3)) continue;
                float f = (float)(((double)ilvPointArray[i].x * d7 - (double)ilvPointArray2[j].x * d8 + (double)(ilvPointArray2[j].y - ilvPointArray[i].y) * d2 * d9) / (d7 - d8));
                float f2 = (float)(((double)ilvPointArray[i].y * d8 - (double)ilvPointArray2[j].y * d7 + (double)(ilvPointArray2[j].x - ilvPointArray[i].x) * d3 * d10) / (d8 - d7));
                if (!(Math.abs(d2) > Math.abs(d3)) ? f2 <= Math.min(ilvPointArray[i].y, ilvPointArray[i + 1].y) || Math.max(ilvPointArray[i].y, ilvPointArray[i + 1].y) <= f2 : f <= Math.min(ilvPointArray[i].x, ilvPointArray[i + 1].x) || Math.max(ilvPointArray[i].x, ilvPointArray[i + 1].x) <= f) continue;
                if (!(Math.abs(d9) > Math.abs(d10)) ? f2 <= Math.min(ilvPointArray2[j].y, ilvPointArray2[j + 1].y) || Math.max(ilvPointArray2[j].y, ilvPointArray2[j + 1].y) <= f2 : f <= Math.min(ilvPointArray2[j].x, ilvPointArray2[j + 1].x) || Math.max(ilvPointArray2[j].x, ilvPointArray2[j + 1].x) <= f) continue;
                if (i == 0 && j == 0 && ilvPointArray[i].equals(ilvPointArray2[j]) || i == 0 && j == n2 - 2 && ilvPointArray[i].equals(ilvPointArray2[j + 1]) || j == 0 && i == n - 2 && ilvPointArray2[j].equals(ilvPointArray[i + 1]) || i == n - 2 && j == n2 - 2 && ilvPointArray[i + 1].equals(ilvPointArray2[j + 1])) continue;
                double d12 = Math.abs(d2) * Math.abs(d10);
                double d13 = Math.abs(d9) * Math.abs(d3);
                boolean bl = true;
                if (d12 < d13) {
                    bl = !ilvCrossingLinkShapePolicy.isHorizontalPreferred();
                } else if (d12 > d13) {
                    bl = ilvCrossingLinkShapePolicy.isHorizontalPreferred();
                } else {
                    boolean bl2 = bl = ilvCrossingAwareLinkImage.hashCode() < ilvCrossingAwareLinkImage2.hashCode();
                }
                if (bl) {
                    d9 = f - ilvPointArray[i].x;
                    d10 = f2 - ilvPointArray[i].y;
                    d6 = d - d4 + Math.sqrt(d9 * d9 + d10 * d10);
                    ilvCrossingAwareLinkImage.a(f, f2, ilvLinkPoints, ilvLinkPoints2, d6);
                    continue;
                }
                d9 = f - ilvPointArray2[j].x;
                d10 = f2 - ilvPointArray2[j].y;
                d6 = d5 - d11 + Math.sqrt(d9 * d9 + d10 * d10);
                ilvCrossingAwareLinkImage2.a(f, f2, ilvLinkPoints2, ilvLinkPoints, d6);
            }
        }
    }

    private static void b(IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage, IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage2, IlvTransformer ilvTransformer, IlvTransformer ilvTransformer2, IlvLinkPoints ilvLinkPoints, boolean bl) {
        IlvPoint[] ilvPointArray;
        IlvPoint[] ilvPointArray2 = ilvPointArray = ilvCrossingAwareLinkImage.getLinkPoints(ilvTransformer);
        if (ilvCrossingAwareLinkImage != ilvCrossingAwareLinkImage2) {
            ilvPointArray2 = ilvCrossingAwareLinkImage2.getLinkPoints(ilvTransformer2);
        }
        int n = ilvPointArray.length;
        int n2 = ilvPointArray2.length;
        double d = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            double d2 = ilvPointArray[i + 1].x - ilvPointArray[i].x;
            double d3 = ilvPointArray[i + 1].y - ilvPointArray[i].y;
            if (d2 == 0.0 && d3 == 0.0) continue;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            d += d4;
            for (int j = 0; j < n2 - 1; ++j) {
                double d5;
                double d6;
                double d7 = ilvPointArray2[j + 1].x - ilvPointArray2[j].x;
                double d8 = ilvPointArray2[j + 1].y - ilvPointArray2[j].y;
                if (d7 == 0.0 && d8 == 0.0 || ilvCrossingAwareLinkImage == ilvCrossingAwareLinkImage2 && j <= i + 1 || (d6 = d2 * d8) == (d5 = d7 * d3)) continue;
                float f = (float)(((double)ilvPointArray[i].x * d5 - (double)ilvPointArray2[j].x * d6 + (double)(ilvPointArray2[j].y - ilvPointArray[i].y) * d2 * d7) / (d5 - d6));
                float f2 = (float)(((double)ilvPointArray[i].y * d6 - (double)ilvPointArray2[j].y * d5 + (double)(ilvPointArray2[j].x - ilvPointArray[i].x) * d3 * d8) / (d6 - d5));
                if (!(Math.abs(d2) > Math.abs(d3)) ? f2 <= Math.min(ilvPointArray[i].y, ilvPointArray[i + 1].y) || Math.max(ilvPointArray[i].y, ilvPointArray[i + 1].y) <= f2 : f <= Math.min(ilvPointArray[i].x, ilvPointArray[i + 1].x) || Math.max(ilvPointArray[i].x, ilvPointArray[i + 1].x) <= f) continue;
                if (!(Math.abs(d7) > Math.abs(d8)) ? f2 <= Math.min(ilvPointArray2[j].y, ilvPointArray2[j + 1].y) || Math.max(ilvPointArray2[j].y, ilvPointArray2[j + 1].y) <= f2 : f <= Math.min(ilvPointArray2[j].x, ilvPointArray2[j + 1].x) || Math.max(ilvPointArray2[j].x, ilvPointArray2[j + 1].x) <= f) continue;
                if (i == 0 && j == 0 && ilvPointArray[i].equals(ilvPointArray2[j]) || i == 0 && j == n2 - 2 && ilvPointArray[i].equals(ilvPointArray2[j + 1]) || j == 0 && i == n - 2 && ilvPointArray2[j].equals(ilvPointArray[i + 1]) || i == n - 2 && j == n2 - 2 && ilvPointArray[i + 1].equals(ilvPointArray2[j + 1])) continue;
                double d9 = Math.abs(d2) * Math.abs(d8);
                double d10 = Math.abs(d7) * Math.abs(d3);
                boolean bl2 = true;
                if (d9 < d10) {
                    bl2 = !bl;
                } else if (d9 > d10) {
                    bl2 = bl;
                } else {
                    boolean bl3 = bl2 = ilvCrossingAwareLinkImage.hashCode() < ilvCrossingAwareLinkImage2.hashCode();
                }
                if (!bl2) continue;
                d7 = f - ilvPointArray[i].x;
                d8 = f2 - ilvPointArray[i].y;
                double d11 = d - d4 + Math.sqrt(d7 * d7 + d8 * d8);
                ilvCrossingAwareLinkImage.a(f, f2, ilvLinkPoints, ilvCrossingAwareLinkImage2, d11);
            }
        }
    }

    void a(float f, float f2, IlvLinkPoints ilvLinkPoints, IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage, double d) {
        this.a(f, f2, ilvLinkPoints, ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage, d);
    }

    void a(float f, float f2, IlvLinkPoints ilvLinkPoints, IlvLinkPoints ilvLinkPoints2, double d) {
        IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = ilvLinkPoints2.e();
        this.a(f, f2, ilvLinkPoints, ilvLinkPoints2, ilvCrossingAwareLinkImage, d);
    }

    private void a(float f, float f2, IlvLinkPoints ilvLinkPoints, Object object, IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage, double d) {
        if (!this.isCrossingEnabled()) {
            return;
        }
        if (ilvLinkPoints.c()) {
            return;
        }
        IlvManager ilvManager = (IlvManager)this.getGraphicBag();
        IlvManager ilvManager2 = (IlvManager)ilvCrossingAwareLinkImage.getGraphicBag();
        if (this.f != null && ilvManager != null) {
            int n;
            IlvManager ilvManager3;
            IlvManager ilvManager4 = this.a() ? this.i : (IlvManager)this.f.getGraphicBag();
            if (ilvManager == ilvManager2 || ilvManager2 == null) {
                ilvManager3 = ilvManager;
                n = ilvManager2 == null ? ilvManager.getLayer(this) + 1 : Math.max(ilvManager.getLayer(this), ilvManager2.getLayer(ilvCrossingAwareLinkImage)) + 1;
                if (ilvManager4 != null && this.a(ilvManager4) < this.a(ilvManager3)) {
                    ilvManager3 = ilvManager4;
                    n = this.a() ? this.j : ilvManager4.getLayer(this.f);
                }
            } else {
                int n2;
                int n3 = this.a(ilvManager);
                if (n3 <= (n2 = this.a(ilvManager2))) {
                    ilvManager3 = ilvManager;
                    n = ilvManager.getLayer(this) + 1;
                    if (ilvManager4 != null && this.a(ilvManager4) < n3) {
                        ilvManager3 = ilvManager4;
                        n = this.a() ? this.j : ilvManager4.getLayer(this.f);
                    }
                } else {
                    ilvManager3 = ilvManager2;
                    n = ilvManager2.getLayer(ilvCrossingAwareLinkImage) + 1;
                    if (ilvManager4 != null && this.a(ilvManager4) < n2) {
                        ilvManager3 = ilvManager4;
                        n = this.a() ? this.j : ilvManager4.getLayer(this.f);
                    }
                }
            }
            if (this.g >= 0) {
                n = this.g;
            }
            if (this.a()) {
                this.f();
                ilvLinkPoints.a(f, f2, d, object);
                this.i = ilvManager3;
                this.j = n;
            } else {
                this.f();
                ilvLinkPoints.a(f, f2, d, object);
                if (ilvManager3 != ilvManager4) {
                    this.e();
                    this.a(ilvManager3, n);
                } else {
                    this.a(n);
                }
            }
        } else {
            this.f();
            ilvLinkPoints.a(f, f2, d, object);
        }
    }

    void b() {
        if (this.a == null) {
            return;
        }
        this.f(true);
        this.b(true);
        try {
            this.i = null;
            for (int i = 0; i < this.a.size(); ++i) {
                IlvLinkPoints ilvLinkPoints = (IlvLinkPoints)this.a.elementAt(i);
                this.a(ilvLinkPoints);
            }
        }
        finally {
            this.b(false);
            this.f(false);
        }
    }

    void a(IlvLinkPoints ilvLinkPoints) {
        this.f(true);
        this.b(true);
        try {
            ilvLinkPoints.a();
            this.f();
        }
        finally {
            this.b(false);
            this.f(false);
        }
    }

    private void f(boolean bl) {
        IlvManager ilvManager = this.g();
        if (ilvManager != null) {
            ilvManager.setContentsAdjusting(bl);
        }
    }

    final boolean b(IlvLinkPoints ilvLinkPoints) {
        if (ilvLinkPoints == null) {
            return false;
        }
        return ilvLinkPoints.j() != 0;
    }

    private void f() {
        if (this.f != null) {
            ((IlvCrossingGraphic)((Object)this.f)).crossingChanged();
        }
    }

    private int a(IlvManager ilvManager) {
        int n = 0;
        while (ilvManager != null) {
            ilvManager = ilvManager.getParent();
            ++n;
        }
        return n;
    }

    private IlvManager g() {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof IlvManager) {
            return (IlvManager)ilvGraphicBag;
        }
        return null;
    }

    private boolean a(IlvGraphicBag ilvGraphicBag, boolean bl) {
        if (ilvGraphicBag instanceof IlvGrapher) {
            IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphicBag;
            boolean bl2 = ilvGrapher.isCrossingAwareLinksFrozen();
            ilvGrapher.setCrossingAwareLinksFrozen(bl);
            return bl2;
        }
        return false;
    }

    static void a(IlvManager ilvManager, boolean bl) {
        if (ilvManager == null) {
            return;
        }
        ManagerStatus managerStatus = ManagerStatus.a(ilvManager);
        if (managerStatus.b(ilvManager)) {
            if (bl) {
                IlvCrossingAwareLinkImage.b(ilvManager, true);
            }
            bl = false;
        }
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvCrossingAwareLinkImage.a((IlvManager)ilvGraphicEnumeration.nextElement(), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void b(IlvManager ilvManager, boolean bl) {
        Vector vector = IlvCrossingAwareLinkImage.d(ilvManager, bl);
        IlvCrossingAwareLinkImage.c(ilvManager, true);
        IlvCrossingAwareLinkImage.a(vector, true);
        try {
            for (int i = 0; i < vector.size(); ++i) {
                IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = (IlvCrossingAwareLinkImage)vector.elementAt(i);
                ilvCrossingAwareLinkImage.a(ilvCrossingAwareLinkImage.getCrossingPolicy());
            }
        }
        finally {
            IlvCrossingAwareLinkImage.a(vector, false);
            IlvCrossingAwareLinkImage.c(ilvManager, false);
        }
    }

    static void c(IlvManager ilvManager, boolean bl) {
        if (ilvManager == null) {
            return;
        }
        ilvManager.setContentsAdjusting(bl);
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvCrossingAwareLinkImage.c((IlvManager)ilvGraphicEnumeration.nextElement(), bl);
        }
    }

    private static void a(Vector vector, boolean bl) {
        for (int i = 0; i < vector.size(); ++i) {
            IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = (IlvCrossingAwareLinkImage)vector.elementAt(i);
            ilvCrossingAwareLinkImage.b(bl);
        }
    }

    private static Vector d(IlvManager ilvManager, boolean bl) {
        Vector<IlvGraphic> vector = new Vector<IlvGraphic>();
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getObjects(bl);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!(ilvGraphic instanceof IlvCrossingAwareLinkImage)) continue;
            vector.addElement(ilvGraphic);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void a(IlvManager ilvManager, IlvManagerView ilvManagerView) {
        Vector vector = IlvCrossingAwareLinkImage.d(ilvManager, true);
        IlvCrossingAwareLinkImage.c(ilvManager, true);
        IlvCrossingAwareLinkImage.a(vector, true);
        try {
            IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage;
            int n;
            for (n = 0; n < vector.size(); ++n) {
                ilvCrossingAwareLinkImage = (IlvCrossingAwareLinkImage)vector.elementAt(n);
                ilvCrossingAwareLinkImage.b(ilvManagerView);
            }
            for (n = 0; n < vector.size(); ++n) {
                ilvCrossingAwareLinkImage = (IlvCrossingAwareLinkImage)vector.elementAt(n);
                IlvLinkPoints ilvLinkPoints = ilvCrossingAwareLinkImage.d(ilvManagerView);
                ilvCrossingAwareLinkImage.a(ilvLinkPoints, ilvCrossingAwareLinkImage.getCrossingPolicy());
            }
        }
        finally {
            IlvCrossingAwareLinkImage.a(vector, false);
            IlvCrossingAwareLinkImage.c(ilvManager, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void b(IlvManager ilvManager, IlvManagerView ilvManagerView) {
        Vector vector = IlvCrossingAwareLinkImage.d(ilvManager, true);
        IlvCrossingAwareLinkImage.c(ilvManager, true);
        IlvCrossingAwareLinkImage.a(vector, true);
        try {
            for (int i = 0; i < vector.size(); ++i) {
                IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = (IlvCrossingAwareLinkImage)vector.elementAt(i);
                ilvCrossingAwareLinkImage.c(ilvManagerView);
            }
        }
        finally {
            IlvCrossingAwareLinkImage.a(vector, false);
            IlvCrossingAwareLinkImage.c(ilvManager, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void a(IlvManager ilvManager, IlvManager ilvManager2) {
        Vector vector = IlvCrossingAwareLinkImage.d(ilvManager2, true);
        IlvCrossingAwareLinkImage.c(ilvManager2, true);
        IlvCrossingAwareLinkImage.a(vector, true);
        try {
            IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage;
            int n;
            IlvManagerView ilvManagerView;
            Enumeration enumeration;
            Object object;
            if (ilvManager != null) {
                object = IlvCrossingAwareLinkImage.d(ilvManager, true);
                enumeration = ilvManager.getViews();
                while (enumeration.hasMoreElements()) {
                    ilvManagerView = (IlvManagerView)enumeration.nextElement();
                    for (n = 0; n < ((Vector)object).size(); ++n) {
                        ilvCrossingAwareLinkImage = (IlvCrossingAwareLinkImage)((Vector)object).elementAt(n);
                        ilvCrossingAwareLinkImage.c(ilvManagerView);
                    }
                }
            }
            enumeration = ilvManager2.getViews();
            while (enumeration.hasMoreElements()) {
                ilvManagerView = (IlvManagerView)enumeration.nextElement();
                for (int i = 0; i < vector.size(); ++i) {
                    ilvCrossingAwareLinkImage = (IlvCrossingAwareLinkImage)vector.elementAt(i);
                    ilvCrossingAwareLinkImage.b(ilvManagerView);
                }
            }
            object = ilvManager2.getTreeLock();
            for (n = 0; n < vector.size(); ++n) {
                ilvCrossingAwareLinkImage = (IlvCrossingAwareLinkImage)vector.elementAt(n);
                ilvCrossingAwareLinkImage.b = object;
                ilvCrossingAwareLinkImage.a(ilvCrossingAwareLinkImage.getCrossingPolicy());
            }
        }
        finally {
            IlvCrossingAwareLinkImage.a(vector, false);
            IlvCrossingAwareLinkImage.c(ilvManager2, false);
        }
    }

    IlvLinkPoints b(IlvManagerView ilvManagerView) {
        IlvLinkPoints ilvLinkPoints = new IlvLinkPoints(this, ilvManagerView);
        if (this.a == null) {
            this.a = new Vector(3);
        }
        this.a.addElement(ilvLinkPoints);
        return ilvLinkPoints;
    }

    void c(IlvManagerView ilvManagerView) {
        if (this.a == null) {
            return;
        }
        IlvLinkPoints ilvLinkPoints = this.d(ilvManagerView);
        if (ilvLinkPoints != null) {
            this.a.removeElement(ilvLinkPoints);
        }
    }

    IlvLinkPoints d(IlvManagerView ilvManagerView) {
        if (this.a == null) {
            return null;
        }
        for (int i = 0; i < this.a.size(); ++i) {
            IlvLinkPoints ilvLinkPoints = (IlvLinkPoints)this.a.elementAt(i);
            if (ilvLinkPoints.h() != ilvManagerView) continue;
            return ilvLinkPoints;
        }
        return null;
    }

    IlvLinkPoints c(IlvTransformer ilvTransformer) {
        this.h();
        if (this.a == null) {
            return null;
        }
        for (int i = 0; i < this.a.size(); ++i) {
            IlvLinkPoints ilvLinkPoints = (IlvLinkPoints)this.a.elementAt(i);
            if (!ilvLinkPoints.f().equals(ilvTransformer)) continue;
            return ilvLinkPoints;
        }
        return null;
    }

    private void h() {
        Object object;
        IlvManager ilvManager = this.g();
        if (ilvManager == null) {
            return;
        }
        boolean bl = false;
        if (ilvManager.getTreeLock() != this.b) {
            bl = true;
            this.b = ilvManager.getTreeLock();
        }
        IlvManager ilvManager2 = null;
        if (this.a != null) {
            if (bl) {
                if (this.a.size() > 0) {
                    object = (IlvLinkPoints)this.a.elementAt(0);
                    ilvManager2 = ((IlvLinkPoints)object).h().getManager();
                }
            } else {
                for (int i = 0; i < this.a.size(); ++i) {
                    IlvLinkPoints ilvLinkPoints = (IlvLinkPoints)this.a.elementAt(i);
                    ilvLinkPoints.g();
                }
            }
        }
        if (bl) {
            object = (IlvManager)this.getTopLevelGraphicBag();
            if (ilvManager2 != null) {
                this.c(ilvManager2);
            } else {
                this.b((IlvManager)object);
            }
            TreeRootListener.a((IlvGraphicBag)object, true);
            IlvCrossingAwareLinkImage.a(ilvManager2, (IlvManager)object);
        }
    }

    private void b(IlvManager ilvManager) {
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvManager ilvManager2 = (IlvManager)ilvGraphicEnumeration.nextElement();
            this.c(ilvManager2);
            this.b(ilvManager2);
        }
    }

    private void c(IlvManager ilvManager) {
        TreeRootListener treeRootListener = TreeRootListener.a(ilvManager, false);
        if (treeRootListener != null) {
            treeRootListener.a();
        }
    }

    static void a(IlvManagerLayer ilvManagerLayer, int n) {
        NumberLinks numberLinks = (NumberLinks)ilvManagerLayer.getProperty(s);
        if (numberLinks == null) {
            ilvManagerLayer.setProperty(s, new NumberLinks(n));
        } else {
            numberLinks.a += n;
            if (numberLinks.a == 0) {
                ilvManagerLayer.setProperty(s, null);
            }
        }
    }

    static int a(IlvManagerLayer ilvManagerLayer) {
        NumberLinks numberLinks = (NumberLinks)ilvManagerLayer.getProperty(s);
        if (numberLinks != null) {
            return numberLinks.a;
        }
        return 0;
    }

    static void a(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvCrossingAwareLinkImage) {
            IlvManager ilvManager = ((IlvCrossingAwareLinkImage)ilvGraphic).g();
            if (!(ilvManager instanceof IlvGrapher)) {
                return;
            }
            IlvGrapher ilvGrapher = (IlvGrapher)ilvManager;
            if (ilvGrapher == null) {
                return;
            }
            IlvManagerLayer ilvManagerLayer = ilvGrapher.getManagerLayer(ilvGraphic);
            IlvCrossingAwareLinkImage.a(ilvManagerLayer, 1);
        }
    }

    static void b(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvCrossingAwareLinkImage) {
            IlvManager ilvManager = ((IlvCrossingAwareLinkImage)ilvGraphic).g();
            if (!(ilvManager instanceof IlvGrapher)) {
                return;
            }
            IlvGrapher ilvGrapher = (IlvGrapher)ilvManager;
            if (ilvGrapher == null) {
                return;
            }
            IlvManagerLayer ilvManagerLayer = ilvGrapher.getManagerLayer(ilvGraphic);
            IlvCrossingAwareLinkImage.a(ilvManagerLayer, -1);
        }
    }

    static void a(IlvGraphic ilvGraphic, IlvManagerLayer ilvManagerLayer, IlvManagerLayer ilvManagerLayer2) {
        if (ilvGraphic instanceof IlvCrossingAwareLinkImage) {
            if (ilvManagerLayer != null) {
                IlvCrossingAwareLinkImage.a(ilvManagerLayer, -1);
            }
            if (ilvManagerLayer2 != null) {
                IlvCrossingAwareLinkImage.a(ilvManagerLayer2, 1);
            }
        }
    }

    static void a(IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic instanceof IlvCrossingAwareLinkImage) {
            IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = (IlvCrossingAwareLinkImage)ilvGraphic;
            IlvGraphic ilvGraphic2 = ilvCrossingAwareLinkImage.getCrossingGraphic();
            if (ilvGraphic2 != null) {
                IlvManager ilvManager = ilvCrossingAwareLinkImage.g();
                boolean bl2 = ilvManager != null ? ilvManager.isVisible(ilvGraphic) : ilvGraphic.isVisible();
                ilvManager = (IlvManager)ilvGraphic2.getGraphicBag();
                if (ilvManager != null) {
                    ilvManager.setVisible(ilvGraphic2, bl2, true);
                } else {
                    ilvGraphic2.setVisible(bl2);
                }
            }
            ilvCrossingAwareLinkImage.c(!ilvCrossingAwareLinkImage.isCrossingEnabled());
        }
    }

    static {
        for (int i = 0; i < 3; ++i) {
            IlvCrossingAwareLinkImage.o[i] = new IlvPoint(0.0f, 0.0f);
        }
        s = "__IlvCrossingAwareLinkImageEventNumLinks".intern();
    }

    static final class TreeRootListener
    implements ManagerViewsChangedListener {
        private IlvManager a;
        private static final String b = "__IlvCrossingAwareLinkImageTreeRootListenerProperty".intern();

        TreeRootListener() {
        }

        static TreeRootListener a(IlvGraphicBag ilvGraphicBag, boolean bl) {
            if (ilvGraphicBag == null) {
                return null;
            }
            IlvManager ilvManager = (IlvManager)ilvGraphicBag;
            TreeRootListener treeRootListener = (TreeRootListener)ilvManager.getProperty(b);
            if (treeRootListener == null && bl) {
                treeRootListener = new TreeRootListener();
                treeRootListener.a = (IlvManager)ilvGraphicBag;
                treeRootListener.a.addManagerViewsListener(treeRootListener);
                treeRootListener.a.setProperty(b, treeRootListener);
            }
            return treeRootListener;
        }

        void a() {
            if (this.a != null) {
                this.a.removeManagerViewsListener(this);
                this.a.removeProperty(b);
                this.a = null;
            }
        }

        @Override
        public void viewChanged(ManagerViewsChangedEvent managerViewsChangedEvent) {
            if (managerViewsChangedEvent.getManager() != this.a) {
                return;
            }
            IlvManagerView ilvManagerView = managerViewsChangedEvent.getManagerView();
            switch (managerViewsChangedEvent.getType()) {
                case 1: {
                    IlvCrossingAwareLinkImage.a(this.a, ilvManagerView);
                    break;
                }
                case 2: {
                    IlvCrossingAwareLinkImage.b(this.a, ilvManagerView);
                }
            }
        }
    }

    static final class ContentChangedListener
    implements ManagerContentChangedListener {
        private IlvGrapher a;
        private int b = 0;
        private static final String c = "__IlvCrossingAwareLinkImageContentChangedListenerProperty".intern();

        ContentChangedListener() {
        }

        static ContentChangedListener a(IlvGraphicBag ilvGraphicBag, boolean bl) {
            ContentChangedListener contentChangedListener = (ContentChangedListener)IlvPolicyAwareLinkImage.b(ilvGraphicBag, c);
            if (contentChangedListener == null && ilvGraphicBag instanceof IlvGrapher && bl) {
                contentChangedListener = new ContentChangedListener();
                contentChangedListener.a = (IlvGrapher)ilvGraphicBag;
                contentChangedListener.a.addManagerContentChangedListener(contentChangedListener);
                IlvPolicyAwareLinkImage.a(ilvGraphicBag, c, contentChangedListener);
            }
            return contentChangedListener;
        }

        void a() {
            ++this.b;
        }

        void b() {
            --this.b;
            if (this.b <= 0) {
                this.c();
            }
        }

        private void c() {
            if (this.a != null) {
                IlvPolicyAwareLinkImage.a(this.a, c);
                this.a.removeManagerContentChangedListener(this);
                this.a = null;
            }
        }

        @Override
        public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
            switch (managerContentChangedEvent.getType()) {
                case 1: {
                    IlvGraphic ilvGraphic = ((ObjectInsertedEvent)managerContentChangedEvent).getGraphicObject();
                    IlvCrossingAwareLinkImage.a(ilvGraphic);
                    break;
                }
                case 16: {
                    ObjectLayerChangedEvent objectLayerChangedEvent = (ObjectLayerChangedEvent)managerContentChangedEvent;
                    IlvGraphic ilvGraphic = objectLayerChangedEvent.getGraphicObject();
                    IlvCrossingAwareLinkImage.a(ilvGraphic, objectLayerChangedEvent.getOldLayer(), objectLayerChangedEvent.getNewLayer());
                    break;
                }
                case 8: {
                    ObjectVisibilityChangedEvent objectVisibilityChangedEvent = (ObjectVisibilityChangedEvent)managerContentChangedEvent;
                    IlvGraphic ilvGraphic = objectVisibilityChangedEvent.getGraphicObject();
                    IlvCrossingAwareLinkImage.a(ilvGraphic, objectVisibilityChangedEvent.isObjectVisible());
                }
            }
        }
    }

    static final class NumberLinks {
        int a;

        NumberLinks(int n) {
            this.a = n;
        }
    }

    static class ManagerStatus {
        IlvTransformer a;
        boolean b;
        boolean c;
        private static final String d = "__IlvCrossingAwareLinkImageManagerStatusProperty".intern();

        ManagerStatus() {
        }

        static ManagerStatus a(IlvManager ilvManager) {
            Object object = ilvManager.getProperty(d);
            if (object == null) {
                object = new ManagerStatus();
                ilvManager.setProperty(d, object);
            }
            return (ManagerStatus)object;
        }

        boolean b(IlvManager ilvManager) {
            boolean bl;
            boolean bl2;
            boolean bl3 = false;
            IlvTransformer ilvTransformer = ilvManager.getTransformer();
            if (this.a == null || !this.a.equals(ilvTransformer)) {
                this.a = ilvTransformer;
                bl3 = true;
            }
            boolean bl4 = bl2 = ilvManager.getFrame() != null && ilvManager.getFrame().isOpaque(ilvManager);
            if (bl2 != this.b) {
                this.b = bl2;
                bl3 = true;
            }
            if ((bl = ilvManager.isCollapsed()) != this.c) {
                this.c = bl;
                bl3 = true;
            }
            return bl3;
        }
    }

    private static final class CalcCrossingsUncachedApplyObject
    extends CalcCrossingsApplyObject {
        private CalcCrossingsUncachedApplyObject() {
        }

        @Override
        CalcCrossingsApplyObject a(IlvTransformer ilvTransformer) {
            CalcCrossingsUncachedApplyObject calcCrossingsUncachedApplyObject = new CalcCrossingsUncachedApplyObject();
            calcCrossingsUncachedApplyObject.a = ilvTransformer;
            calcCrossingsUncachedApplyObject.b = this.b;
            return calcCrossingsUncachedApplyObject;
        }

        @Override
        public void apply(IlvGraphic ilvGraphic, Object object) {
            if (ilvGraphic instanceof IlvCrossingAwareLinkImage) {
                IlvLinkPoints ilvLinkPoints = (IlvLinkPoints)object;
                IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = ilvLinkPoints.e();
                IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage2 = (IlvCrossingAwareLinkImage)ilvGraphic;
                if (ilvCrossingAwareLinkImage2.isCrossingEnabled() && IlvCrossingAwareLinkImage.b(ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage2)) {
                    IlvCrossingAwareLinkImage.b(ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage2, ilvLinkPoints.f(), this.a, ilvLinkPoints, this.b.isHorizontalPreferred());
                }
            }
        }
    }

    private static final class CalcCrossingsCachedApplyObject
    extends CalcCrossingsApplyObject {
        private CalcCrossingsCachedApplyObject() {
        }

        @Override
        CalcCrossingsApplyObject a(IlvTransformer ilvTransformer) {
            CalcCrossingsCachedApplyObject calcCrossingsCachedApplyObject = new CalcCrossingsCachedApplyObject();
            calcCrossingsCachedApplyObject.b = this.b;
            return calcCrossingsCachedApplyObject;
        }

        @Override
        public void apply(IlvGraphic ilvGraphic, Object object) {
            if (ilvGraphic instanceof IlvCrossingAwareLinkImage) {
                IlvLinkPoints ilvLinkPoints = (IlvLinkPoints)object;
                IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = ilvLinkPoints.e();
                IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage2 = (IlvCrossingAwareLinkImage)ilvGraphic;
                if (ilvCrossingAwareLinkImage2.isCrossingEnabled() && IlvCrossingAwareLinkImage.b(ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage2)) {
                    IlvManagerView ilvManagerView = ilvLinkPoints.h();
                    IlvLinkPoints ilvLinkPoints2 = ilvCrossingAwareLinkImage2.a(ilvManagerView);
                    IlvCrossingAwareLinkImage.b(ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage2, ilvLinkPoints, ilvLinkPoints2, this.b);
                }
            }
        }
    }

    private static class CalcCrossingsApplyObject
    implements IlvApplyObject {
        IlvTransformer a;
        IlvCrossingLinkShapePolicy b;

        private CalcCrossingsApplyObject() {
        }

        CalcCrossingsApplyObject a(IlvTransformer ilvTransformer) {
            return null;
        }

        @Override
        public void apply(IlvGraphic ilvGraphic, Object object) {
        }
    }

    static class CrossingApplyContObject
    implements CrossingApplyObject {
        IlvPoint a;
        IlvPoint b;
        IlvTransformer c;

        CrossingApplyContObject() {
        }

        @Override
        public boolean apply(IlvCrossingGraphic ilvCrossingGraphic, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
            return ilvCrossingGraphic.containsAtCrossing(this.a, this.b, this.c, ilvLinkImage, ilvLinkImage2, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f, f2, f3);
        }
    }

    static class CrossingApplyBBoxObject
    implements CrossingApplyObject {
        IlvRect a;
        IlvTransformer b;

        CrossingApplyBBoxObject() {
        }

        @Override
        public boolean apply(IlvCrossingGraphic ilvCrossingGraphic, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
            ilvCrossingGraphic.addCrossingBound(this.a, this.b, ilvLinkImage, ilvLinkImage2, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f, f2, f3);
            return false;
        }
    }

    static class CrossingApplyDrawObject
    implements CrossingApplyObject {
        Graphics a;
        IlvTransformer b;

        CrossingApplyDrawObject() {
        }

        @Override
        public boolean apply(IlvCrossingGraphic ilvCrossingGraphic, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
            ilvCrossingGraphic.drawCrossing(this.a, this.b, ilvLinkImage, ilvLinkImage2, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f, f2, f3);
            return false;
        }
    }

    static interface CrossingApplyObject {
        public boolean apply(IlvCrossingGraphic var1, IlvLinkImage var2, IlvLinkImage var3, IlvPoint var4, IlvPoint var5, IlvPoint var6, IlvPoint var7, float var8, float var9, float var10);
    }
}

