/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.layout;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Insets;
import java.io.IOException;

public class IlvCenteredLayout
implements IlvLayoutManager {
    Insets a;
    IlvAttachable b;
    IlvAttachable c;
    public static final String INNER = "Inner";
    public static final String OUTER = "Outer";

    public IlvCenteredLayout() {
        this.a = new Insets(0, 0, 0, 0);
    }

    public IlvCenteredLayout(IlvInputStream ilvInputStream) throws IlvReadFileException {
        int n = ilvInputStream.readInt("insets.left");
        int n2 = ilvInputStream.readInt("insets.right");
        int n3 = ilvInputStream.readInt("insets.top");
        int n4 = ilvInputStream.readInt("insets.bottom");
        this.a = new Insets(n3, n, n4, n2);
    }

    public IlvCenteredLayout(Insets insets) {
        this.a = insets;
    }

    public void setInsets(Insets insets) {
        this.a = insets;
    }

    public Insets getInsets() {
        return this.a;
    }

    @Override
    public void setConstraints(IlvAttachable ilvAttachable, Object object) {
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
        }
        this.a(ilvAttachable, (String)object);
    }

    private void a(IlvAttachable ilvAttachable, String string) {
        if (string == null) {
            string = OUTER;
        }
        if (OUTER.equals(string)) {
            this.c = ilvAttachable;
        } else if (INNER.equals(string)) {
            this.b = ilvAttachable;
        } else {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
        }
    }

    @Override
    public void removeConstraints(IlvAttachable ilvAttachable) {
        if (ilvAttachable == this.b) {
            this.b = null;
        } else if (ilvAttachable == this.c) {
            this.c = null;
        }
    }

    @Override
    public void layoutGroup(IlvAttachable ilvAttachable) {
        if (this.c == null || this.b == null) {
            return;
        }
        IlvRect ilvRect = this.c.getAttachmentBounds();
        IlvRect ilvRect2 = this.b.getAttachmentBounds();
        this.c.center(ilvRect2, this.a);
        IlvRect ilvRect3 = this.c.getAttachmentBounds();
        IlvPoint ilvPoint = new IlvPoint(ilvRect3.x - ilvRect2.x, ilvRect3.y - ilvRect2.y);
        this.c.move(ilvRect.x, ilvRect.y);
        this.b.move(ilvRect.x - ilvPoint.x, ilvRect.y - ilvPoint.y);
    }

    @Override
    public void attach(IlvAttachable ilvAttachable) {
        IlvAttachable[] ilvAttachableArray = ilvAttachable.getAttachables();
        this.c = ilvAttachableArray[0];
        this.b = ilvAttachableArray[1];
    }

    @Override
    public void reset() {
        this.b = null;
        this.c = null;
    }

    @Override
    public Object clone() {
        try {
            IlvCenteredLayout ilvCenteredLayout = (IlvCenteredLayout)super.clone();
            ilvCenteredLayout.a = (Insets)this.a.clone();
            ilvCenteredLayout.reset();
            return ilvCenteredLayout;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError();
        }
    }

    @Override
    public boolean resizeFirstChildOnly() {
        return true;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("insets.left", this.a.left);
        ilvOutputStream.write("insets.right", this.a.right);
        ilvOutputStream.write("insets.top", this.a.top);
        ilvOutputStream.write("insets.bottom", this.a.bottom);
    }
}

