/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.internal;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IlvLineSegment
extends Line2D
implements Cloneable,
Serializable {
    protected IlvPoint _from;
    protected IlvPoint _to;
    private int a;
    static final long serialVersionUID = 2275642729241063494L;

    protected void transientInit() {
        this.a = (this._from.x == this._to.x ? 128 : 0) | (this._from.y == this._to.y ? 96 : 0);
    }

    public IlvLineSegment(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        this._from = ilvPoint;
        this._to = ilvPoint2;
        this.transientInit();
    }

    public IlvPoint getFrom() {
        return this._from;
    }

    public IlvPoint getTo() {
        return this._to;
    }

    public int getOrientation() {
        return this.a;
    }

    public int getDirection() {
        int n = this.getOrientation();
        if (n == 96) {
            n = this._from.x < this._to.x ? 2 : 1;
        } else if (n == 128) {
            n = this._from.y < this._to.y ? 8 : 4;
        }
        return n;
    }

    public float length() {
        if (this.a == 0) {
            float f = this._to.x - this._from.x;
            float f2 = this._to.y - this._from.y;
            return (float)Math.sqrt(f * f + f2 * f2);
        }
        if (this.a == 96) {
            return Math.abs(this._to.x - this._from.x);
        }
        if (this.a == 128) {
            return Math.abs(this._to.y - this._from.y);
        }
        return 0.0f;
    }

    public IlvPoint nearestTo(IlvPoint ilvPoint) {
        IlvPoint ilvPoint2 = this._from;
        IlvPoint ilvPoint3 = this._to;
        float f = ilvPoint2.x - ilvPoint3.x;
        float f2 = ilvPoint2.y - ilvPoint3.y;
        float f3 = ilvPoint2.x - ilvPoint.x;
        float f4 = ilvPoint2.y - ilvPoint.y;
        float f5 = ilvPoint3.x - ilvPoint.x;
        float f6 = ilvPoint3.y - ilvPoint.y;
        if (this.a == 0) {
            if (f * f3 + f2 * f4 <= 0.0f) {
                return ilvPoint2;
            }
            if (f * f5 + f2 * f6 >= 0.0f) {
                return ilvPoint3;
            }
            float f7 = (f * f3 + f2 * f4) / (f * f + f2 * f2);
            return new IlvPoint(ilvPoint2.x - f7 * f, ilvPoint2.y - f7 * f2);
        }
        if (this.a == 96) {
            if (f * f3 <= 0.0f) {
                return ilvPoint2;
            }
            if (f * f5 >= 0.0f) {
                return ilvPoint3;
            }
            return new IlvPoint(ilvPoint.x, ilvPoint2.y);
        }
        if (this.a == 128) {
            if (f2 * f4 <= 0.0f) {
                return ilvPoint2;
            }
            if (f2 * f6 >= 0.0f) {
                return ilvPoint3;
            }
            return new IlvPoint(ilvPoint2.x, ilvPoint.y);
        }
        return ilvPoint2;
    }

    public float sqdist(IlvPoint ilvPoint) {
        IlvPoint ilvPoint2 = this._from;
        IlvPoint ilvPoint3 = this._to;
        float f = ilvPoint2.x - ilvPoint3.x;
        float f2 = ilvPoint2.y - ilvPoint3.y;
        float f3 = ilvPoint2.x - ilvPoint.x;
        float f4 = ilvPoint2.y - ilvPoint.y;
        float f5 = ilvPoint3.x - ilvPoint.x;
        float f6 = ilvPoint3.y - ilvPoint.y;
        if (this.a == 0) {
            float f7;
            if (f * f3 + f2 * f4 <= 0.0f) {
                return f3 * f3 + f4 * f4;
            }
            if (f * f5 + f2 * f6 >= 0.0f) {
                return f5 * f5 + f6 * f6;
            }
            float f8 = f5 * f5 + f6 * f6;
            float f9 = f3 * f3 + f4 * f4;
            if (f8 < f9) {
                float f10 = f * f5 + f2 * f6;
                f7 = f8 - f10 * f10 / (f * f + f2 * f2);
            } else {
                float f11 = f * f3 + f2 * f4;
                f7 = f9 - f11 * f11 / (f * f + f2 * f2);
            }
            if (f7 < 0.0f) {
                f7 = 0.0f;
            }
            return f7;
        }
        if (this.a == 96) {
            if (f * f3 <= 0.0f) {
                return f3 * f3 + f4 * f4;
            }
            if (f * f5 >= 0.0f) {
                return f5 * f5 + f6 * f6;
            }
            return f6 * f6;
        }
        if (this.a == 128) {
            if (f2 * f4 <= 0.0f) {
                return f3 * f3 + f4 * f4;
            }
            if (f2 * f6 >= 0.0f) {
                return f5 * f5 + f6 * f6;
            }
            return f5 * f5;
        }
        return f3 * f3 + f4 * f4;
    }

    public boolean intersects(float f, float f2, float f3, float f4) {
        float f5;
        IlvPoint ilvPoint = this._from;
        IlvPoint ilvPoint2 = this._to;
        if (this.a == 96) {
            if (ilvPoint.y < f2 || ilvPoint.y > f4) {
                return false;
            }
            return !(ilvPoint.x < f && ilvPoint2.x < f) && (!(ilvPoint.x > f3) || !(ilvPoint2.x > f3));
        }
        if (this.a == 128) {
            if (ilvPoint.x < f || ilvPoint.x > f3) {
                return false;
            }
            return !(ilvPoint.y < f2 && ilvPoint2.y < f2) && (!(ilvPoint.y > f4) || !(ilvPoint2.y > f4));
        }
        if (this.a == 224) {
            return ilvPoint.x >= f && ilvPoint.x <= f3 && ilvPoint.y >= f2 && ilvPoint.y <= f4;
        }
        if (ilvPoint.x < f && ilvPoint2.x < f || ilvPoint.x > f3 && ilvPoint2.x > f3) {
            return false;
        }
        if (ilvPoint.y < f2 && ilvPoint2.y < f2 || ilvPoint.y > f4 && ilvPoint2.y > f4) {
            return false;
        }
        if (ilvPoint.x >= f && ilvPoint.x <= f3 && ilvPoint.y >= f2 && ilvPoint.y <= f4) {
            return true;
        }
        if (ilvPoint2.x >= f && ilvPoint2.x <= f3 && ilvPoint2.y >= f2 && ilvPoint2.y <= f4) {
            return true;
        }
        if (ilvPoint.x >= f && ilvPoint2.x <= f || ilvPoint.x <= f && ilvPoint2.x >= f) {
            if (ilvPoint.x == ilvPoint2.x) {
                return true;
            }
            f5 = ilvPoint.y + (f - ilvPoint.x) * (ilvPoint2.y - ilvPoint.y) / (ilvPoint2.x - ilvPoint.x);
            if (f5 >= f2 && f5 <= f4) {
                return true;
            }
        }
        if (ilvPoint.x >= f3 && ilvPoint2.x <= f3 || ilvPoint.x <= f3 && ilvPoint2.x >= f3) {
            if (ilvPoint.x == ilvPoint2.x) {
                return true;
            }
            f5 = ilvPoint.y + (f3 - ilvPoint.x) * (ilvPoint2.y - ilvPoint.y) / (ilvPoint2.x - ilvPoint.x);
            if (f5 >= f2 && f5 <= f4) {
                return true;
            }
        }
        if (ilvPoint.y >= f2 && ilvPoint2.y <= f2 || ilvPoint.y <= f2 && ilvPoint2.y >= f2) {
            if (ilvPoint.y == ilvPoint2.y) {
                return true;
            }
            f5 = ilvPoint.x + (f2 - ilvPoint.y) * (ilvPoint2.x - ilvPoint.x) / (ilvPoint2.y - ilvPoint.y);
            if (f5 >= f && f5 <= f3) {
                return true;
            }
        }
        if (ilvPoint.y >= f4 && ilvPoint2.y <= f4 || ilvPoint.y <= f4 && ilvPoint2.y >= f4) {
            if (ilvPoint.y == ilvPoint2.y) {
                return true;
            }
            f5 = ilvPoint.x + (f4 - ilvPoint.y) * (ilvPoint2.x - ilvPoint.x) / (ilvPoint2.y - ilvPoint.y);
            if (f5 >= f && f5 <= f3) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5;
        IlvPoint ilvPoint = this._from;
        IlvPoint ilvPoint2 = this._to;
        if (this.a == 96) {
            if ((double)ilvPoint.y < d2 || (double)ilvPoint.y > d4) {
                return false;
            }
            return !((double)ilvPoint.x < d && (double)ilvPoint2.x < d) && (!((double)ilvPoint.x > d3) || !((double)ilvPoint2.x > d3));
        }
        if (this.a == 128) {
            if ((double)ilvPoint.x < d || (double)ilvPoint.x > d3) {
                return false;
            }
            return !((double)ilvPoint.y < d2 && (double)ilvPoint2.y < d2) && (!((double)ilvPoint.y > d4) || !((double)ilvPoint2.y > d4));
        }
        if (this.a == 224) {
            return (double)ilvPoint.x >= d && (double)ilvPoint.x <= d3 && (double)ilvPoint.y >= d2 && (double)ilvPoint.y <= d4;
        }
        if ((double)ilvPoint.x < d && (double)ilvPoint2.x < d || (double)ilvPoint.x > d3 && (double)ilvPoint2.x > d3) {
            return false;
        }
        if ((double)ilvPoint.y < d2 && (double)ilvPoint2.y < d2 || (double)ilvPoint.y > d4 && (double)ilvPoint2.y > d4) {
            return false;
        }
        if ((double)ilvPoint.x >= d && (double)ilvPoint.x <= d3 && (double)ilvPoint.y >= d2 && (double)ilvPoint.y <= d4) {
            return true;
        }
        if ((double)ilvPoint2.x >= d && (double)ilvPoint2.x <= d3 && (double)ilvPoint2.y >= d2 && (double)ilvPoint2.y <= d4) {
            return true;
        }
        if ((double)ilvPoint.x >= d && (double)ilvPoint2.x <= d || (double)ilvPoint.x <= d && (double)ilvPoint2.x >= d) {
            if (ilvPoint.x == ilvPoint2.x) {
                return true;
            }
            d5 = (double)ilvPoint.y + (d - (double)ilvPoint.x) * (double)(ilvPoint2.y - ilvPoint.y) / (double)(ilvPoint2.x - ilvPoint.x);
            if (d5 >= d2 && d5 <= d4) {
                return true;
            }
        }
        if ((double)ilvPoint.x >= d3 && (double)ilvPoint2.x <= d3 || (double)ilvPoint.x <= d3 && (double)ilvPoint2.x >= d3) {
            if (ilvPoint.x == ilvPoint2.x) {
                return true;
            }
            d5 = (double)ilvPoint.y + (d3 - (double)ilvPoint.x) * (double)(ilvPoint2.y - ilvPoint.y) / (double)(ilvPoint2.x - ilvPoint.x);
            if (d5 >= d2 && d5 <= d4) {
                return true;
            }
        }
        if ((double)ilvPoint.y >= d2 && (double)ilvPoint2.y <= d2 || (double)ilvPoint.y <= d2 && (double)ilvPoint2.y >= d2) {
            if (ilvPoint.y == ilvPoint2.y) {
                return true;
            }
            d5 = (double)ilvPoint.x + (d2 - (double)ilvPoint.y) * (double)(ilvPoint2.x - ilvPoint.x) / (double)(ilvPoint2.y - ilvPoint.y);
            if (d5 >= d && d5 <= d3) {
                return true;
            }
        }
        if ((double)ilvPoint.y >= d4 && (double)ilvPoint2.y <= d4 || (double)ilvPoint.y <= d4 && (double)ilvPoint2.y >= d4) {
            if (ilvPoint.y == ilvPoint2.y) {
                return true;
            }
            d5 = (double)ilvPoint.x + (d4 - (double)ilvPoint.y) * (double)(ilvPoint2.x - ilvPoint.x) / (double)(ilvPoint2.y - ilvPoint.y);
            if (d5 >= d && d5 <= d3) {
                return true;
            }
        }
        return false;
    }

    public boolean isParallelTo(IlvLineSegment ilvLineSegment) {
        return this.a == ilvLineSegment.a && (this._to.x - this._from.x) * (ilvLineSegment._to.y - ilvLineSegment._from.y) == (ilvLineSegment._to.x - ilvLineSegment._from.x) * (this._to.y - this._from.y);
    }

    public boolean isParallelVectorTo(IlvLineSegment ilvLineSegment) {
        return this.isParallelTo(ilvLineSegment) && this._from.x < this._to.x == ilvLineSegment._from.x < ilvLineSegment._to.x && this._from.y < this._to.y == ilvLineSegment._from.y < ilvLineSegment._to.y;
    }

    @Override
    public Object clone() {
        IlvLineSegment ilvLineSegment = (IlvLineSegment)super.clone();
        ilvLineSegment._from = this._from;
        ilvLineSegment._to = this._to;
        ilvLineSegment.transientInit();
        return ilvLineSegment;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
        objectOutputStream.writeObject(this._from);
        objectOutputStream.writeObject(this._to);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte by = objectInputStream.readByte();
        if (by != 1) {
            throw new InvalidClassException("Unsupported version " + by + " in readObject of class " + this.getClass());
        }
        this._from = (IlvPoint)objectInputStream.readObject();
        this._to = (IlvPoint)objectInputStream.readObject();
        this.transientInit();
    }

    @Override
    public double getX1() {
        return this._from.x;
    }

    @Override
    public double getY1() {
        return this._from.y;
    }

    @Override
    public double getX2() {
        return this._to.x;
    }

    @Override
    public double getY2() {
        return this._to.y;
    }

    @Override
    public Point2D getP1() {
        return this._from;
    }

    @Override
    public Point2D getP2() {
        return this._to;
    }

    @Override
    public void setLine(double d, double d2, double d3, double d4) {
        this._from = new IlvPoint((float)d, (float)d2);
        this._to = new IlvPoint((float)d3, (float)d4);
    }

    @Override
    public Rectangle2D getBounds2D() {
        float f;
        float f2;
        float f3;
        float f4;
        IlvPoint ilvPoint = this._from;
        IlvPoint ilvPoint2 = this._to;
        float f5 = ilvPoint.x;
        float f6 = ilvPoint.y;
        float f7 = ilvPoint2.x;
        float f8 = ilvPoint2.y;
        if (f5 <= f7) {
            f4 = f5;
            f3 = f7 - f5;
        } else {
            f4 = f7;
            f3 = f5 - f7;
        }
        if (f6 <= f8) {
            f2 = f6;
            f = f8 - f6;
        } else {
            f2 = f8;
            f = f6 - f8;
        }
        return new IlvRect(f4, f2, f3, f);
    }

    public String toString() {
        return this.getClass().getName() + "[(" + this._from.x + "," + this._from.y + ")-(" + this._to.x + "," + this._to.y + ")]";
    }
}

