/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.decoration;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class IlvDiamond
extends IlvGraphic {
    private IlvRect a;
    private Color b;
    private Color c;
    private int d = 2;
    private GeneralPath e;
    private Shape f;
    private Stroke g = new BasicStroke(1.0f);
    private static int h = 4;

    public IlvDiamond() {
        this(new IlvRect(100.0f, 100.0f, 50.0f, 50.0f));
    }

    public IlvDiamond(IlvRect ilvRect) {
        this.a(ilvRect);
    }

    public IlvDiamond(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a(ilvInputStream.readRect("definitionRect"));
        this.setBackground(ilvInputStream.readColor("background"));
        this.setForeground(ilvInputStream.readColor("foreground"));
        this.setFillOn(ilvInputStream.readBoolean("fillOn"));
        try {
            this.setStroke(ilvInputStream.readStroke("stroke"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvDiamond(IlvDiamond ilvDiamond) {
        super(ilvDiamond);
        this.a(ilvDiamond.a);
        this.setBackground(ilvDiamond.getBackground());
        this.setForeground(ilvDiamond.getForeground());
        this.setFillOn(ilvDiamond.isFillOn());
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(this.a);
            this.a((IlvTransformer)null);
        }
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        Rectangle2D rectangle2D = this.f.getBounds2D();
        IlvRect ilvRect = new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(ilvRect);
        }
        return ilvRect;
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        return this.e.contains(ilvPoint) || this.f.contains(ilvPoint);
    }

    @Override
    public IlvGraphic copy() {
        return new IlvDiamond(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = this.e;
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            object = new AffineTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
            shape = this.e.createTransformedShape((AffineTransform)object);
        }
        object = graphics2D.getStroke();
        try {
            if (this.g != null) {
                graphics2D.setStroke(this.g);
            }
            if (this.isFillOn()) {
                graphics.setColor(this.getBackground());
                graphics2D.fill(shape);
            }
            graphics.setColor(this.getForeground());
            graphics2D.draw(shape);
        }
        finally {
            graphics2D.setStroke((Stroke)object);
        }
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.c;
        this.c = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        if (this.c == null) {
            return Color.black;
        }
        return this.c;
    }

    @Override
    public void setBackground(Color color) {
        Color color2 = this.b;
        this.b = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getBackground() {
        if (this.b == null) {
            return Color.black;
        }
        return this.b;
    }

    public boolean isFillOn() {
        return (this.d & h) != 0;
    }

    @Override
    public void setFillOn(boolean bl) {
        this.d = bl ? (this.d |= h) : (this.d &= ~h);
    }

    public IlvRect getDefinitionRect() {
        return new IlvRect(this.a);
    }

    private void a(IlvRect ilvRect) {
        this.a = ilvRect;
        this.a((IlvTransformer)null);
    }

    public void setStroke(Stroke stroke) {
        this.g = stroke;
        this.a();
    }

    public Stroke getStroke() {
        return this.g;
    }

    private void a(IlvTransformer ilvTransformer) {
        if (ilvTransformer == null) {
            float f = (float)this.a.getCenterX();
            float f2 = (float)this.a.getY();
            float f3 = (float)this.a.getMaxX();
            float f4 = (float)this.a.getCenterY();
            float f5 = (float)this.a.getCenterX();
            float f6 = (float)this.a.getMaxY();
            float f7 = (float)this.a.getX();
            float f8 = (float)this.a.getCenterY();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f, f2);
            generalPath.lineTo(f3, f4);
            generalPath.lineTo(f5, f6);
            generalPath.lineTo(f7, f8);
            generalPath.closePath();
            this.e = generalPath;
        } else {
            AffineTransform affineTransform = new AffineTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
            this.e.transform(affineTransform);
        }
        this.a();
    }

    private void a() {
        this.f = this.g.createStrokedShape(this.e);
    }

    public void setWidth(float f) {
        this.a.width = f;
        this.a((IlvTransformer)null);
    }

    public float getWidth() {
        return this.a.width;
    }

    public void setHeight(float f) {
        this.a.height = f;
        this.a((IlvTransformer)null);
    }

    public float getHeight() {
        return this.a.height;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("definitionRect", this.a);
        ilvOutputStream.write("background", this.getBackground());
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("fillOn", this.isFillOn());
        if (this.g instanceof BasicStroke) {
            ilvOutputStream.write("stroke", (BasicStroke)this.g);
        }
    }
}

