/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvShadowRectangle;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.text.IlvBidiUtil;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;

public class IlvShadowLabel
extends IlvShadowRectangle
implements IlvFontInterface,
IlvLabelInterface {
    private String a = null;
    private Font b = IlvToolkit.defaultFont;
    private int c;
    private ComponentOrientation d;
    private int e;
    private IlvRect f;

    public IlvShadowLabel() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f), "", 2.0f, 10);
    }

    public IlvShadowLabel(IlvRect ilvRect, String string, float f, int n) {
        super(ilvRect, f, n);
        this.c = 513;
        this.setLabel(string);
        this.invalidateBidiCache();
    }

    public IlvShadowLabel(IlvPoint ilvPoint, String string, float f, float f2, float f3, int n) {
        super(new IlvRect(ilvPoint.x, ilvPoint.y, 10.0f, 10.0f), f, n);
        this.c = 513;
        this.setLabel(string);
        this.fitToLabel(f2, f3);
        this.invalidateBidiCache();
    }

    public IlvShadowLabel(IlvShadowLabel ilvShadowLabel) {
        super(ilvShadowLabel);
        this.c = ilvShadowLabel.c;
        this.setLabel(ilvShadowLabel.getLabel());
        this.setFont(ilvShadowLabel.getFont());
        this.setAntialiasing(ilvShadowLabel.isAntialiasing());
        this.invalidateBidiCache();
    }

    public IlvShadowLabel(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setLabel(ilvInputStream.readString("label"));
        this.setFont(ilvInputStream.readFont("font"));
        try {
            this.setAntialiasing(ilvInputStream.readBoolean("antialiasing"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.invalidateBidiCache();
    }

    @Override
    public IlvGraphic copy() {
        return new IlvShadowLabel(this);
    }

    @Override
    public String getLabel() {
        return this.a;
    }

    @Override
    public void setLabel(String string) {
        if (this.a == string && this.f != null) {
            return;
        }
        if (string == null || string == null || !string.equals(this.a)) {
            this.a = string;
            this.d();
        }
    }

    public void fitToLabel(float f, float f2) {
        this.drawrect.resize(this.f.width + 2.0f * f, this.f.height + 2.0f * f2);
    }

    @Override
    public Font getFont() {
        return this.b;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (font == this.b) {
            return;
        }
        this.b = font;
        this.d();
    }

    @Override
    public ComponentOrientation getComponentOrientation() {
        if (this.d == null) {
            this.d = super.getComponentOrientation();
        }
        return this.d;
    }

    @Override
    public void setBaseTextDirection(int n) {
        if (!IlvBidiUtil.isAdvancedBidiOn()) {
            return;
        }
        if (n == this.c) {
            return;
        }
        IlvBidiUtil.checkBaseTextDirectionChoice(n, false, false);
        int n2 = this.getResolvedBaseTextDirection();
        this.c = n;
        this.e = 0;
        int n3 = this.getResolvedBaseTextDirection();
        if (n2 != n3) {
            this.baseTextDirectionChanged(n2, n3);
        }
    }

    @Override
    public int getBaseTextDirection() {
        return this.c;
    }

    @Override
    public int getResolvedBaseTextDirection() {
        if (this.e == 0) {
            this.e = super.getResolvedBaseTextDirection();
        }
        return this.e;
    }

    @Override
    protected void invalidateBidiCache() {
        this.d = null;
        this.e = 0;
    }

    @Override
    public boolean usesBidiMarkers() {
        return IlvBidiUtil.isStringRTL(this, this.a, this.getComponentOrientation());
    }

    @Override
    public boolean isBaseTextDirectionSensitive() {
        return IlvBidiUtil.isAdvancedBidiOn();
    }

    @Override
    public void baseTextDirectionChanged(int n, int n2) {
        super.baseTextDirectionChanged(n, n2);
        this.d();
    }

    @Override
    public void componentOrientationChanged(ComponentOrientation componentOrientation, ComponentOrientation componentOrientation2) {
        super.componentOrientationChanged(componentOrientation, componentOrientation2);
        if (this.getResolvedBaseTextDirection() == 527) {
            this.d();
        }
    }

    public final boolean isAntialiasing() {
        return this.getProperty("__ILVAntialiasing") != null;
    }

    public final void setAntialiasing(boolean bl) {
        if (bl == this.isAntialiasing()) {
            return;
        }
        this.setProperty("__ILVAntialiasing", bl ? new Boolean(true) : null);
        this.d();
    }

    @Override
    public boolean supportMultiline() {
        return false;
    }

    @Override
    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        return this.boundingBox(ilvTransformer);
    }

    private void d() {
        if (this.b != null) {
            this.f = IlvGraphicUtil.GetStringBounds(this, this.getLabel(), this.getFont(), this.isAntialiasing());
        }
    }

    public void drawLabel(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
        Rectangle rectangle;
        String string = this.getLabel();
        if (string == null) {
            return;
        }
        Shape shape = graphics.getClip();
        Rectangle rectangle2 = shape != null ? shape.getBounds() : null;
        Rectangle rectangle3 = rectangle = rectangle2 != null ? rectangle2.intersection(new Rectangle((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height)) : new Rectangle((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        if (rectangle.width != 0 && rectangle.height != 0) {
            boolean bl = this.isAntialiasing();
            Font font = this.getFont();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            IlvRect ilvRect2 = this.f;
            int n = (int)Math.floor(ilvRect.x) + ((int)Math.floor(ilvRect.width) - (int)Math.floor(ilvRect2.width)) / 2;
            int n2 = (int)Math.floor(ilvRect.y) + ((int)Math.floor(ilvRect.height) + (int)Math.floor(ilvRect2.height)) / 2;
            graphics.setColor(this.getForeground());
            graphics.setFont(font);
            IlvGraphicUtil.DrawString(this, graphics, string, n, n2, bl);
            graphics.setClip(shape);
        }
    }

    @Override
    protected void drawContent(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
        this.drawLabel(graphics, ilvRect, ilvTransformer);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("label", this.getLabel());
        ilvOutputStream.write("font", this.getFont());
        if (this.isAntialiasing()) {
            ilvOutputStream.write("antialiasing", this.isAntialiasing());
        }
    }

    @Override
    public String toString() {
        String string = this.getLabel();
        return super.toString() + (string != null ? " Label: " + string : " (no label)");
    }
}

