/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvTextSelection;
import ilog.views.internal.IlvUtility;
import ilog.views.util.text.IlvAttributedStringUtil;
import ilog.views.util.text.IlvBidiUtil;
import ilog.views.util.text.IlvWrappedICUBreakIterator;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class IlvLayoutTextRenderer
implements IlvText.Renderer {
    private transient boolean a = false;
    private transient Rectangle2D b;
    private transient Rectangle2D c;
    private transient float d;
    private transient int e;
    private transient TextLayout[] f;
    private transient FontRenderContext g = null;
    private transient TextLayout h = null;
    private transient boolean i = false;
    private transient InfoForFRCDependentTreatment j;
    private transient Integer[] k;
    private IlvText l;
    boolean m = false;

    public IlvLayoutTextRenderer(IlvText ilvText) {
        this.l = ilvText;
        this.j = IlvText.IsTransformerDependentRendering() ? new InfoForFRCDependentTreatment() : null;
    }

    @Override
    public Shape getCaretShape(IlvTextSelection.Range range, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2;
        TextLayout textLayout;
        double d;
        if ((this.l.getWrappingMode() & 2) == 2) {
            return null;
        }
        double d2 = this.l.getAnchorPoint().x;
        double d3 = d = (double)this.l.getAnchorPoint().y;
        this.j();
        Path2D path2D = null;
        this.c();
        int n = this.e;
        if (n == 0) {
            return null;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        switch (this.l.getAnchorPosition()) {
            case 256: {
                d2 -= this.f[0].isLeftToRight() ? 0.0 : (double)this.d;
                break;
            }
            case 257: {
                d2 -= this.f[0].isLeftToRight() ? (double)this.d : 0.0;
                break;
            }
            case 16: {
                d2 -= this.b.getWidth() / 2.0;
                d -= this.b.getHeight() / 2.0 - (double)this.f[0].getAscent();
                break;
            }
            case 2: {
                d2 -= (double)this.d;
            }
        }
        double d6 = this.l.getRotationAlignmentThresholdAngle();
        double d7 = 0.0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Object object;
            textLayout = this.f[i];
            if (textLayout == null) continue;
            d5 = 0.0;
            d4 = this.a(textLayout);
            if (i > 0) {
                d += (double)textLayout.getAscent();
            }
            if (d6 > 0.0 && this.e > 0) {
                IlvPoint ilvPoint = new IlvPoint(0.0f, (float)d3);
                IlvPoint ilvPoint2 = new IlvPoint(0.0f, (float)d);
                object = this.l.getTransformer();
                IlvTransformer ilvTransformer3 = null;
                if (this.l.getRotationAlignmentAngle() != 0.0f) {
                    ilvTransformer3 = new IlvTransformer(ilvPoint, this.l.getRotationAlignmentAngle());
                }
                if (object != null) {
                    ((IlvTransformer)object).apply(ilvPoint);
                    ((IlvTransformer)object).apply(ilvPoint2);
                }
                if (ilvTransformer3 != null) {
                    ilvTransformer3.inverse(ilvPoint);
                    ilvTransformer3.inverse(ilvPoint2);
                }
                if (!bl && d != d3) {
                    for (d7 = Math.atan2(ilvPoint2.y - ilvPoint.y, ilvPoint2.x - ilvPoint.x) / Math.PI * 180.0; d7 < 0.0; d7 += 180.0) {
                    }
                    while (d7 > 180.0) {
                        d7 -= 180.0;
                    }
                    bl = true;
                }
                if (d7 < 90.0 - d6 || d7 > 90.0 + d6) {
                    if (Math.abs(ilvPoint.x - ilvPoint2.x) > 0.0f) {
                        float f = ilvPoint2.x - ilvPoint.x;
                        float f2 = ilvPoint2.y - ilvPoint.y;
                        ilvPoint2.y = ilvPoint.y;
                        ilvPoint2.x += f2 * f2 / f;
                    }
                } else if (Math.abs(ilvPoint.y - ilvPoint2.y) > 0.0f) {
                    float f = ilvPoint2.y - ilvPoint.y;
                    float f3 = ilvPoint2.x - ilvPoint.x;
                    ilvPoint2.x = ilvPoint.x;
                    ilvPoint2.y += f3 * f3 / f;
                }
                if (ilvTransformer3 != null) {
                    ilvTransformer3.apply(ilvPoint2);
                }
                if (object != null) {
                    ((IlvTransformer)object).inverse(ilvPoint2);
                }
                d4 += (double)ilvPoint2.x;
                d5 += (double)ilvPoint2.y - d;
            }
            int n2 = this.k[i];
            int n3 = this.a(i) + (this.usesMarkers() ? 1 : 0);
            object = null;
            int n4 = textLayout.getCharacterCount() - (this.usesMarkers() ? 1 : 0);
            if (range.isCollapsed()) {
                if (range.from >= n2 && range.from <= n3) {
                    object = textLayout.getCaretShapes(Math.min(range.from - n2, n4))[0];
                }
            } else {
                int n5 = Math.max(range.from - n2, 0);
                int n6 = Math.min(n4, range.to - n2);
                if (n5 >= 0 && n5 < n6) {
                    object = textLayout.getLogicalHighlightShape(n5, n6);
                }
            }
            if (object != null) {
                AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, d2 + d4, d + d5);
                object = affineTransform.createTransformedShape((Shape)object);
                if (path2D == null) {
                    path2D = new GeneralPath();
                }
                path2D.append((Shape)object, false);
                if (range.isCollapsed()) break;
            }
            d += (double)(textLayout.getDescent() + this.b(textLayout));
        }
        if ((ilvTransformer2 = this.l.getTransformer()) != null) {
            ilvTransformer2.compose(ilvTransformer);
        } else {
            ilvTransformer2 = ilvTransformer;
        }
        textLayout = ilvTransformer2 != null ? IlvUtility.IlvToJava2DTransformer(ilvTransformer2, null) : null;
        if (textLayout != null & path2D != null) {
            return path2D.createTransformedShape((AffineTransform)((Object)textLayout));
        }
        return path2D;
    }

    private int a(int n) {
        if (n < this.k.length - 1) {
            return this.k[n + 1] - 1;
        }
        return this.l.getLabel().length();
    }

    @Override
    public int pickCharacter(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        double d;
        double d2 = this.l.getAnchorPoint().x;
        double d3 = d = (double)this.l.getAnchorPoint().y;
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvPoint);
        }
        if (this.l.getTransformer() != null) {
            this.l.getTransformer().inverse(ilvPoint);
        }
        this.j();
        this.c();
        int n = this.e;
        if (n == 0) {
            return -1;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        switch (this.l.getAnchorPosition()) {
            case 256: {
                d2 -= this.f[0].isLeftToRight() ? 0.0 : (double)this.d;
                break;
            }
            case 257: {
                d2 -= this.f[0].isLeftToRight() ? (double)this.d : 0.0;
                break;
            }
            case 16: {
                d2 -= this.b.getWidth() / 2.0;
                d -= this.b.getHeight() / 2.0 - (double)this.f[0].getAscent();
                break;
            }
            case 2: {
                d2 -= (double)this.d;
            }
        }
        double d6 = this.l.getRotationAlignmentThresholdAngle();
        double d7 = 0.0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2;
            Object object;
            TextLayout textLayout = this.f[i];
            if (textLayout == null) continue;
            d4 = this.a(textLayout);
            d5 = 0.0;
            if (i > 0) {
                d += (double)textLayout.getAscent();
            }
            if (d6 > 0.0 && this.e > 0) {
                float f;
                float f2;
                IlvPoint ilvPoint2 = new IlvPoint(0.0f, (float)d3);
                object = new IlvPoint(0.0f, (float)d);
                IlvTransformer ilvTransformer2 = this.l.getTransformer();
                IlvTransformer ilvTransformer3 = null;
                if (this.l.getRotationAlignmentAngle() != 0.0f) {
                    ilvTransformer3 = new IlvTransformer(ilvPoint2, this.l.getRotationAlignmentAngle());
                }
                if (ilvTransformer2 != null) {
                    ilvTransformer2.apply(ilvPoint2);
                    ilvTransformer2.apply((IlvPoint)object);
                }
                if (ilvTransformer3 != null) {
                    ilvTransformer3.inverse(ilvPoint2);
                    ilvTransformer3.inverse((IlvPoint)object);
                }
                if (!bl && d != d3) {
                    for (d7 = Math.atan2(((Point2D.Float)object).y - ilvPoint2.y, ((Point2D.Float)object).x - ilvPoint2.x) / Math.PI * 180.0; d7 < 0.0; d7 += 180.0) {
                    }
                    while (d7 > 180.0) {
                        d7 -= 180.0;
                    }
                    bl = true;
                }
                if (d7 < 90.0 - d6 || d7 > 90.0 + d6) {
                    if (Math.abs(ilvPoint2.x - ((Point2D.Float)object).x) > 0.0f) {
                        f2 = ((Point2D.Float)object).x - ilvPoint2.x;
                        f = ((Point2D.Float)object).y - ilvPoint2.y;
                        ((Point2D.Float)object).y = ilvPoint2.y;
                        ((Point2D.Float)object).x += f * f / f2;
                    }
                } else if (Math.abs(ilvPoint2.y - ((Point2D.Float)object).y) > 0.0f) {
                    f2 = ((Point2D.Float)object).y - ilvPoint2.y;
                    f = ((Point2D.Float)object).x - ilvPoint2.x;
                    ((Point2D.Float)object).x = ilvPoint2.x;
                    ((Point2D.Float)object).y += f * f / f2;
                }
                if (ilvTransformer3 != null) {
                    ilvTransformer3.apply((IlvPoint)object);
                }
                if (ilvTransformer2 != null) {
                    ilvTransformer2.inverse((IlvPoint)object);
                }
                d4 += (double)((Point2D.Float)object).x;
                d5 += (double)((Point2D.Float)object).y - d;
            }
            int n3 = textLayout.getCharacterCount();
            if ((double)ilvPoint.y >= d - (double)textLayout.getAscent() && (double)ilvPoint.y <= d + (double)textLayout.getDescent() && (n2 = ((TextHitInfo)(object = textLayout.hitTestChar((float)((double)ilvPoint.x - d2 - d4), (float)((double)ilvPoint.y - d - d5)))).getInsertionIndex()) >= 0 && n2 <= n3) {
                if (this.a()) {
                    return this.lineOffset(i);
                }
                return this.lineOffset(i) + n2;
            }
            d += (double)(textLayout.getDescent() + this.b(textLayout));
        }
        return -1;
    }

    boolean a() {
        return this.l.getLabel() == null || this.l.getLabel().length() == 0;
    }

    @Override
    public int lineCount() {
        this.j();
        return this.k.length;
    }

    @Override
    public int lineOffset(int n) {
        this.j();
        if (n < 0 || n >= this.lineCount()) {
            return -1;
        }
        return this.k[n];
    }

    @Override
    public boolean hasEllipsis() {
        this.j();
        return this.i;
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        AffineTransform affineTransform;
        IlvTransformer ilvTransformer2;
        this.j();
        graphics = graphics.create();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.l.isAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.l.isFractionalMetrics()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        if ((ilvTransformer2 = this.l.getTransformer()) != null) {
            ilvTransformer2.compose(ilvTransformer);
        } else {
            ilvTransformer2 = ilvTransformer;
        }
        AffineTransform affineTransform2 = affineTransform = ilvTransformer2 != null ? IlvUtility.IlvToJava2DTransformer(ilvTransformer2, null) : null;
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        graphics2D.setFont(this.l.getFont());
        TextLayout[] textLayoutArray = this.f;
        if (this.j != null) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            this.f = this.a(fontRenderContext);
        }
        if (this.e > 0) {
            if (this.e > 1) {
                this.b(graphics2D, this.l.ag.x, this.l.ag.y);
            } else {
                this.a(graphics2D, this.l.ag.x, this.l.ag.y);
            }
        }
        if (this.j != null) {
            this.f = textLayoutArray;
        }
        graphics.dispose();
    }

    private static BasicStroke a(IlvText ilvText) {
        if (ilvText.getOutlineMode() == 0) {
            return null;
        }
        return new BasicStroke(ilvText.getOutlineThickness(), 1, 1);
    }

    private static void a(Graphics2D graphics2D, IlvText ilvText, TextLayout textLayout, float f, float f2) {
        Shape shape = null;
        switch (ilvText.getOutlineMode()) {
            case 2048: 
            case 4096: 
            case 6144: {
                shape = textLayout.getOutline(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, f, f2));
            }
        }
        if (shape == null) {
            graphics2D.setColor(ilvText.getForeground());
            textLayout.draw(graphics2D, f, f2);
            return;
        }
        if (ilvText.getOutlineMode() == 2048) {
            graphics2D.setColor(ilvText.getOutlineColor());
            graphics2D.draw(shape);
            return;
        }
        if (ilvText.a() != null) {
            switch (ilvText.getOutlineMode()) {
                case 4096: {
                    graphics2D.setColor(ilvText.getOutlineColor());
                    graphics2D.draw(shape);
                    graphics2D.setColor(ilvText.getForeground());
                    textLayout.draw(graphics2D, f, f2);
                    break;
                }
                case 6144: {
                    graphics2D.setColor(ilvText.getForeground());
                    textLayout.draw(graphics2D, f, f2);
                    graphics2D.setColor(ilvText.getOutlineColor());
                    graphics2D.draw(shape);
                }
            }
        } else {
            switch (ilvText.getOutlineMode()) {
                case 4096: {
                    graphics2D.setColor(ilvText.getOutlineColor());
                    graphics2D.draw(shape);
                    graphics2D.setPaint(ilvText.getForeground());
                    graphics2D.fill(shape);
                    break;
                }
                case 6144: {
                    graphics2D.setPaint(ilvText.getForeground());
                    graphics2D.fill(shape);
                    graphics2D.setColor(ilvText.getOutlineColor());
                    graphics2D.draw(shape);
                }
            }
        }
    }

    private void a(Graphics2D graphics2D, double d, double d2) {
        TextLayout textLayout = this.f[0];
        if (textLayout == null) {
            return;
        }
        switch (this.l.getAnchorPosition()) {
            case 256: {
                d -= textLayout.isLeftToRight() ? 0.0 : (double)textLayout.getAdvance();
                break;
            }
            case 257: {
                d -= textLayout.isLeftToRight() ? (double)textLayout.getAdvance() : 0.0;
                break;
            }
            case 16: {
                d -= this.b().getWidth() / 2.0;
                d2 += (double)((textLayout.getAscent() - textLayout.getDescent()) / 2.0f);
                break;
            }
            case 2: {
                d -= (double)textLayout.getAdvance();
            }
        }
        if (this.l.getOutlineMode() == 0) {
            IlvLayoutTextRenderer.a(graphics2D, this.l, textLayout, (float)d, (float)d2);
        } else {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(IlvLayoutTextRenderer.a(this.l));
            IlvLayoutTextRenderer.a(graphics2D, this.l, textLayout, (float)d, (float)d2);
            graphics2D.setStroke(stroke);
        }
    }

    private void b(Graphics2D graphics2D, double d, double d2) {
        this.c();
        int n = this.e;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = d2;
        switch (this.l.getAnchorPosition()) {
            case 256: {
                d -= this.f[0].isLeftToRight() ? 0.0 : (double)this.d;
                break;
            }
            case 257: {
                d -= this.f[0].isLeftToRight() ? (double)this.d : 0.0;
                break;
            }
            case 16: {
                d -= this.b.getWidth() / 2.0;
                d2 -= this.b.getHeight() / 2.0 - (double)this.f[0].getAscent();
                break;
            }
            case 2: {
                d -= (double)this.d;
            }
        }
        Stroke stroke = null;
        if (this.l.getOutlineMode() != 0) {
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(IlvLayoutTextRenderer.a(this.l));
        }
        double d6 = this.l.getRotationAlignmentThresholdAngle();
        double d7 = 0.0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            TextLayout textLayout = this.f[i];
            if (textLayout == null) continue;
            d4 = 0.0;
            d3 = this.a(textLayout);
            if (i > 0) {
                d2 += (double)textLayout.getAscent();
            }
            if (d6 > 0.0 && this.e > 0) {
                float f;
                float f2;
                IlvPoint ilvPoint = new IlvPoint(0.0f, (float)d5);
                IlvPoint ilvPoint2 = new IlvPoint(0.0f, (float)d2);
                IlvTransformer ilvTransformer = this.l.getTransformer();
                IlvTransformer ilvTransformer2 = null;
                if (this.l.getRotationAlignmentAngle() != 0.0f) {
                    ilvTransformer2 = new IlvTransformer(ilvPoint, this.l.getRotationAlignmentAngle());
                }
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint);
                    ilvTransformer.apply(ilvPoint2);
                }
                if (ilvTransformer2 != null) {
                    ilvTransformer2.inverse(ilvPoint);
                    ilvTransformer2.inverse(ilvPoint2);
                }
                if (!bl && d2 != d5) {
                    for (d7 = Math.atan2(ilvPoint2.y - ilvPoint.y, ilvPoint2.x - ilvPoint.x) / Math.PI * 180.0; d7 < 0.0; d7 += 180.0) {
                    }
                    while (d7 > 180.0) {
                        d7 -= 180.0;
                    }
                    bl = true;
                }
                if (d7 < 90.0 - d6 || d7 > 90.0 + d6) {
                    if (Math.abs(ilvPoint.x - ilvPoint2.x) > 0.0f) {
                        f2 = ilvPoint2.x - ilvPoint.x;
                        f = ilvPoint2.y - ilvPoint.y;
                        ilvPoint2.y = ilvPoint.y;
                        ilvPoint2.x += f * f / f2;
                    }
                } else if (Math.abs(ilvPoint.y - ilvPoint2.y) > 0.0f) {
                    f2 = ilvPoint2.y - ilvPoint.y;
                    f = ilvPoint2.x - ilvPoint.x;
                    ilvPoint2.x = ilvPoint.x;
                    ilvPoint2.y += f * f / f2;
                }
                if (ilvTransformer2 != null) {
                    ilvTransformer2.apply(ilvPoint2);
                }
                if (ilvTransformer != null) {
                    ilvTransformer.inverse(ilvPoint2);
                }
                d3 += (double)ilvPoint2.x;
                d4 += (double)ilvPoint2.y - d2;
            }
            IlvLayoutTextRenderer.a(graphics2D, this.l, textLayout, (float)(d + d3), (float)(d2 + d4));
            d2 += (double)(textLayout.getDescent() + this.b(textLayout));
        }
        if (this.l.getOutlineMode() != 0) {
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    public final Rectangle2D getBounds() {
        this.j();
        this.c();
        double d = this.l.getRotationAlignmentThresholdAngle();
        if (d > 0.0 && this.e > 1) {
            this.d();
            return this.c;
        }
        return this.b;
    }

    private final Rectangle2D b() {
        this.j();
        this.c();
        return this.b;
    }

    private void c() {
        if (this.b != null) {
            return;
        }
        this.b = this.j != null ? this.a(false) : this.b(false);
    }

    private void d() {
        if (this.c != null) {
            return;
        }
        this.c = this.j != null ? this.a(true) : this.b(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle2D a(boolean bl) {
        Rectangle2D rectangle2D = this.b(bl);
        AffineTransform affineTransform = new AffineTransform(100.0f, 0.0f, 0.0f, 100.0f, 0.0f, 0.0f);
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, this.l.isAntialiasing(), this.l.isFractionalMetrics());
        TextLayout[] textLayoutArray = this.f;
        try {
            this.f = this.a(fontRenderContext);
            Rectangle2D rectangle2D2 = this.b(bl);
            rectangle2D = rectangle2D.createUnion(rectangle2D2);
        }
        finally {
            this.f = textLayoutArray;
        }
        return rectangle2D;
    }

    private Rectangle2D b(boolean bl) {
        if (bl) {
            return this.f();
        }
        return this.e();
    }

    private Rectangle2D e() {
        TextLayout textLayout;
        this.d = 0.0f;
        int n = this.e;
        for (int i = 0; i < n; ++i) {
            textLayout = this.f[i];
            if (textLayout == null) continue;
            this.d = Math.max(this.d, textLayout.getAdvance());
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            textLayout = this.f[i];
            if (textLayout == null) continue;
            if (i == 0) {
                d3 = Math.min(d3, (double)(-textLayout.getAscent()));
            } else {
                d5 += (double)textLayout.getAscent();
            }
            Rectangle2D rectangle2D = textLayout.getBounds();
            d = Math.min(d, rectangle2D.getX());
            d2 = Math.max(d2, rectangle2D.getX() + rectangle2D.getWidth());
            d3 = Math.min(d3, d5 + rectangle2D.getY());
            d4 = Math.max(d4, d5 + rectangle2D.getY() + rectangle2D.getHeight());
            d5 += (double)(textLayout.getDescent() + this.b(textLayout));
        }
        d2 = Math.max(d2, (double)this.d);
        d4 = Math.max(d4, d5);
        double d6 = d2 - d;
        double d7 = d4 - d3;
        d += (double)this.l.ag.x;
        d3 += (double)this.l.ag.y;
        TextLayout textLayout2 = textLayout = this.f.length == 0 ? null : this.f[0];
        if (textLayout != null) {
            switch (this.l.getAnchorPosition()) {
                case 256: {
                    d -= textLayout.isLeftToRight() ? 0.0 : (double)this.d;
                    break;
                }
                case 257: {
                    d -= textLayout.isLeftToRight() ? (double)this.d : 0.0;
                    break;
                }
                case 16: {
                    if (n == 1) {
                        d -= d6 / 2.0;
                        d3 += (double)((textLayout.getAscent() - textLayout.getDescent()) / 2.0f);
                        break;
                    }
                    d -= d6 / 2.0;
                    d3 -= d7 / 2.0 - (double)this.f[0].getAscent();
                    break;
                }
                case 2: {
                    d -= (double)this.d;
                }
            }
        }
        return new Rectangle2D.Double(d, d3, d6, d7);
    }

    private Rectangle2D f() {
        TextLayout textLayout;
        if (this.b == null) {
            throw new RuntimeException("Illegal situation");
        }
        double d = this.l.getRotationAlignmentThresholdAngle();
        double d2 = 0.0;
        boolean bl = false;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n = this.e;
        for (int i = 0; i < n; ++i) {
            float f;
            float f2;
            textLayout = this.f[i];
            if (textLayout == null) continue;
            if (i == 0) {
                d5 = Math.min(d5, (double)(-textLayout.getAscent()));
            } else {
                d7 += (double)textLayout.getAscent();
            }
            Rectangle2D rectangle2D = textLayout.getBounds();
            double d8 = this.a(textLayout);
            double d9 = 0.0;
            IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
            IlvPoint ilvPoint2 = new IlvPoint(0.0f, (float)d7);
            IlvTransformer ilvTransformer = this.l.getTransformer();
            IlvTransformer ilvTransformer2 = null;
            if (this.l.getRotationAlignmentAngle() != 0.0f) {
                ilvTransformer2 = new IlvTransformer(ilvPoint, this.l.getRotationAlignmentAngle());
            }
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
                ilvTransformer.apply(ilvPoint2);
            }
            if (ilvTransformer2 != null) {
                ilvTransformer2.inverse(ilvPoint);
                ilvTransformer2.inverse(ilvPoint2);
            }
            if (!bl && d7 != 0.0) {
                for (d2 = Math.atan2(ilvPoint2.y - ilvPoint.y, ilvPoint2.x - ilvPoint.x) / Math.PI * 180.0; d2 < 0.0; d2 += 180.0) {
                }
                while (d2 > 180.0) {
                    d2 -= 180.0;
                }
                bl = true;
            }
            if (d2 < 90.0 - d || d2 > 90.0 + d) {
                if (Math.abs(ilvPoint.x - ilvPoint2.x) > 0.0f) {
                    f2 = ilvPoint2.x - ilvPoint.x;
                    f = ilvPoint2.y - ilvPoint.y;
                    ilvPoint2.y = ilvPoint.y;
                    ilvPoint2.x += f * f / f2;
                }
            } else if (Math.abs(ilvPoint.y - ilvPoint2.y) > 0.0f) {
                f2 = ilvPoint2.y - ilvPoint.y;
                f = ilvPoint2.x - ilvPoint.x;
                ilvPoint2.x = ilvPoint.x;
                ilvPoint2.y += f * f / f2;
            }
            if (ilvTransformer2 != null) {
                ilvTransformer2.apply(ilvPoint2);
            }
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint2);
            }
            d3 = Math.min(d3, (d8 += (double)ilvPoint2.x) + rectangle2D.getX());
            d4 = Math.max(d4, d8 + rectangle2D.getX() + rectangle2D.getWidth());
            d5 = Math.min(d5, (d9 += (double)ilvPoint2.y - d7) + d7 + rectangle2D.getY());
            d6 = Math.max(d6, d9 + d7 + rectangle2D.getY() + rectangle2D.getHeight());
            d7 += (double)(textLayout.getDescent() + this.b(textLayout));
        }
        d4 = Math.max(d4, (double)this.d);
        d6 = Math.max(d6, d7);
        double d10 = d4 - d3;
        double d11 = d6 - d5;
        d3 += (double)this.l.ag.x;
        d5 += (double)this.l.ag.y;
        TextLayout textLayout2 = textLayout = this.f.length == 0 ? null : this.f[0];
        if (textLayout != null) {
            switch (this.l.getAnchorPosition()) {
                case 256: {
                    d3 -= textLayout.isLeftToRight() ? 0.0 : (double)this.d;
                    break;
                }
                case 257: {
                    d3 -= textLayout.isLeftToRight() ? (double)this.d : 0.0;
                    break;
                }
                case 16: {
                    if (n == 1) {
                        d3 -= d10 / 2.0;
                        d5 += (double)((textLayout.getAscent() - textLayout.getDescent()) / 2.0f);
                        break;
                    }
                    d3 -= d10 / 2.0;
                    d5 -= d11 / 2.0 - (double)this.f[0].getAscent();
                    break;
                }
                case 2: {
                    d3 -= (double)this.d;
                }
            }
        }
        return new Rectangle2D.Double(d3, d5, d10, d11);
    }

    @Override
    public IlvPoint[] getAnchorPoints(boolean bl, IlvTransformer ilvTransformer) {
        double d;
        double d2 = this.l.getAnchorPoint().x;
        double d3 = d = (double)this.l.getAnchorPoint().y;
        this.j();
        this.c();
        int n = Math.max(this.e, 0);
        IlvPoint[] ilvPointArray = null;
        if (n == 0) {
            ilvPointArray = new IlvPoint[]{new IlvPoint((float)d2, (float)d)};
        } else {
            float f;
            float f2;
            IlvTransformer ilvTransformer2;
            Cloneable cloneable;
            IlvPoint ilvPoint;
            ilvPointArray = new IlvPoint[n + 2];
            double d4 = 0.0;
            double d5 = 0.0;
            switch (this.l.getAnchorPosition()) {
                case 256: {
                    d2 -= this.f[0].isLeftToRight() ? 0.0 : (double)this.d;
                    break;
                }
                case 257: {
                    d2 -= this.f[0].isLeftToRight() ? (double)this.d : 0.0;
                    break;
                }
                case 16: {
                    d2 -= this.b.getWidth() / 2.0;
                    d -= this.b.getHeight() / 2.0 - (double)this.f[0].getAscent();
                    break;
                }
                case 2: {
                    d2 -= (double)this.d;
                }
            }
            double d6 = this.l.getRotationAlignmentThresholdAngle();
            double d7 = 0.0;
            boolean bl2 = false;
            TextLayout textLayout = this.f[0];
            if (textLayout != null) {
                d4 = this.a(textLayout);
                d5 = 0.0;
                d -= (double)textLayout.getAscent();
                if (d6 > 0.0) {
                    IlvPoint ilvPoint2 = new IlvPoint(0.0f, (float)d3);
                    ilvPoint = new IlvPoint(0.0f, (float)d);
                    cloneable = this.l.getTransformer();
                    ilvTransformer2 = null;
                    if (this.l.getRotationAlignmentAngle() != 0.0f) {
                        ilvTransformer2 = new IlvTransformer(ilvPoint2, this.l.getRotationAlignmentAngle());
                    }
                    if (cloneable != null) {
                        ((IlvTransformer)cloneable).apply(ilvPoint2);
                        ((IlvTransformer)cloneable).apply(ilvPoint);
                    }
                    if (ilvTransformer2 != null) {
                        ilvTransformer2.inverse(ilvPoint2);
                        ilvTransformer2.inverse(ilvPoint);
                    }
                    if (!bl2 && d != d3) {
                        for (d7 = Math.atan2(ilvPoint.y - ilvPoint2.y, ilvPoint.x - ilvPoint2.x) / Math.PI * 180.0; d7 < 0.0; d7 += 180.0) {
                        }
                        while (d7 > 180.0) {
                            d7 -= 180.0;
                        }
                        bl2 = true;
                    }
                    if (d7 < 90.0 - d6 || d7 > 90.0 + d6) {
                        if (Math.abs(ilvPoint2.x - ilvPoint.x) > 0.0f) {
                            f2 = ilvPoint.x - ilvPoint2.x;
                            f = ilvPoint.y - ilvPoint2.y;
                            ilvPoint.y = ilvPoint2.y;
                            ilvPoint.x += f * f / f2;
                        }
                    } else if (Math.abs(ilvPoint2.y - ilvPoint.y) > 0.0f) {
                        f2 = ilvPoint.y - ilvPoint2.y;
                        f = ilvPoint.x - ilvPoint2.x;
                        ilvPoint.x = ilvPoint2.x;
                        ilvPoint.y += f * f / f2;
                    }
                    if (ilvTransformer2 != null) {
                        ilvTransformer2.apply(ilvPoint);
                    }
                    if (cloneable != null) {
                        ((IlvTransformer)cloneable).inverse(ilvPoint);
                    }
                    d4 += (double)ilvPoint.x;
                    d5 += (double)ilvPoint.y - d;
                }
                ilvPointArray[0] = bl ? new IlvPoint((float)(d2 + d4), (float)(d + d5)) : new IlvPoint((float)(d2 + d4 + (double)textLayout.getAdvance()), (float)(d + d5));
                d = d3;
            }
            for (int i = 0; i < n; ++i) {
                textLayout = this.f[i];
                if (textLayout == null) continue;
                d4 = this.a(textLayout);
                d5 = 0.0;
                if (i > 0) {
                    d += (double)textLayout.getAscent();
                }
                if (d6 > 0.0) {
                    float f3;
                    ilvPoint = new IlvPoint(0.0f, (float)d3);
                    cloneable = new IlvPoint(0.0f, (float)d);
                    ilvTransformer2 = this.l.getTransformer();
                    IlvTransformer ilvTransformer3 = null;
                    if (this.l.getRotationAlignmentAngle() != 0.0f) {
                        ilvTransformer3 = new IlvTransformer(ilvPoint, this.l.getRotationAlignmentAngle());
                    }
                    if (ilvTransformer2 != null) {
                        ilvTransformer2.apply(ilvPoint);
                        ilvTransformer2.apply((IlvPoint)cloneable);
                    }
                    if (ilvTransformer3 != null) {
                        ilvTransformer3.inverse(ilvPoint);
                        ilvTransformer3.inverse((IlvPoint)cloneable);
                    }
                    if (!bl2 && d != d3) {
                        for (d7 = Math.atan2(((Point2D.Float)cloneable).y - ilvPoint.y, ((Point2D.Float)cloneable).x - ilvPoint.x) / Math.PI * 180.0; d7 < 0.0; d7 += 180.0) {
                        }
                        while (d7 > 180.0) {
                            d7 -= 180.0;
                        }
                        bl2 = true;
                    }
                    if (d7 < 90.0 - d6 || d7 > 90.0 + d6) {
                        if (Math.abs(ilvPoint.x - ((Point2D.Float)cloneable).x) > 0.0f) {
                            f = ((Point2D.Float)cloneable).x - ilvPoint.x;
                            f3 = ((Point2D.Float)cloneable).y - ilvPoint.y;
                            ((Point2D.Float)cloneable).y = ilvPoint.y;
                            ((Point2D.Float)cloneable).x += f3 * f3 / f;
                        }
                    } else if (Math.abs(ilvPoint.y - ((Point2D.Float)cloneable).y) > 0.0f) {
                        f = ((Point2D.Float)cloneable).y - ilvPoint.y;
                        f3 = ((Point2D.Float)cloneable).x - ilvPoint.x;
                        ((Point2D.Float)cloneable).x = ilvPoint.x;
                        ((Point2D.Float)cloneable).y += f3 * f3 / f;
                    }
                    if (ilvTransformer3 != null) {
                        ilvTransformer3.apply((IlvPoint)cloneable);
                    }
                    if (ilvTransformer2 != null) {
                        ilvTransformer2.inverse((IlvPoint)cloneable);
                    }
                    d4 += (double)((Point2D.Float)cloneable).x;
                    d5 += (double)((Point2D.Float)cloneable).y - d;
                }
                ilvPointArray[i + 1] = bl ? new IlvPoint((float)(d2 + d4), (float)(d + d5)) : new IlvPoint((float)(d2 + d4 + (double)textLayout.getAdvance()), (float)(d + d5));
                d += (double)(textLayout.getDescent() + this.b(textLayout));
            }
            textLayout = this.f[n - 1];
            if (textLayout != null) {
                d4 = this.a(textLayout);
                d5 = 0.0;
                if (d6 > 0.0) {
                    IlvPoint ilvPoint3 = new IlvPoint(0.0f, (float)d3);
                    ilvPoint = new IlvPoint(0.0f, (float)d);
                    cloneable = this.l.getTransformer();
                    ilvTransformer2 = null;
                    if (this.l.getRotationAlignmentAngle() != 0.0f) {
                        ilvTransformer2 = new IlvTransformer(ilvPoint3, this.l.getRotationAlignmentAngle());
                    }
                    if (cloneable != null) {
                        ((IlvTransformer)cloneable).apply(ilvPoint3);
                        ((IlvTransformer)cloneable).apply(ilvPoint);
                    }
                    if (ilvTransformer2 != null) {
                        ilvTransformer2.inverse(ilvPoint3);
                        ilvTransformer2.inverse(ilvPoint);
                    }
                    if (!bl2 && d != d3) {
                        for (d7 = Math.atan2(ilvPoint.y - ilvPoint3.y, ilvPoint.x - ilvPoint3.x) / Math.PI * 180.0; d7 < 0.0; d7 += 180.0) {
                        }
                        while (d7 > 180.0) {
                            d7 -= 180.0;
                        }
                        bl2 = true;
                    }
                    if (d7 < 90.0 - d6 || d7 > 90.0 + d6) {
                        if (Math.abs(ilvPoint3.x - ilvPoint.x) > 0.0f) {
                            f2 = ilvPoint.x - ilvPoint3.x;
                            f = ilvPoint.y - ilvPoint3.y;
                            ilvPoint.y = ilvPoint3.y;
                            ilvPoint.x += f * f / f2;
                        }
                    } else if (Math.abs(ilvPoint3.y - ilvPoint.y) > 0.0f) {
                        f2 = ilvPoint.y - ilvPoint3.y;
                        f = ilvPoint.x - ilvPoint3.x;
                        ilvPoint.x = ilvPoint3.x;
                        ilvPoint.y += f * f / f2;
                    }
                    if (ilvTransformer2 != null) {
                        ilvTransformer2.apply(ilvPoint);
                    }
                    if (cloneable != null) {
                        ((IlvTransformer)cloneable).inverse(ilvPoint);
                    }
                    d4 += (double)ilvPoint.x;
                    d5 += (double)ilvPoint.y - d;
                }
                ilvPointArray[n + 1] = bl ? new IlvPoint((float)(d2 + d4), (float)(d + d5)) : new IlvPoint((float)(d2 + d4 + (double)textLayout.getAdvance()), (float)(d + d5));
            }
        }
        IlvTransformer ilvTransformer4 = this.l.getTransformer();
        if (ilvTransformer4 != null) {
            ilvTransformer4.compose(ilvTransformer);
        } else {
            ilvTransformer4 = ilvTransformer;
        }
        for (int i = 0; i < ilvPointArray.length; ++i) {
            if (ilvPointArray[i] == null) continue;
            ilvTransformer4.apply(ilvPointArray[i]);
        }
        return ilvPointArray;
    }

    private double a(TextLayout textLayout) {
        switch (this.l.getAlignment()) {
            case 256: {
                return textLayout.isLeftToRight() ? 0.0 : (double)(this.d - textLayout.getAdvance());
            }
            case 257: {
                return textLayout.isLeftToRight() ? (double)(this.d - textLayout.getAdvance()) : 0.0;
            }
            case 16: {
                return (this.d - textLayout.getAdvance()) / 2.0f;
            }
            case 1: {
                return 0.0;
            }
            case 2: {
                return this.d - textLayout.getAdvance();
            }
        }
        return 0.0;
    }

    private final FontRenderContext g() {
        if (this.g == null) {
            this.g = new FontRenderContext(null, this.l.isAntialiasing(), this.l.isFractionalMetrics());
        }
        return this.g;
    }

    private final TextLayout h() {
        if (this.h == null) {
            this.h = new TextLayout("\u2026", this.l.getFont(), this.g());
        }
        return this.h;
    }

    private final boolean i() {
        return IlvBidiUtil.isStringRTL(this.l, this.l.getLabel(), this.l.getComponentOrientation());
    }

    private void j() {
        if (this.a) {
            return;
        }
        this.i = false;
        int n = 0;
        boolean bl = this.l.a() == null;
        HashMap<TextAttribute, Serializable> hashMap = new HashMap<TextAttribute, Serializable>();
        hashMap.put(TextAttribute.FONT, this.l.getFont());
        if (this.l.isStrikethrough()) {
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (this.l.isUnderline()) {
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (!IlvBidiUtil.isAdvancedBidiOn()) {
            this.m = false;
        } else if (this.i()) {
            this.m = true;
            hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            if (!this.l.b()) {
                this.l.a(257);
            }
        } else {
            this.m = false;
            hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            if (!this.l.b()) {
                this.l.a(256);
            }
        }
        Object[] objectArray = IlvLayoutTextRenderer.a(this.l.getLabel(), this.l.a());
        String[] stringArray = (String[])objectArray[0];
        AttributedString[] attributedStringArray = (AttributedString[])objectArray[1];
        int n2 = stringArray.length;
        FontRenderContext fontRenderContext = this.g();
        float f = this.l.getWrappingWidth();
        if (Float.isNaN(f)) {
            f = 100.0f;
        }
        switch (this.l.getWrappingMode()) {
            case 1: 
            case 4: 
            case 5: {
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                ArrayList<TextLayoutCreationInfo> arrayList2 = this.j != null ? new ArrayList<TextLayoutCreationInfo>() : null;
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                BreakIterator breakIterator = this.l.getWrappingMode() == 1 ? IlvWrappedICUBreakIterator.getLineInstance(this.l.getULocale()) : IlvWrappedICUBreakIterator.getCharacterInstance(this.l.getULocale());
                for (int i = 0; i < n2; ++i) {
                    String string = stringArray[i];
                    AttributedString attributedString = attributedStringArray[i];
                    IlvLayoutTextRenderer.a(attributedString, hashMap);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), breakIterator, fontRenderContext);
                    int n3 = string.length();
                    int n4 = 0;
                    while (n4 < n3) {
                        TextLayout textLayout;
                        int n5;
                        int n6 = lineBreakMeasurer.nextOffset(f, n3, true);
                        if (n6 == n4) {
                            n6 = n5 = breakIterator.following(n4);
                        }
                        n5 = n6;
                        while (--n5 > n4 && Character.isSpaceChar(string.charAt(n5))) {
                        }
                        if (arrayList2 != null) {
                            TextLayoutCreationInfo textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string.substring(n4, n5 + 1), hashMap) : new TextLayoutCreationInfo(attributedString.getIterator(null, n4, n5 + 1));
                            textLayout = textLayoutCreationInfo.a(fontRenderContext, this.m);
                            arrayList2.add(textLayoutCreationInfo);
                        } else {
                            textLayout = bl ? new TextLayout(this.m ? IlvBidiUtil.getStringWithMarks(string.substring(n4, n5 + 1)) : string.substring(n4, n5 + 1), hashMap, fontRenderContext) : new TextLayout(this.m ? IlvBidiUtil.getIteratorWithMarks(attributedString.getIterator(null, n4, n5 + 1)) : attributedString.getIterator(null, n4, n5 + 1), fontRenderContext);
                        }
                        arrayList.add(textLayout);
                        arrayList3.add(new Integer(n + n4));
                        lineBreakMeasurer.setPosition(n6);
                        n4 = n6;
                    }
                    n += n3 + 1;
                }
                this.e = arrayList.size();
                this.f = arrayList.toArray(new TextLayout[this.e]);
                this.k = arrayList3.toArray(new Integer[this.e]);
                if (arrayList2 == null) break;
                this.j.a = arrayList2.toArray(new TextLayoutCreationInfo[this.e]);
                break;
            }
            case 2: {
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                ArrayList<TextLayoutCreationInfo> arrayList4 = this.j != null ? new ArrayList<TextLayoutCreationInfo>() : null;
                TextLayout textLayout = this.h();
                TextLayout textLayout2 = null;
                TextLayoutCreationInfo textLayoutCreationInfo = null;
                String string = null;
                AttributedString attributedString = null;
                float f2 = 0.0f;
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    int n7;
                    TextMeasurer textMeasurer;
                    if (i > 0) {
                        f2 += textLayout2.getAscent();
                    }
                    String string2 = stringArray[i];
                    AttributedString attributedString2 = attributedStringArray[i];
                    IlvLayoutTextRenderer.a(attributedString2, hashMap);
                    if (arrayList4 != null) {
                        textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string2, hashMap) : new TextLayoutCreationInfo(attributedString2.getIterator());
                        textLayout2 = textLayoutCreationInfo.a(fontRenderContext, this.m);
                    } else {
                        textLayout2 = bl ? new TextLayout(!this.m ? string2 : IlvBidiUtil.getStringWithMarks(string2), hashMap, fontRenderContext) : new TextLayout(!this.m ? attributedString2.getIterator() : IlvBidiUtil.getIteratorWithMarks(attributedString2.getIterator()), fontRenderContext);
                    }
                    boolean bl3 = false;
                    if (textLayout2.getAdvance() > f) {
                        this.i = true;
                        bl3 = true;
                        textMeasurer = new TextMeasurer(attributedString2.getIterator(), fontRenderContext);
                        n7 = textMeasurer.getLineBreakIndex(0, f - textLayout.getAdvance());
                        if (n7 == -1) {
                            attributedString2 = new AttributedString(" ");
                            string2 = " ";
                        } else {
                            attributedString2 = this.a(string2, attributedString2, n7);
                            string2 = this.a(string2, n7);
                        }
                        if (arrayList4 != null) {
                            textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string2, hashMap) : new TextLayoutCreationInfo(attributedString2.getIterator());
                            textLayout2 = textLayoutCreationInfo.a(fontRenderContext, this.m);
                        } else {
                            TextLayout textLayout3 = bl ? new TextLayout(!this.m ? string2 : IlvBidiUtil.getStringWithMarks(string2), hashMap, fontRenderContext) : (textLayout2 = new TextLayout(!this.m ? attributedString2.getIterator() : IlvBidiUtil.getIteratorWithMarks(attributedString2.getIterator()), fontRenderContext));
                        }
                    }
                    if ((f2 += textLayout2.getDescent() + this.b(textLayout2)) < this.l.getWrappingHeight()) {
                        arrayList.add(textLayout2);
                        if (arrayList4 != null) {
                            arrayList4.add(textLayoutCreationInfo);
                        }
                    } else {
                        if (bl2 || string == null) break;
                        this.i = true;
                        string2 = string;
                        attributedString2 = attributedString;
                        textMeasurer = new TextMeasurer(attributedString2.getIterator(), fontRenderContext);
                        n7 = textMeasurer.getLineBreakIndex(0, f - textLayout.getAdvance());
                        if (n7 == -1) {
                            attributedString2 = new AttributedString(" ");
                            string2 = " ";
                        } else {
                            attributedString2 = bl ? null : this.a(string2, attributedString2, n7);
                            string2 = this.a(string2, n7);
                        }
                        if (arrayList4 != null) {
                            textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string2, hashMap) : new TextLayoutCreationInfo(attributedString2.getIterator());
                            textLayout2 = textLayoutCreationInfo.a(fontRenderContext, this.m);
                            arrayList.set(arrayList.size() - 1, textLayout2);
                            arrayList4.set(arrayList4.size() - 1, textLayoutCreationInfo);
                        } else {
                            textLayout2 = bl ? new TextLayout(!this.m ? string2 : IlvBidiUtil.getStringWithMarks(string2), hashMap, fontRenderContext) : new TextLayout(!this.m ? attributedString2.getIterator() : IlvBidiUtil.getIteratorWithMarks(attributedString2.getIterator()), fontRenderContext);
                            arrayList.set(arrayList.size() - 1, textLayout2);
                        }
                        bl2 = true;
                        break;
                    }
                    bl2 = bl3;
                    string = string2;
                    attributedString = attributedString2;
                }
                this.e = arrayList.size();
                this.f = arrayList.toArray(new TextLayout[this.e]);
                if (arrayList4 == null) break;
                this.j.a = arrayList4.toArray(new TextLayoutCreationInfo[this.e]);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                ArrayList<TextLayoutCreationInfo> arrayList5 = this.j != null ? new ArrayList<TextLayoutCreationInfo>() : null;
                BreakIterator breakIterator = this.l.getWrappingMode() == 3 ? IlvWrappedICUBreakIterator.getLineInstance(this.l.getULocale()) : IlvWrappedICUBreakIterator.getCharacterInstance(this.l.getULocale());
                TextLayout textLayout = this.h();
                TextLayout textLayout4 = null;
                TextLayoutCreationInfo textLayoutCreationInfo = null;
                String string = null;
                AttributedString attributedString = null;
                float f3 = 0.0f;
                boolean bl4 = false;
                block9: for (int i = 0; i < n2; ++i) {
                    String string3 = stringArray[i];
                    AttributedString attributedString3 = attributedStringArray[i];
                    IlvLayoutTextRenderer.a(attributedString3, hashMap);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString3.getIterator(), breakIterator, fontRenderContext);
                    int n8 = string3.length();
                    int n9 = 0;
                    int n10 = -1;
                    while (n9 < n8) {
                        int n11;
                        TextMeasurer textMeasurer;
                        int n12;
                        if (i > 0 || n10 != -1) {
                            f3 += textLayout4.getAscent();
                        }
                        if ((n12 = lineBreakMeasurer.nextOffset(f, n8, true)) == n9) {
                            n12 = n10 = breakIterator.following(n9);
                        }
                        n10 = n12;
                        while (--n10 > n9 && Character.isSpaceChar(string3.charAt(n10))) {
                        }
                        String string4 = string3.substring(n9, n10 + 1);
                        AttributedString attributedString4 = new AttributedString(attributedString3.getIterator(null, n9, n10 + 1));
                        if (arrayList5 != null) {
                            textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string4, hashMap) : new TextLayoutCreationInfo(attributedString4.getIterator());
                            textLayout4 = textLayoutCreationInfo.a(fontRenderContext, this.m);
                        } else {
                            textLayout4 = bl ? new TextLayout(!this.m ? string4 : IlvBidiUtil.getStringWithMarks(string4), hashMap, fontRenderContext) : new TextLayout(this.m ? attributedString4.getIterator() : IlvBidiUtil.getIteratorWithMarks(attributedString4.getIterator()), fontRenderContext);
                        }
                        boolean bl5 = false;
                        if (textLayout4.getAdvance() > f) {
                            this.i = true;
                            bl5 = true;
                            textMeasurer = new TextMeasurer(attributedString4.getIterator(), fontRenderContext);
                            n11 = textMeasurer.getLineBreakIndex(0, f - textLayout.getAdvance());
                            if (n11 == -1) {
                                attributedString4 = new AttributedString(" ");
                                string4 = " ";
                            } else {
                                attributedString4 = this.a(string4, attributedString4, n11);
                                string4 = this.a(string4, n11);
                            }
                            if (arrayList5 != null) {
                                textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string4, hashMap) : new TextLayoutCreationInfo(attributedString4.getIterator());
                                textLayout4 = textLayoutCreationInfo.a(fontRenderContext, this.m);
                            } else {
                                TextLayout textLayout5 = bl ? new TextLayout(this.m ? string4 : IlvBidiUtil.getStringWithMarks(string4), hashMap, fontRenderContext) : (textLayout4 = new TextLayout(this.m ? attributedString4.getIterator() : IlvBidiUtil.getIteratorWithMarks(attributedString4.getIterator()), fontRenderContext));
                            }
                        }
                        if ((f3 += textLayout4.getDescent() + this.b(textLayout4)) < this.l.getWrappingHeight()) {
                            arrayList.add(textLayout4);
                            if (arrayList5 != null) {
                                arrayList5.add(textLayoutCreationInfo);
                            }
                            bl4 = bl5;
                            string = string4;
                            attributedString = attributedString4;
                            lineBreakMeasurer.setPosition(n12);
                            n9 = n12;
                            continue;
                        }
                        i = n2;
                        if (bl4 || string == null) continue block9;
                        this.i = true;
                        string3 = string;
                        attributedString3 = attributedString;
                        textMeasurer = new TextMeasurer(attributedString3.getIterator(), fontRenderContext);
                        n11 = textMeasurer.getLineBreakIndex(0, f - textLayout.getAdvance());
                        if (n11 == -1) {
                            attributedString3 = new AttributedString(" ");
                            string3 = " ";
                        } else {
                            attributedString3 = this.a(string3, attributedString3, n11);
                            string3 = this.a(string3, n11);
                        }
                        if (arrayList5 != null) {
                            textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string3, hashMap) : new TextLayoutCreationInfo(attributedString3.getIterator());
                            textLayout4 = textLayoutCreationInfo.a(fontRenderContext, this.m);
                            arrayList.set(arrayList.size() - 1, textLayout4);
                            arrayList5.set(arrayList5.size() - 1, textLayoutCreationInfo);
                        } else {
                            textLayout4 = bl ? new TextLayout(!this.m ? string3 : IlvBidiUtil.getStringWithMarks(string3), hashMap, fontRenderContext) : new TextLayout(!this.m ? attributedString3.getIterator() : IlvBidiUtil.getIteratorWithMarks(attributedString3.getIterator()), fontRenderContext);
                            arrayList.set(arrayList.size() - 1, textLayout4);
                        }
                        bl4 = true;
                        continue block9;
                    }
                }
                this.e = arrayList.size();
                this.f = arrayList.toArray(new TextLayout[this.e]);
                if (arrayList5 == null) break;
                this.j.a = arrayList5.toArray(new TextLayoutCreationInfo[this.e]);
                break;
            }
            default: {
                this.e = stringArray.length;
                this.f = new TextLayout[n2];
                this.k = new Integer[n2];
                if (this.j != null) {
                    this.j.a = new TextLayoutCreationInfo[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    AttributedString attributedString;
                    String string = stringArray[i];
                    if (bl) {
                        attributedString = null;
                    } else {
                        attributedString = attributedStringArray[i];
                        IlvLayoutTextRenderer.a(attributedString, hashMap);
                    }
                    if (string.length() > 0) {
                        if (this.j != null) {
                            TextLayoutCreationInfo textLayoutCreationInfo = this.j.a[i] = bl ? new TextLayoutCreationInfo(string, hashMap) : new TextLayoutCreationInfo(attributedString.getIterator());
                        }
                        this.f[i] = bl ? new TextLayout(!this.m ? string : IlvBidiUtil.getStringWithMarks(string), hashMap, fontRenderContext) : new TextLayout(!this.m ? attributedString.getIterator() : IlvBidiUtil.getIteratorWithMarks(attributedString.getIterator()), fontRenderContext);
                    } else {
                        if (this.j != null) {
                            this.j.a[i] = null;
                        }
                        this.f[i] = null;
                    }
                    this.k[i] = new Integer(n);
                    n += string.length() + 1;
                }
            }
        }
        this.a = true;
        this.b = null;
    }

    private static void a(AttributedString attributedString, Map map) {
        int n;
        if (map == null || attributedString == null || map.size() == 0) {
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n2 = attributedCharacterIterator.getBeginIndex();
        if (n2 < (n = attributedCharacterIterator.getEndIndex())) {
            Set set = map.keySet();
            int n3 = n2;
            while (true) {
                attributedCharacterIterator.setIndex(n3);
                int n4 = attributedCharacterIterator.getRunLimit(set);
                Map<AttributedCharacterIterator.Attribute, Object> map2 = attributedCharacterIterator.getAttributes();
                if (map2 == null) {
                    attributedString.addAttributes(map, n3, n4);
                } else {
                    HashMap hashMap = null;
                    for (Map.Entry entry : map.entrySet()) {
                        AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)entry.getKey();
                        if (map2.containsKey(attribute)) continue;
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        hashMap.put(attribute, entry.getValue());
                    }
                    if (hashMap != null) {
                        attributedString.addAttributes(hashMap, n3, n4);
                    }
                }
                if (n4 >= n) break;
                n3 = n4;
            }
        }
    }

    private String a(String string, int n) {
        this.i = true;
        return string.substring(0, n) + "\u2026";
    }

    private AttributedString a(String string, AttributedString attributedString, int n) {
        this.i = true;
        if (n > 0) {
            return IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString, 0, n), "\u2026");
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        attributedCharacterIterator.first();
        return new AttributedString("\u2026", attributedCharacterIterator.getAttributes());
    }

    private static Object[] a(String string, AttributedString attributedString) {
        int n;
        int n2 = string.length();
        int n3 = 1;
        for (n = 0; n < n2; ++n) {
            if (string.charAt(n) != '\n') continue;
            ++n3;
        }
        String[] stringArray = new String[n3];
        AttributedString[] attributedStringArray = new AttributedString[n3];
        if (n3 == 1) {
            if (string.length() == 0) {
                stringArray[0] = " ";
                attributedStringArray[0] = new AttributedString(" ");
            } else {
                stringArray[0] = string;
                attributedStringArray[0] = attributedString == null ? new AttributedString(stringArray[0]) : new AttributedString(attributedString.getIterator());
            }
        } else {
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < n3; ++n) {
                n5 = string.indexOf(10, n4);
                if (n5 == -1) {
                    n5 = n2;
                }
                if (n5 == n4) {
                    stringArray[n] = " ";
                    attributedStringArray[n] = new AttributedString(" ");
                } else {
                    stringArray[n] = string.substring(n4, n5);
                    attributedStringArray[n] = attributedString == null ? new AttributedString(stringArray[n]) : new AttributedString(attributedString.getIterator(), n4, n5);
                }
                n4 = n5 + 1;
            }
        }
        return new Object[]{stringArray, attributedStringArray};
    }

    private float b(TextLayout textLayout) {
        if (this.l.getInterlineSpacing() != -1.0f) {
            return this.l.getInterlineSpacing();
        }
        return textLayout.getLeading();
    }

    @Override
    public void invalidate(boolean bl, boolean bl2) {
        this.b = null;
        this.c = null;
        if (bl2) {
            this.a = false;
            this.k();
        }
        if (bl) {
            this.h = null;
            this.g = null;
        }
    }

    private TextLayout[] a(FontRenderContext fontRenderContext) {
        InfoForFRCDependentTreatment infoForFRCDependentTreatment = this.j;
        if (fontRenderContext.equals(infoForFRCDependentTreatment.b[0])) {
            infoForFRCDependentTreatment.d = true;
            return infoForFRCDependentTreatment.c[0];
        }
        if (fontRenderContext.equals(infoForFRCDependentTreatment.b[1])) {
            infoForFRCDependentTreatment.d = false;
            return infoForFRCDependentTreatment.c[1];
        }
        int n = infoForFRCDependentTreatment.d ? 1 : 0;
        infoForFRCDependentTreatment.b[n] = fontRenderContext;
        TextLayout[] textLayoutArray = new TextLayout[infoForFRCDependentTreatment.a.length];
        for (int i = 0; i < textLayoutArray.length; ++i) {
            if (infoForFRCDependentTreatment.a[i] == null) continue;
            textLayoutArray[i] = infoForFRCDependentTreatment.a[i].a(fontRenderContext, this.m);
        }
        infoForFRCDependentTreatment.c[n] = textLayoutArray;
        return textLayoutArray;
    }

    private void k() {
        InfoForFRCDependentTreatment infoForFRCDependentTreatment = this.j;
        if (infoForFRCDependentTreatment == null) {
            return;
        }
        infoForFRCDependentTreatment.b[1] = null;
        infoForFRCDependentTreatment.b[0] = null;
    }

    @Override
    public boolean usesMarkers() {
        if (!IlvBidiUtil.isAdvancedBidiOn()) {
            return false;
        }
        this.j();
        return this.m;
    }

    static class TextLayoutCreationInfo {
        private String a;
        private Map<? extends AttributedCharacterIterator.Attribute, ?> b;
        private AttributedString c;

        TextLayoutCreationInfo(String string, Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
            this.a = string;
            this.b = map;
            this.c = null;
        }

        TextLayoutCreationInfo(AttributedCharacterIterator attributedCharacterIterator) {
            this.a = null;
            this.b = null;
            this.c = new AttributedString(attributedCharacterIterator);
        }

        TextLayout a(FontRenderContext fontRenderContext, boolean bl) {
            if (this.a != null) {
                return new TextLayout(!bl ? this.a : IlvBidiUtil.getStringWithMarks(this.a), this.b, fontRenderContext);
            }
            return new TextLayout(!bl ? this.c.getIterator() : IlvBidiUtil.getIteratorWithMarks(this.c.getIterator()), fontRenderContext);
        }
    }

    static class InfoForFRCDependentTreatment {
        transient TextLayoutCreationInfo[] a;
        transient FontRenderContext[] b = new FontRenderContext[2];
        transient TextLayout[][] c = new TextLayout[2][];
        transient boolean d;

        InfoForFRCDependentTreatment() {
        }
    }
}

