/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUnresizeableDrawSelection;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvGraphicHandleBag;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.swing.IlvPopupMenuManager;
import ilog.views.util.print.IlvPrintUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import javax.swing.JPopupMenu;

public class IlvFixedSizeGraphic
extends IlvGraphicHandleBag {
    private IlvPoint a;
    private int b;

    public IlvFixedSizeGraphic(IlvGraphic ilvGraphic, int n, IlvPoint ilvPoint) {
        super(ilvGraphic, false);
        this.b = n;
        this.a = ilvPoint != null ? new IlvPoint(ilvPoint) : this.b();
    }

    public IlvFixedSizeGraphic(IlvGraphic ilvGraphic, IlvPoint ilvPoint) {
        this(ilvGraphic, 0, ilvPoint);
    }

    public IlvFixedSizeGraphic(IlvGraphic ilvGraphic, int n) {
        this(ilvGraphic, n, null);
    }

    public IlvFixedSizeGraphic(IlvFixedSizeGraphic ilvFixedSizeGraphic) {
        super(ilvFixedSizeGraphic);
        this.b = ilvFixedSizeGraphic.b;
        this.a = new IlvPoint(ilvFixedSizeGraphic.a);
    }

    @Override
    public IlvGraphic copy() {
        IlvFixedSizeGraphic ilvFixedSizeGraphic = new IlvFixedSizeGraphic(this);
        if (ilvFixedSizeGraphic.getObject() != null) {
            return ilvFixedSizeGraphic;
        }
        return null;
    }

    @Override
    public boolean zoomable() {
        return false;
    }

    public IlvFixedSizeGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readPoint("point");
        this.b = ilvInputStream.readInt("position");
        this.setDelegateMoveResize(false);
    }

    private IlvPoint b() {
        IlvRect ilvRect = this.getObject().boundingBox(null);
        IlvPoint ilvPoint = new IlvPoint();
        switch (this.b) {
            case 0: 
            case 16: {
                ilvPoint.move(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
                break;
            }
            case 5: {
                ilvPoint.move(ilvRect.x, ilvRect.y);
                break;
            }
            case 9: {
                ilvPoint.move(ilvRect.x, ilvRect.y + ilvRect.height);
                break;
            }
            case 6: {
                ilvPoint.move(ilvRect.x + ilvRect.width, ilvRect.y);
                break;
            }
            case 10: {
                ilvPoint.move(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height);
                break;
            }
            case 2: {
                ilvPoint.move(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height / 2.0f);
                break;
            }
            case 1: {
                ilvPoint.move(ilvRect.x, ilvRect.y + ilvRect.height / 2.0f);
                break;
            }
            case 4: {
                ilvPoint.move(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y);
                break;
            }
            case 8: {
                ilvPoint.move(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height);
                break;
            }
        }
        return ilvPoint;
    }

    public final int getPosition() {
        return this.b;
    }

    public void setPosition(int n) {
        this.b = n;
        this.a = this.b();
    }

    public final IlvPoint getPoint() {
        return new IlvPoint(this.a);
    }

    public void setPoint(IlvPoint ilvPoint) {
        if (ilvPoint == null) {
            this.a = this.b();
        } else {
            this.a.move(ilvPoint.x, ilvPoint.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.a(this.a, ilvTransformer);
        if (IlvGraphicUtil.isPrinting(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                AffineTransform affineTransform = (AffineTransform)graphics2D.getRenderingHint(IlvPrintUtil.KEY_PRINTING_TRANSFORM);
                if (affineTransform != null) {
                    IlvPoint ilvPoint = new IlvPoint(this.a);
                    ilvTransformer2.apply(ilvPoint);
                    graphics2D.translate(ilvPoint.x, ilvPoint.y);
                    graphics2D.scale(1.0 / affineTransform.getScaleX(), 1.0 / affineTransform.getScaleY());
                    graphics2D.translate(-ilvPoint.x, -ilvPoint.y);
                }
                this.getObject().callDraw(graphics2D, ilvTransformer2);
            }
            finally {
                graphics2D.dispose();
            }
        } else {
            this.getObject().callDraw(graphics, ilvTransformer2);
        }
    }

    private IlvTransformer a(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint2);
        }
        IlvTransformer ilvTransformer2 = new IlvTransformer();
        ilvTransformer2.setValues(1.0, 0.0, 0.0, 1.0, (double)ilvPoint2.x - (double)ilvPoint.x, (double)ilvPoint2.y - (double)ilvPoint.y);
        return ilvTransformer2;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.a(this.a, ilvTransformer);
        return this.getObject().boundingBox(ilvTransformer2);
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.getObject().boundingBox(null);
        float f = ilvRect.x - this.a.x;
        float f2 = ilvRect.y - this.a.y;
        ilvTransformer.apply(this.a);
        this.getObject().move(this.a.x + f, this.a.y + f2);
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.a(this.a, ilvTransformer);
        IlvPoint ilvPoint3 = new IlvPoint(ilvPoint);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(ilvPoint3);
        }
        if (!ilvTransformer2.isIdentity()) {
            ilvTransformer2.inverse(ilvPoint3);
        }
        return this.getObject().contains(ilvPoint3, ilvPoint2, ilvTransformer2);
    }

    @Override
    public boolean intersects(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.a(this.a, ilvTransformer);
        IlvRect ilvRect3 = new IlvRect(ilvRect2);
        ilvTransformer2.boundingBox(ilvRect3, true);
        return this.getObject().intersects(ilvRect3, ilvRect2, ilvTransformer2);
    }

    @Override
    public boolean inside(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.a(this.a, ilvTransformer);
        IlvRect ilvRect3 = new IlvRect(ilvRect2);
        ilvTransformer2.boundingBox(ilvRect3, true);
        return this.getObject().inside(ilvRect3, ilvRect2, ilvTransformer2);
    }

    @Override
    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.a(this.a, ilvTransformer);
        return this.getObject().getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer2);
    }

    @Override
    public void rotate(IlvPoint ilvPoint, double d) {
        d = IlvUtil.degreesToRadians(d);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        IlvTransformer ilvTransformer = new IlvTransformer(d2, -d3, d3, d2, (double)ilvPoint.x * (1.0 - d2) + d3 * (double)ilvPoint.y, -((double)ilvPoint.x * d3) + (double)ilvPoint.y * (1.0 - d2));
        this.getObject().applyTransform(ilvTransformer);
    }

    @Override
    public void resize(float f, float f2) {
        IlvRect ilvRect = this.boundingBox(null);
        float f3 = ilvRect.width == 0.0f ? 1.0f : ilvRect.width;
        float f4 = ilvRect.height == 0.0f ? 1.0f : ilvRect.height;
        this.scale((double)f / (double)f3, (double)f2 / (double)f4);
    }

    @Override
    public IlvSelection makeSelection() {
        return new IlvUnresizeableDrawSelection(this);
    }

    @Override
    public String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.a(this.a, ilvTransformer);
        String string = this.getObject().getToolTipText(ilvPoint, ilvTransformer2);
        if (string != null) {
            return string;
        }
        return this.getToolTipText();
    }

    @Override
    public JPopupMenu getPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        IlvTransformer ilvTransformer2 = this.a(this.a, ilvTransformer);
        JPopupMenu jPopupMenu = this.getObject().getPopupMenu(ilvPoint, ilvTransformer2, ilvManagerView, ilvPopupMenuManager);
        if (jPopupMenu != null) {
            return jPopupMenu;
        }
        return this.getOriginalPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("point", this.a);
        ilvOutputStream.write("position", this.b);
    }
}

