/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.dxf;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvNamedProperty;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.dxf.IlvDXFGraphicFactory;
import ilog.views.graphic.IlvArc;
import ilog.views.graphic.IlvArrowLine;
import ilog.views.graphic.IlvArrowPolyline;
import ilog.views.graphic.IlvEllipse;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.IlvMarker;
import ilog.views.graphic.IlvPolygon;
import ilog.views.graphic.IlvPolyline;
import ilog.views.graphic.IlvSpline;
import ilog.views.graphic.IlvText;
import ilog.views.io.IlvSingleValueNamedProperty;
import ilog.views.util.collections.IlvDoubleArrayList;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;

public class IlvDefaultDXFGraphicFactory
implements IlvDXFGraphicFactory {
    private final IlvDoubleArrayList a = new IlvDoubleArrayList(200);
    private static final int b = 63;
    private static final int c = 0;
    private static final int d = 1;
    private static final int e = 2;
    private static final int f = 3;
    private static final int g = 4;
    private static final int h = 5;
    private static final int i = 6;
    private static final int j = 6;
    private static final String k = "__blockNameKey";

    @Override
    public void addObject(IlvGraphic ilvGraphic, IlvManager ilvManager, int n) {
        ilvManager.addObject(ilvGraphic, n, false);
    }

    @Override
    public void addObject(IlvGraphic ilvGraphic, IlvGraphicBag ilvGraphicBag) {
        ilvGraphicBag.addObject(ilvGraphic, false);
    }

    @Override
    public IlvManagerLayer prepareLayer(IlvManager ilvManager, String string) {
        int n = ilvManager.getLayersCount();
        ilvManager.addLayer(n);
        ilvManager.setLayerName(n, string);
        return ilvManager.getManagerLayer(n);
    }

    @Override
    public IlvGraphic createPoint(IlvPoint ilvPoint, float f, Color color) {
        IlvMarker ilvMarker = new IlvMarker(ilvPoint, 16, 4);
        ((IlvGraphic)ilvMarker).setForeground(color);
        return ilvMarker;
    }

    @Override
    public IlvGraphic createLine(IlvPoint ilvPoint, IlvPoint ilvPoint2, float f, Color color) {
        IlvLine ilvLine = new IlvLine(ilvPoint, ilvPoint2);
        ilvLine.setForeground(color);
        ilvLine.setEndCap(0);
        if (f > 0.0f) {
            ilvLine.setLineWidth(f);
        }
        return ilvLine;
    }

    @Override
    public IlvGraphic createArc(IlvPoint ilvPoint, float f, float f2, float f3, float f4, Color color) {
        IlvRect ilvRect = new IlvRect(ilvPoint.x - f, ilvPoint.y - f, f * 2.0f, f * 2.0f);
        if (f2 > 180.0f) {
            f2 = (float)((double)f2 - 360.0);
        }
        if (f2 < -180.0f) {
            f2 = (float)((double)f2 + 360.0);
        }
        IlvArc ilvArc = new IlvArc(ilvRect, f2, f3);
        ilvArc.setForeground(color);
        return ilvArc;
    }

    @Override
    public IlvGraphic createCircle(IlvPoint ilvPoint, float f, float f2, Color color) {
        float f3 = f * 2.0f;
        IlvRect ilvRect = new IlvRect(ilvPoint.x - f, ilvPoint.y - f, f3, f3);
        IlvEllipse ilvEllipse = new IlvEllipse(ilvRect);
        ilvEllipse.setForeground(color);
        return ilvEllipse;
    }

    @Override
    public IlvGraphic createPolyline(IlvPoint[] ilvPointArray, boolean bl, boolean bl2, float f, Color color) {
        IlvPoint[] ilvPointArray2;
        int n;
        int n2 = n = ilvPointArray != null ? ilvPointArray.length : 0;
        if (n == 0) {
            return null;
        }
        if (bl && bl2) {
            IlvPolygon ilvPolygon = new IlvPolygon(ilvPointArray);
            ilvPolygon.setForeground(color);
            ilvPolygon.setBackground(color);
            ilvPolygon.setFillOn(true);
            ilvPolygon.setStrokeOn(true);
            return ilvPolygon;
        }
        if (bl && !ilvPointArray[0].equals(ilvPointArray[n - 1])) {
            ilvPointArray2 = new IlvPoint[n + 1];
            System.arraycopy(ilvPointArray, 0, ilvPointArray2, 0, n);
            ilvPointArray2[n] = new IlvPoint(ilvPointArray[0]);
            ilvPointArray = ilvPointArray2;
        }
        ilvPointArray2 = new IlvPolyline(ilvPointArray);
        ilvPointArray2.setForeground(color);
        ilvPointArray2.setEndCap(0);
        if (f > 0.0f) {
            ilvPointArray2.setLineWidth(f);
        }
        return ilvPointArray2;
    }

    @Override
    public IlvGraphic createSpline(IlvPoint[] ilvPointArray, boolean bl, float f, Color color) {
        IlvSpline ilvSpline = new IlvSpline(ilvPointArray);
        ilvSpline.setForeground(color);
        return ilvSpline;
    }

    @Override
    public IlvGraphic createTrace(IlvPoint[] ilvPointArray, float f, Color color) {
        return this.createPolyline(ilvPointArray, true, true, f, color);
    }

    @Override
    public IlvGraphic createSolid(IlvPoint[] ilvPointArray, float f, Color color) {
        return this.createPolyline(ilvPointArray, true, true, f, color);
    }

    @Override
    public IlvGraphic create3DFace(IlvPoint[] ilvPointArray, Color color) {
        return this.createPolyline(ilvPointArray, true, false, 0.0f, color);
    }

    @Override
    public IlvGraphic createText(IlvPoint ilvPoint, String string, boolean bl, boolean bl2, Font font, Color color) {
        IlvText ilvText = new IlvText(ilvPoint, string);
        if (bl) {
            ilvText.setUnderline(true);
        }
        ilvText.setForeground(color);
        ilvText.setAntialiasing(bl2);
        ilvText.setFont(font);
        return ilvText;
    }

    @Override
    public IlvGraphic createDimension(String string, short s, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5, IlvPoint ilvPoint6, IlvPoint ilvPoint7) {
        IlvGraphicSet ilvGraphicSet = null;
        boolean bl = string != null && string.length() > 0;
        switch (s & 0x3F) {
            case 1: {
                break;
            }
            case 2: {
                double d;
                if (ilvPoint == null || ilvPoint4 == null || ilvPoint5 == null || ilvPoint6 == null || ilvPoint7 == null) break;
                ilvGraphicSet = new IlvGraphicSet();
                IlvLine ilvLine = new IlvLine(ilvPoint5.x, ilvPoint5.y, ilvPoint4.x, ilvPoint4.y);
                IlvLine ilvLine2 = new IlvLine(ilvPoint.x, ilvPoint.y, ilvPoint6.x, ilvPoint6.y);
                double d2 = ilvPoint.x - ilvPoint6.x != 0.0f ? (double)((ilvPoint.y - ilvPoint6.y) / (ilvPoint.x - ilvPoint6.x)) : Double.POSITIVE_INFINITY * (double)(ilvPoint.y - ilvPoint6.y);
                double d3 = (double)ilvPoint.y - d2 * (double)ilvPoint.x;
                double d4 = Math.atan(d2);
                double d5 = ilvPoint4.x - ilvPoint5.x != 0.0f ? (double)((ilvPoint4.y - ilvPoint5.y) / (ilvPoint4.x - ilvPoint5.x)) : Double.POSITIVE_INFINITY * (double)(ilvPoint4.y - ilvPoint5.y);
                double d6 = (double)ilvPoint4.y - d5 * (double)ilvPoint4.x;
                double d7 = Math.atan(d5);
                double d8 = d2 - d5 != 0.0 ? (d6 - d3) / (d2 - d5) : Double.POSITIVE_INFINITY * (d6 - d3);
                double d9 = d2 * d8 + d3;
                double d10 = Point2D.distance(d8, d9, ilvPoint7.x, ilvPoint7.y);
                if (d4 > d7) {
                    d = d4;
                    d4 = d7;
                    d7 = d;
                }
                this.a.clear();
                for (d = d4; d < d7; d += (d7 - d4) / 16.0) {
                    this.a.add(d10 * Math.cos(d) + d8);
                    this.a.add(d10 * Math.sin(d) + d9);
                }
                double[] dArray = this.a.toArray();
                IlvPoint[] ilvPointArray = IlvDefaultDXFGraphicFactory.a(dArray);
                IlvDefaultDXFGraphicFactory.a(ilvGraphicSet, ilvPointArray);
                ilvGraphicSet.addObject(ilvLine, false);
                ilvGraphicSet.addObject(ilvLine2, false);
                if (!bl) break;
                IlvDefaultDXFGraphicFactory.a(ilvGraphicSet, ilvPoint2.x, ilvPoint2.y, string, 0.0);
                break;
            }
            case 3: {
                if (ilvPoint == null || ilvPoint6 == null) break;
                ilvGraphicSet = new IlvGraphicSet();
                IlvDefaultDXFGraphicFactory.a(ilvGraphicSet, ilvPoint, ilvPoint6);
                if (!bl) break;
                IlvDefaultDXFGraphicFactory.a(ilvGraphicSet, (ilvPoint.x + ilvPoint6.x) / 2.0f, (ilvPoint.y + ilvPoint6.y) / 2.0f, string, 0.0);
                break;
            }
            case 4: {
                if (ilvPoint == null || ilvPoint6 == null) break;
                ilvGraphicSet = new IlvGraphicSet();
                IlvDefaultDXFGraphicFactory.a(ilvGraphicSet, ilvPoint, ilvPoint6);
                if (!bl) break;
                IlvDefaultDXFGraphicFactory.a(ilvGraphicSet, (ilvPoint.x + ilvPoint6.x) / 2.0f, (ilvPoint.y + ilvPoint6.y) / 2.0f, string, 0.0);
                break;
            }
            case 5: {
                double d;
                if (ilvPoint == null || ilvPoint4 == null || ilvPoint5 == null || ilvPoint6 == null) break;
                double d11 = Math.atan((ilvPoint5.y - ilvPoint6.y) / (ilvPoint5.x - ilvPoint6.x));
                double d12 = Math.atan((ilvPoint4.y - ilvPoint6.y) / (ilvPoint4.x - ilvPoint6.x));
                double d13 = Point2D.distance(ilvPoint6.x, ilvPoint6.y, ilvPoint.x, ilvPoint.y);
                ilvGraphicSet = new IlvGraphicSet();
                IlvLine ilvLine = new IlvLine(ilvPoint5.x, ilvPoint5.y, (float)(d13 * Math.cos(d11) + (double)ilvPoint6.x), (float)(d13 * Math.sin(d11) + (double)ilvPoint6.y));
                IlvLine ilvLine3 = new IlvLine(ilvPoint4.x, ilvPoint4.y, (float)(d13 * Math.cos(d12) + (double)ilvPoint6.x), (float)(d13 * Math.sin(d12) + (double)ilvPoint6.y));
                if (d11 > d12) {
                    d = d11;
                    d11 = d12;
                    d12 = d;
                }
                this.a.clear();
                for (d = d11; d < d12; d += (d12 - d11) / 16.0) {
                    this.a.add(d13 * Math.cos(d) + (double)ilvPoint6.x);
                    this.a.add(d13 * Math.sin(d) + (double)ilvPoint6.y);
                }
                double[] dArray = this.a.toArray();
                IlvPoint[] ilvPointArray = IlvDefaultDXFGraphicFactory.a(dArray);
                IlvDefaultDXFGraphicFactory.a(ilvGraphicSet, ilvPointArray);
                ilvGraphicSet.addObject(ilvLine, false);
                ilvGraphicSet.addObject(ilvLine3, false);
                if (!bl) break;
                IlvDefaultDXFGraphicFactory.a(ilvGraphicSet, ilvPoint2.x, ilvPoint2.y, string, 0.0);
                break;
            }
            case 6: {
                break;
            }
            default: {
                IlvPoint ilvPoint8 = null;
                if (ilvPoint == null || ilvPoint4 == null || ilvPoint5 == null) break;
                ilvPoint8 = ilvPoint.y == ilvPoint5.y ? new IlvPoint(ilvPoint.x, ilvPoint4.y) : (ilvPoint.x == ilvPoint5.x ? new IlvPoint(ilvPoint4.x, ilvPoint.y) : new IlvPoint(ilvPoint4.x + (ilvPoint.x - ilvPoint5.x), ilvPoint4.y + (ilvPoint.y - ilvPoint5.y)));
                ilvGraphicSet = new IlvGraphicSet();
                IlvLine ilvLine = new IlvLine(ilvPoint5.x, ilvPoint5.y, ilvPoint.x, ilvPoint.y);
                IlvLine ilvLine4 = new IlvLine(ilvPoint4.x, ilvPoint4.y, ilvPoint8.x, ilvPoint8.y);
                ilvGraphicSet.addObject(ilvLine, false);
                ilvGraphicSet.addObject(ilvLine4, false);
                IlvDefaultDXFGraphicFactory.a(ilvGraphicSet, ilvPoint8, ilvPoint);
                if (!bl) break;
                double d = ilvPoint5.x - ilvPoint.x != 0.0f ? -Math.atan((ilvPoint5.y - ilvPoint.y) / (ilvPoint5.x - ilvPoint.x)) : -1.5707963267948966;
                IlvDefaultDXFGraphicFactory.a(ilvGraphicSet, ilvPoint2.x, ilvPoint2.y, string, d);
            }
        }
        return ilvGraphicSet;
    }

    private static void a(IlvGraphicSet ilvGraphicSet, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        IlvArrowLine ilvArrowLine = new IlvArrowLine(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, 1.0f);
        IlvArrowLine ilvArrowLine2 = new IlvArrowLine(ilvPoint2.x, ilvPoint2.y, ilvPoint.x, ilvPoint.y, 1.0f);
        ilvGraphicSet.addObject(ilvArrowLine, false);
        ilvGraphicSet.addObject(ilvArrowLine2, false);
    }

    private static void a(IlvGraphicSet ilvGraphicSet, IlvPoint[] ilvPointArray) {
        IlvArrowPolyline ilvArrowPolyline = new IlvArrowPolyline(ilvPointArray);
        IlvArrowPolyline ilvArrowPolyline2 = new IlvArrowPolyline(IlvDefaultDXFGraphicFactory.a(ilvPointArray));
        ilvGraphicSet.addObject(ilvArrowPolyline, false);
        ilvGraphicSet.addObject(ilvArrowPolyline2, false);
    }

    private static final IlvPoint[] a(IlvPoint[] ilvPointArray) {
        int n;
        int n2 = n = ilvPointArray != null ? ilvPointArray.length : 0;
        if (n <= 1) {
            return ilvPointArray;
        }
        IlvPoint[] ilvPointArray2 = new IlvPoint[n];
        for (int i = 0; i < n; ++i) {
            ilvPointArray2[i] = new IlvPoint(ilvPointArray[n - i - 1]);
        }
        return ilvPointArray2;
    }

    /*
     * Unable to fully structure code
     */
    private static void a(IlvGraphicBag var0, float var1_1, float var2_2, String var3_3, double var4_4) {
        if (var3_3.startsWith("%%u")) ** GOTO lbl-1000
        if (var3_3.startsWith("%%U")) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = var6_5 = false;
        }
        if (var6_5 && (var7_6 = var3_3.length()) > 3) {
            var3_3 = var3_3.substring(3, var7_6);
        }
        if (var3_3.length() == 0) {
            return;
        }
        var7_7 = new IlvText(new IlvPoint(var1_1, var2_2), var3_3);
        if (var6_5) {
            var7_7.setUnderline(true);
        }
        var10_8 = var7_7.getLabelBBox(null);
        var8_9 = var10_8.height / 6.0f;
        var9_10 = var10_8.width / var8_9;
        var7_7.resize(var9_10, 6.0f);
        var11_11 = var7_7.getLabelBBox(null);
        var7_7.move(var1_1 - var11_11.width * 0.5f, var2_2 - var11_11.height * 0.5f);
        var7_7.rotate(new IlvPoint(0.0f, 0.0f), var4_4);
        var0.addObject(var7_7, false);
    }

    private static IlvPoint[] a(double[] dArray) {
        int n = dArray.length;
        int n2 = n >> 1;
        IlvPoint[] ilvPointArray = new IlvPoint[n2];
        for (int i = 0; i < n - 1; i += 2) {
            float f = (float)dArray[i];
            float f2 = (float)dArray[i + 1];
            int n3 = i >> 1;
            ilvPointArray[n3] = new IlvPoint(f, f2);
        }
        return ilvPointArray;
    }

    @Override
    public IlvGraphic createInsert(IlvGraphicVector ilvGraphicVector, String string, Color color) {
        int n;
        int n2 = n = ilvGraphicVector != null ? ilvGraphicVector.size() : 0;
        if (n == 0) {
            return null;
        }
        IlvGraphic ilvGraphic = null;
        if (n == 1) {
            ilvGraphic = ilvGraphicVector.elementAt(0);
        } else {
            IlvGraphicSet ilvGraphicSet = new IlvGraphicSet();
            for (int i = 0; i < n; ++i) {
                ilvGraphicSet.addObject(ilvGraphicVector.elementAt(i), false);
            }
            ilvGraphicSet.setForeground(color);
            ilvGraphic = ilvGraphicSet;
        }
        if (ilvGraphic != null) {
            IlvDefaultDXFGraphicFactory.setBlockName(ilvGraphic, string);
        }
        return ilvGraphic;
    }

    public static void setBlockName(IlvGraphic ilvGraphic, String string) {
        if (ilvGraphic == null) {
            throw new IllegalArgumentException("blockGraphic cannot be null");
        }
        if (string != null && string.length() > 0) {
            IlvSingleValueNamedProperty ilvSingleValueNamedProperty = new IlvSingleValueNamedProperty(k, string);
            ilvGraphic.setNamedProperty(ilvSingleValueNamedProperty);
        }
    }

    public static String getBlockName(IlvGraphic ilvGraphic) {
        Object object;
        if (ilvGraphic == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        IlvNamedProperty ilvNamedProperty = ilvGraphic.getNamedProperty(k);
        if (ilvNamedProperty instanceof IlvSingleValueNamedProperty && (object = ((IlvSingleValueNamedProperty)ilvNamedProperty).getValue()) instanceof String) {
            return (String)object;
        }
        return null;
    }
}

