/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.gui;

import ilog.views.applications.util.wizard.IlvBoxUtils;
import ilog.views.applications.util.wizard.IlvMessagesSupport;
import ilog.views.builder.editor.IlvCSSMicroCustomizer;
import ilog.views.builder.event.IlvStyleChangeSupport;
import ilog.views.builder.event.StyleChangeListener;
import ilog.views.builder.gui.IlvDecimalNumberCustomizer;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.css.model.internal.IlvCSSWriter;
import ilog.views.util.beans.editor.IlvColorPropertyEditor;
import ilog.views.util.css.IlvCSSDOMImplementation;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.cssbeans.IlvCSSBeans;
import ilog.views.util.psheet.CustomPropertyEditor;
import ilog.views.util.swing.IlvJComboBox;
import ilog.views.util.swing.SwingFactories;
import ilog.views.util.swing.border.IlvEtchedLineBorder;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IlvBorderCustomizer
extends JPanel
implements IlvCSSMicroCustomizer {
    protected IlvStyleChangeSupport _ssupport = new IlvStyleChangeSupport(this);
    private IlvMessagesSupport a = new IlvMessagesSupport("ilog.views.builder.gui.border");
    private IlvCSSWriter b = new IlvCSSWriter(IlvCSSBeans.createDOMImplementation());
    private JFrame c;
    private JDialog d;
    private SettingPanel e;
    protected JComboBox _borderBox;
    private JButton f;
    private Map g = new HashMap();
    private Border h;
    private String i;
    private boolean j;

    public IlvBorderCustomizer(JFrame jFrame, String string) {
        this(jFrame, string, true);
    }

    private IlvBorderCustomizer(JFrame jFrame, String string, boolean bl) {
        this.c = jFrame;
        this.i = string;
        this.setLayout(new BoxLayout(this, SwingFactories.getBoxLayoutLineAxis()));
        Object[] objectArray = this.initializeBorders(bl);
        this._borderBox = new IlvJComboBox(objectArray);
        this._borderBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    jLabel.setIcon((BorderImpl)object);
                    jLabel.setText(((BorderImpl)object).getLabel());
                }
                jLabel.setComponentOrientation(jList.getComponentOrientation());
                return jLabel;
            }
        });
        this._borderBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    IlvBorderCustomizer.this.borderSelected(((JComboBox)itemEvent.getSource()).getSelectedItem());
                }
            }
        });
        this.add(this._borderBox);
        this.add(Box.createHorizontalStrut(3));
        this.f = new JButton(this.a("Builder.BorderEditor.Configure"));
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvBorderCustomizer.this.a();
            }
        });
        this.add(this.f);
        this.b((BorderImpl)this._borderBox.getSelectedItem());
    }

    protected BorderImpl[] initializeBorders(boolean bl) {
        BorderImpl[] borderImplArray = new BorderImpl[bl ? 8 : 6];
        int n = 0;
        if (bl) {
            int n2 = n++;
            borderImplArray[n2] = new BorderImpl(null, this.a("Builder.BorderEditor.None")){

                @Override
                public BorderSettingPanel createSettingPanel() {
                    return null;
                }

                @Override
                public boolean accept(Border border) {
                    return border == null;
                }
            };
        }
        int n3 = n++;
        borderImplArray[n3] = new BorderImpl(BorderFactory.createEtchedBorder(), this.a("Builder.BorderEditor.Etched")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new EtchedSetting(true);
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == EtchedBorder.class;
            }
        };
        int n4 = n++;
        borderImplArray[n4] = new BorderImpl(BorderFactory.createLineBorder(Color.black), this.a("Builder.BorderEditor.Line")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new LineSetting();
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == LineBorder.class;
            }
        };
        int n5 = n++;
        borderImplArray[n5] = new BorderImpl(BorderFactory.createRaisedBevelBorder(), this.a("Builder.BorderEditor.Bevel")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new BevelSetting();
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == BevelBorder.class;
            }
        };
        int n6 = n++;
        borderImplArray[n6] = new BorderImpl(BorderFactory.createTitledBorder(this.a("Builder.BorderEditor.TitledBorderTitle")), this.a("Builder.BorderEditor.Titled")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new TitledSetting();
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == TitledBorder.class;
            }
        };
        int n7 = n++;
        borderImplArray[n7] = new BorderImpl(BorderFactory.createMatteBorder(1, 5, 2, 1, Color.black), this.a("Builder.BorderEditor.Matte")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new MatteSetting();
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == MatteBorder.class;
            }
        };
        if (bl) {
            int n8 = n++;
            borderImplArray[n8] = new BorderImpl(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createLineBorder(Color.black)), this.a("Builder.BorderEditor.Compound")){

                @Override
                public BorderSettingPanel createSettingPanel() {
                    return new CompoundSetting();
                }

                @Override
                public boolean accept(Border border) {
                    return border.getClass() == CompoundBorder.class;
                }
            };
        }
        int n9 = n++;
        borderImplArray[n9] = new BorderImpl(BorderFactory.createEmptyBorder(), this.a("Builder.BorderEditor.Empty")){

            @Override
            public BorderSettingPanel createSettingPanel() {
                return new EmptySetting();
            }

            @Override
            public boolean accept(Border border) {
                return border.getClass() == EmptyBorder.class;
            }
        };
        return borderImplArray;
    }

    protected void borderSelected(Object object) {
        this.b((BorderImpl)object);
        this.j = true;
        BorderSettingPanel borderSettingPanel = this.a((BorderImpl)object);
        this.h = borderSettingPanel != null ? borderSettingPanel.createBorder() : null;
        this.fireStyleChangeEvent(true);
        this.j = false;
    }

    public Border getSelectedBorder() {
        return this.h;
    }

    protected String getPropertyName() {
        return this.i;
    }

    private void a() {
        BorderSettingPanel borderSettingPanel;
        BorderImpl borderImpl = (BorderImpl)this._borderBox.getSelectedItem();
        if (this.d == null) {
            this.b();
        }
        if ((borderSettingPanel = this.a(borderImpl)) != null) {
            this.e.setPanel(borderSettingPanel);
            borderSettingPanel.setObject(this.h);
            this.d.setTitle(borderSettingPanel.getSettingTitle());
            this.d.setLocationRelativeTo(this.c);
            this.d.pack();
            this.d.setVisible(true);
            if (this.e.isOk()) {
                this.h = borderSettingPanel.createBorder();
                borderImpl.setBorder(this.h);
                this.fireStyleChangeEvent(true);
            }
        }
    }

    private void b() {
        this.d = new JDialog(this.c, "", true);
        this.e = new SettingPanel(this.a);
        this.d.getContentPane().add(this.e);
    }

    private BorderSettingPanel a(BorderImpl borderImpl) {
        Class<?> clazz;
        BorderSettingPanel borderSettingPanel = null;
        Border border = borderImpl.getBorder();
        if (border != null && (borderSettingPanel = (BorderSettingPanel)this.g.get(clazz = border.getClass())) == null) {
            borderSettingPanel = borderImpl.createSettingPanel();
            this.g.put(clazz, borderSettingPanel);
        }
        return borderSettingPanel;
    }

    private void b(BorderImpl borderImpl) {
        BorderSettingPanel borderSettingPanel = this.a(borderImpl);
        this.f.setEnabled(borderSettingPanel != null && borderSettingPanel.isConfigurable());
    }

    @Override
    public void setObject(Object object) {
        int n;
        Border border;
        if (this.j) {
            return;
        }
        if (object != null && !(object instanceof Border)) {
            throw new IllegalArgumentException("Not a Border.");
        }
        int n2 = this._borderBox.getItemCount();
        this.h = border = (Border)object;
        if (border != null) {
            for (n = 0; n < n2; ++n) {
                BorderSettingPanel borderSettingPanel;
                BorderImpl borderImpl = (BorderImpl)this._borderBox.getItemAt(n);
                if (!borderImpl.accept(border)) continue;
                if (this.e == null) {
                    this.b();
                }
                if ((borderSettingPanel = this.a(borderImpl)) != null) {
                    borderSettingPanel.setObject(border);
                }
                borderImpl.setBorder(border);
                break;
            }
        }
        if (n == n2) {
            n = 0;
        }
        if (n != this._borderBox.getSelectedIndex()) {
            this._borderBox.setSelectedIndex(n);
        }
        this.b((BorderImpl)this._borderBox.getItemAt(n));
    }

    @Override
    public void addStyleChangeListener(StyleChangeListener styleChangeListener) {
        this._ssupport.addStyleChangeListener(styleChangeListener);
    }

    @Override
    public void removeStyleChangeListener(StyleChangeListener styleChangeListener) {
        this._ssupport.removeStyleChangeListener(styleChangeListener);
    }

    @Override
    public void fireStyleChangeEvent(boolean bl) {
        Object object;
        Border border = this.h;
        IlvCSSDOMImplementation ilvCSSDOMImplementation = IlvCSSBeans.createDOMImplementation();
        IlvCSSWriter.IlvCSSCustomizerDeclarations ilvCSSCustomizerDeclarations = null;
        IlvRule[] ilvRuleArray = null;
        IlvRule[] ilvRuleArray2 = null;
        String string = null;
        if (border != null) {
            string = "Subobject#border" + border.hashCode();
            try {
                ilvCSSCustomizerDeclarations = this.b.convert(string, border, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = IlvRuleUtils.createRule(ilvCSSDOMImplementation, string);
            Declaration[] declarationArray = ilvCSSCustomizerDeclarations.getDeclarations();
            for (int i = 0; i < declarationArray.length; ++i) {
                object.setDeclaration(declarationArray[i]);
            }
            ilvRuleArray = ilvCSSCustomizerDeclarations.getAdditionalRules();
            ilvRuleArray2 = new IlvRule[ilvRuleArray.length + 1];
            ilvRuleArray2[0] = object;
        }
        object = null;
        if (this.i != null) {
            object = ilvCSSDOMImplementation.createDeclaration(this.i);
            ((Declaration)object).setValue(border != null ? "@" + string.substring("Subobject".length()) : "");
            if (ilvRuleArray != null && ilvRuleArray.length > 0) {
                System.arraycopy(ilvRuleArray, 0, ilvRuleArray2, 1, ilvRuleArray.length);
            }
            this._ssupport.fireStyleChangeEvent(null, new Declaration[]{object}, !bl, ilvRuleArray2);
            this.repaint();
        }
    }

    public String getStateName() {
        return null;
    }

    private String a(String string) {
        return this.a.getMessage(string);
    }

    static {
        IlvCSSWriter.setConstructorDescriptor(EtchedBorder.class, new IlvCSSWriter.ConstructorDescriptor(){

            @Override
            public String[] getParameters(Object object) {
                String[] stringArray = new String[3];
                stringArray[0] = "etchType";
                stringArray[1] = "highlightColor";
                stringArray[2] = "shadowColor";
                return stringArray;
            }
        });
        IlvCSSWriter.setConstructorDescriptor(LineBorder.class, new IlvCSSWriter.ConstructorDescriptor(){

            @Override
            public String[] getParameters(Object object) {
                String[] stringArray = new String[3];
                stringArray[0] = "lineColor";
                stringArray[1] = "thickness";
                stringArray[2] = "roundedCorners";
                return stringArray;
            }
        });
        IlvCSSWriter.setConstructorDescriptor(BevelBorder.class, new IlvCSSWriter.ConstructorDescriptor(){

            @Override
            public String[] getParameters(Object object) {
                String[] stringArray = new String[5];
                stringArray[0] = "bevelType";
                stringArray[1] = "highlightOuterColor";
                stringArray[2] = "highlightInnerColor";
                stringArray[3] = "shadowOuterColor";
                stringArray[4] = "shadowInnerColor";
                return stringArray;
            }
        });
        IlvCSSWriter.setConstructorDescriptor(TitledBorder.class, new IlvCSSWriter.ConstructorDescriptor(){

            @Override
            public String[] getParameters(Object object) {
                String[] stringArray = new String[1];
                stringArray[0] = "title";
                return stringArray;
            }
        });
        IlvCSSWriter.setConstructorDescriptor(MatteBorder.class, new IlvCSSWriter.ConstructorDescriptor(){

            @Override
            public String[] getParameters(Object object) {
                String[] stringArray = new String[2];
                stringArray[0] = "borderInsets";
                stringArray[1] = "matteColor";
                return stringArray;
            }
        });
        IlvCSSWriter.setConstructorDescriptor(CompoundBorder.class, new IlvCSSWriter.ConstructorDescriptor(){

            @Override
            public String[] getParameters(Object object) {
                String[] stringArray = new String[2];
                stringArray[0] = "outsideBorder";
                stringArray[1] = "insideBorder";
                return stringArray;
            }
        });
        IlvCSSWriter.setConstructorDescriptor(EmptyBorder.class, new IlvCSSWriter.ConstructorDescriptor(){

            @Override
            public String[] getParameters(Object object) {
                String[] stringArray = new String[1];
                stringArray[0] = "borderInsets";
                return stringArray;
            }
        });
    }

    protected static abstract class BorderImpl
    extends BorderIcon {
        private String a;

        public BorderImpl(Border border, String string) {
            this(border, string, new Dimension(25, 20));
        }

        public BorderImpl(Border border, String string, Dimension dimension) {
            super(border, dimension);
            this.a = string;
        }

        public String getLabel() {
            return this.a;
        }

        public abstract BorderSettingPanel createSettingPanel();

        public abstract boolean accept(Border var1);
    }

    private static class BorderIcon
    implements Icon {
        private Border a;
        private Dimension b;
        private JPanel c = new JPanel();

        public BorderIcon(Border border) {
            this(border, new Dimension(25, 20));
        }

        public BorderIcon(Border border, Dimension dimension) {
            this.a = border;
            this.b = dimension;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.a == null) {
                return;
            }
            graphics.setColor(UIManager.getColor("Panel.background"));
            graphics.fillRect(n, n2, this.b.width, this.b.height);
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setClip(n, n2, this.b.width, this.b.height);
            this.a.paintBorder(this.c, graphics, n, n2, this.b.width, this.b.height);
            graphics.setClip(rectangle);
        }

        @Override
        public final int getIconHeight() {
            return this.b.height;
        }

        @Override
        public final int getIconWidth() {
            return this.b.width;
        }

        public final void setBorder(Border border) {
            this.a = border;
        }

        public final Border getBorder() {
            return this.a;
        }
    }

    private static class SettingPanel
    extends JPanel
    implements ActionListener,
    PropertyChangeListener {
        private static final String a = "_OK_CMD__";
        private static final String b = "_CANCEL_CMD__";
        private boolean c;
        private BorderSettingPanel d;
        private BorderIcon e;
        private JPanel f;

        public SettingPanel(IlvMessagesSupport ilvMessagesSupport) {
            double[][] dArrayArray = new double[][]{{2.0, -1.0, 3.0, -1.0, 2.0}, {-1.0, 2.0, -2.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            JButton jButton = new JButton(ilvMessagesSupport.getMessage("Builder.BorderEditor.OK"));
            jButton.setActionCommand(a);
            jButton.addActionListener(this);
            Box box = SwingFactories.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(jButton);
            box.add(Box.createHorizontalStrut(5));
            Dimension dimension = jButton.getPreferredSize();
            JButton jButton2 = new JButton(ilvMessagesSupport.getMessage("Builder.BorderEditor.CANCEL"));
            jButton2.setActionCommand(b);
            jButton2.addActionListener(this);
            box.add(jButton2);
            box.add(Box.createHorizontalGlue());
            Dimension dimension2 = jButton2.getPreferredSize();
            if (dimension.width > dimension2.width) {
                dimension2.width = dimension.width;
            } else {
                dimension.width = dimension2.width;
            }
            jButton.setPreferredSize(dimension);
            jButton2.setPreferredSize(dimension2);
            if (box instanceof JComponent) {
                ((JComponent)box).setBorder(BorderFactory.createCompoundBorder(new IlvEtchedLineBorder(1), BorderFactory.createEmptyBorder(4, 0, 4, 0)));
            }
            IlvBoxUtils.alignCenter(box);
            this.add((Component)box, "1,2,3,2");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(new IlvEtchedLineBorder(1), ilvMessagesSupport.getMessage("Builder.BorderEditor.Preview")));
            this.e = new BorderIcon(BorderFactory.createEmptyBorder(), new Dimension(60, 50));
            jPanel.add((Component)new JLabel(this.e), "Center");
            this.add((Component)jPanel, "3,0");
            this.f = new JPanel(new BorderLayout());
            this.f.setOpaque(false);
            this.f.setBorder(BorderFactory.createTitledBorder(new IlvEtchedLineBorder(1), ilvMessagesSupport.getMessage("Builder.BorderEditor.Settings")));
            this.add((Component)this.f, "1,0");
            Component component = Box.createHorizontalStrut(5);
            this.add(component, "2,0");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.c = actionEvent.getActionCommand() == a;
            SwingUtilities.getRoot(this).setVisible(false);
        }

        public void setPanel(BorderSettingPanel borderSettingPanel) {
            if (this.d != null) {
                this.e.setBorder(BorderFactory.createEmptyBorder());
                this.f.remove(this.d);
                this.d.removePropertyChangeListener(this);
            }
            this.d = borderSettingPanel;
            if (this.d != null) {
                this.e.setBorder(this.d.createBorder());
                this.f.add((Component)this.d, "Center");
                this.d.addPropertyChangeListener(this);
            }
            this.revalidate();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.e.setBorder(this.d.createBorder());
            this.revalidate();
            this.repaint();
        }

        public boolean isOk() {
            return this.c;
        }
    }

    private final class CompoundSetting
    extends BorderSettingPanel {
        private IlvBorderCustomizer a;
        private IlvBorderCustomizer b;

        public CompoundSetting() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = SwingFactories.getGridBagLayoutLineStart();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 50.0;
            JLabel jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Compound.Inner"));
            this.a = new IlvBorderCustomizer(IlvBorderCustomizer.this.c, null, false){

                @Override
                public void fireStyleChangeEvent(boolean bl) {
                    CompoundSetting.this.propertyChange(null);
                }

                @Override
                protected void borderSelected(Object object) {
                    super.borderSelected(object);
                    CompoundSetting.this.propertyChange(null);
                }
            };
            gridBagConstraints.gridy = 1;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.add((Component)this.a, gridBagConstraints);
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Compound.Outer"));
            this.b = new IlvBorderCustomizer(IlvBorderCustomizer.this.c, null, false){

                @Override
                public void fireStyleChangeEvent(boolean bl) {
                    CompoundSetting.this.propertyChange(null);
                }

                @Override
                protected void borderSelected(Object object) {
                    super.borderSelected(object);
                    CompoundSetting.this.propertyChange(null);
                }
            };
            gridBagConstraints.gridy = 3;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridy = 4;
            this.add((Component)this.b, gridBagConstraints);
        }

        @Override
        public Border createBorder() {
            Border border = this.a.getSelectedBorder();
            Border border2 = this.b.getSelectedBorder();
            return new CompoundBorder(border2 != null ? border2 : BorderFactory.createEmptyBorder(), border != null ? border : BorderFactory.createEmptyBorder());
        }

        private void a() {
            IlvBorderCustomizer.this.b.reset();
            this.propertyChange(null);
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderCustomizer.this.a("Builder.BorderEditor.Compound.SettingTitle");
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof CompoundBorder)) {
                throw new IllegalArgumentException("Not a CompoundBorder");
            }
            CompoundBorder compoundBorder = (CompoundBorder)object;
            this.a.setObject(compoundBorder.getInsideBorder());
            this.b.setObject(compoundBorder.getOutsideBorder());
        }
    }

    private final class MatteSetting
    extends BorderSettingPanel {
        private Insets a;
        private IlvColorPropertyEditor b;
        private IlvDecimalNumberCustomizer c;
        private IlvDecimalNumberCustomizer d;
        private IlvDecimalNumberCustomizer e;
        private IlvDecimalNumberCustomizer f;

        public MatteSetting() {
            this.a = new Insets(1, 1, 1, 1);
            double[][] dArrayArray = new double[][]{{3.0, -1.0, 3.0, -1.0, 3.0}, {-1.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, -1.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            JLabel jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Matte.Color"));
            CustomPropertyEditor customPropertyEditor = new CustomPropertyEditor(IlvBorderCustomizer.this.c, null);
            this.b = new IlvColorPropertyEditor();
            this.b.setValue(Color.black);
            customPropertyEditor.setEditor(this.b);
            this.b.addPropertyChangeListener(this);
            this.add((Component)jLabel, "1,1");
            this.add((Component)customPropertyEditor, "3,1");
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Empty.Left"));
            this.c = new IlvDecimalNumberCustomizer(null, 0.0, 10.0, 1.0f, null, null);
            this.c.setValue(this.a.left);
            this.c.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ((MatteSetting)MatteSetting.this).a.left = ((Double)propertyChangeEvent.getNewValue()).intValue();
                    MatteSetting.this.propertyChange(null);
                }
            });
            this.add((Component)jLabel, "1,3");
            this.add((Component)this.c, "3,3");
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Empty.Right"));
            this.f = new IlvDecimalNumberCustomizer(null, 0.0, 10.0, 1.0f, null, null);
            this.f.setValue(this.a.right);
            this.f.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ((MatteSetting)MatteSetting.this).a.right = ((Double)propertyChangeEvent.getNewValue()).intValue();
                    MatteSetting.this.propertyChange(null);
                }
            });
            this.add((Component)jLabel, "1,5");
            this.add((Component)this.f, "3,5");
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Empty.Top"));
            this.d = new IlvDecimalNumberCustomizer(null, 0.0, 10.0, 1.0f, null, null);
            this.d.setValue(this.a.top);
            this.d.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ((MatteSetting)MatteSetting.this).a.top = ((Double)propertyChangeEvent.getNewValue()).intValue();
                    MatteSetting.this.propertyChange(null);
                }
            });
            this.add((Component)jLabel, "1,7");
            this.add((Component)this.d, "3,7");
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Empty.Bottom"));
            this.e = new IlvDecimalNumberCustomizer(null, 0.0, 10.0, 1.0f, null, null);
            this.e.setValue(this.a.bottom);
            this.e.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ((MatteSetting)MatteSetting.this).a.bottom = ((Double)propertyChangeEvent.getNewValue()).intValue();
                    MatteSetting.this.propertyChange(null);
                }
            });
            this.add((Component)jLabel, "1,9");
            this.add((Component)this.e, "3,9");
        }

        @Override
        public Border createBorder() {
            return new MatteBorder(this.a, (Color)this.b.getValue());
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderCustomizer.this.a("Builder.BorderEditor.Matte.SettingTitle");
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof MatteBorder)) {
                throw new IllegalArgumentException("Not a MatteBorder");
            }
            this.a = ((MatteBorder)object).getBorderInsets();
            this.c.setValue(this.a.left);
            this.f.setValue(this.a.right);
            this.d.setValue(this.a.top);
            this.e.setValue(this.a.bottom);
            this.b.setValue(((MatteBorder)object).getMatteColor());
        }
    }

    private final class EmptySetting
    extends BorderSettingPanel {
        Insets a;
        private IlvDecimalNumberCustomizer b;
        private IlvDecimalNumberCustomizer c;
        private IlvDecimalNumberCustomizer d;
        private IlvDecimalNumberCustomizer e;

        public EmptySetting() {
            this.a = new Insets(1, 1, 1, 1);
            double[][] dArrayArray = new double[][]{{3.0, -1.0, 3.0, -1.0, 3.0}, {-1.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, -1.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    EmptySetting.this.propertyChange(null);
                }
            };
            JLabel jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Empty.Left"));
            this.b = new IlvDecimalNumberCustomizer(null, 0.0, 99.0, 1.0f, null, null);
            this.b.setValue(this.a.left);
            this.b.addPropertyChangeListener("value", propertyChangeListener);
            this.add((Component)jLabel, "1,1");
            this.add((Component)this.b, "3,1");
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Empty.Right"));
            this.e = new IlvDecimalNumberCustomizer(null, 0.0, 99.0, 1.0f, null, null);
            this.e.setValue(this.a.right);
            this.e.addPropertyChangeListener("value", propertyChangeListener);
            this.add((Component)jLabel, "1,3");
            this.add((Component)this.e, "3,3");
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Empty.Top"));
            this.c = new IlvDecimalNumberCustomizer(null, 0.0, 99.0, 1.0f, null, null);
            this.c.setValue(this.a.top);
            this.c.addPropertyChangeListener("value", propertyChangeListener);
            this.add((Component)jLabel, "1,5");
            this.add((Component)this.c, "3,5");
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Empty.Bottom"));
            this.d = new IlvDecimalNumberCustomizer(null, 0.0, 99.0, 1.0f, null, null);
            this.d.setValue(this.a.bottom);
            this.d.addPropertyChangeListener("value", propertyChangeListener);
            this.add((Component)jLabel, "1,7");
            this.add((Component)this.d, "3,7");
        }

        @Override
        public Border createBorder() {
            this.a.top = (int)this.c.getValue();
            this.a.left = (int)this.b.getValue();
            this.a.right = (int)this.e.getValue();
            this.a.bottom = (int)this.d.getValue();
            return new EmptyBorder(this.a);
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderCustomizer.this.a("Builder.BorderEditor.Empty.SettingTitle");
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof EmptyBorder)) {
                throw new IllegalArgumentException("Not a EmptyBorder");
            }
            this.a = ((EmptyBorder)object).getBorderInsets();
            this.b.setValue(this.a.left);
            this.e.setValue(this.a.right);
            this.c.setValue(this.a.top);
            this.d.setValue(this.a.bottom);
        }
    }

    private final class TitledSetting
    extends BorderSettingPanel {
        private JTextField a;

        public TitledSetting() {
            double[][] dArrayArray = new double[][]{{3.0, -1.0, 3.0, -1.0, 3.0}, {-1.0, -2.0, -1.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            this.a = new JTextField(10);
            this.a.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TitledSetting.this.propertyChange(null);
                }
            });
            JLabel jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Title.Title"));
            this.add((Component)jLabel, "1,1");
            this.add((Component)this.a, "3,1");
        }

        @Override
        public Border createBorder() {
            return new TitledBorder(this.a.getText());
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof TitledBorder)) {
                throw new IllegalArgumentException("Not a TitledBorder");
            }
            this.a.setText(((TitledBorder)object).getTitle());
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderCustomizer.this.a("Builder.BorderEditor.Title.SettingTitle");
        }
    }

    private final class LineSetting
    extends BorderSettingPanel {
        private IlvColorPropertyEditor a;
        private JSlider b;
        private JCheckBox c;

        public LineSetting() {
            double[][] dArrayArray = new double[][]{{3.0, -1.0, 3.0, -1.0, 3.0}, {-1.0, -2.0, 2.0, -2.0, 2.0, -2.0, -1.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            JLabel jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Line.LineColor"));
            CustomPropertyEditor customPropertyEditor = new CustomPropertyEditor(IlvBorderCustomizer.this.c, null);
            this.a = new IlvColorPropertyEditor();
            customPropertyEditor.setEditor(this.a);
            this.a.addPropertyChangeListener(this);
            this.add((Component)jLabel, "1,1");
            this.add((Component)customPropertyEditor, "3,1");
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Line.Thickness"));
            this.b = new JSlider(0, 1, 10, 1);
            Dimension dimension = this.b.getPreferredSize();
            dimension.width = 80;
            this.b.setPreferredSize(dimension);
            this.b.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    LineSetting.this.propertyChange(null);
                }
            });
            this.add((Component)jLabel, "1,3");
            this.add((Component)this.b, "3,3");
            this.c = new JCheckBox(IlvBorderCustomizer.this.a("Builder.BorderEditor.Line.RoundCorner"));
            this.c.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    LineSetting.this.propertyChange(null);
                }
            });
            this.add((Component)this.c, "1,5,3,5");
        }

        @Override
        public Border createBorder() {
            return new LineBorder((Color)this.a.getValue(), this.b.getValue(), this.c.isSelected());
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof LineBorder)) {
                throw new IllegalArgumentException("Not a LineBorder");
            }
            LineBorder lineBorder = (LineBorder)object;
            this.b.setValue(lineBorder.getThickness());
            this.c.setSelected(lineBorder.getRoundedCorners());
            this.a.setValue(lineBorder.getLineColor());
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderCustomizer.this.a("Builder.BorderEditor.Line.SettingTitle");
        }
    }

    private final class BevelSetting
    extends EtchedSetting {
        public BevelSetting() {
            super(true);
        }

        @Override
        public Border createBorder() {
            return new BevelBorder(((EtchedSetting)this).a, this.c, this.c, this.d, this.d);
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderCustomizer.this.a("Builder.BorderEditor.Bevel.SettingTitle");
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof BevelBorder)) {
                throw new IllegalArgumentException("Not a BevelBorder");
            }
            BevelBorder bevelBorder = (BevelBorder)object;
            this.h.setSelected(bevelBorder.getBevelType() == this.getLoweredTypeValue());
            this.c = bevelBorder.getHighlightInnerColor();
            boolean bl = this.c == null;
            this.f.setSelected(bl);
            this.b.setValue(!bl ? this.c : bevelBorder.getHighlightInnerColor(this.j));
            this.d = bevelBorder.getShadowInnerColor();
            bl = this.d == null;
            this.g.setSelected(bl);
            this.e.setValue(!bl ? this.d : bevelBorder.getShadowInnerColor(this.j));
        }

        @Override
        protected int getLoweredTypeValue() {
            return 1;
        }

        @Override
        protected int getRaisedTypeValue() {
            return 0;
        }
    }

    private class EtchedSetting
    extends BorderSettingPanel {
        int a;
        IlvColorPropertyEditor b;
        Color c;
        Color d;
        IlvColorPropertyEditor e;
        JCheckBox f;
        JCheckBox g;
        JRadioButton h;
        JRadioButton i;
        JPanel j;

        public EtchedSetting(boolean bl) {
            Serializable serializable;
            Serializable serializable2;
            JLabel jLabel;
            this.a = this.getLoweredTypeValue();
            this.j = new JPanel();
            double[][] dArrayArray = new double[][]{{3.0, -1.0, 3.0, -1.0, 3.0}, {-1.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 2.0, -2.0, -1.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])dArrayArray));
            if (bl) {
                jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Etched.Type"));
                serializable2 = new Dimension(22, 22);
                serializable = new ButtonGroup();
                this.h = new JRadioButton(IlvBorderCustomizer.this.a("Builder.BorderEditor.Etched.Lowered"));
                this.h.setToolTipText(IlvBorderCustomizer.this.a("Builder.BorderEditor.Etched.Lowered"));
                ItemListener itemListener = new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            EtchedSetting.this.a = itemEvent.getSource() == EtchedSetting.this.h ? EtchedSetting.this.getLoweredTypeValue() : EtchedSetting.this.getRaisedTypeValue();
                            EtchedSetting.this.propertyChange(null);
                        }
                    }
                };
                this.h.addItemListener(itemListener);
                ((ButtonGroup)serializable).add(this.h);
                this.i = new JRadioButton(IlvBorderCustomizer.this.a("Builder.BorderEditor.Etched.Raised"));
                this.i.setToolTipText(IlvBorderCustomizer.this.a("Builder.BorderEditor.Etched.Raised"));
                this.i.addItemListener(itemListener);
                ((ButtonGroup)serializable).add(this.i);
                this.add((Component)jLabel, "1,1");
                this.add((Component)this.h, "1,3");
                this.add((Component)this.i, "3,3");
            }
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Etched.Highlight"));
            serializable2 = new CustomPropertyEditor(IlvBorderCustomizer.this.c, null);
            this.b = new IlvColorPropertyEditor();
            ((CustomPropertyEditor)serializable2).setEditor(this.b);
            this.f = new JCheckBox(IlvBorderCustomizer.this.a("Builder.BorderEditor.Etched.Automatic"));
            this.f.addItemListener(new ItemListener((CustomPropertyEditor)serializable2){
                final /* synthetic */ CustomPropertyEditor b;
                {
                    this.b = customPropertyEditor;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        EtchedSetting.this.c = null;
                        this.b.setEnabled(false);
                    } else {
                        this.b.setEnabled(true);
                        EtchedSetting.this.c = (Color)EtchedSetting.this.b.getValue();
                    }
                    EtchedSetting.this.propertyChange(null);
                }
            });
            this.b.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    EtchedSetting.this.c = (Color)EtchedSetting.this.b.getValue();
                }
            });
            this.b.addPropertyChangeListener(this);
            this.add((Component)jLabel, "1,5");
            this.add((Component)this.f, "1,7");
            this.add((Component)serializable2, "3,7");
            jLabel = new JLabel(IlvBorderCustomizer.this.a("Builder.BorderEditor.Etched.Shadow"));
            serializable = new CustomPropertyEditor(IlvBorderCustomizer.this.c, null);
            this.e = new IlvColorPropertyEditor();
            ((CustomPropertyEditor)serializable).setEditor(this.e);
            this.g = new JCheckBox(IlvBorderCustomizer.this.a("Builder.BorderEditor.Etched.Automatic"));
            this.g.addItemListener(new ItemListener((CustomPropertyEditor)serializable){
                final /* synthetic */ CustomPropertyEditor b;
                {
                    this.b = customPropertyEditor;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        EtchedSetting.this.d = null;
                        this.b.setEnabled(false);
                    } else {
                        this.b.setEnabled(true);
                        EtchedSetting.this.d = (Color)EtchedSetting.this.e.getValue();
                    }
                    EtchedSetting.this.propertyChange(null);
                }
            });
            this.e.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    EtchedSetting.this.d = (Color)EtchedSetting.this.e.getValue();
                }
            });
            this.e.addPropertyChangeListener(this);
            this.add((Component)jLabel, "1,9");
            this.add((Component)this.g, "1,11");
            this.add((Component)serializable, "3,11");
        }

        @Override
        public Border createBorder() {
            return BorderFactory.createEtchedBorder(this.a, this.c, this.d);
        }

        @Override
        public void setObject(Object object) {
            if (!(object instanceof EtchedBorder)) {
                throw new IllegalArgumentException("Not a EtchedBorder");
            }
            EtchedBorder etchedBorder = (EtchedBorder)object;
            this.h.setSelected(etchedBorder.getEtchType() == this.getLoweredTypeValue());
            this.c = etchedBorder.getHighlightColor();
            boolean bl = this.c == null;
            this.f.setSelected(bl);
            this.b.setValue(!bl ? this.c : etchedBorder.getHighlightColor(this.j));
            this.d = etchedBorder.getShadowColor();
            bl = this.d == null;
            this.g.setSelected(bl);
            this.e.setValue(!bl ? this.d : etchedBorder.getShadowColor(this.j));
        }

        @Override
        public String getSettingTitle() {
            return IlvBorderCustomizer.this.a("Builder.BorderEditor.Etched.SettingTitle");
        }

        protected int getLoweredTypeValue() {
            return 1;
        }

        protected int getRaisedTypeValue() {
            return 0;
        }
    }

    protected abstract class BorderSettingPanel
    extends JPanel
    implements PropertyChangeListener {
        PropertyChangeEvent a = new PropertyChangeEvent(this, null, null, null);
        private PropertyChangeSupport b = new PropertyChangeSupport(this);

        protected BorderSettingPanel() {
        }

        public abstract Border createBorder();

        public abstract String getSettingTitle();

        public boolean isConfigurable() {
            return true;
        }

        public void setObject(Object object) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                propertyChangeEvent = this.a;
            }
            this.b.firePropertyChange(propertyChangeEvent);
            this.revalidate();
            this.repaint();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.b.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.b.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

