/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.docview;

import ilog.views.appframe.IlvAction;
import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvAbstractDocument;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.event.ApplicationEvent;
import ilog.views.appframe.event.IlvApplicationAdapter;
import ilog.views.appframe.swing.IlvSwingMainWindow;
import ilog.views.appframe.swing.IlvTreeView;
import ilog.views.builder.IlvBuilder;
import ilog.views.builder.docview.IlvBuilderDocument;
import ilog.views.builder.gui.Utils;
import ilog.views.css.model.IlvRule;
import ilog.views.util.IlvImageUtil;
import ilog.views.util.css.IlvCSS;
import ilog.views.util.cssbeans.IlvCSSBeans;
import ilog.views.util.swing.IlvJComboBox;
import ilog.views.util.swing.IlvSwingUtil;
import ilog.views.util.swing.layout.IlvBetterFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class IlvMessageView
extends IlvTreeView {
    private DefaultTreeModel a;
    private DefaultMutableTreeNode b;
    private TreePath c;
    private HashMap d = new HashMap();
    private Icon e;
    private Icon f;
    private Icon g;
    private Icon h;
    private String i;
    private String j;
    private JButton k;
    private boolean l = true;
    private IlvBuilderDocument m;
    private boolean n = true;
    private Level o = q;
    private static HashMap p = new HashMap();
    private static final Level q = Level.SEVERE;
    private static final boolean r = false;

    public IlvMessageView() {
        this.e = this.c("error.png");
        this.f = this.c("warning.png");
        this.g = this.c("info.png");
        this.h = this.c("grayinfo.png");
    }

    public static void setEnabled(IlvApplication ilvApplication, boolean bl) {
        IlvMessageView ilvMessageView = IlvMessageView.a(ilvApplication, false);
        if (ilvMessageView == null) {
            return;
        }
        ilvMessageView.n = bl;
    }

    public static boolean isEnabled(IlvApplication ilvApplication) {
        IlvMessageView ilvMessageView = IlvMessageView.a(ilvApplication, false);
        if (ilvMessageView == null) {
            return false;
        }
        return ilvMessageView.n;
    }

    public int getCount(Level level) {
        int n = 0;
        for (LogEntry logEntry : this.d.values()) {
            if (logEntry.getRecord().getLevel().intValue() != level.intValue()) continue;
            ++n;
        }
        return n;
    }

    public static void initialize(final IlvApplication ilvApplication) {
        Logger logger = Logger.getLogger("ilog.views");
        logger.addHandler(new MessageViewHandler(ilvApplication));
        String string = IlvCSSBeans.class.getName();
        string = string.substring(0, string.lastIndexOf(46));
        IlvMessageView.addLogPublisher(string, new CSSLogPublisher());
        string = IlvBuilder.class.getName();
        string = string.substring(0, string.lastIndexOf(46));
        IlvMessageView.addLogPublisher(string, new BuilderLogPublisher());
        IlvCSSBeans.setLoggingEnabled(true);
        IlvCSS._debug = false;
        ilvApplication.addApplicationListener(new IlvApplicationAdapter(){

            @Override
            public void documentInitializing(ApplicationEvent applicationEvent) {
                IlvMessageView ilvMessageView = IlvMessageView.a(ilvApplication, false);
                if (ilvMessageView != null) {
                    ilvMessageView.m = (IlvBuilderDocument)applicationEvent.getDocument();
                }
            }

            @Override
            public void documentCreated(ApplicationEvent applicationEvent) {
                IlvMessageView ilvMessageView = IlvMessageView.a(ilvApplication, false);
                if (ilvMessageView != null && ilvMessageView.m == applicationEvent.getDocument()) {
                    ilvMessageView.m = null;
                }
            }
        });
    }

    private static LogPublisher b(String string) {
        LogPublisher logPublisher = (LogPublisher)p.get(string);
        if (logPublisher == null) {
            logPublisher = new LogPublisher();
            p.put(string, logPublisher);
        }
        return logPublisher;
    }

    public static void addLogPublisher(String string, LogPublisher logPublisher) {
        p.put(string, logPublisher);
    }

    @Override
    public void setApplication(IlvApplication ilvApplication) {
        super.setApplication(ilvApplication);
        this.getTree();
        this.i = this.getApplication().getString("Builder.MessageView.ClickableFormat");
        this.j = this.getApplication().getString("Builder.MessageView.ClickableToolTip");
    }

    private Icon c(String string) {
        try {
            Image image = IlvImageUtil.getImageFromFile(this.getClass(), string);
            return new ImageIcon(image);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected void initializeTree(JTree jTree) {
        super.initializeTree(jTree);
        this.b = new DefaultMutableTreeNode(null);
        this.a = new DefaultTreeModel(this.b);
        jTree.setModel(this.a);
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setRowHeight(0);
        this.c = new TreePath(this.b.getPath());
        jTree.expandPath(this.c);
        ToolTipManager.sharedInstance().registerComponent(jTree);
        Utils.installDropTarget(this.getApplication(), jTree);
    }

    @Override
    protected TreeCellRenderer createTreeCellRenderer(JTree jTree) {
        return new LogEntryRenderer();
    }

    @Override
    protected void addTree(JTree jTree) {
        Object object;
        super.addTree(jTree);
        final IlvApplication ilvApplication = this.getApplication();
        JPanel jPanel = new JPanel(new IlvBetterFlowLayout(3, 5, 5));
        this.add((Component)jPanel, "South");
        JButton jButton = new JButton(ilvApplication.getString("Builder.MessageView.Clear"));
        jButton.setToolTipText(ilvApplication.getString("Builder.MessageView.ClearToolTip"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvMessageView.this.clear();
            }
        });
        jPanel.add(jButton);
        if (this.l) {
            this.k = new JButton();
            object = this.getApplication().getAction("CheckRulesAction");
            IlvAction.SetAction(this.k, (Action)object, this.getApplication());
            jPanel.add(this.k);
        }
        object = new JButton(ilvApplication.getString("Builder.MessageView.Copy"));
        ((JComponent)object).setToolTipText(ilvApplication.getString("Builder.MessageView.CopyToolTip"));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvMessageView.this.a();
            }
        });
        jPanel.add((Component)object);
        jPanel.add(Box.createHorizontalStrut(11));
        JLabel jLabel = new JLabel(ilvApplication.getString("Builder.MessageView.Level"));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        jPanel2.add((Component)jLabel, "Before");
        IlvJComboBox ilvJComboBox = new IlvJComboBox(new Object[]{Level.INFO, Level.WARNING, Level.SEVERE});
        ((JComboBox)ilvJComboBox).setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object == Level.SEVERE) {
                    jLabel.setIcon(IlvMessageView.this.e);
                    jLabel.setText(ilvApplication.getString("Builder.MessageView.Severe"));
                } else if (object == Level.WARNING) {
                    jLabel.setIcon(IlvMessageView.this.f);
                    jLabel.setText(ilvApplication.getString("Builder.MessageView.Warning"));
                } else {
                    jLabel.setIcon(IlvMessageView.this.g);
                    jLabel.setText(ilvApplication.getString("Builder.MessageView.Info"));
                }
                jLabel.setBorder(null);
                jLabel.setComponentOrientation(jList.getComponentOrientation());
                return jLabel;
            }
        });
        ilvJComboBox.setSelectedItem(q);
        ((JComboBox)ilvJComboBox).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvMessageView.this.setLevel((Level)((JComboBox)actionEvent.getSource()).getSelectedItem());
            }
        });
        jPanel2.add((Component)ilvJComboBox, "Center");
        jPanel.add(jPanel2);
        this.revalidate();
        this.repaint();
    }

    public void setLevel(Level level) {
        this.o = level;
    }

    public Level getLevel() {
        return this.o;
    }

    @Override
    protected void nodeDoubleClicked(MouseEvent mouseEvent, TreeNode treeNode, Object object) {
        if (object instanceof LogDetail && ((LogDetail)object).isClickable()) {
            ((LogDetail)object).click();
        }
    }

    @Override
    public void initializeView(IlvDocument ilvDocument) {
        super.initializeView(ilvDocument);
        Utils.installDropTarget(this.getApplication(), this);
    }

    public void clear() {
        this.b.removeAllChildren();
        this.a.nodeStructureChanged(this.b);
        this.clearEntries();
    }

    public void clearEntries() {
        this.d.clear();
    }

    private void a() {
        StringBuffer stringBuffer = new StringBuffer();
        this.a(stringBuffer, this.b, 0);
        String string = stringBuffer.toString();
        try {
            this.getToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
        }
        catch (Exception exception) {
            String string2 = IlvBuilder.class.getName();
            string2 = string2.substring(0, string2.lastIndexOf(46));
            Logger.getLogger(string2).log(Level.SEVERE, this.getApplication().getString("Builder.MessageView.CannotCopy"), exception);
        }
    }

    private void a(StringBuffer stringBuffer, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        int n2;
        Component component = this.getTree().getCellRenderer().getTreeCellRendererComponent(this.getTree(), defaultMutableTreeNode, false, false, false, this.getTree().getRowForPath(new TreePath(defaultMutableTreeNode.getPath())), false);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("- ");
        if (defaultMutableTreeNode == this.b) {
            stringBuffer.append(this.getApplication().getString(this.getApplication().getTitle()));
        } else {
            if (defaultMutableTreeNode.getUserObject() instanceof LogEntry) {
                stringBuffer.append(((LogEntry)defaultMutableTreeNode.getUserObject()).getRecord().getLevel().getName());
                stringBuffer.append(": ");
            }
            stringBuffer.append(this.d(((JLabel)component).getText()));
        }
        stringBuffer.append("\n");
        for (n2 = 0; n2 < defaultMutableTreeNode.getChildCount(); ++n2) {
            this.a(stringBuffer, (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2), n + 2);
        }
    }

    private String d(String string) {
        if (string.startsWith("<html>")) {
            string = string.substring("<html>".length());
            if (string.endsWith("</html>")) {
                string = string.substring(0, string.length() - "</html>".length());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "<>", true);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("<") && stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    continue;
                }
                if (string2.equals(">")) continue;
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private boolean a(LogRecord logRecord, LogPublisher logPublisher) {
        LogEntry logEntry = (LogEntry)this.d.get(logPublisher.getHashKey(logRecord));
        if (logEntry == null) {
            Throwable throwable;
            logEntry = new LogEntry(logRecord, logPublisher.getLabel(logRecord));
            this.d.put(logPublisher.getHashKey(logRecord), logEntry);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(logEntry);
            this.a.insertNodeInto(defaultMutableTreeNode, this.b, this.b.getChildCount());
            this.getTree().expandPath(this.c);
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            LogDetail[] logDetailArray = logPublisher.getDetails(logRecord, this);
            if (logDetailArray != null) {
                for (int i = 0; i < logDetailArray.length; ++i) {
                    LogDetail logDetail = logDetailArray[i];
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(logDetail);
                    this.a.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    defaultMutableTreeNode2 = defaultMutableTreeNode3;
                }
            }
            if ((throwable = logPublisher.getThrown(logRecord)) != null) {
                defaultMutableTreeNode2 = this.a(throwable, defaultMutableTreeNode);
            }
            this.getTree().scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
            return true;
        }
        return false;
    }

    private DefaultMutableTreeNode a(Throwable throwable, DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        String string = this.getApplication().getString("Builder.MessageView.ExceptionFormat");
        String string2 = MessageFormat.format(string, throwable);
        Object object2 = new DefaultMutableTreeNode(string2);
        this.a.insertNodeInto((MutableTreeNode)object2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        Throwable throwable2 = null;
        while (throwable != null) {
            throwable2 = throwable;
            if ((throwable = throwable.getCause()) == null) continue;
            string = this.getApplication().getString("Builder.MessageView.CausedByFormat");
            string2 = MessageFormat.format(string, throwable);
            object = new DefaultMutableTreeNode(string2);
            this.a.insertNodeInto((MutableTreeNode)object, (MutableTreeNode)object2, object2.getChildCount());
            object2 = object;
        }
        if (throwable2 != null) {
            object = throwable2.getStackTrace();
            for (int i = 0; i < ((StackTraceElement[])object).length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object[i]);
                this.a.insertNodeInto(defaultMutableTreeNode2, (MutableTreeNode)object2, object2.getChildCount());
            }
        }
        return object2;
    }

    public static IlvMessageView getMessageView(IlvApplication ilvApplication) {
        return IlvMessageView.a(ilvApplication, true);
    }

    static IlvMessageView a(IlvApplication ilvApplication, boolean bl) {
        IlvMessageView ilvMessageView = (IlvMessageView)((IlvSwingMainWindow)ilvApplication.getMainWindow()).getDockingArea().getDockableView("MessageView");
        if (ilvMessageView == null && bl) {
            ((IlvSwingMainWindow)ilvApplication.getMainWindow()).getDockingArea().setDockableVisible("MessageView", true);
            ((IlvSwingMainWindow)ilvApplication.getMainWindow()).getDockingArea().setDockableVisible("MessageView", false);
            ilvMessageView = (IlvMessageView)((IlvSwingMainWindow)ilvApplication.getMainWindow()).getDockingArea().getDockableView("MessageView");
        }
        if (ilvMessageView != null && ilvMessageView.getApplication() == null) {
            ilvMessageView.setApplication(ilvApplication);
        }
        return ilvMessageView;
    }

    private IlvBuilderDocument b() {
        if (this.m != null) {
            return this.m;
        }
        return (IlvBuilderDocument)this.getDocument();
    }

    private void a(IlvBuilderDocument ilvBuilderDocument, IlvRule ilvRule, IlvRule ilvRule2, String string, String string2) {
        IlvRule ilvRule3;
        ilvBuilderDocument.getDocumentTemplate().activateDocumentView(ilvBuilderDocument);
        IlvRule ilvRule4 = ilvRule3 = ilvBuilderDocument.getCSS().getSameRule(ilvRule);
        if (ilvRule3 != null) {
            if (ilvRule2 != null) {
                ilvRule4 = ilvBuilderDocument.getCSS().getSameRule(ilvRule2);
            }
            ilvBuilderDocument.getSelectionManager().setSelection(ilvRule3, ilvRule4, string, string2);
        }
    }

    protected void setCheckButton(boolean bl) {
        this.l = bl;
    }

    protected boolean isCheckButton() {
        return this.l;
    }

    private static class BuilderLogPublisher
    extends LogPublisher {
        private BuilderLogPublisher() {
        }

        @Override
        public boolean publish(LogRecord logRecord, IlvMessageView ilvMessageView) {
            if (super.publish(logRecord, ilvMessageView)) {
                if (logRecord.getLevel().intValue() >= Level.SEVERE.intValue()) {
                    JFrame jFrame = ((IlvSwingMainWindow)ilvMessageView.getApplication().getMainWindow()).getFrame();
                    IlvSwingUtil.showErrorDialog(jFrame, logRecord.getMessage(), logRecord.getThrown());
                }
                return true;
            }
            return false;
        }
    }

    private class LogEntryRenderer
    extends DefaultTreeCellRenderer {
        private LogEntryRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            String string = null;
            if (object2 instanceof LogEntry) {
                LogEntry logEntry = (LogEntry)object2;
                this.setIcon(logEntry.getIcon());
                this.setText(logEntry.getLabel());
            } else {
                this.setIcon(IlvMessageView.this.h);
                if (object2 instanceof LogDetail && ((LogDetail)object2).isClickable()) {
                    this.setText(MessageFormat.format(IlvMessageView.this.i, this.getText()));
                    string = IlvMessageView.this.j;
                }
            }
            this.setToolTipText(string);
            return jLabel;
        }
    }

    public static class CSSLogPublisher
    extends LogPublisher {
        @Override
        public boolean isIgnored(LogRecord logRecord, IlvMessageView ilvMessageView) {
            IlvBuilderDocument ilvBuilderDocument;
            Object object = this.a(logRecord, "CSS.Beans.Object");
            if (object == null) {
                return true;
            }
            IlvCSSBeans ilvCSSBeans = (IlvCSSBeans)this.a(logRecord, "CSS.Beans.CSSEngine");
            if (ilvCSSBeans != null && (ilvBuilderDocument = ilvMessageView.b()) != null) {
                try {
                    if (ilvCSSBeans != ilvBuilderDocument.getCSSBeans()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public Object getHashKey(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(logRecord.getMessage());
            stringBuffer.append("");
            Object[] objectArray = logRecord.getParameters();
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.a(logRecord, i)) continue;
                stringBuffer.append(objectArray[i]);
                stringBuffer.append("");
            }
            return stringBuffer.toString();
        }

        @Override
        public LogDetail[] getDetails(LogRecord logRecord, IlvMessageView ilvMessageView) {
            String string;
            IlvRule[] ilvRuleArray;
            Object object;
            Object[] objectArray = logRecord.getParameters();
            ArrayList<LogDetail> arrayList = new ArrayList<LogDetail>();
            try {
                IlvRule ilvRule = (IlvRule)this.a(logRecord, "CSS.Beans.Rule");
                object = ilvMessageView.b();
                if (ilvRule != null && object != null) {
                    IlvRule ilvRule2;
                    String string2;
                    ilvRuleArray = ((IlvBuilderDocument)object).getRules(false);
                    ilvRule = ((IlvBuilderDocument)object).getCSS().getSameRule(ilvRule);
                    string = (String)this.a(logRecord, "CSS.Beans.Property");
                    String string3 = (String)this.a(logRecord, "CSS.Beans.Value");
                    if (string3 == null) {
                        string2 = (String)this.a(logRecord, "CSS.Beans.ModelProperty");
                        if (string2 != null) {
                            string3 = "@" + string2;
                        }
                    }
                    string2 = string3;
                    if (string != null && (ilvRule2 = ((IlvBuilderDocument)object).getCSS().getRuleWithDeclaration(ilvRule, string)) != null) {
                        ilvRule = ilvRule2;
                    }
                    ilvRule2 = ilvRule;
                    IlvRule ilvRule3 = ((IlvBuilderDocument)object).getCSS().getToplevelRule(ilvRule);
                    String string4 = ilvRule3.getName();
                    String string5 = ilvRule.getName();
                    String string6 = ilvMessageView.getApplication().getString(string4.equals(string5) ? "Builder.MessageView.Rule" : "Builder.MessageView.SecondaryRule");
                    LogDetail logDetail = new LogDetail(MessageFormat.format(string6, string4, string5), (IlvBuilderDocument)object, ilvMessageView, ilvRule3, ilvRule2, string, string2){
                        final /* synthetic */ IlvBuilderDocument a;
                        final /* synthetic */ IlvMessageView b;
                        final /* synthetic */ IlvRule c;
                        final /* synthetic */ IlvRule d;
                        final /* synthetic */ String e;
                        final /* synthetic */ String f;
                        {
                            this.a = ilvBuilderDocument;
                            this.b = ilvMessageView;
                            this.c = ilvRule;
                            this.d = ilvRule2;
                            this.e = string;
                            this.f = string2;
                            super(object);
                        }

                        @Override
                        public boolean isClickable() {
                            return this.a != null;
                        }

                        @Override
                        public void click() {
                            if (this.a != null) {
                                this.b.a(this.a, this.c, this.d != this.c ? this.d : null, this.e, this.f);
                            }
                        }
                    };
                    if (object != null) {
                        ((IlvAbstractDocument)object).getDocumentTemplate().getViewConfiguration("Default").setCloseDocumentOnClose(false);
                    }
                    arrayList.add(logDetail);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < objectArray.length; i += 2) {
                object = (String)objectArray[i];
                if (this.a(logRecord, i)) continue;
                ilvRuleArray = objectArray[i + 1] != null ? objectArray[i + 1].toString() : null;
                string = logRecord.getResourceBundle().getString((String)object);
                arrayList.add(new LogDetail(MessageFormat.format(string, new Object[]{ilvRuleArray})));
            }
            return arrayList.toArray(new LogDetail[0]);
        }

        @Override
        public Throwable getThrown(LogRecord logRecord) {
            Object object = this.a(logRecord, "CSS.Beans.Exception");
            if (object instanceof Throwable) {
                return (Throwable)object;
            }
            return super.getThrown(logRecord);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean a(LogRecord logRecord, int n) {
            Object[] objectArray = logRecord.getParameters();
            if (objectArray == null) return false;
            n = n / 2 * 2;
            Object object = objectArray[n];
            if ("CSS.Beans.Object".equals(object)) return true;
            if ("CSS.Beans.Bean".equals(object)) return true;
            if ("CSS.Beans.Rule".equals(object)) return true;
            if ("CSS.Beans.RuleSelector".equals(object)) return true;
            if ("CSS.Beans.Exception".equals(object)) return true;
            if (!"CSS.Beans.CSSEngine".equals(object)) return false;
            return true;
        }

        private Object a(LogRecord logRecord, String string) {
            Object[] objectArray = logRecord.getParameters();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; i += 2) {
                    if (!string.equals(objectArray[i]) || i >= objectArray.length - 1) continue;
                    return objectArray[i + 1];
                }
            }
            return null;
        }
    }

    public static class LogPublisher {
        public boolean isIgnored(LogRecord logRecord, IlvMessageView ilvMessageView) {
            return false;
        }

        public Object getHashKey(LogRecord logRecord) {
            return logRecord;
        }

        public boolean publish(LogRecord logRecord, IlvMessageView ilvMessageView) {
            return ilvMessageView.a(logRecord, this);
        }

        public String getLabel(LogRecord logRecord) {
            String string = logRecord.getMessage();
            if (string == null) {
                return "<html><i>(null)</i></html>";
            }
            if (logRecord.getResourceBundle() != null) {
                try {
                    string = logRecord.getResourceBundle().getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            String string2 = "<html>";
            StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("{")) {
                    string2 = string2 + "<strong>{";
                    continue;
                }
                if (string3.equals("}")) {
                    string2 = string2 + "}</strong>";
                    continue;
                }
                string2 = string2 + IlvSwingUtil.escapeForHTMLElement(string3, false);
            }
            string2 = string2 + "</html>";
            return MessageFormat.format(string2, logRecord.getParameters());
        }

        public LogDetail[] getDetails(LogRecord logRecord, IlvMessageView ilvMessageView) {
            Object[] objectArray = logRecord.getParameters();
            if (objectArray != null) {
                ArrayList<LogDetail> arrayList = new ArrayList<LogDetail>();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) continue;
                    LogDetail logDetail = new LogDetail(objectArray[i].toString());
                    arrayList.add(logDetail);
                }
                return arrayList.toArray(new LogDetail[0]);
            }
            return null;
        }

        public Throwable getThrown(LogRecord logRecord) {
            return logRecord.getThrown();
        }

        public void pusblished(LogRecord logRecord) {
        }
    }

    private static class MessageViewHandler
    extends Handler {
        private IlvApplication a;

        public MessageViewHandler(IlvApplication ilvApplication) {
            this.a = ilvApplication;
        }

        @Override
        public void publish(LogRecord logRecord) {
            IlvMessageView ilvMessageView = IlvMessageView.a(this.a, false);
            if (ilvMessageView == null || !ilvMessageView.n) {
                return;
            }
            if (logRecord.getLevel().intValue() < ilvMessageView.o.intValue()) {
                return;
            }
            LogPublisher logPublisher = IlvMessageView.b(logRecord.getLoggerName());
            if (logPublisher.isIgnored(logRecord, ilvMessageView)) {
                return;
            }
            if (logPublisher.publish(logRecord, ilvMessageView)) {
                ((IlvSwingMainWindow)this.a.getMainWindow()).getDockingArea().setDockableVisible("MessageView", true);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }

    public static class LogDetail {
        private Object a;

        public LogDetail(Object object) {
            this.a = object;
        }

        public String toString() {
            return this.a.toString();
        }

        public boolean isClickable() {
            return false;
        }

        public void click() {
        }
    }

    private class LogEntry {
        private LogRecord a;
        private Icon b;
        private String c;

        public LogEntry(LogRecord logRecord, String string) {
            this.a = logRecord;
            this.b = logRecord.getLevel().intValue() >= Level.SEVERE.intValue() ? IlvMessageView.this.e : (logRecord.getLevel().intValue() >= Level.WARNING.intValue() ? IlvMessageView.this.f : IlvMessageView.this.g);
            this.c = string;
        }

        public LogRecord getRecord() {
            return this.a;
        }

        public Icon getIcon() {
            return this.b;
        }

        public String getLabel() {
            return this.c;
        }
    }
}

