/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.util;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class IlvTabVisibilityHandler
implements ContainerListener {
    private transient JTabbedPane a;
    private transient ArrayList b;
    private transient ArrayList c;
    private transient TabPropertiesFactory d;
    static final String e = "VisibilityHandler";
    static final String f = "HiddenTabs";
    static final boolean g = false;

    public IlvTabVisibilityHandler(JTabbedPane jTabbedPane) {
        this.a = jTabbedPane;
        jTabbedPane.putClientProperty(e, this);
        jTabbedPane.addContainerListener(this);
        this.c = new ArrayList(jTabbedPane.getTabCount());
        int n = jTabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.c.add(jTabbedPane.getComponentAt(i));
        }
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        int n = this.a.indexOfComponent(component);
        this.c.add(n, component);
        if (this.b != null) {
            for (int i = 0; i < this.b.size(); ++i) {
                AbstractTabProperties abstractTabProperties = (AbstractTabProperties)this.b.get(i);
                abstractTabProperties.componentAdded(n);
            }
        }
    }

    boolean a() {
        IlvTabVisibilityHandler.a("Checking...");
        if (this.a.getComponentCount() != this.c.size()) {
            IlvTabVisibilityHandler.a("Not the same sizes " + this.a.getComponentCount() + " and " + this.c.size());
            return false;
        }
        for (int i = 0; i < this.a.getComponentCount(); ++i) {
            if (this.c.get(i) == this.a.getComponent(i)) continue;
            return false;
        }
        return true;
    }

    int a(Component component) {
        for (int i = 0; i < this.c.size(); ++i) {
            if (this.c.get(i) != component) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        int n = this.a(component);
        int n2 = this.a.indexOfComponent(component);
        this.c.remove(n);
        if (this.b != null) {
            for (int i = 0; i < this.b.size(); ++i) {
                AbstractTabProperties abstractTabProperties = (AbstractTabProperties)this.b.get(i);
                abstractTabProperties.componentRemoved(n);
            }
        }
    }

    public void setTabVisible(Component component, boolean bl) {
        if (bl) {
            this.showPane(component);
        } else {
            this.hidePane(component);
        }
    }

    public void showPane(Component component) {
        AbstractTabProperties abstractTabProperties = this.b(component);
        if (abstractTabProperties == null) {
            return;
        }
        this.b.remove(abstractTabProperties);
        abstractTabProperties.insertTab(this.a);
    }

    public void hidePane(Component component) {
        int n = this.a.indexOfComponent(component);
        if (n == -1) {
            if (this.b(component) != null) {
                // empty if block
            }
            return;
        }
        AbstractTabProperties abstractTabProperties = this.createTabProperties(n);
        this.a.remove(n);
        if (this.b == null) {
            this.b = new ArrayList();
        }
        this.b.add(abstractTabProperties);
    }

    public boolean isTabHidden(Component component) {
        return this.b(component) != null;
    }

    public boolean removeTab(Component component) {
        AbstractTabProperties abstractTabProperties = this.b(component);
        if (abstractTabProperties != null) {
            this.b.remove(abstractTabProperties);
            return true;
        }
        int n = this.a.indexOfComponent(component);
        if (n != -1) {
            this.a.removeTabAt(n);
            return true;
        }
        return false;
    }

    protected AbstractTabProperties createTabProperties(int n) {
        return new DefaultTabProperties(this.a, n);
    }

    public void setTabPropertiesFactory(TabPropertiesFactory tabPropertiesFactory) {
        this.d = tabPropertiesFactory;
    }

    AbstractTabProperties b(Component component) {
        if (this.b == null) {
            return null;
        }
        for (int i = 0; i < this.b.size(); ++i) {
            AbstractTabProperties abstractTabProperties = (AbstractTabProperties)this.b.get(i);
            if (abstractTabProperties.getComponent() != component) continue;
            return abstractTabProperties;
        }
        return null;
    }

    public static void SetTabVisible(JTabbedPane jTabbedPane, Component component, boolean bl) {
        IlvTabVisibilityHandler.a(jTabbedPane).setTabVisible(component, bl);
    }

    public static boolean IsTabVisible(JTabbedPane jTabbedPane, Component component) {
        return jTabbedPane.indexOfComponent(component) != -1;
    }

    public static boolean IsTabHidden(JTabbedPane jTabbedPane, Component component) {
        IlvTabVisibilityHandler ilvTabVisibilityHandler = (IlvTabVisibilityHandler)jTabbedPane.getClientProperty(e);
        if (ilvTabVisibilityHandler != null) {
            return ilvTabVisibilityHandler.isTabHidden(component);
        }
        return !IlvTabVisibilityHandler.IsTabVisible(jTabbedPane, component);
    }

    public static void HideTab(JTabbedPane jTabbedPane, Component component) {
        IlvTabVisibilityHandler.a(jTabbedPane).hidePane(component);
    }

    public static boolean RemoveTab(JTabbedPane jTabbedPane, Component component) {
        IlvTabVisibilityHandler ilvTabVisibilityHandler = (IlvTabVisibilityHandler)jTabbedPane.getClientProperty(e);
        if (ilvTabVisibilityHandler != null) {
            return ilvTabVisibilityHandler.removeTab(component);
        }
        int n = jTabbedPane.indexOfComponent(component);
        if (n != -1) {
            jTabbedPane.removeTabAt(n);
            return true;
        }
        return false;
    }

    static IlvTabVisibilityHandler a(JTabbedPane jTabbedPane) {
        IlvTabVisibilityHandler ilvTabVisibilityHandler = (IlvTabVisibilityHandler)jTabbedPane.getClientProperty(e);
        if (ilvTabVisibilityHandler != null) {
            return ilvTabVisibilityHandler;
        }
        ilvTabVisibilityHandler = new IlvTabVisibilityHandler(jTabbedPane);
        return ilvTabVisibilityHandler;
    }

    public static IlvTabVisibilityHandler ConnectHandler(JTabbedPane jTabbedPane) {
        return IlvTabVisibilityHandler.a(jTabbedPane);
    }

    static void a(String string) {
    }

    static class DefaultTabProperties
    extends AbstractTabProperties {
        Icon a;
        String b;
        String c;
        Component d;

        public DefaultTabProperties(JTabbedPane jTabbedPane, int n) {
            super(n);
            this.a = jTabbedPane.getIconAt(n);
            this.b = jTabbedPane.getTitleAt(n);
            this.c = jTabbedPane.getToolTipTextAt(n);
            this.d = jTabbedPane.getComponentAt(n);
        }

        @Override
        public Component getComponent() {
            return this.d;
        }

        @Override
        public void insertTab(JTabbedPane jTabbedPane) {
            jTabbedPane.insertTab(this.b, this.a, this.getComponent(), this.c, ((AbstractTabProperties)this).a);
        }

        public String toString() {
            return this.b + " = " + ((AbstractTabProperties)this).a;
        }
    }

    static interface TabPropertiesFactory {
        public AbstractTabProperties createTabProperties();
    }

    static abstract class AbstractTabProperties {
        int a;

        public AbstractTabProperties(int n) {
            this.a = n;
        }

        public void componentAdded(int n) {
            if (this.a >= n) {
                ++this.a;
            }
        }

        public void componentRemoved(int n) {
            if (this.a > n) {
                --this.a;
            }
        }

        public int getIndex() {
            return this.a;
        }

        public abstract void insertTab(JTabbedPane var1);

        public abstract Component getComponent();
    }
}

